/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.XmlNamespaceContext;

public final class CatalogUIAdapterConfiguration {
    public static final String KEY_XML_ROOT_ELEMENT_NAME = "xml.rootElement.name";
    public static final String KEY_XML_ROOT_ELEMENT_NS_URI = "xml.rootElement.namespace.URI";
    public static final String XML_BINDING_KEY_PREFIX = "xml.namespaceBinding.";
    public static final String XML_BINDING_URI_SUFFIX = ".URI";
    public static final String XML_BINDING_PREFIX_SUFFIX = ".prefix";
    private final Dictionary<String, ?> configProperties;
    private XmlNamespaceContext xmlNSContext;

    public static CatalogUIAdapterConfiguration loadFromDictionary(Dictionary<String, ?> properties) throws ConfigurationException {
        return new CatalogUIAdapterConfiguration(properties);
    }

    private CatalogUIAdapterConfiguration(Dictionary<String, ?> properties) throws ConfigurationException {
        this.configProperties = properties;
        this.loadXmlNSContext();
        this.validate();
    }

    private void validate() throws ConfigurationException {
        if (this.configProperties.get(KEY_XML_ROOT_ELEMENT_NAME) == null) {
            throw new ConfigurationException(String.format("Value for configuration key '%s' is missing", KEY_XML_ROOT_ELEMENT_NAME));
        }
        if (this.configProperties.get(KEY_XML_ROOT_ELEMENT_NS_URI) == null) {
            throw new ConfigurationException(String.format("Value for configuration key '%s' is missing", KEY_XML_ROOT_ELEMENT_NS_URI));
        }
        if (this.xmlNSContext.getPrefix(this.getCatalogXmlRootNamespace()) == null) {
            throw new ConfigurationException(String.format("Binding for XML namespace URI '%s' is missing", this.getCatalogXmlRootNamespace()));
        }
    }

    private void loadXmlNSContext() {
        Enumeration<String> keys = this.configProperties.keys();
        HashMap<String, String> prefixToUri = new HashMap<String, String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(XML_BINDING_KEY_PREFIX)) continue;
            String nsBindingName = CatalogUIAdapterConfiguration.getXmlBindingNameFromConfigKey(key);
            String nsUri = (String)this.configProperties.get(XML_BINDING_KEY_PREFIX + nsBindingName + XML_BINDING_URI_SUFFIX);
            String nsPrefix = (String)this.configProperties.get(XML_BINDING_KEY_PREFIX + nsBindingName + XML_BINDING_PREFIX_SUFFIX);
            if (StringUtils.isBlank((CharSequence)nsUri)) {
                throw new ConfigurationException(String.format("No URI for namespace binding '%s' found", nsBindingName));
            }
            if (nsPrefix == null) {
                throw new ConfigurationException(String.format("No prefix for namespace binding '%s' found", nsBindingName));
            }
            prefixToUri.put(nsPrefix, nsUri);
        }
        this.xmlNSContext = new XmlNamespaceContext(prefixToUri);
    }

    private static String getXmlBindingNameFromConfigKey(String key) {
        if (StringUtils.isBlank((CharSequence)key) || !key.startsWith(XML_BINDING_KEY_PREFIX)) {
            throw new IllegalArgumentException(String.format("The given key '%s' is not part of a XML binding definition", key));
        }
        String keyWithoutPrefix = key.substring(XML_BINDING_KEY_PREFIX.length());
        return keyWithoutPrefix.substring(0, keyWithoutPrefix.indexOf("."));
    }

    public String getCatalogXmlRootElementName() {
        return (String)this.configProperties.get(KEY_XML_ROOT_ELEMENT_NAME);
    }

    public String getCatalogXmlRootNamespace() {
        return (String)this.configProperties.get(KEY_XML_ROOT_ELEMENT_NS_URI);
    }

    public XmlNamespaceContext getXmlNamespaceContext() {
        return this.xmlNSContext;
    }
}

