/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.api;

import com.entwinemedia.fn.data.Opt;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONObject;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.exception.UnsupportedAssetException;
import org.opencastproject.index.service.impl.util.EventHttpServletRequest;
import org.opencastproject.ingest.api.IngestException;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowDatabaseException;

public interface IndexService {
    public Opt<Event> getEvent(String var1, ElasticsearchIndex var2) throws SearchIndexException;

    public String createEvent(HttpServletRequest var1) throws IndexServiceException, IllegalArgumentException, UnsupportedAssetException;

    public String createEvent(EventHttpServletRequest var1) throws ParseException, IOException, MediaPackageException, IngestException, NotFoundException, SchedulerException, UnauthorizedException;

    public EventRemovalResult removeEvent(Event var1, String var2) throws UnauthorizedException, WorkflowDatabaseException, NotFoundException;

    public boolean removeEvent(String var1) throws NotFoundException, UnauthorizedException;

    public String updateEventAssets(MediaPackage var1, HttpServletRequest var2) throws ParseException, IOException, MediaPackageException, NotFoundException, UnauthorizedException, IndexServiceException, UnsupportedAssetException;

    public MetadataList updateEventMetadata(String var1, MetadataList var2, ElasticsearchIndex var3) throws IndexServiceException, SearchIndexException, NotFoundException, UnauthorizedException;

    public MetadataList updateAllEventMetadata(String var1, String var2, ElasticsearchIndex var3) throws IllegalArgumentException, IndexServiceException, SearchIndexException, NotFoundException, UnauthorizedException;

    public void removeCatalogByFlavor(Event var1, MediaPackageElementFlavor var2) throws IndexServiceException, NotFoundException, UnauthorizedException;

    public AccessControlList updateEventAcl(String var1, AccessControlList var2, ElasticsearchIndex var3) throws IllegalArgumentException, IndexServiceException, SearchIndexException, NotFoundException, UnauthorizedException;

    public MediaPackage getEventMediapackage(Event var1) throws IndexServiceException;

    public Source getEventSource(Event var1);

    public void updateCommentCatalog(Event var1, List<EventComment> var2) throws Exception;

    public MetadataList getMetadataListWithAllSeriesCatalogUIAdapters();

    public MetadataList getMetadataListWithAllEventCatalogUIAdapters();

    public List<EventCatalogUIAdapter> getEventCatalogUIAdapters();

    public List<EventCatalogUIAdapter> getExtendedEventCatalogUIAdapters();

    public EventCatalogUIAdapter getCommonEventCatalogUIAdapter();

    public String createSeries(JSONObject var1) throws IllegalArgumentException, IndexServiceException, UnauthorizedException;

    public String createSeries(MetadataList var1, Map<String, String> var2, Opt<AccessControlList> var3, Opt<Long> var4) throws IndexServiceException;

    public void removeSeries(String var1) throws NotFoundException, SeriesException, UnauthorizedException;

    public SeriesCatalogUIAdapter getCommonSeriesCatalogUIAdapter();

    public List<SeriesCatalogUIAdapter> getSeriesCatalogUIAdapters();

    public MetadataList updateAllSeriesMetadata(String var1, String var2, ElasticsearchIndex var3) throws IllegalArgumentException, IndexServiceException, NotFoundException, UnauthorizedException;

    public MetadataList updateAllSeriesMetadata(String var1, MetadataList var2, ElasticsearchIndex var3) throws IndexServiceException, NotFoundException, UnauthorizedException;

    public void removeCatalogByFlavor(Series var1, MediaPackageElementFlavor var2) throws IndexServiceException, NotFoundException;

    public Map<String, Map<String, String>> getEventWorkflowProperties(List<String> var1);

    public static enum EventRemovalResult {
        SUCCESS,
        GENERAL_FAILURE,
        NOT_FOUND,
        RETRACTING;

    }

    public static enum SourceType {
        UPLOAD,
        UPLOAD_LATER,
        SCHEDULE_SINGLE,
        SCHEDULE_MULTIPLE;

    }

    public static enum Source {
        ARCHIVE,
        WORKFLOW,
        SCHEDULE;

    }
}

