/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.fileupload.rest;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.fileupload.api.FileUploadService;
import org.opencastproject.fileupload.api.exception.FileUploadException;
import org.opencastproject.fileupload.api.job.FileUploadJob;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="fileupload", title="Big File Upload Service", abstractText="This service provides a facility to upload files that exceed the 2 GB boundry imposed by most browsers through chunked uploads via HTTP.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={FileUploadRestService.class}, property={"service.description=File Upload REST Endpoint", "opencast.service.type=org.opencastproject.fileupload", "opencast.service.path=/upload"})
public class FileUploadRestService {
    static final String REQUESTFIELD_FILENAME = "filename";
    static final String REQUESTFIELD_FILESIZE = "filesize";
    static final String REQUESTFIELD_DATA = "filedata";
    static final String REQUESTFIELD_CHUNKSIZE = "chunksize";
    static final String REQUESTFIELD_CHUNKNUM = "chunknumber";
    static final String REQUESTFIELD_MEDIAPACKAGE = "mediapackage";
    static final String REQUESTFIELD_FLAVOR = "flavor";
    private static final Logger log = LoggerFactory.getLogger(FileUploadRestService.class);
    private FileUploadService uploadService;
    private MediaPackageBuilderFactory factory = MediaPackageBuilderFactory.newInstance();

    @Reference(unbind="unsetFileUploadService")
    protected void setFileUploadService(FileUploadService service) {
        this.uploadService = service;
    }

    protected void unsetFileUploadService(FileUploadService service) {
        this.uploadService = null;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        log.info("File Upload REST Endpoint activated");
    }

    protected void deactivate(ComponentContext cc) {
        log.info("File Upload REST Endpoint deactivated");
    }

    @POST
    @Produces(value={"text/plain"})
    @Path(value="newjob")
    @RestQuery(name="newjob", description="Creates a new upload job and returns the jobs ID.", restParameters={@RestParameter(name="filename", description="The name of the file that will be uploaded", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="filesize", description="The size of the file that will be uploaded", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="chunksize", description="The size of the chunks that will be uploaded", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="flavor", description="The flavor of this track", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="mediapackage", description="The mediapackage the file should belong to", isRequired=false, type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="job was successfully created", responseCode=200), @RestResponse(description="upload service gave an error", responseCode=204)}, returnDescription="The ID of the newly created upload job")
    public Response getNewJob(@FormParam(value="filename") String filename, @FormParam(value="filesize") long filesize, @FormParam(value="chunksize") int chunksize, @FormParam(value="mediapackage") String mediapackage, @FormParam(value="flavor") String flav) {
        try {
            if (StringUtils.isBlank((CharSequence)filename)) {
                filename = "john.doe";
            }
            if (filesize < 1L) {
                filesize = -1L;
            }
            if (chunksize < 1) {
                chunksize = -1;
            }
            MediaPackage mp = null;
            if (StringUtils.isNotBlank((CharSequence)mediapackage)) {
                mp = this.factory.newMediaPackageBuilder().loadFromXml(mediapackage);
            }
            MediaPackageElementFlavor flavor = null;
            if (StringUtils.isNotBlank((CharSequence)flav)) {
                flavor = new MediaPackageElementFlavor(flav.split("/")[0], flav.split("/")[1]);
            }
            FileUploadJob job = this.uploadService.createJob(filename, filesize, chunksize, mp, flavor);
            return Response.ok((Object)job.getId()).build();
        }
        catch (FileUploadException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)this.buildUnexpectedErrorMessage(e)).build();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="job/{jobID}.{format:xml|json}")
    @RestQuery(name="job", description="Returns the XML or the JSON representation of an upload job.", pathParameters={@RestParameter(name="jobID", description="The ID of the upload job", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="format", description="The output format (json or xml) of the response body.", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="the job was successfully retrieved.", responseCode=200), @RestResponse(description="the job was not found.", responseCode=404)}, returnDescription="The XML representation of the requested upload job.")
    public Response getJob(@PathParam(value="jobID") String id, @PathParam(value="format") String format) {
        try {
            if (this.uploadService.hasJob(id)) {
                FileUploadJob job = this.uploadService.getJob(id);
                String type = "json".equals(format) ? "application/json" : "application/xml";
                return Response.ok().entity((Object)job).type(type).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)this.buildUnexpectedErrorMessage(e)).build();
        }
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="job/{jobID}")
    @RestQuery(name="newjob", description="Appends the next chunk of data to the file on the server.", pathParameters={@RestParameter(name="jobID", description="The ID of the upload job", isRequired=false, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The number of the current chunk", isRequired=false, name="chunknumber", type=RestParameter.Type.STRING), @RestParameter(description="The payload", isRequired=false, name="filedata", type=RestParameter.Type.FILE)}, responses={@RestResponse(description="the chunk data was successfully appended to file on server", responseCode=200), @RestResponse(description="the upload job was not found", responseCode=404), @RestResponse(description="the request was malformed", responseCode=400)}, returnDescription="The XML representation of the updated upload job")
    public Response postPayload(@PathParam(value="jobID") String jobId, @Context HttpServletRequest request) {
        try {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                throw new FileUploadException("Request is not of type multipart/form-data");
            }
            if (this.uploadService.hasJob(jobId)) {
                long chunkNum = 0L;
                FileUploadJob job = this.uploadService.getJob(jobId);
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (item.isFormField()) {
                        String name = item.getFieldName();
                        if (!REQUESTFIELD_CHUNKNUM.equalsIgnoreCase(name)) continue;
                        chunkNum = Long.parseLong(Streams.asString((InputStream)item.openStream()));
                        continue;
                    }
                    if (!REQUESTFIELD_DATA.equalsIgnoreCase(item.getFieldName())) continue;
                    this.uploadService.acceptChunk(job, chunkNum, item.openStream());
                    return Response.ok((Object)job).build();
                }
                throw new FileUploadException("No payload!");
            }
            log.warn("Upload job not found: " + jobId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (FileUploadException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)this.buildUnexpectedErrorMessage(e)).build();
        }
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="job/{jobID}/{filename}")
    @RestQuery(name="payload", description="Returns the payload of the upload job.", pathParameters={@RestParameter(name="jobID", description="The ID of the upload job to retrieve the file from", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="filename", description="The name of the payload file", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="the job and file have been found.", responseCode=200), @RestResponse(description="the job or file were not found.", responseCode=404)}, returnDescription="The payload of the upload job")
    public Response getPayload(@PathParam(value="jobID") String id, @PathParam(value="filename") String filename) {
        try {
            if (this.uploadService.hasJob(id)) {
                FileUploadJob job = this.uploadService.getJob(id);
                InputStream payload = this.uploadService.getPayload(job);
                return Response.ok((Object)payload).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)this.buildUnexpectedErrorMessage(e)).build();
        }
    }

    @DELETE
    @Produces(value={"text/plain"})
    @Path(value="job/{jobID}")
    @RestQuery(name="job", description="Deletes an upload job on the server.", pathParameters={@RestParameter(name="jobID", description="The ID of the upload job to be deleted", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="the job was successfully deleted.", responseCode=200), @RestResponse(description="the job was not found.", responseCode=404)}, returnDescription="A success message that starts with OK")
    public Response deleteJob(@PathParam(value="jobID") String id) {
        try {
            if (this.uploadService.hasJob(id)) {
                this.uploadService.deleteJob(id);
                StringBuilder okMessage = new StringBuilder().append("OK: Deleted job ").append(id);
                return Response.ok((Object)okMessage.toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)this.buildUnexpectedErrorMessage(e)).build();
        }
    }

    private String buildUnexpectedErrorMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unexpected error (").append(e.getClass().getName()).append(")");
        String message = e.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            sb.append(": ").append(message);
        }
        return sb.toString();
    }
}

