/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.execute.operation.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.execute.api.ExecuteException;
import org.opencastproject.execute.api.ExecuteService;
import org.opencastproject.inspection.api.MediaInspectionException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationResultImpl;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Execute Many Workflow Operation Handler", "workflow.operation=execute-many"})
public class ExecuteManyWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteManyWorkflowOperationHandler.class);
    public static final String EXEC_PROPERTY = "exec";
    public static final String PARAMS_PROPERTY = "params";
    public static final String LOAD_PROPERTY = "load";
    public static final String SOURCE_FLAVOR_PROPERTY = "source-flavor";
    public static final String OUTPUT_FILENAME_PROPERTY = "output-filename";
    public static final String EXPECTED_TYPE_PROPERTY = "expected-type";
    public static final String SOURCE_TAGS_PROPERTY = "source-tags";
    public static final String SOURCE_AUDIO_PROPERTY = "source-audio";
    public static final String SOURCE_VIDEO_PROPERTY = "source-video";
    public static final String SOURCE_SUBTITLE_PROPERTY = "source-subtitle";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String SET_WF_PROPS_PROPERTY = "set-workflow-properties";
    protected ExecuteService executeService;
    private MediaInspectionService inspectionService = null;
    protected Workspace workspace;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        logger.debug("Running execute workflow operation with ID {}", (Object)operation.getId());
        String exec = StringUtils.trimToNull((String)operation.getConfiguration(EXEC_PROPERTY));
        String params = StringUtils.trimToNull((String)operation.getConfiguration(PARAMS_PROPERTY));
        float load = 1.0f;
        String loadPropertyStr = StringUtils.trimToEmpty((String)operation.getConfiguration(LOAD_PROPERTY));
        if (StringUtils.isNotBlank((CharSequence)loadPropertyStr)) {
            try {
                load = Float.parseFloat(loadPropertyStr);
            }
            catch (NumberFormatException e) {
                String description = StringUtils.trimToEmpty((String)operation.getDescription());
                logger.warn("Ignoring invalid load value '{}' on execute operation with description '{}'", (Object)loadPropertyStr, (Object)description);
            }
        }
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List sourceFlavor = tagsAndFlavors.getSrcFlavors();
        List sourceTagList = tagsAndFlavors.getSrcTags();
        String sourceAudio = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_AUDIO_PROPERTY));
        String sourceVideo = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_VIDEO_PROPERTY));
        String sourceSubtitle = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_SUBTITLE_PROPERTY));
        List targetFlavorList = tagsAndFlavors.getTargetFlavors();
        List targetTags = tagsAndFlavors.getTargetTags();
        String outputFilename = StringUtils.trimToNull((String)operation.getConfiguration(OUTPUT_FILENAME_PROPERTY));
        String expectedTypeStr = StringUtils.trimToNull((String)operation.getConfiguration(EXPECTED_TYPE_PROPERTY));
        boolean setWfProps = Boolean.valueOf(StringUtils.trimToNull((String)operation.getConfiguration(SET_WF_PROPS_PROPERTY)));
        MediaPackageElementFlavor targetFlavor = null;
        if (!targetFlavorList.isEmpty()) {
            targetFlavor = (MediaPackageElementFlavor)targetFlavorList.get(0);
        }
        MediaPackageElement.Type expectedType = null;
        if (expectedTypeStr != null) {
            for (MediaPackageElement.Type type : MediaPackageElement.Type.values()) {
                if (!type.toString().equalsIgnoreCase(expectedTypeStr)) continue;
                expectedType = type;
                break;
            }
            if (expectedType == null) {
                throw new WorkflowOperationException("'" + expectedTypeStr + "' is not a valid element type");
            }
        }
        HashSet<MediaPackageElement> inputSet = new HashSet<MediaPackageElement>();
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (MediaPackageElementFlavor flavor : sourceFlavor) {
            elementSelector.addFlavor(flavor);
        }
        for (String tag : sourceTagList) {
            elementSelector.addTag(tag);
        }
        for (MediaPackageElement element : elementSelector.select(mediaPackage, true)) {
            if (element instanceof Track && sourceAudio != null && Boolean.parseBoolean(sourceAudio) != ((Track)element).hasAudio() || element instanceof Track && sourceVideo != null && Boolean.parseBoolean(sourceVideo) != ((Track)element).hasVideo() || element instanceof Track && sourceSubtitle != null && Boolean.parseBoolean(sourceSubtitle) != ((Track)element).hasSubtitle()) continue;
            inputSet.add(element);
        }
        if (inputSet.size() == 0) {
            logger.warn("Mediapackage {} has no suitable elements to execute the command {} based on tags {}, flavor {}, sourceAudio {}, sourceVideo {}, sourceSubtitle {}", new Object[]{mediaPackage, exec, sourceTagList, sourceFlavor, sourceAudio, sourceVideo, sourceSubtitle});
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        MediaPackageElement[] inputElements = inputSet.toArray(new MediaPackageElement[inputSet.size()]);
        HashMap<Object, Object> wfProps = new HashMap<Object, Object>();
        try {
            int i;
            Job[] jobs = new Job[inputElements.length];
            MediaPackageElement[] resultElements = new MediaPackageElement[inputElements.length];
            long totalTimeInQueue = 0L;
            for (int i2 = 0; i2 < inputElements.length; ++i2) {
                jobs[i2] = this.executeService.execute(exec, params, inputElements[i2], outputFilename, expectedType, load);
            }
            if (!this.waitForStatus(jobs).isSuccess()) {
                throw new WorkflowOperationException("Execute operation failed");
            }
            HashMap<Integer, Job> jobMap = new HashMap<Integer, Job>();
            for (i = 0; i < jobs.length; ++i) {
                totalTimeInQueue += jobs[i].getQueueTime().longValue();
                if (StringUtils.trimToNull((String)jobs[i].getPayload()) != null) {
                    resultElements[i] = MediaPackageElementParser.getFromXml((String)jobs[i].getPayload());
                    if (resultElements[i].getElementType() != MediaPackageElement.Type.Track) continue;
                    jobMap.put(i, this.inspectionService.inspect(resultElements[i].getURI()));
                    continue;
                }
                resultElements[i] = inputElements[i];
            }
            if (jobMap.size() > 0) {
                if (!this.waitForStatus(jobMap.values().toArray(new Job[jobMap.size()])).isSuccess()) {
                    throw new WorkflowOperationException("Execute operation failed in track inspection");
                }
                for (Map.Entry entry : jobMap.entrySet()) {
                    totalTimeInQueue += ((Job)entry.getValue()).getQueueTime().longValue();
                    resultElements[((Integer)entry.getKey()).intValue()] = MediaPackageElementParser.getFromXml((String)((Job)entry.getValue()).getPayload());
                }
            }
            for (i = 0; i < resultElements.length; ++i) {
                if (resultElements[i] != inputElements[i]) {
                    if (setWfProps) {
                        Properties properties = new Properties();
                        File propertiesFile = this.workspace.get(resultElements[i].getURI());
                        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), StandardCharsets.UTF_8);){
                            properties.load(reader);
                        }
                        logger.debug("Loaded {} properties from {}", (Object)properties.size(), (Object)propertiesFile);
                        this.workspace.deleteFromCollection("executor", propertiesFile.getName());
                        wfProps.putAll(properties);
                    } else {
                        mediaPackage.addDerived(resultElements[i], inputElements[i]);
                        URI uri = this.workspace.moveTo(resultElements[i].getURI(), mediaPackage.getIdentifier().toString(), resultElements[i].getIdentifier(), outputFilename);
                        resultElements[i].setURI(uri);
                        if (targetFlavor != null) {
                            String targetFlavorType = targetFlavor.getType();
                            String targetFlavorSubtype = targetFlavor.getSubtype();
                            if ("*".equals(targetFlavorType)) {
                                targetFlavorType = inputElements[i].getFlavor().getType();
                            }
                            if ("*".equals(targetFlavorSubtype)) {
                                targetFlavorSubtype = inputElements[i].getFlavor().getSubtype();
                            }
                            String resolvedTargetFlavorStr = targetFlavorType + "/" + targetFlavorSubtype;
                            resultElements[i].setFlavor(MediaPackageElementFlavor.parseFlavor((String)resolvedTargetFlavorStr));
                        }
                    }
                }
                if (targetTags == null) continue;
                for (String tag : targetTags) {
                    if (tag.startsWith("-")) {
                        resultElements[i].removeTag(tag.replaceAll("^-+", ""));
                        continue;
                    }
                    resultElements[i].addTag(tag);
                }
            }
            WorkflowOperationResult result = this.createResult(mediaPackage, wfProps, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
            logger.debug("Execute operation {} completed", (Object)operation.getId());
            return result;
        }
        catch (ExecuteException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new WorkflowOperationException("Some result element couldn't be serialized", (Throwable)e);
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException("Could not find mediapackage", (Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Error unmarshalling a result mediapackage element", (Throwable)e);
        }
        catch (MediaInspectionException e) {
            throw new WorkflowOperationException("Error inspecting one of the created tracks", (Throwable)e);
        }
    }

    public WorkflowOperationResult skip(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        return new WorkflowOperationResultImpl(workflowInstance.getMediaPackage(), null, WorkflowOperationResult.Action.SKIP, 0L);
    }

    public String getId() {
        return "execute";
    }

    public String getDescription() {
        return "Executes command line workflow operations in workers";
    }

    public void destroy(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
    }

    @Reference
    public void setExecuteService(ExecuteService service) {
        this.executeService = service;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.inspectionService = mediaInspectionService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

