/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment.persistence;

import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.event.comment.EventCommentReply;
import org.opencastproject.event.comment.persistence.EventCommentDto;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.util.data.Option;

@Entity(name="EventCommentReply")
@Access(value=AccessType.FIELD)
@Table(name="oc_event_comment_reply")
@NamedQueries(value={@NamedQuery(name="EventCommentReply.findAll", query="SELECT c FROM EventCommentReply c"), @NamedQuery(name="EventCommentReply.clear", query="DELETE FROM EventCommentReply")})
public class EventCommentReplyDto {
    @Id
    @GeneratedValue
    @Column(name="id")
    private long id;
    @ManyToOne(targetEntity=EventCommentDto.class)
    @JoinColumn(name="event_comment_id", referencedColumnName="id", nullable=false)
    private EventCommentDto eventComment;
    @Lob
    @Column(name="text", nullable=false)
    private String text;
    @Column(name="creation_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="modification_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modificationDate;
    @Column(name="author", nullable=false)
    private String author;

    public static EventCommentReplyDto from(EventCommentReply reply) {
        EventCommentReplyDto dto = new EventCommentReplyDto();
        if (reply.getId().isSome()) {
            dto.id = (Long)reply.getId().get();
        }
        dto.text = reply.getText();
        dto.creationDate = reply.getCreationDate();
        dto.modificationDate = reply.getModificationDate();
        dto.author = reply.getAuthor().getUsername();
        return dto;
    }

    public long getId() {
        return this.id;
    }

    EventCommentDto getEventComment() {
        return this.eventComment;
    }

    void setEventComment(EventCommentDto eventComment) {
        this.eventComment = eventComment;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public EventCommentReply toCommentReply(UserDirectoryService userDirectoryService) {
        User user = userDirectoryService.loadUser(this.author);
        return EventCommentReply.create((Option<Long>)Option.option((Object)this.id), this.text, user, this.creationDate, this.modificationDate);
    }
}

