/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.event.comment.EventCommentReply;
import org.opencastproject.security.api.User;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.Jsons;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.data.Option;

public final class EventComment {
    public static final String REASON_NEEDS_CUTTING = "EVENTS.EVENTS.DETAILS.COMMENTS.REASONS.CUTTING";
    private Option<Long> id;
    private String eventId;
    private String organization;
    private String text;
    private Date creationDate;
    private Date modificationDate;
    private User author;
    private String reason;
    private boolean resolvedStatus = false;
    private List<EventCommentReply> replies = new ArrayList<EventCommentReply>();

    public static EventComment create(Option<Long> id, String eventId, String organization, String text, User author) {
        return EventComment.create(id, eventId, organization, text, author, null, false);
    }

    public static EventComment create(Option<Long> id, String eventId, String organization, String text, User author, String reason, boolean resolvedStatus) {
        Date creationDate = new Date();
        return EventComment.create(id, eventId, organization, text, author, reason, resolvedStatus, creationDate, creationDate, new ArrayList<EventCommentReply>());
    }

    public static EventComment create(Option<Long> id, String eventId, String organization, String text, User author, String reason, boolean resolvedStatus, Date creationDate, Date modificationDate) {
        return new EventComment(id, eventId, organization, text, author, reason, resolvedStatus, creationDate, modificationDate, new ArrayList<EventCommentReply>());
    }

    public static EventComment create(Option<Long> id, String eventId, String organization, String text, User author, String reason, boolean resolvedStatus, Date creationDate, Date modificationDate, List<EventCommentReply> replies) {
        return new EventComment(id, eventId, organization, text, author, reason, resolvedStatus, creationDate, modificationDate, replies);
    }

    private EventComment(Option<Long> id, String eventId, String organization, String text, User author, String reason, boolean resolvedStatus, Date creationDate, Date modificationDate, List<EventCommentReply> replies) {
        this.id = (Option)RequireUtil.notNull(id, (String)"id");
        this.eventId = RequireUtil.notEmpty((String)eventId, (String)"eventId");
        this.organization = RequireUtil.notEmpty((String)organization, (String)"organization");
        this.text = RequireUtil.notEmpty((String)text, (String)"text");
        this.author = (User)RequireUtil.notNull((Object)author, (String)"author");
        this.reason = reason;
        this.resolvedStatus = resolvedStatus;
        this.creationDate = (Date)RequireUtil.notNull((Object)creationDate, (String)"creationDate");
        this.modificationDate = (Date)RequireUtil.notNull((Object)modificationDate, (String)"modificationDate");
        this.replies = (List)RequireUtil.notNull(replies, (String)"replies");
    }

    public Option<Long> getId() {
        return this.id;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getText() {
        return this.text;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public User getAuthor() {
        return this.author;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isResolvedStatus() {
        return this.resolvedStatus;
    }

    public List<EventCommentReply> getReplies() {
        return this.replies;
    }

    public boolean addReply(EventCommentReply reply) {
        return this.replies.add((EventCommentReply)RequireUtil.notNull((Object)reply, (String)"reply"));
    }

    public boolean removeReply(EventCommentReply reply) {
        return this.replies.remove(RequireUtil.notNull((Object)reply, (String)"reply"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventComment comment = (EventComment)o;
        return this.text.equals(comment.getText()) && this.creationDate.equals(comment.getCreationDate()) && this.modificationDate.equals(comment.getModificationDate()) && this.author.equals(comment.getAuthor()) && (this.reason == null ? comment.getReason() == null : this.reason.equals(comment.getReason())) && this.resolvedStatus == comment.isResolvedStatus();
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.text, this.creationDate, this.modificationDate, this.author, this.reason, this.resolvedStatus});
    }

    public String toString() {
        return "Comment:" + this.id + "|" + StringUtils.abbreviate((String)this.text, (int)25);
    }

    public Jsons.Obj toJson() {
        Jsons.Obj authorObj = Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"name", (String)this.author.getName()), Jsons.p((String)"username", (String)this.author.getUsername()), Jsons.p((String)"email", (String)this.author.getEmail())});
        ArrayList<Jsons.Obj> replyArr = new ArrayList<Jsons.Obj>();
        for (EventCommentReply reply : this.replies) {
            replyArr.add(reply.toJson());
        }
        Jsons.Val idValue = Jsons.ZERO_VAL;
        if (this.id.isSome()) {
            idValue = Jsons.v((Number)((Number)this.id.get()));
        }
        return Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"id", (Jsons.Val)idValue), Jsons.p((String)"text", (String)this.text), Jsons.p((String)"creationDate", (String)DateTimeSupport.toUTC((long)this.creationDate.getTime())), Jsons.p((String)"modificationDate", (String)DateTimeSupport.toUTC((long)this.modificationDate.getTime())), Jsons.p((String)"author", (Jsons.Val)authorObj), Jsons.p((String)"reason", (String)this.reason), Jsons.p((String)"resolvedStatus", (Boolean)this.resolvedStatus), Jsons.p((String)"replies", (Jsons.Val)Jsons.arr(replyArr))});
    }
}

