/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.engage.ui;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="PlayerRedirect", title="Configurable Player Endpoint", abstractText="This service redirects to configured players.", notes={})
@Component(immediate=true, service={PlayerRedirect.class}, property={"service.description=Configurable Player Endpoint", "opencast.service.type=org.opencastproject.engage.ui.player.redirect", "opencast.service.path=/play"})
public class PlayerRedirect {
    private static final Logger logger = LoggerFactory.getLogger(PlayerRedirect.class);
    private static final String PLAYER_DEFAULT = "/paella7/ui/watch.html?id=#{id}";
    private SecurityService securityService;

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @GET
    @Path(value="/{id:.+}")
    @RestQuery(name="redirect", description="Player redirect", pathParameters={@RestParameter(name="id", description="The event identifier", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the paella configuration", responseCode=307)}, returnDescription="")
    public Response redirect(@PathParam(value="id") String id) {
        Organization org = this.securityService.getOrganization();
        String playerPath = Objects.toString(org.getProperties().get("player"), PLAYER_DEFAULT).replace("#{id}", URLEncoder.encode(id, StandardCharsets.UTF_8));
        logger.debug("redirecting to player: {}", (Object)playerPath);
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).header("location", (Object)playerPath).build();
    }
}

