/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.email.template.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.opencastproject.email.template.api.EmailTemplateService;
import org.opencastproject.email.template.impl.EmailData;
import org.opencastproject.email.template.impl.EmailTemplateScanner;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.job.api.Incident;
import org.opencastproject.job.api.IncidentTree;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.CatalogUIAdapter;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.serviceregistry.api.IncidentService;
import org.opencastproject.util.doc.DocData;
import org.opencastproject.util.doc.DocUtil;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EmailTemplateService.class}, property={"service.description=Email Template Service"})
public class EmailTemplateServiceImpl
implements EmailTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(EmailTemplateServiceImpl.class);
    public static final String DEFAULT_DELIMITER_FOR_MULTIPLE = ", ";
    private Workspace workspace;
    private final AtomicReference<EmailTemplateScanner> templateScannerRef = new AtomicReference();
    private IncidentService incidentService = null;
    private IndexService indexService;
    private SecurityService securityService;

    @Activate
    protected void activate(ComponentContext context) {
        logger.info("EmailTemplateServiceImpl activated");
    }

    public String applyTemplate(String templateName, String templateContent, WorkflowInstance workflowInstance) {
        return this.applyTemplate(templateName, templateContent, workflowInstance, DEFAULT_DELIMITER_FOR_MULTIPLE);
    }

    public String applyTemplate(String templateName, String templateContent, WorkflowInstance workflowInstance, String delimiter) {
        if (templateContent == null && this.templateScannerRef.get() != null) {
            templateContent = this.templateScannerRef.get().getTemplate(templateName);
        }
        if (templateContent == null) {
            logger.warn("E-mail template not found: {}", (Object)templateName);
            return "TEMPLATE NOT FOUND: " + templateName;
        }
        HashMap<String, HashMap<String, String>> catalogs = this.initCatalogs(workflowInstance.getMediaPackage(), delimiter);
        WorkflowOperationInstance failed = this.findFailedOperation(workflowInstance);
        List<Incident> incidentList = null;
        if (failed != null) {
            try {
                IncidentTree incidents = this.incidentService.getIncidentsOfJob(failed.getId().longValue(), true);
                incidentList = this.generateIncidentList(incidents);
            }
            catch (Exception e) {
                logger.error("Error when populating template with incidents", (Throwable)e);
            }
        }
        Map orgProperties = null;
        Organization org = this.securityService.getOrganization();
        if (org != null) {
            orgProperties = org.getProperties();
        }
        return DocUtil.generate((DocData)new EmailData(templateName, workflowInstance, catalogs, failed, incidentList, orgProperties), (String)templateContent);
    }

    private HashMap<String, HashMap<String, String>> initCatalogs(MediaPackage mediaPackage, String delimiter) {
        HashMap<String, HashMap<String, String>> catalogs = new HashMap<String, HashMap<String, String>>();
        HashSet<MediaPackageElementFlavor> catalogFlavors = new HashSet<MediaPackageElementFlavor>();
        catalogFlavors.add(this.indexService.getCommonEventCatalogUIAdapter().getFlavor());
        catalogFlavors.add(this.indexService.getCommonSeriesCatalogUIAdapter().getFlavor());
        catalogFlavors.addAll(this.indexService.getEventCatalogUIAdapters().stream().map(CatalogUIAdapter::getFlavor).collect(Collectors.toSet()));
        catalogFlavors.addAll(this.indexService.getSeriesCatalogUIAdapters().stream().map(CatalogUIAdapter::getFlavor).collect(Collectors.toSet()));
        Set catalogElements = catalogFlavors.stream().flatMap(f -> Arrays.stream(mediaPackage.getCatalogs(f))).filter(Objects::nonNull).collect(Collectors.toSet());
        for (Catalog c : catalogElements) {
            DublinCoreCatalog dc;
            try (InputStream in = this.workspace.read(c.getURI());){
                dc = DublinCores.read((InputStream)in);
            }
            catch (Exception e) {
                logger.warn("Error when populating catalog data", (Throwable)e);
                continue;
            }
            HashMap<String, String> catalogHash = new HashMap<String, String>();
            for (EName ename : dc.getProperties()) {
                String name = ename.getLocalName();
                catalogHash.put(name, dc.getAsText(ename, "**", delimiter));
            }
            catalogs.put(c.getFlavor().toString(), catalogHash);
            if (!c.getFlavor().getType().equals("dublincore")) continue;
            catalogs.put(c.getFlavor().getSubtype(), catalogHash);
        }
        return catalogs;
    }

    private WorkflowOperationInstance findFailedOperation(WorkflowInstance workflow) {
        ArrayList operations = new ArrayList(workflow.getOperations());
        WorkflowOperationInstance emailOp = workflow.getCurrentOperation();
        WorkflowOperationInstance op = null;
        for (int i = operations.indexOf(emailOp) - 1; i >= 0; --i) {
            op = (WorkflowOperationInstance)operations.get(i);
            if (!WorkflowOperationInstance.OperationState.FAILED.equals((Object)op.getState()) || !op.isFailOnError()) continue;
            return op;
        }
        return null;
    }

    private List<Incident> generateIncidentList(IncidentTree tree) {
        LinkedList<Incident> list = new LinkedList<Incident>();
        if (tree != null && tree.getDescendants() != null && tree.getDescendants().size() > 0) {
            for (IncidentTree subtree : tree.getDescendants()) {
                list.addAll(this.generateIncidentList(subtree));
            }
        }
        list.addAll(tree.getIncidents());
        return list;
    }

    @Reference
    void setWorkspace(Workspace ws) {
        this.workspace = ws;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetEmailTemplateScanner")
    void setEmailTemplateScanner(EmailTemplateScanner templateScanner) {
        this.templateScannerRef.compareAndSet(null, templateScanner);
    }

    void unsetEmailTemplateScanner(EmailTemplateScanner templateScanner) {
        this.templateScannerRef.compareAndSet(templateScanner, null);
    }

    @Reference
    public void setIncidentService(IncidentService incidentService) {
        this.incidentService = incidentService;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

