/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.rebuild;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRebuildService
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(IndexRebuildService.class);
    private final Map<Service, IndexProducer> indexProducers = new ConcurrentHashMap<Service, IndexProducer>();
    private ServiceRegistration<?> serviceRegistration = null;
    private final Map<Service, State> rebuildStates = new HashMap<Service, State>();

    public void start(BundleContext bundleContext) throws Exception {
        ServiceReference[] serviceReferences = bundleContext.getAllServiceReferences(IndexProducer.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                this.addIndexProducer((IndexProducer)bundleContext.getService(serviceReference), bundleContext);
            }
        }
        this.setAllRebuildStates(State.OK);
        bundleContext.addServiceListener((ServiceListener)new IndexProducerListener(bundleContext), "(objectClass=" + IndexProducer.class.getName() + ")");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.unregisterIndexRebuildService();
    }

    public synchronized void rebuildIndex(ElasticsearchIndex index) throws IOException, IndexRebuildException {
        index.clear();
        logger.info("Index cleared, starting complete rebuild.");
        this.setAllRebuildStates(State.PENDING);
        for (Service service : Service.values()) {
            this.rebuildIndex(index, service);
        }
    }

    public synchronized void rebuildIndex(ElasticsearchIndex index, String serviceName) throws IllegalArgumentException, IndexRebuildException {
        Service service = Service.valueOf(serviceName);
        logger.info("Starting partial rebuild of the {} index.", (Object)service);
        this.setRebuildState(service, State.PENDING);
        this.rebuildIndex(index, service);
    }

    public synchronized void resumeIndexRebuild(ElasticsearchIndex index, String serviceName) throws IllegalArgumentException, IndexRebuildException {
        Service startingService = Service.valueOf(serviceName);
        logger.info("Resuming rebuild of {} index.", (Object)startingService);
        this.setSubsetOfRebuildStates(startingService, State.PENDING);
        Service[] services = Service.values();
        for (int i = startingService.ordinal(); i < services.length; ++i) {
            this.rebuildIndex(index, services[i]);
        }
    }

    private void rebuildIndex(ElasticsearchIndex index, Service service) throws IndexRebuildException {
        if (!this.indexProducers.containsKey((Object)service)) {
            throw new IllegalStateException(String.format("Service %s is not available", new Object[]{service}));
        }
        IndexProducer indexProducer = this.indexProducers.get((Object)service);
        logger.info("Starting to rebuild the {} index", (Object)service);
        this.setRebuildState(service, State.RUNNING);
        try {
            indexProducer.repopulate();
            this.setRebuildState(service, State.OK);
        }
        catch (IndexRebuildException e) {
            this.setRebuildState(service, State.ERROR);
        }
        logger.info("Finished rebuilding the {} index", (Object)service);
    }

    private void addIndexProducer(IndexProducer indexProducer, BundleContext bundleContext) {
        if (this.indexProducers.putIfAbsent(indexProducer.getService(), indexProducer) == null) {
            logger.info("Service {} added.", (Object)indexProducer.getService());
            if (this.indexProducers.size() == Service.values().length) {
                this.registerIndexRebuildService(bundleContext);
            }
        }
    }

    private void removeIndexProducer(IndexProducer indexProducer) {
        if (this.indexProducers.remove((Object)indexProducer.getService(), indexProducer)) {
            logger.info("Service {} removed.", (Object)indexProducer.getService());
            if (this.indexProducers.size() != Service.values().length) {
                this.unregisterIndexRebuildService();
            }
        }
    }

    private synchronized void unregisterIndexRebuildService() {
        if (this.serviceRegistration != null) {
            logger.info("Unregister IndexRebuildService.");
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    private synchronized void registerIndexRebuildService(BundleContext bundleContext) {
        if (this.serviceRegistration == null) {
            logger.info("Register IndexRebuildService.");
            this.serviceRegistration = bundleContext.registerService(this.getClass().getName(), (Object)this, null);
        }
    }

    public Map<String, String> getRebuildStates() {
        HashMap<String, String> statesAsString = new HashMap<String, String>();
        for (Map.Entry<Service, State> entry : this.rebuildStates.entrySet()) {
            statesAsString.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return statesAsString;
    }

    public String getRebuildState(Service service) {
        return this.rebuildStates.get((Object)service).toString();
    }

    private void setAllRebuildStates(State state) {
        for (Service service : Service.values()) {
            this.setRebuildState(service, state);
        }
    }

    private void setSubsetOfRebuildStates(Service startingService, State state) {
        Service[] services = Service.values();
        for (int i = startingService.ordinal(); i < services.length; ++i) {
            this.rebuildStates.put(services[i], state);
        }
    }

    private void setRebuildState(Service service, State state) {
        this.rebuildStates.put(service, state);
    }

    private final class IndexProducerListener
    implements ServiceListener {
        private final BundleContext bundleContext;

        private IndexProducerListener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            if (serviceEvent.getType() == 1) {
                ServiceReference serviceReference = serviceEvent.getServiceReference();
                IndexRebuildService.this.addIndexProducer((IndexProducer)this.bundleContext.getService(serviceReference), this.bundleContext);
            } else if (serviceEvent.getType() == 4) {
                ServiceReference serviceReference = serviceEvent.getServiceReference();
                IndexRebuildService.this.removeIndexProducer((IndexProducer)this.bundleContext.getService(serviceReference));
            }
        }
    }

    public static enum State {
        PENDING,
        RUNNING,
        OK,
        ERROR;

    }

    public static enum Service {
        Themes,
        Series,
        Scheduler,
        AssetManager,
        Comments,
        Workflow,
        Search;

    }
}

