/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.rebuild;

import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.security.api.Organization;
import org.slf4j.Logger;

public abstract class AbstractIndexProducer
implements IndexProducer {
    protected void logIndexRebuildBegin(Logger logger, int total, String elementName) {
        logger.info("Starting {} index rebuild with {} {}", new Object[]{this.getService(), total, elementName});
    }

    protected void logIndexRebuildBegin(Logger logger, int total, String elementName, Organization org) {
        logger.info("Starting {} index rebuild for organization {} with {} {}", new Object[]{this.getService(), org, total, elementName});
    }

    protected void logIndexRebuildProgress(Logger logger, int total, int current) {
        this.logIndexRebuildProgress(logger, total, current, 1);
    }

    protected void logIndexRebuildProgress(Logger logger, int total, int current, Organization org) {
        this.logIndexRebuildProgress(logger, total, current, 1, org);
    }

    protected void logIndexRebuildProgress(Logger logger, int total, int current, int batchSize) {
        this.logIndexRebuildProgress(logger, total, current, batchSize, null);
    }

    protected void logIndexRebuildProgress(Logger logger, int total, int current, int batchSize, Organization org) {
        int responseInterval;
        int n = responseInterval = total < 100 ? 1 : total / 100;
        if (responseInterval == 1 || batchSize > responseInterval || current == total || current % responseInterval < batchSize) {
            int progress;
            int n2 = progress = total > 0 ? current * 100 / total : 100;
            if (org == null) {
                logger.info("{} index rebuild: {}/{} finished, {}% complete.", new Object[]{this.getService(), current, total, progress});
            } else {
                logger.info("{} index rebuild for organization {}: {}/{} finished, {}% complete.", new Object[]{this.getService(), org.getId(), current, total, progress});
            }
        }
    }

    protected void logSkippingElement(Logger logger, String elementName, String element, Throwable t) {
        logger.error("Unable to re-index {} {}, skipping.", new Object[]{elementName, element, t});
    }

    protected void logSkippingElement(Logger logger, String elementName, String element, Organization org, Throwable t) {
        logger.error("Unable to re-index {} {} for organization {}, skipping.", new Object[]{elementName, element, org.getId(), t});
    }

    protected void logIndexRebuildError(Logger logger, Throwable t) {
        logger.error("Error updating the {} index.", (Object)this.getService(), (Object)t);
    }

    protected void logIndexRebuildError(Logger logger, int total, int current, Throwable t) {
        logger.error("Error updating the {} index: {}/{} could be finished.", new Object[]{this.getService(), current, total, t});
    }

    protected void logIndexRebuildError(Logger logger, Throwable t, Organization org) {
        logger.error("Error updating the {} index for service for organization {}.", new Object[]{this.getService(), org.getId(), t});
    }
}

