/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.theme;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchTerms;
import org.opencastproject.elasticsearch.impl.AbstractSearchQuery;
import org.opencastproject.security.api.User;
import org.opencastproject.util.requests.SortCriterion;

public class ThemeSearchQuery
extends AbstractSearchQuery {
    protected List<Long> identifiers = new ArrayList<Long>();
    private User user = null;
    private String organization = null;
    private String creator = null;
    private Date createdFrom = null;
    private Date createdTo = null;
    private Boolean isDefault = null;
    private String description = null;
    private String name = null;
    private Boolean bumperActive = null;
    private String bumperFile = null;
    private Boolean licenseSlideActive = null;
    private String licenseSlideBackground = null;
    private String licenseSlideDescription = null;
    private Boolean trailerActive = null;
    private String trailerFile = null;
    private Boolean titleSlideActive = null;
    private String titleSlideBackground = null;
    private String titleSlideMetadata = null;
    private Boolean watermarkActive = null;
    private String watermarkFile = null;
    private String watermarkPosition = null;

    private ThemeSearchQuery() {
    }

    public ThemeSearchQuery(String organization, User user) {
        super("theme");
        if (organization == null) {
            throw new IllegalStateException("The organization for this query was null.");
        }
        if (user == null) {
            throw new IllegalStateException("The user for this query was null.");
        }
        this.organization = organization;
        this.user = user;
        if (!user.getOrganization().getId().equals(organization)) {
            throw new IllegalStateException("User's organization must match search organization");
        }
    }

    public ThemeSearchQuery withIdentifier(long id) {
        this.identifiers.add(id);
        return this;
    }

    public Long[] getIdentifiers() {
        return this.identifiers.toArray(new Long[this.identifiers.size()]);
    }

    public ThemeSearchQuery withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOrganization() {
        return this.organization;
    }

    public User getUser() {
        return this.user;
    }

    public ThemeSearchQuery withCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public ThemeSearchQuery withCreatedFrom(Date createdFrom) {
        this.createdFrom = createdFrom;
        return this;
    }

    public Date getCreatedFrom() {
        return this.createdFrom;
    }

    public ThemeSearchQuery withCreatedTo(Date createdTo) {
        this.createdTo = createdTo;
        return this;
    }

    public Date getCreatedTo() {
        return this.createdTo;
    }

    public ThemeSearchQuery withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public ThemeSearchQuery withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ThemeSearchQuery withBumperActive(Boolean bumperActive) {
        this.bumperActive = bumperActive;
        return this;
    }

    public Boolean getBumperActive() {
        return this.bumperActive;
    }

    public ThemeSearchQuery withBumperFile(String bumperFile) {
        this.bumperFile = bumperFile;
        return this;
    }

    public String getBumperFile() {
        return this.bumperFile;
    }

    public ThemeSearchQuery withLicenseSlideActive(Boolean licenseSlideActive) {
        this.licenseSlideActive = licenseSlideActive;
        return this;
    }

    public Boolean getLicenseSlideActive() {
        return this.licenseSlideActive;
    }

    public ThemeSearchQuery withLicenseSlideBackground(String licenseSlideBackground) {
        this.licenseSlideBackground = licenseSlideBackground;
        return this;
    }

    public String getLicenseSlideBackground() {
        return this.licenseSlideBackground;
    }

    public ThemeSearchQuery withLicenseSlideDescription(String licenseSlideDescription) {
        this.licenseSlideDescription = licenseSlideDescription;
        return this;
    }

    public String getLicenseSlideDescription() {
        return this.licenseSlideDescription;
    }

    public ThemeSearchQuery withTrailerActive(Boolean trailerActive) {
        this.trailerActive = trailerActive;
        return this;
    }

    public Boolean getTrailerActive() {
        return this.trailerActive;
    }

    public ThemeSearchQuery withTrailerFile(String trailerFile) {
        this.trailerFile = trailerFile;
        return this;
    }

    public String getTrailerFile() {
        return this.trailerFile;
    }

    public ThemeSearchQuery withTitleSlideActive(Boolean titleSlideActive) {
        this.titleSlideActive = titleSlideActive;
        return this;
    }

    public Boolean getTitleSlideActive() {
        return this.titleSlideActive;
    }

    public ThemeSearchQuery withTitleSlideMetadata(String titleSlideMetadata) {
        this.titleSlideMetadata = titleSlideMetadata;
        return this;
    }

    public String getTitleSlideMetadata() {
        return this.titleSlideMetadata;
    }

    public ThemeSearchQuery withTitleSlideBackground(String titleSlideBackground) {
        this.titleSlideBackground = titleSlideBackground;
        return this;
    }

    public String getTitleSlideBackground() {
        return this.titleSlideBackground;
    }

    public ThemeSearchQuery withWatermarkActive(Boolean watermarkActive) {
        this.watermarkActive = watermarkActive;
        return this;
    }

    public Boolean getWatermarkActive() {
        return this.watermarkActive;
    }

    public ThemeSearchQuery withWatermarkFile(String watermarkFile) {
        this.watermarkFile = watermarkFile;
        return this;
    }

    public String getWatermarkFile() {
        return this.watermarkFile;
    }

    public ThemeSearchQuery withLicense(String watermarkPosition) {
        this.watermarkPosition = watermarkPosition;
        return this;
    }

    public String getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public ThemeSearchQuery sortByCreator(SortCriterion.Order order) {
        this.withSortOrder("creator", order);
        return this;
    }

    public SortCriterion.Order getThemeCreatorSortOrder() {
        return this.getSortOrder("creator");
    }

    public ThemeSearchQuery sortByCreatedDateTime(SortCriterion.Order order) {
        this.withSortOrder("creation_date", order);
        return this;
    }

    public ThemeSearchQuery sortByDefault(SortCriterion.Order order) {
        this.withSortOrder("default", order);
        return this;
    }

    public SortCriterion.Order getSeriesDateSortOrder() {
        return this.getSortOrder("creation_date");
    }

    public ThemeSearchQuery sortByName(SortCriterion.Order order) {
        this.withSortOrder("name", order);
        return this;
    }

    public SortCriterion.Order getThemeNameSortOrder() {
        return this.getSortOrder("name");
    }

    public ThemeSearchQuery sortByDescription(SortCriterion.Order order) {
        this.withSortOrder("description", order);
        return this;
    }

    public SortCriterion.Order getThemeDescriptionSortOrder() {
        return this.getSortOrder("description");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ThemeSearchQuery.class.getSimpleName() + " ");
        if (this.identifiers.size() > 0) {
            sb.append("ids:'" + this.identifiers.toString() + "' ");
        }
        if (StringUtils.trimToNull((String)this.organization) != null) {
            sb.append("organization:'" + this.organization + "' ");
        }
        if (StringUtils.trimToNull((String)this.creator) != null) {
            sb.append("creator:'" + this.creator + "' ");
        }
        if (this.createdFrom != null) {
            sb.append("Created From:'" + this.createdFrom + "' ");
        }
        if (this.createdTo != null) {
            sb.append("Created To:'" + this.createdTo + "' ");
        }
        sb.append("Is Default:'" + this.isDefault + "' ");
        if (StringUtils.trimToNull((String)this.description) != null) {
            sb.append("description:'" + this.description + "' ");
        }
        if (StringUtils.trimToNull((String)this.name) != null) {
            sb.append("name:'" + this.name + "' ");
        }
        sb.append("bumper active:'" + this.bumperActive + "' ");
        if (StringUtils.trimToNull((String)this.bumperFile) != null) {
            sb.append("bumper file:'" + this.bumperFile + "' ");
        }
        sb.append("license slide active:'" + this.licenseSlideActive + "' ");
        if (StringUtils.trimToNull((String)this.licenseSlideBackground) != null) {
            sb.append("license slide background:'" + this.licenseSlideBackground + "' ");
        }
        if (StringUtils.trimToNull((String)this.licenseSlideDescription) != null) {
            sb.append("license slide description:'" + this.licenseSlideDescription + "' ");
        }
        sb.append("trailer active:'" + this.trailerActive + "' ");
        if (StringUtils.trimToNull((String)this.trailerFile) != null) {
            sb.append("trailer file:'" + this.trailerFile + "' ");
        }
        sb.append("title slide active:'" + this.titleSlideActive + "' ");
        if (StringUtils.trimToNull((String)this.titleSlideBackground) != null) {
            sb.append("title slide background:'" + this.titleSlideBackground + "' ");
        }
        if (StringUtils.trimToNull((String)this.titleSlideMetadata) != null) {
            sb.append("title slide metadata:'" + this.titleSlideMetadata + "' ");
        }
        sb.append("watermark active:'" + this.watermarkActive + "' ");
        if (StringUtils.trimToNull((String)this.watermarkFile) != null) {
            sb.append("watermark file:'" + this.watermarkFile + "' ");
        }
        if (StringUtils.trimToNull((String)this.watermarkPosition) != null) {
            sb.append("watermark position:'" + this.watermarkPosition + "' ");
        }
        if (this.getTerms().size() > 0) {
            sb.append("Text:");
            for (SearchTerms searchTerm : this.getTerms()) {
                sb.append("'" + searchTerm.getTerms() + "' ");
            }
        }
        return sb.toString();
    }
}

