/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.theme;

import java.util.ArrayList;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchTerms;
import org.opencastproject.elasticsearch.impl.AbstractElasticsearchQueryBuilder;
import org.opencastproject.elasticsearch.index.objects.theme.ThemeSearchQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeQueryBuilder
extends AbstractElasticsearchQueryBuilder<ThemeSearchQuery> {
    private static final Logger logger = LoggerFactory.getLogger(ThemeQueryBuilder.class);

    public ThemeQueryBuilder(ThemeSearchQuery query) {
        super((SearchQuery)query);
    }

    public void buildQuery(ThemeSearchQuery query) {
        if (query.getOrganization() == null) {
            throw new IllegalStateException("No organization set on the theme search query!");
        }
        this.and("organization", new Object[]{query.getOrganization()});
        if (query.getIdentifiers().length > 0) {
            this.and("id", query.getIdentifiers());
        }
        if (query.getCreator() != null) {
            this.and("creator", new Object[]{query.getCreator()});
        }
        if (query.getCreatedFrom() != null && query.getCreatedTo() != null) {
            this.and("creation_date", query.getCreatedFrom(), query.getCreatedTo());
        }
        if (query.getIsDefault() != null) {
            this.and("default", new Object[]{query.getIsDefault()});
        }
        if (query.getDescription() != null) {
            this.and("description", new Object[]{query.getDescription()});
        }
        if (query.getName() != null) {
            this.and("name", new Object[]{query.getName()});
        }
        if (query.getBumperActive() != null) {
            this.and("bumper_active", new Object[]{query.getBumperActive()});
        }
        if (query.getBumperFile() != null) {
            this.and("bumper_file", new Object[]{query.getBumperFile()});
        }
        if (query.getLicenseSlideActive() != null) {
            this.and("license_slide_active", new Object[]{query.getLicenseSlideActive()});
        }
        if (query.getLicenseSlideBackground() != null) {
            this.and("license_slide_background", new Object[]{query.getLicenseSlideBackground()});
        }
        if (query.getLicenseSlideDescription() != null) {
            this.and("license_slide_description", new Object[]{query.getLicenseSlideDescription()});
        }
        if (query.getTrailerActive() != null) {
            this.and("trailer_active", new Object[]{query.getTrailerActive()});
        }
        if (query.getTrailerFile() != null) {
            this.and("trailer_file", new Object[]{query.getTrailerFile()});
        }
        if (query.getTitleSlideActive() != null) {
            this.and("title_slide_active", new Object[]{query.getTitleSlideActive()});
        }
        if (query.getTitleSlideBackground() != null) {
            this.and("title_slide_background", new Object[]{query.getTitleSlideBackground()});
        }
        if (query.getTitleSlideMetadata() != null) {
            this.and("title_slide_metadata", new Object[]{query.getTitleSlideMetadata()});
        }
        if (query.getWatermarkActive() != null) {
            this.and("watermark_active", new Object[]{query.getWatermarkActive()});
        }
        if (query.getWatermarkFile() != null) {
            this.and("watermark_file", new Object[]{query.getWatermarkFile()});
        }
        if (query.getWatermarkPosition() != null) {
            this.and("watermark_position", new Object[]{query.getWatermarkPosition()});
        }
        if (query.getTerms() != null) {
            for (SearchTerms terms : query.getTerms()) {
                StringBuilder queryText = new StringBuilder();
                for (String term : terms.getTerms()) {
                    if (queryText.length() > 0) {
                        queryText.append(" ");
                    }
                    queryText.append(term);
                }
                if (query.isFuzzySearch()) {
                    this.fuzzyText = queryText.toString();
                } else {
                    this.text = queryText.toString();
                }
                if (!SearchTerms.Quantifier.All.equals((Object)terms.getQuantifier())) continue;
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                if (query.isFuzzySearch()) {
                    logger.warn("All quantifier not supported in conjunction with wildcard text");
                }
                this.groups.add(new AbstractElasticsearchQueryBuilder.ValueGroup("text", (Object[])terms.getTerms().toArray(new String[terms.size()])));
            }
        }
        if (query.getFilter() != null) {
            this.filter = query.getFilter();
        }
    }
}

