/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.theme;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchMetadata;
import org.opencastproject.elasticsearch.impl.SearchMetadataCollection;
import org.opencastproject.elasticsearch.index.objects.IndexObject;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlType(name="theme", namespace="http://index.matterhorn.opencastproject.org", propOrder={"identifier", "creationDate", "isDefault", "description", "name", "creator", "organization", "bumperActive", "bumperFile", "trailerActive", "trailerFile", "titleSlideActive", "titleSlideMetadata", "titleSlideBackground", "licenseSlideActive", "licenseSlideDescription", "licenseSlideBackground", "watermarkActive", "watermarkFile", "watermarkPosition"})
@XmlRootElement(name="theme", namespace="http://index.matterhorn.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class IndexTheme
implements IndexObject {
    public static final String DOCUMENT_TYPE = "theme";
    public static final String XML_SURROUNDING_TAG = "themes";
    @XmlElement(name="identifier")
    private Long identifier = null;
    @XmlElement(name="creationDate")
    @XmlJavaTypeAdapter(value=DateTimeSupport.UtcTimestampAdapter.class)
    private Date creationDate;
    @XmlElement(name="default")
    private boolean isDefault = false;
    @XmlElement(name="description")
    private String description = null;
    @XmlElement(name="name")
    private String name = null;
    @XmlElement(name="creator")
    private String creator = null;
    @XmlElement(name="organization")
    private String organization = null;
    @XmlElement(name="bumperActive")
    private boolean bumperActive = false;
    @XmlElement(name="bumperFile")
    private String bumperFile = null;
    @XmlElement(name="trailerActive")
    private boolean trailerActive = false;
    @XmlElement(name="trailerFile")
    private String trailerFile = null;
    @XmlElement(name="titleSlideActive")
    private boolean titleSlideActive = false;
    @XmlElement(name="titleSlideMetadata")
    private String titleSlideMetadata = null;
    @XmlElement(name="titleSlideBackground")
    private String titleSlideBackground = null;
    @XmlElement(name="licenseSlideActive")
    private boolean licenseSlideActive = false;
    @XmlElement(name="licenseSlideDescription")
    private String licenseSlideDescription = null;
    @XmlElement(name="licenseSlideBackground")
    private String licenseSlideBackground = null;
    @XmlElement(name="watermarkActive")
    private boolean watermarkActive = false;
    @XmlElement(name="watermarkFile")
    private String watermarkFile = null;
    @XmlElement(name="watermarkPosition")
    private String watermarkPosition = null;
    private static JAXBContext context = null;

    public IndexTheme() {
    }

    public IndexTheme(long identifier, String organization) {
        this.identifier = identifier;
        this.organization = organization;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getOrganization() {
        return this.organization;
    }

    public boolean isBumperActive() {
        return this.bumperActive;
    }

    public void setBumperActive(boolean bumperActive) {
        this.bumperActive = bumperActive;
    }

    public String getBumperFile() {
        return this.bumperFile;
    }

    public void setBumperFile(String bumperFile) {
        this.bumperFile = bumperFile;
    }

    public boolean isTrailerActive() {
        return this.trailerActive;
    }

    public void setTrailerActive(boolean trailerActive) {
        this.trailerActive = trailerActive;
    }

    public String getTrailerFile() {
        return this.trailerFile;
    }

    public void setTrailerFile(String trailerFile) {
        this.trailerFile = trailerFile;
    }

    public boolean isTitleSlideActive() {
        return this.titleSlideActive;
    }

    public void setTitleSlideActive(boolean titleSlideActive) {
        this.titleSlideActive = titleSlideActive;
    }

    public String getTitleSlideMetadata() {
        return this.titleSlideMetadata;
    }

    public void setTitleSlideMetadata(String titleSlideMetadata) {
        this.titleSlideMetadata = titleSlideMetadata;
    }

    public String getTitleSlideBackground() {
        return this.titleSlideBackground;
    }

    public void setTitleSlideBackground(String titleSlideBackground) {
        this.titleSlideBackground = titleSlideBackground;
    }

    public boolean isLicenseSlideActive() {
        return this.licenseSlideActive;
    }

    public void setLicenseSlideActive(boolean licenseSlideActive) {
        this.licenseSlideActive = licenseSlideActive;
    }

    public String getLicenseSlideDescription() {
        return this.licenseSlideDescription;
    }

    public void setLicenseSlideDescription(String licenseSlideDescription) {
        this.licenseSlideDescription = licenseSlideDescription;
    }

    public String getLicenseSlideBackground() {
        return this.licenseSlideBackground;
    }

    public void setLicenseSlideBackground(String licenseSlideBackground) {
        this.licenseSlideBackground = licenseSlideBackground;
    }

    public boolean isWatermarkActive() {
        return this.watermarkActive;
    }

    public void setWatermarkActive(boolean watermarkActive) {
        this.watermarkActive = watermarkActive;
    }

    public String getWatermarkFile() {
        return this.watermarkFile;
    }

    public void setWatermarkFile(String watermarkFile) {
        this.watermarkFile = watermarkFile;
    }

    public String getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public void setWatermarkPosition(String watermarkPosition) {
        this.watermarkPosition = watermarkPosition;
    }

    public static IndexTheme valueOf(InputStream xml) throws IOException {
        try {
            if (context == null) {
                IndexTheme.createJAXBContext();
            }
            Unmarshaller unmarshaller = context.createUnmarshaller();
            IndexTheme indexTheme = (IndexTheme)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)xml), IndexTheme.class).getValue();
            return indexTheme;
        }
        catch (JAXBException e) {
            throw new IOException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)xml);
        }
    }

    private static void createJAXBContext() throws JAXBException {
        context = JAXBContext.newInstance((Class[])new Class[]{IndexTheme.class});
    }

    public String toXML() {
        try {
            if (context == null) {
                IndexTheme.createJAXBContext();
            }
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }

    public static IndexTheme fromSearchMetadata(SearchMetadataCollection metadata) throws IOException {
        Map metadataMap = metadata.toMap();
        String themeXml = (String)((SearchMetadata)metadataMap.get("object")).getValue();
        return IndexTheme.valueOf(IOUtils.toInputStream((String)themeXml));
    }

    public SearchMetadataCollection toSearchMetadata() {
        SearchMetadataCollection metadata = new SearchMetadataCollection(Long.toString(this.getIdentifier()).concat(this.getOrganization()), DOCUMENT_TYPE);
        metadata.addField("id", (Object)this.getIdentifier(), true);
        metadata.addField("organization", (Object)this.getOrganization(), false);
        metadata.addField("object", (Object)this.toXML(), false);
        if (StringUtils.isNotBlank((CharSequence)this.getName())) {
            metadata.addField("name", (Object)this.getName(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDescription())) {
            metadata.addField("description", (Object)this.getDescription(), true);
        }
        metadata.addField("default", (Object)this.isDefault(), false);
        if (this.getCreationDate() != null) {
            metadata.addField("creation_date", (Object)DateTimeSupport.toUTC((long)this.getCreationDate().getTime()), true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCreator())) {
            metadata.addField("creator", (Object)this.getCreator(), true);
        }
        metadata.addField("bumper_active", (Object)this.isBumperActive(), false);
        if (StringUtils.isNotBlank((CharSequence)this.getBumperFile())) {
            metadata.addField("bumper_file", (Object)this.getBumperFile(), false);
        }
        metadata.addField("trailer_active", (Object)this.isTrailerActive(), false);
        if (StringUtils.isNotBlank((CharSequence)this.getTrailerFile())) {
            metadata.addField("trailer_file", (Object)this.getTrailerFile(), false);
        }
        metadata.addField("title_slide_active", (Object)this.isTrailerActive(), false);
        if (StringUtils.isNotBlank((CharSequence)this.getTitleSlideMetadata())) {
            metadata.addField("title_slide_metadata", (Object)this.getTitleSlideMetadata(), false);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTitleSlideBackground())) {
            metadata.addField("title_slide_background", (Object)this.getTitleSlideBackground(), false);
        }
        metadata.addField("license_slide_active", (Object)this.isLicenseSlideActive(), false);
        if (StringUtils.isNotBlank((CharSequence)this.getLicenseSlideDescription())) {
            metadata.addField("license_slide_description", (Object)this.getLicenseSlideDescription(), false);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getLicenseSlideBackground())) {
            metadata.addField("license_slide_background", (Object)this.getLicenseSlideBackground(), false);
        }
        metadata.addField("watermark_active", (Object)this.isWatermarkActive(), false);
        if (StringUtils.isNotBlank((CharSequence)this.getWatermarkFile())) {
            metadata.addField("watermark_file", (Object)this.getWatermarkFile(), false);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getWatermarkPosition())) {
            metadata.addField("watermark_position", (Object)this.getWatermarkPosition(), false);
        }
        return metadata;
    }
}

