/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.series;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchTerms;
import org.opencastproject.elasticsearch.impl.AbstractSearchQuery;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.User;
import org.opencastproject.util.requests.SortCriterion;

public class SeriesSearchQuery
extends AbstractSearchQuery {
    protected List<String> identifiers = new ArrayList<String>();
    private String title = null;
    private User user = null;
    private String description = null;
    private Set<String> actions = new HashSet<String>();
    private List<String> subjects = new ArrayList<String>();
    private String organization = null;
    private String language = null;
    private String creator = null;
    private String license = null;
    private String accessPolicy = null;
    private String managedAcl = null;
    private List<String> organizers = new ArrayList<String>();
    private List<String> contributors = new ArrayList<String>();
    private List<String> publishers = new ArrayList<String>();
    private Date createdFrom = null;
    private Date createdTo = null;
    private boolean editOnly = false;
    private String rightsHolder = null;
    private Long theme = null;

    private SeriesSearchQuery() {
    }

    public SeriesSearchQuery(String organization, User user) {
        super("series");
        this.organization = organization;
        this.user = user;
        this.actions.add(Permissions.Action.READ.toString());
        if (!user.hasRole("ROLE_ADMIN") && !user.getOrganization().getId().equals(organization)) {
            throw new IllegalStateException("User's organization must match search organization");
        }
    }

    public SeriesSearchQuery withIdentifier(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Identifier cannot be null");
        }
        this.identifiers.add(id);
        return this;
    }

    public String[] getIdentifier() {
        return this.identifiers.toArray(new String[this.identifiers.size()]);
    }

    public SeriesSearchQuery withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SeriesSearchQuery withoutActions() {
        this.actions.clear();
        return this;
    }

    public SeriesSearchQuery withAction(Permissions.Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null");
        }
        this.actions.add(action.toString());
        return this;
    }

    public String[] getActions() {
        return this.actions.toArray(new String[this.actions.size()]);
    }

    public SeriesSearchQuery withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SeriesSearchQuery withSubject(String subject) {
        if (StringUtils.isBlank((CharSequence)subject)) {
            throw new IllegalArgumentException("Subject cannot be null");
        }
        this.subjects.add(subject);
        return this;
    }

    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    public String getOrganization() {
        return this.organization;
    }

    public User getUser() {
        return this.user;
    }

    public SeriesSearchQuery withLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public SeriesSearchQuery withCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public SeriesSearchQuery withLicense(String license) {
        this.license = license;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public SeriesSearchQuery withAccessPolicy(String accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public SeriesSearchQuery withTheme(long theme) {
        this.theme = theme;
        return this;
    }

    public Long getTheme() {
        return this.theme;
    }

    public SeriesSearchQuery withManagedAcl(String managedAcl) {
        this.managedAcl = managedAcl;
        return this;
    }

    public String getManagedAcl() {
        return this.managedAcl;
    }

    public SeriesSearchQuery withOrganizer(String organizer) {
        if (StringUtils.isBlank((CharSequence)organizer)) {
            throw new IllegalArgumentException("Organizer cannot be null");
        }
        this.organizers.add(organizer);
        return this;
    }

    public String[] getOrganizers() {
        return this.organizers.toArray(new String[this.organizers.size()]);
    }

    public SeriesSearchQuery withContributor(String contributor) {
        if (StringUtils.isBlank((CharSequence)contributor)) {
            throw new IllegalArgumentException("Contributor can't be null");
        }
        this.contributors.add(contributor);
        return this;
    }

    public String[] getContributors() {
        return this.contributors.toArray(new String[this.contributors.size()]);
    }

    public SeriesSearchQuery withPublisher(String publisher) {
        if (StringUtils.isBlank((CharSequence)publisher)) {
            throw new IllegalArgumentException("Publisher can't be null");
        }
        this.publishers.add(publisher);
        return this;
    }

    public String[] getPublishers() {
        return this.publishers.toArray(new String[this.publishers.size()]);
    }

    public SeriesSearchQuery withCreatedFrom(Date createdFrom) {
        this.createdFrom = createdFrom;
        return this;
    }

    public Date getCreatedFrom() {
        return this.createdFrom;
    }

    public SeriesSearchQuery withCreatedTo(Date createdTo) {
        this.createdTo = createdTo;
        return this;
    }

    public Date getCreatedTo() {
        return this.createdTo;
    }

    public SeriesSearchQuery withEdit(Boolean edit) {
        this.editOnly = edit;
        return this;
    }

    public boolean isEditOnly() {
        return this.editOnly;
    }

    public SeriesSearchQuery withRightsHolder(String rightsHolder) {
        this.rightsHolder = rightsHolder;
        return this;
    }

    public String getRightsHolder() {
        return this.rightsHolder;
    }

    public SeriesSearchQuery sortByIdentifer(SortCriterion.Order order) {
        this.withSortOrder("uid", order);
        return this;
    }

    public SortCriterion.Order getSeriesIdentifierSortOrder() {
        return this.getSortOrder("uid");
    }

    public SeriesSearchQuery sortBySubject(SortCriterion.Order order) {
        this.withSortOrder("subject", order);
        return this;
    }

    public SortCriterion.Order getSeriesSubjectSortOrder() {
        return this.getSortOrder("subject");
    }

    public SeriesSearchQuery sortByCreator(SortCriterion.Order order) {
        this.withSortOrder("creator", order);
        return this;
    }

    public SortCriterion.Order getSeriesCreatorSortOrder() {
        return this.getSortOrder("creator");
    }

    public SeriesSearchQuery sortByPublishers(SortCriterion.Order order) {
        this.withSortOrder("publisher", order);
        return this;
    }

    public SortCriterion.Order getSeriesPublishersSortOrder() {
        return this.getSortOrder("publisher");
    }

    public SeriesSearchQuery sortByDescription(SortCriterion.Order order) {
        this.withSortOrder("description", order);
        return this;
    }

    public SortCriterion.Order getSeriesDescriptionSortOrder() {
        return this.getSortOrder("description");
    }

    public SeriesSearchQuery sortByLanguage(SortCriterion.Order order) {
        this.withSortOrder("language", order);
        return this;
    }

    public SortCriterion.Order getSeriesLanguageSortOrder() {
        return this.getSortOrder("language");
    }

    public SeriesSearchQuery sortByRightsHolder(SortCriterion.Order order) {
        this.withSortOrder("rights_holder", order);
        return this;
    }

    public SortCriterion.Order getSeriesRightsHolderSortOrder() {
        return this.getSortOrder("rights_holder");
    }

    public SeriesSearchQuery sortByLicense(SortCriterion.Order order) {
        this.withSortOrder("license", order);
        return this;
    }

    public SortCriterion.Order getSeriesLicenseSortOrder() {
        return this.getSortOrder("license");
    }

    public SeriesSearchQuery sortByContributors(SortCriterion.Order order) {
        this.withSortOrder("contributors", order);
        return this;
    }

    public SortCriterion.Order getSeriesContributorsSortOrder() {
        return this.getSortOrder("contributors");
    }

    public SeriesSearchQuery sortByManagedAcl(SortCriterion.Order order) {
        this.withSortOrder("managed_acl", order);
        return this;
    }

    public SortCriterion.Order getSeriesManagedAclSortOrder() {
        return this.getSortOrder("managed_acl");
    }

    public SeriesSearchQuery sortByCreatedDateTime(SortCriterion.Order order) {
        this.withSortOrder("createdDateTime", order);
        return this;
    }

    public SortCriterion.Order getSeriesDateSortOrder() {
        return this.getSortOrder("createdDateTime");
    }

    public SeriesSearchQuery sortByOrganizers(SortCriterion.Order order) {
        this.withSortOrder("organizers", order);
        return this;
    }

    public SortCriterion.Order getSeriesOrganizersSortOrder() {
        return this.getSortOrder("organizers");
    }

    public SeriesSearchQuery sortByTitle(SortCriterion.Order order) {
        this.withSortOrder("title", order);
        return this;
    }

    public SortCriterion.Order getSeriesTitleSortOrder() {
        return this.getSortOrder("title");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SeriesSearchQuery.class.getSimpleName() + " ");
        if (this.identifiers.size() > 0) {
            sb.append("ids:'" + this.identifiers.toString() + "' ");
        }
        if (StringUtils.trimToNull((String)this.title) != null) {
            sb.append("title:'" + this.title + "' ");
        }
        if (StringUtils.trimToNull((String)this.description) != null) {
            sb.append("description:'" + this.description + "' ");
        }
        if (this.subjects.size() > 0) {
            sb.append("subjects:'" + this.subjects.toString() + "' ");
        }
        if (StringUtils.trimToNull((String)this.organization) != null) {
            sb.append("organization:'" + this.organization + "' ");
        }
        if (StringUtils.trimToNull((String)this.language) != null) {
            sb.append("language:'" + this.language + "' ");
        }
        if (StringUtils.trimToNull((String)this.creator) != null) {
            sb.append("creator:'" + this.creator + "' ");
        }
        if (StringUtils.trimToNull((String)this.license) != null) {
            sb.append("license:'" + this.license + "' ");
        }
        if (StringUtils.trimToNull((String)this.accessPolicy) != null) {
            sb.append("ACL:'" + this.accessPolicy + "' ");
        }
        if (this.createdFrom != null) {
            sb.append("Created From:'" + this.createdFrom + "' ");
        }
        if (this.createdTo != null) {
            sb.append("Created To:'" + this.createdTo + "' ");
        }
        if (this.organizers.size() > 0) {
            sb.append("organizers:'" + this.organizers.toString() + "' ");
        }
        if (this.contributors.size() > 0) {
            sb.append("contributors:'" + this.contributors.toString() + "' ");
        }
        if (this.publishers.size() > 0) {
            sb.append("publishers:'" + this.publishers.toString() + "' ");
        }
        if (this.theme != null) {
            sb.append("Theme:'" + this.theme + "' ");
        }
        sb.append("Edit:'" + this.editOnly + "' ");
        if (this.getTerms().size() > 0) {
            sb.append("Text:");
            for (SearchTerms searchTerm : this.getTerms()) {
                sb.append("'" + searchTerm.getTerms() + "' ");
            }
        }
        if (StringUtils.trimToNull((String)this.rightsHolder) != null) {
            sb.append("Rights Holder:'" + this.rightsHolder + "' ");
        }
        return sb.toString();
    }
}

