/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.series;

import java.util.ArrayList;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchTerms;
import org.opencastproject.elasticsearch.impl.AbstractElasticsearchQueryBuilder;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesQueryBuilder
extends AbstractElasticsearchQueryBuilder<SeriesSearchQuery> {
    private static final Logger logger = LoggerFactory.getLogger(SeriesQueryBuilder.class);

    public SeriesQueryBuilder(SeriesSearchQuery query) {
        super((SearchQuery)query);
    }

    public void buildQuery(SeriesSearchQuery query) {
        User user;
        if (query.getOrganization() == null) {
            throw new IllegalStateException("No organization set on the series search query!");
        }
        this.and("organization", new Object[]{query.getOrganization()});
        if (query.getIdentifier().length > 0) {
            this.and("uid", query.getIdentifier());
        }
        if (query.getTitle() != null) {
            this.and("title", new Object[]{query.getTitle()});
        }
        if (query.getActions() != null && query.getActions().length > 0 && !(user = query.getUser()).hasRole("ROLE_ADMIN") && !user.hasRole(user.getOrganization().getAdminRole())) {
            for (Role role : user.getRoles()) {
                for (String action : query.getActions()) {
                    this.and("acl_permission_".concat(action), new Object[]{role.getName()});
                }
            }
        }
        if (query.getDescription() != null) {
            this.and("description", new Object[]{query.getDescription()});
        }
        if (query.getSubjects().length > 0) {
            this.and("subject", query.getSubjects());
        }
        if (query.getLanguage() != null) {
            this.and("language", new Object[]{query.getLanguage()});
        }
        if (query.getCreator() != null) {
            this.and("creator", new Object[]{query.getCreator()});
        }
        if (query.getLicense() != null) {
            this.and("license", new Object[]{query.getLicense()});
        }
        if (query.getAccessPolicy() != null) {
            this.and("access_policy", new Object[]{query.getAccessPolicy()});
        }
        if (query.getCreatedFrom() != null && query.getCreatedTo() != null) {
            this.and("createdDateTime", query.getCreatedFrom(), query.getCreatedTo());
        }
        if (query.getOrganizers().length > 0) {
            this.and("organizers", query.getOrganizers());
        }
        if (query.getContributors().length > 0) {
            this.and("contributors", query.getContributors());
        }
        if (query.getPublishers().length > 0) {
            this.and("publisher", query.getPublishers());
        }
        if (query.getManagedAcl() != null) {
            this.and("managed_acl", new Object[]{query.getManagedAcl()});
        }
        if (query.getRightsHolder() != null) {
            this.and("rights_holder", new Object[]{query.getRightsHolder()});
        }
        if (query.getTheme() != null) {
            this.and("theme", new Object[]{query.getTheme()});
        }
        if (query.getCreatedFrom() != null && query.getCreatedTo() != null) {
            this.and("createdDateTime", query.getCreatedFrom(), query.getCreatedTo());
        }
        if (query.getTerms() != null) {
            for (SearchTerms terms : query.getTerms()) {
                StringBuffer queryText = new StringBuffer();
                for (String term : terms.getTerms()) {
                    if (queryText.length() > 0) {
                        queryText.append(" ");
                    }
                    queryText.append(term);
                }
                if (query.isFuzzySearch()) {
                    this.fuzzyText = queryText.toString();
                } else {
                    this.text = queryText.toString();
                }
                if (!SearchTerms.Quantifier.All.equals((Object)terms.getQuantifier())) continue;
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                if (query.isFuzzySearch()) {
                    logger.warn("All quantifier not supported in conjunction with wildcard text");
                }
                this.groups.add(new AbstractElasticsearchQueryBuilder.ValueGroup("text", (Object[])terms.getTerms().toArray(new String[terms.size()])));
            }
        }
        if (query.getFilter() != null) {
            this.filter = query.getFilter();
        }
    }
}

