/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.series;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchMetadata;
import org.opencastproject.elasticsearch.impl.SearchMetadataCollection;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.util.DateTimeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeriesIndexUtils {
    private static final Logger logger = LoggerFactory.getLogger(SeriesIndexUtils.class);

    private SeriesIndexUtils() {
    }

    public static Series toSeries(SearchMetadataCollection metadata, Unmarshaller unmarshaller) throws IOException {
        Map metadataMap = metadata.toMap();
        String seriesXml = (String)((SearchMetadata)metadataMap.get("object")).getValue();
        return Series.valueOf(IOUtils.toInputStream((String)seriesXml, (Charset)Charset.defaultCharset()), unmarshaller);
    }

    public static SearchMetadataCollection toSearchMetadata(Series series) {
        SearchMetadataCollection metadata = new SearchMetadataCollection(series.getIdentifier().concat(series.getOrganization()), "series");
        metadata.addField("uid", (Object)series.getIdentifier(), true);
        metadata.addField("organization", (Object)series.getOrganization(), false);
        metadata.addField("object", (Object)series.toXML(), false);
        metadata.addField("title", (Object)series.getTitle(), true);
        if (StringUtils.trimToNull((String)series.getDescription()) != null) {
            metadata.addField("description", (Object)series.getDescription(), true);
        }
        if (StringUtils.trimToNull((String)series.getSubject()) != null) {
            metadata.addField("subject", (Object)series.getSubject(), true);
        }
        if (StringUtils.trimToNull((String)series.getLanguage()) != null) {
            metadata.addField("language", (Object)series.getLanguage(), true);
        }
        if (StringUtils.trimToNull((String)series.getCreator()) != null) {
            metadata.addField("creator", (Object)series.getCreator(), true);
        }
        if (StringUtils.trimToNull((String)series.getLicense()) != null) {
            metadata.addField("license", (Object)series.getLicense(), true);
        }
        if (StringUtils.trimToNull((String)series.getManagedAcl()) != null) {
            metadata.addField("managed_acl", (Object)series.getManagedAcl(), true);
        }
        if (series.getCreatedDateTime() != null) {
            metadata.addField("createdDateTime", (Object)DateTimeSupport.toUTC((long)series.getCreatedDateTime().getTime()), true);
        }
        if (series.getOrganizers() != null) {
            metadata.addField("organizers", (Object)series.getOrganizers().toArray(), true);
        }
        if (series.getContributors() != null) {
            metadata.addField("contributors", (Object)series.getContributors().toArray(), true);
        }
        if (series.getPublishers() != null) {
            metadata.addField("publisher", (Object)series.getPublishers().toArray(), true);
        }
        if (series.getRightsHolder() != null) {
            metadata.addField("rights_holder", (Object)series.getRightsHolder(), true);
        }
        if (!series.getExtendedMetadata().isEmpty()) {
            SeriesIndexUtils.addExtendedMetadata(metadata, series.getExtendedMetadata());
        }
        if (StringUtils.trimToNull((String)series.getAccessPolicy()) != null) {
            metadata.addField("access_policy", (Object)series.getAccessPolicy(), false);
            SeriesIndexUtils.addAuthorization(metadata, series.getAccessPolicy());
        }
        if (series.getTheme() != null) {
            metadata.addField("theme", (Object)series.getTheme(), false);
        }
        return metadata;
    }

    private static void addExtendedMetadata(SearchMetadataCollection doc, Map<String, Map<String, List<String>>> extendedMetadata) {
        for (String type : extendedMetadata.keySet()) {
            Map<String, List<String>> extendedMetadataByType = extendedMetadata.get(type);
            for (String name : extendedMetadataByType.keySet()) {
                List<String> values = extendedMetadataByType.get(name);
                String fieldName = "extended_metadata_".concat(type + "_" + name);
                doc.addField(fieldName, values, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addAuthorization(SearchMetadataCollection doc, String aclString) {
        void var5_7;
        HashMap permissions = new HashMap();
        Permissions.Action[] actionArray = Permissions.Action.values();
        int n = actionArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Permissions.Action action = actionArray[var5_7];
            permissions.put(action.toString(), new ArrayList());
            ++var5_7;
        }
        AccessControlList acl = AccessControlParser.parseAclSilent((String)aclString);
        for (AccessControlEntry accessControlEntry : acl.getEntries()) {
            if (!accessControlEntry.isAllow()) {
                logger.info("Series index does not support denial via ACL, ignoring {}", (Object)accessControlEntry);
                continue;
            }
            ArrayList<String> actionPermissions = (ArrayList<String>)permissions.get(accessControlEntry.getAction());
            if (actionPermissions == null) {
                actionPermissions = new ArrayList<String>();
                permissions.put(accessControlEntry.getAction(), actionPermissions);
            }
            actionPermissions.add(accessControlEntry.getRole());
        }
        for (Map.Entry entry : permissions.entrySet()) {
            String fieldName = "acl_permission_".concat((String)entry.getKey());
            doc.addField(fieldName, entry.getValue(), false);
        }
    }
}

