/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.series;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.opencastproject.elasticsearch.index.objects.IndexObject;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.jaxb.ExtendedMetadataAdapter;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlType(name="series", namespace="http://index.matterhorn.opencastproject.org", propOrder={"identifier", "title", "description", "subject", "organization", "language", "creator", "license", "extendedMetadata", "accessPolicy", "managedAcl", "createdDateTime", "organizers", "contributors", "publishers", "rightsHolder", "theme"})
@XmlRootElement(name="series", namespace="http://index.matterhorn.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Series
implements IndexObject {
    public static final String DOCUMENT_TYPE = "series";
    public static final String XML_SURROUNDING_TAG = "series-list";
    @XmlElement(name="identifier")
    private String identifier = null;
    @XmlElement(name="title")
    private String title = null;
    @XmlElement(name="description")
    private String description = null;
    @XmlElement(name="subject")
    private String subject = null;
    @XmlElement(name="organization")
    private String organization = null;
    @XmlElement(name="language")
    private String language = null;
    @XmlElement(name="creator")
    private String creator = null;
    @XmlElement(name="license")
    private String license = null;
    @XmlElement(name="extendedMetadata")
    @XmlJavaTypeAdapter(value=ExtendedMetadataAdapter.class)
    private Map<String, Map<String, List<String>>> extendedMetadata = new HashMap<String, Map<String, List<String>>>();
    @XmlElement(name="access_policy")
    private String accessPolicy = null;
    @XmlElement(name="managed_acl")
    private String managedAcl = null;
    @XmlElement(name="createdDateTime")
    @XmlJavaTypeAdapter(value=DateTimeSupport.UtcTimestampAdapter.class)
    private Date createdDateTime;
    @XmlElementWrapper(name="organizers")
    @XmlElement(name="organizer")
    private List<String> organizers = null;
    @XmlElementWrapper(name="contributors")
    @XmlElement(name="contributor")
    private List<String> contributors = null;
    @XmlElementWrapper(name="publishers")
    @XmlElement(name="publisher")
    private List<String> publishers = null;
    @XmlElement(name="rights_holder")
    private String rightsHolder = null;
    @XmlElement(name="theme")
    private Long theme = null;
    private static JAXBContext context = null;

    public Series() {
    }

    public Series(String identifier, String organization) {
        this.identifier = identifier;
        this.organization = organization;
    }

    public static Unmarshaller createUnmarshaller() throws IOException {
        try {
            if (context == null) {
                Series.createJAXBContext();
            }
            return context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IOException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setTitle(String title) {
        if (EqualsUtil.eq((Object)this.title, (Object)title)) {
            return;
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicense() {
        return this.license;
    }

    public void setAccessPolicy(String accessPolicy) {
        this.accessPolicy = accessPolicy;
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public void setManagedAcl(String managedAcl) {
        this.managedAcl = managedAcl;
    }

    public String getManagedAcl() {
        return this.managedAcl;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void addOrganizer(String organizer) {
        if (this.organizers == null) {
            this.organizers = new ArrayList<String>();
        }
        this.organizers.add(organizer);
    }

    public void setOrganizers(List<String> organizers) {
        this.organizers = organizers;
    }

    public List<String> getOrganizers() {
        return this.organizers;
    }

    public void addContributor(String contributor) {
        if (this.contributors == null) {
            this.contributors = new ArrayList<String>();
        }
        this.contributors.add(contributor);
    }

    public void setContributors(List<String> contributors) {
        this.contributors = contributors;
    }

    public List<String> getContributors() {
        return this.contributors;
    }

    public void addPublisher(String publisher) {
        if (this.publishers == null) {
            this.publishers = new ArrayList<String>();
        }
        this.publishers.add(publisher);
    }

    public void setPublishers(List<String> publishers) {
        this.publishers = publishers;
    }

    public List<String> getPublishers() {
        return this.publishers;
    }

    public void setRightsHolder(String rightsHolder) {
        this.rightsHolder = rightsHolder;
    }

    public String getRightsHolder() {
        return this.rightsHolder;
    }

    public void setTheme(Long theme) {
        this.theme = theme;
    }

    public Long getTheme() {
        return this.theme;
    }

    public void setExtendedMetadata(String type, Map<String, List<String>> metadata) {
        this.extendedMetadata.put(type, metadata);
    }

    public void removeExtendedMetadata(String type) {
        this.extendedMetadata.remove(type);
    }

    public void resetExtendedMetadata() {
        this.extendedMetadata.clear();
    }

    public Map<String, Map<String, List<String>>> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    public static Series valueOf(InputStream xml, Unmarshaller unmarshaller) throws IOException {
        try {
            if (context == null) {
                Series.createJAXBContext();
            }
            Series series = (Series)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)xml), Series.class).getValue();
            return series;
        }
        catch (JAXBException e) {
            throw new IOException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)xml);
        }
    }

    public static Series valueOfJson(InputStream json) throws IOException, JSONException, XMLStreamException, JAXBException {
        String inputStr;
        if (context == null) {
            Series.createJAXBContext();
        }
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(json, "UTF-8"));
        StringBuilder jsonStringBuilder = new StringBuilder();
        while ((inputStr = streamReader.readLine()) != null) {
            jsonStringBuilder.append(inputStr);
        }
        JSONObject obj = new JSONObject(jsonStringBuilder.toString());
        Configuration config = new Configuration();
        config.setSupressAtAttributes(true);
        HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>(1);
        xmlToJsonNamespaces.put("http://index.matterhorn.opencastproject.org", "");
        config.setXmlToJsonNamespaces(xmlToJsonNamespaces);
        MappedNamespaceConvention con = new MappedNamespaceConvention(config);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
        Series event = (Series)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
        return event;
    }

    private static void createJAXBContext() throws JAXBException {
        context = JAXBContext.newInstance((Class[])new Class[]{Series.class});
    }

    public String toJSON() {
        try {
            if (context == null) {
                Series.createJAXBContext();
            }
            Marshaller marshaller = context.createMarshaller();
            Configuration config = new Configuration();
            config.setSupressAtAttributes(true);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            StringWriter writer = new StringWriter();
            MappedXMLStreamWriter xmlStreamWriter = new MappedXMLStreamWriter(con, writer){

                public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
                    super.writeStartElement("", local, "");
                }

                public void writeStartElement(String uri, String local) throws XMLStreamException {
                    super.writeStartElement("", local, "");
                }

                public void setPrefix(String pfx, String uri) throws XMLStreamException {
                }

                public void setDefaultNamespace(String uri) throws XMLStreamException {
                }
            };
            marshaller.marshal((Object)this, (XMLStreamWriter)xmlStreamWriter);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }

    public String toXML() {
        try {
            if (context == null) {
                Series.createJAXBContext();
            }
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }
}

