/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.impl.AbstractSearchQuery;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.User;
import org.opencastproject.util.requests.SortCriterion;

public class EventSearchQuery
extends AbstractSearchQuery {
    private final List<String> identifiers = new ArrayList<String>();
    private String organization = null;
    private User user = null;
    private String title = null;
    private String description = null;
    private final Set<String> actions = new HashSet<String>();
    private final List<String> presenters = new ArrayList<String>();
    private final List<String> contributors = new ArrayList<String>();
    private String subject = null;
    private String location = null;
    private String seriesId = null;
    private String seriesName = null;
    private String language = null;
    private String source = null;
    private String created = null;
    private Date startFrom = null;
    private Date startTo = null;
    private Date technicalStartFrom = null;
    private Date technicalStartTo = null;
    private String creator = null;
    private String publisher = null;
    private String license = null;
    private String rights = null;
    private String accessPolicy = null;
    private String managedAcl = null;
    private String workflowState = null;
    private Long workflowId = null;
    private String workflowDefinition = null;
    private Long duration = null;
    private String startDate = null;
    private String eventStatus = null;
    private Boolean hasComments = null;
    private Boolean hasOpenComments = null;
    private final List<String> comments = new ArrayList<String>();
    private Boolean needsCutting = null;
    private final List<String> publications = new ArrayList<String>();
    private Long archiveVersion = null;
    private String agentId = null;
    private Date technicalStartTime = null;
    private Date technicalEndTime = null;
    private List<String> technicalPresenters = new ArrayList<String>();

    private EventSearchQuery() {
    }

    public EventSearchQuery(String organization, User user) {
        super("event");
        this.organization = organization;
        this.user = user;
        this.actions.add(Permissions.Action.READ.toString());
        if (!user.hasRole("ROLE_ADMIN") && !user.getOrganization().getId().equals(organization)) {
            throw new IllegalStateException("User's organization must match search organization");
        }
    }

    public EventSearchQuery withIdentifier(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Identifier cannot be null");
        }
        this.identifiers.add(id);
        return this;
    }

    public String[] getIdentifier() {
        return this.identifiers.toArray(new String[this.identifiers.size()]);
    }

    public String getOrganization() {
        return this.organization;
    }

    public User getUser() {
        return this.user;
    }

    public EventSearchQuery withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public EventSearchQuery withoutActions() {
        this.actions.clear();
        return this;
    }

    public EventSearchQuery withAction(Permissions.Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null");
        }
        this.actions.add(action.toString());
        return this;
    }

    public String[] getActions() {
        return this.actions.toArray(new String[this.actions.size()]);
    }

    public EventSearchQuery withPresenter(String presenter) {
        if (StringUtils.isBlank((CharSequence)presenter)) {
            throw new IllegalArgumentException("Presenter cannot be null");
        }
        this.presenters.add(presenter);
        return this;
    }

    public String[] getPresenters() {
        return this.presenters.toArray(new String[this.presenters.size()]);
    }

    public EventSearchQuery withContributor(String contributor) {
        if (StringUtils.isBlank((CharSequence)contributor)) {
            throw new IllegalArgumentException("Contributor cannot be null");
        }
        this.contributors.add(contributor);
        return this;
    }

    public String[] getContributors() {
        return this.contributors.toArray(new String[this.contributors.size()]);
    }

    public EventSearchQuery withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public EventSearchQuery withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public EventSearchQuery withLocation(String location) {
        this.location = location;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public EventSearchQuery withSeriesId(String seriesId) {
        this.seriesId = seriesId;
        return this;
    }

    public String getSeriesId() {
        return this.seriesId;
    }

    public EventSearchQuery withSeriesName(String seriesName) {
        this.seriesName = seriesName;
        return this;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public EventSearchQuery withLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public EventSearchQuery withSource(String source) {
        this.source = source;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public EventSearchQuery withCreated(String created) {
        this.created = created;
        return this;
    }

    public String getCreated() {
        return this.created;
    }

    public EventSearchQuery withStartFrom(Date startFrom) {
        this.startFrom = startFrom;
        return this;
    }

    public Date getStartFrom() {
        return this.startFrom;
    }

    public EventSearchQuery withStartTo(Date startTo) {
        this.startTo = startTo;
        return this;
    }

    public Date getStartTo() {
        return this.startTo;
    }

    public EventSearchQuery withTechnicalStartFrom(Date startFrom) {
        this.technicalStartFrom = startFrom;
        return this;
    }

    public Date getTechnicalStartFrom() {
        return this.technicalStartFrom;
    }

    public EventSearchQuery withTechnicalStartTo(Date startTo) {
        this.technicalStartTo = startTo;
        return this;
    }

    public Date getTechnicalStartTo() {
        return this.technicalStartTo;
    }

    public EventSearchQuery withCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public EventSearchQuery withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public EventSearchQuery withLicense(String license) {
        this.license = license;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public EventSearchQuery withRights(String rights) {
        this.rights = rights;
        return this;
    }

    public String getRights() {
        return this.rights;
    }

    public EventSearchQuery withAccessPolicy(String accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public EventSearchQuery withManagedAcl(String managedAcl) {
        this.managedAcl = managedAcl;
        return this;
    }

    public String getManagedAcl() {
        return this.managedAcl;
    }

    public EventSearchQuery withWorkflowState(String workflowState) {
        this.workflowState = workflowState;
        return this;
    }

    public String getWorkflowState() {
        return this.workflowState;
    }

    public EventSearchQuery withWorkflowId(long workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public Long getWorkflowId() {
        return this.workflowId;
    }

    public EventSearchQuery withWorkflowDefinition(String workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
        return this;
    }

    public String getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    public EventSearchQuery withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public EventSearchQuery withDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public Long getDuration() {
        return this.duration;
    }

    public EventSearchQuery withEventStatus(String eventStatus) {
        this.eventStatus = eventStatus;
        return this;
    }

    public String getEventStatus() {
        return this.eventStatus;
    }

    public EventSearchQuery withComments(boolean hasComments) {
        this.hasComments = hasComments;
        return this;
    }

    public EventSearchQuery withOpenComments(boolean hasOpenComments) {
        this.hasOpenComments = hasOpenComments;
        return this;
    }

    public EventSearchQuery withNeedsCutting(boolean needsCutting) {
        this.needsCutting = needsCutting;
        return this;
    }

    public Boolean getHasComments() {
        return this.hasComments;
    }

    public Boolean getHasOpenComments() {
        return this.hasOpenComments;
    }

    public EventSearchQuery withComments(String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        this.comments.add(comment);
        return this;
    }

    public String[] getComments() {
        return this.comments.toArray(new String[this.comments.size()]);
    }

    public Boolean needsCutting() {
        return this.needsCutting;
    }

    public EventSearchQuery withPublications(String publication) {
        if (StringUtils.isBlank((CharSequence)publication)) {
            throw new IllegalArgumentException("Publication cannot be null");
        }
        this.publications.add(publication);
        return this;
    }

    public String[] getPublications() {
        return this.publications.toArray(new String[this.publications.size()]);
    }

    public EventSearchQuery withArchiveVersion(long archiveVersion) {
        this.archiveVersion = archiveVersion;
        return this;
    }

    public Long getArchiveVersion() {
        return this.archiveVersion;
    }

    public EventSearchQuery withAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public EventSearchQuery withTechnicalStartTime(Date technicalStartTime) {
        this.technicalStartTime = technicalStartTime;
        return this;
    }

    public Date getTechnicalStartTime() {
        return this.technicalStartTime;
    }

    public EventSearchQuery withTechnicalEndTime(Date technicalEndTime) {
        this.technicalEndTime = technicalEndTime;
        return this;
    }

    public Date getTechnicalEndTime() {
        return this.technicalEndTime;
    }

    public EventSearchQuery withTechnicalPresenters(String presenter) {
        if (StringUtils.isBlank((CharSequence)presenter)) {
            throw new IllegalArgumentException("Presenter cannot be null");
        }
        this.technicalPresenters.add(presenter);
        return this;
    }

    public String[] getTechnicalPresenters() {
        return this.technicalPresenters.toArray(new String[this.technicalPresenters.size()]);
    }

    public EventSearchQuery sortByStartDate(SortCriterion.Order order) {
        this.withSortOrder("start_date", order);
        return this;
    }

    public SortCriterion.Order getStartDateSortOrder() {
        return this.getSortOrder("start_date");
    }

    public EventSearchQuery sortByTechnicalStartDate(SortCriterion.Order order) {
        this.withSortOrder("technical_start", order);
        return this;
    }

    public SortCriterion.Order getTechnicalStartDateSortOrder() {
        return this.getSortOrder("technical_start");
    }

    public EventSearchQuery sortByEndDate(SortCriterion.Order order) {
        this.withSortOrder("end_date", order);
        return this;
    }

    public SortCriterion.Order getEndDateSortOrder() {
        return this.getSortOrder("end_date");
    }

    public EventSearchQuery sortByTechnicalEndDate(SortCriterion.Order order) {
        this.withSortOrder("technical_end", order);
        return this;
    }

    public SortCriterion.Order getTechnicalEndDateSortOrder() {
        return this.getSortOrder("technical_end");
    }

    public EventSearchQuery sortByDate(SortCriterion.Order order) {
        this.withSortOrder("end_date", order);
        return this;
    }

    public SortCriterion.Order getDateSortOrder() {
        return this.getSortOrder("end_date");
    }

    public EventSearchQuery sortByTitle(SortCriterion.Order order) {
        this.withSortOrder("title", order);
        return this;
    }

    public SortCriterion.Order getTitleSortOrder() {
        return this.getSortOrder("title");
    }

    public EventSearchQuery sortByPresenter(SortCriterion.Order order) {
        this.withSortOrder("presenter", order);
        return this;
    }

    public SortCriterion.Order getPresentersSortOrder() {
        return this.getSortOrder("presenter");
    }

    public EventSearchQuery sortByLocation(SortCriterion.Order order) {
        this.withSortOrder("location", order);
        return this;
    }

    public SortCriterion.Order getLocationSortOrder() {
        return this.getSortOrder("location");
    }

    public EventSearchQuery sortBySeriesName(SortCriterion.Order order) {
        this.withSortOrder("series_name", order);
        return this;
    }

    public SortCriterion.Order getSeriesNameSortOrder() {
        return this.getSortOrder("series_name");
    }

    public EventSearchQuery sortByManagedAcl(SortCriterion.Order order) {
        this.withSortOrder("managed_acl", order);
        return this;
    }

    public SortCriterion.Order getManagedAclSortOrder() {
        return this.getSortOrder("managed_acl");
    }

    public EventSearchQuery sortByWorkflowState(SortCriterion.Order order) {
        this.withSortOrder("workflow_state", order);
        return this;
    }

    public SortCriterion.Order getWorkflowStateSortOrder() {
        return this.getSortOrder("workflow_state");
    }

    public EventSearchQuery sortByEventStatus(SortCriterion.Order order) {
        this.withSortOrder("event_status", order);
        return this;
    }

    public SortCriterion.Order getEventStatusSortOrder() {
        return this.getSortOrder("event_status");
    }

    public EventSearchQuery sortByPublicationIgnoringInternal(SortCriterion.Order order) {
        this.withSortOrder("publication", order);
        return this;
    }

    public SortCriterion.Order getPublicationSortOrder() {
        return this.getSortOrder("publication");
    }
}

