/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.event;

import java.util.ArrayList;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchTerms;
import org.opencastproject.elasticsearch.impl.AbstractElasticsearchQueryBuilder;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueryBuilder
extends AbstractElasticsearchQueryBuilder<EventSearchQuery> {
    private static final Logger logger = LoggerFactory.getLogger(EventQueryBuilder.class);

    public EventQueryBuilder(EventSearchQuery query) {
        super((SearchQuery)query);
    }

    public void buildQuery(EventSearchQuery query) {
        User user;
        if (query.getOrganization() == null) {
            throw new IllegalStateException("No organization set on the event search query!");
        }
        this.and("organization", new Object[]{query.getOrganization()});
        if (query.getIdentifier().length > 0) {
            this.and("uid", query.getIdentifier());
        }
        if (query.getTitle() != null) {
            this.and("title", new Object[]{query.getTitle()});
        }
        if (query.getDescription() != null) {
            this.and("description", new Object[]{query.getDescription()});
        }
        if (query.getActions() != null && query.getActions().length > 0 && !(user = query.getUser()).hasRole("ROLE_ADMIN") && !user.hasRole(user.getOrganization().getAdminRole())) {
            for (Role role : user.getRoles()) {
                for (String action : query.getActions()) {
                    this.and("acl_permission_".concat(action), new Object[]{role.getName()});
                }
            }
        }
        if (query.getPresenters() != null) {
            for (String presenter : query.getPresenters()) {
                this.and("presenter", new Object[]{presenter});
            }
        }
        if (query.getContributors().length > 0) {
            this.and("contributor", query.getContributors());
        }
        if (query.getSubject() != null) {
            this.and("subject", new Object[]{query.getSubject()});
        }
        if (query.getLocation() != null) {
            this.and("location", new Object[]{query.getLocation()});
        }
        if (query.getSeriesId() != null) {
            this.and("series_id", new Object[]{query.getSeriesId()});
        }
        if (query.getSeriesName() != null) {
            this.and("series_name", new Object[]{query.getSeriesName()});
        }
        if (query.getLanguage() != null) {
            this.and("language", new Object[]{query.getLanguage()});
        }
        if (query.getSource() != null) {
            this.and("source", new Object[]{query.getSource()});
        }
        if (query.getCreated() != null) {
            this.and("created", new Object[]{query.getCreated()});
        }
        if (query.getCreator() != null) {
            this.and("creator", new Object[]{query.getCreator()});
        }
        if (query.getPublisher() != null) {
            this.and("publisher", new Object[]{query.getPublisher()});
        }
        if (query.getLicense() != null) {
            this.and("license", new Object[]{query.getLicense()});
        }
        if (query.getRights() != null) {
            this.and("rights", new Object[]{query.getRights()});
        }
        if (query.getAccessPolicy() != null) {
            this.and("access_policy", new Object[]{query.getAccessPolicy()});
        }
        if (query.getManagedAcl() != null) {
            this.and("managed_acl", new Object[]{query.getManagedAcl()});
        }
        if (query.getWorkflowState() != null) {
            this.and("workflow_state", new Object[]{query.getWorkflowState()});
        }
        if (query.getWorkflowId() != null) {
            this.and("workflow_id", new Object[]{query.getWorkflowId()});
        }
        if (query.getWorkflowDefinition() != null) {
            this.and("workflow_definition_id", new Object[]{query.getWorkflowDefinition()});
        }
        if (query.getEventStatus() != null) {
            this.and("event_status", new Object[]{query.getEventStatus()});
        }
        if (query.getStartFrom() != null && query.getStartTo() != null) {
            this.and("start_date", query.getStartFrom(), query.getStartTo());
        }
        if (query.getStartDate() != null) {
            this.and("start_date", new Object[]{query.getStartDate()});
        }
        if (query.getDuration() != null) {
            this.and("duration", new Object[]{query.getDuration()});
        }
        if (query.getHasComments() != null) {
            this.and("has_comments", new Object[]{query.getHasComments()});
        }
        if (query.getHasOpenComments() != null) {
            this.and("has_open_comments", new Object[]{query.getHasOpenComments()});
        }
        if (query.getComments() != null) {
            for (String comment : query.getComments()) {
                this.and("comments", new Object[]{comment});
            }
        }
        if (query.getPublications() != null) {
            for (String publication : query.getPublications()) {
                this.and("publication", new Object[]{publication});
            }
        }
        if (query.getArchiveVersion() != null) {
            this.and("archive_version", new Object[]{query.getArchiveVersion()});
        }
        if (query.getAgentId() != null) {
            this.and("agent_id", new Object[]{query.getAgentId()});
        }
        if (query.getTechnicalStartFrom() != null && query.getTechnicalStartTo() != null) {
            this.and("technical_start", query.getTechnicalStartFrom(), query.getTechnicalStartTo());
        }
        if (query.getTechnicalStartTime() != null) {
            this.and("technical_start", new Object[]{query.getTechnicalStartTime()});
        }
        if (query.getTechnicalEndTime() != null) {
            this.and("technical_end", new Object[]{query.getTechnicalEndTime()});
        }
        if (query.getTechnicalPresenters().length > 0) {
            this.and("technical_presenters", query.getTechnicalPresenters());
        }
        if (query.getTerms() != null) {
            for (SearchTerms terms : query.getTerms()) {
                StringBuilder queryText = new StringBuilder();
                for (String term : terms.getTerms()) {
                    if (queryText.length() > 0) {
                        queryText.append(" ");
                    }
                    queryText.append(term);
                }
                if (query.isFuzzySearch()) {
                    this.fuzzyText = queryText.toString();
                } else {
                    this.text = queryText.toString();
                }
                if (!SearchTerms.Quantifier.All.equals((Object)terms.getQuantifier())) continue;
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                if (query.isFuzzySearch()) {
                    logger.warn("All quantifier not supported in conjunction with wildcard text");
                }
                this.groups.add(new AbstractElasticsearchQueryBuilder.ValueGroup("text", (Object[])terms.getTerms().toArray(new String[terms.size()])));
            }
        }
        if (query.getFilter() != null) {
            this.filter = query.getFilter();
        }
    }
}

