/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.event;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchMetadata;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.impl.SearchMetadataCollection;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Comment;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.User;
import org.opencastproject.util.DateTimeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventIndexUtils {
    private static final Logger logger = LoggerFactory.getLogger(EventIndexUtils.class);
    public static final int DEFAULT_ATTEMPTS = 10;
    public static final long DEFAULT_SLEEP = 100L;

    private EventIndexUtils() {
    }

    public static Event toRecordingEvent(SearchMetadataCollection metadata, Unmarshaller unmarshaller) throws IOException {
        Map metadataMap = metadata.toMap();
        String eventJson = (String)((SearchMetadata)metadataMap.get("object")).getValue();
        return Event.valueOf(IOUtils.toInputStream((String)eventJson, (Charset)Charset.defaultCharset()), unmarshaller);
    }

    public static SearchMetadataCollection toSearchMetadata(Event event) {
        int i;
        SearchMetadataCollection metadata = new SearchMetadataCollection(event.getIdentifier().concat(event.getOrganization()), "event");
        metadata.addField("uid", (Object)event.getIdentifier(), true);
        metadata.addField("organization", (Object)event.getOrganization(), false);
        metadata.addField("object", (Object)event.toXML(), false);
        if (StringUtils.isNotBlank((CharSequence)event.getTitle())) {
            metadata.addField("title", (Object)event.getTitle(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getDescription())) {
            metadata.addField("description", (Object)event.getDescription(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getLocation())) {
            metadata.addField("location", (Object)event.getLocation(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getSeriesId())) {
            metadata.addField("series_id", (Object)event.getSeriesId(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getSeriesName())) {
            metadata.addField("series_name", (Object)event.getSeriesName(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getLanguage())) {
            metadata.addField("language", (Object)event.getLanguage(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getSubject())) {
            metadata.addField("subject", (Object)event.getSubject(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getSource())) {
            metadata.addField("source", (Object)event.getSource(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getCreated())) {
            metadata.addField("created", (Object)event.getCreated(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getCreator())) {
            metadata.addField("creator", (Object)event.getCreator(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getPublisher())) {
            metadata.addField("publisher", (Object)event.getPublisher(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getLicense())) {
            metadata.addField("license", (Object)event.getLicense(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getRights())) {
            metadata.addField("rights", (Object)event.getRights(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getManagedAcl())) {
            metadata.addField("managed_acl", (Object)event.getManagedAcl(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getWorkflowState())) {
            metadata.addField("workflow_state", (Object)event.getWorkflowState(), true);
        }
        if (event.getWorkflowId() != null) {
            metadata.addField("workflow_id", (Object)event.getWorkflowId(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getWorkflowDefinitionId())) {
            metadata.addField("workflow_definition_id", (Object)event.getWorkflowDefinitionId(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getRecordingStartDate())) {
            metadata.addField("start_date", (Object)event.getRecordingStartDate(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getRecordingEndDate())) {
            metadata.addField("end_date", (Object)event.getRecordingEndDate(), true);
        }
        if (event.getDuration() != null) {
            metadata.addField("duration", (Object)event.getDuration(), true);
        }
        if (event.getArchiveVersion() != null) {
            metadata.addField("archive_version", (Object)event.getArchiveVersion(), true);
        }
        if (event.getRecordingStatus() != null) {
            metadata.addField("recording_status", (Object)event.getRecordingStatus(), true);
        }
        metadata.addField("event_status", (Object)event.getEventStatus(), true);
        metadata.addField("has_comments", (Object)event.hasComments(), true);
        metadata.addField("has_open_comments", (Object)event.hasOpenComments(), true);
        if (event.comments() != null) {
            List<Comment> comments = event.comments();
            HashMap[] commentsArray = new HashMap[comments.size()];
            for (i = 0; i < comments.size(); ++i) {
                final Comment comment = comments.get(i);
                HashMap<String, Object> myMap = new HashMap<String, Object>(){
                    {
                        this.put("uid", comment.getId());
                        this.put("reason", comment.getReason());
                        this.put("text", comment.getText());
                        this.put("resolvedStatus", comment.isResolvedStatus());
                    }
                };
                commentsArray[i] = myMap;
            }
            metadata.addField("comments", (Object)commentsArray, true);
        }
        metadata.addField("needs_cutting", (Object)event.needsCutting(), true);
        if (event.getPublications() != null) {
            List<Publication> publications = event.getPublications();
            HashMap[] publicationsArray = new HashMap[publications.size()];
            for (i = 0; i < publications.size(); ++i) {
                publicationsArray[i] = EventIndexUtils.generatePublicationDoc(publications.get(i));
            }
            metadata.addField("publication", (Object)publicationsArray, true);
        }
        if (event.getPresenters() != null) {
            List<String> presenters = event.getPresenters();
            metadata.addField("presenter", (Object)presenters.toArray(new String[presenters.size()]), true);
        }
        if (event.getContributors() != null) {
            List<String> contributors = event.getContributors();
            metadata.addField("contributor", (Object)contributors.toArray(new String[contributors.size()]), true);
        }
        if (!event.getExtendedMetadata().isEmpty()) {
            EventIndexUtils.addExtendedMetadata(metadata, event.getExtendedMetadata());
        }
        if (StringUtils.isNotBlank((CharSequence)event.getAccessPolicy())) {
            metadata.addField("access_policy", (Object)event.getAccessPolicy(), true);
            EventIndexUtils.addAuthorization(metadata, event.getAccessPolicy());
        }
        if (StringUtils.isNotBlank((CharSequence)event.getAgentId())) {
            metadata.addField("agent_id", (Object)event.getAgentId(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getTechnicalStartTime())) {
            metadata.addField("technical_start", (Object)event.getTechnicalStartTime(), true);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getTechnicalEndTime())) {
            metadata.addField("technical_end", (Object)event.getTechnicalEndTime(), true);
        }
        if (event.getTechnicalPresenters() != null) {
            metadata.addField("technical_presenters", (Object)event.getTechnicalPresenters().toArray(new String[event.getTechnicalPresenters().size()]), true);
        }
        return metadata;
    }

    private static void addObjectStringtToMap(HashMap<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, "");
        } else {
            map.put(key, value.toString());
        }
    }

    private static HashMap<String, Object> generatePublicationDoc(Publication publication) {
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        pMap.put("channel", publication.getChannel());
        EventIndexUtils.addObjectStringtToMap(pMap, "mimetype", publication.getMimeType());
        Attachment[] attachments = publication.getAttachments();
        HashMap[] attachmentsArray = new HashMap[attachments.length];
        for (int i = 0; i < attachmentsArray.length; ++i) {
            Attachment attachment = attachments[i];
            HashMap<String, Object> element = new HashMap<String, Object>();
            element.put("id", attachment.getIdentifier());
            EventIndexUtils.addObjectStringtToMap(element, "mimetype", attachment.getMimeType());
            EventIndexUtils.addObjectStringtToMap(element, "type", attachment.getElementType());
            element.put("tag", attachment.getTags());
            EventIndexUtils.addObjectStringtToMap(element, "tag", attachment.getURI());
            element.put("size", attachment.getSize());
            attachmentsArray[i] = element;
        }
        pMap.put("attachment", attachmentsArray);
        Catalog[] catalogs = publication.getCatalogs();
        HashMap[] catalogsArray = new HashMap[catalogs.length];
        for (int i = 0; i < catalogsArray.length; ++i) {
            Catalog catalog = catalogs[i];
            HashMap<String, Object> element = new HashMap<String, Object>();
            element.put("id", catalog.getIdentifier());
            EventIndexUtils.addObjectStringtToMap(element, "mimetype", catalog.getMimeType());
            EventIndexUtils.addObjectStringtToMap(element, "type", catalog.getElementType());
            element.put("tag", catalog.getTags());
            EventIndexUtils.addObjectStringtToMap(element, "tag", catalog.getURI());
            element.put("size", catalog.getSize());
            catalogsArray[i] = element;
        }
        pMap.put("catalog", catalogsArray);
        Track[] tracks = publication.getTracks();
        HashMap[] tracksArray = new HashMap[tracks.length];
        for (int i = 0; i < tracksArray.length; ++i) {
            Track track = tracks[i];
            HashMap<String, Object> element = new HashMap<String, Object>();
            element.put("id", track.getIdentifier());
            EventIndexUtils.addObjectStringtToMap(element, "mimetype", track.getMimeType());
            EventIndexUtils.addObjectStringtToMap(element, "type", track.getElementType());
            element.put("tag", track.getTags());
            EventIndexUtils.addObjectStringtToMap(element, "tag", track.getURI());
            element.put("size", track.getSize());
            element.put("duration", track.getDuration());
            tracksArray[i] = element;
        }
        pMap.put("track", tracksArray);
        return pMap;
    }

    private static void addExtendedMetadata(SearchMetadataCollection doc, Map<String, Map<String, List<String>>> extendedMetadata) {
        for (String type : extendedMetadata.keySet()) {
            Map<String, List<String>> extendedMetadataByType = extendedMetadata.get(type);
            for (String name : extendedMetadataByType.keySet()) {
                List<String> values = extendedMetadataByType.get(name);
                String fieldName = "extended_metadata_".concat(type + "_" + name);
                doc.addField(fieldName, values, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addAuthorization(SearchMetadataCollection doc, String aclString) {
        void var5_7;
        HashMap permissions = new HashMap();
        Permissions.Action[] actionArray = Permissions.Action.values();
        int n = actionArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Permissions.Action action = actionArray[var5_7];
            permissions.put(action.toString(), new ArrayList());
            ++var5_7;
        }
        AccessControlList acl = AccessControlParser.parseAclSilent((String)aclString);
        for (AccessControlEntry accessControlEntry : acl.getEntries()) {
            if (!accessControlEntry.isAllow()) {
                logger.info("Event index does not support denial via ACL, ignoring {}", (Object)accessControlEntry);
                continue;
            }
            ArrayList<String> actionPermissions = (ArrayList<String>)permissions.get(accessControlEntry.getAction());
            if (actionPermissions == null) {
                actionPermissions = new ArrayList<String>();
                permissions.put(accessControlEntry.getAction(), actionPermissions);
            }
            actionPermissions.add(accessControlEntry.getRole());
        }
        for (Map.Entry entry : permissions.entrySet()) {
            String fieldName = "acl_permission_".concat((String)entry.getKey());
            doc.addField(fieldName, entry.getValue(), false);
        }
    }

    public static Event updateEventExtendedMetadata(Event event, DublinCoreCatalog dc, MediaPackageElementFlavor flavor) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Set eNames = dc.getProperties();
        for (EName eName : eNames) {
            String name = eName.getLocalName();
            List values = dc.get(eName, "**");
            map.put(name, values);
        }
        event.setExtendedMetadata(flavor.toString(), map);
        return event;
    }

    public static Event updateEvent(Event event, DublinCore dc) {
        event.setTitle(dc.getFirst(DublinCore.PROPERTY_TITLE));
        event.setDescription(dc.getFirst(DublinCore.PROPERTY_DESCRIPTION));
        event.setSubject(dc.getFirst(DublinCore.PROPERTY_SUBJECT));
        event.setLocation(dc.getFirst(DublinCore.PROPERTY_SPATIAL));
        event.setLanguage(dc.getFirst(DublinCore.PROPERTY_LANGUAGE));
        event.setSource(dc.getFirst(DublinCore.PROPERTY_SOURCE));
        event.setSeriesId(dc.getFirst(DublinCore.PROPERTY_IS_PART_OF));
        event.setLicense(dc.getFirst(DublinCore.PROPERTY_LICENSE));
        event.setRights(dc.getFirst(DublinCore.PROPERTY_RIGHTS_HOLDER));
        event.setPublisher(dc.getFirst(DublinCore.PROPERTY_PUBLISHER));
        String encodedDate = dc.getFirst(DublinCore.PROPERTY_CREATED);
        Date created = StringUtils.isBlank((CharSequence)encodedDate) ? new Date() : EncodingSchemeUtils.decodeDate((String)encodedDate);
        event.setCreated(DateTimeSupport.toUTC((long)created.getTime()));
        String strPeriod = dc.getFirst(DublinCore.PROPERTY_TEMPORAL);
        try {
            if (StringUtils.isNotBlank((CharSequence)strPeriod)) {
                DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod((String)strPeriod);
                event.setRecordingStartDate(DateTimeSupport.toUTC((long)period.getStart().getTime()));
                event.setRecordingEndDate(DateTimeSupport.toUTC((long)period.getEnd().getTime()));
                event.setDuration(period.getEnd().getTime() - period.getStart().getTime());
            } else {
                event.setRecordingStartDate(DateTimeSupport.toUTC((long)created.getTime()));
            }
        }
        catch (Exception e) {
            logger.warn("Invalid start and end date/time for event {}: {}", (Object)event.getIdentifier(), (Object)strPeriod);
            event.setRecordingStartDate(DateTimeSupport.toUTC((long)created.getTime()));
        }
        EventIndexUtils.updateTechnicalDate(event);
        event.setContributors(dc.get(DublinCore.PROPERTY_CONTRIBUTOR, "**"));
        event.setPresenters(dc.get(DublinCore.PROPERTY_CREATOR, "**"));
        return event;
    }

    public static Event updateTechnicalDate(Event event) {
        if (event.isScheduledEvent() && event.hasRecordingStarted()) {
            event.setTechnicalStartTime(event.getRecordingStartDate());
            event.setTechnicalEndTime(event.getRecordingEndDate());
        } else {
            if (StringUtils.isBlank((CharSequence)event.getTechnicalStartTime())) {
                event.setTechnicalStartTime(event.getRecordingStartDate());
            }
            if (StringUtils.isBlank((CharSequence)event.getTechnicalEndTime())) {
                event.setTechnicalEndTime(event.getRecordingEndDate());
            }
        }
        return event;
    }

    public static Event updateEvent(Event event, MediaPackage mp) {
        event.setPublications(Arrays.asList(mp.getPublications()));
        event.setSeriesName(mp.getSeriesTitle());
        return event;
    }

    public static void updateSeriesName(Event event, String organization, User user, ElasticsearchIndex searchIndex) throws SearchIndexException {
        EventIndexUtils.updateSeriesName(event, organization, user, searchIndex, 10, 100L);
    }

    public static void updateSeriesName(Event event, String organization, User user, ElasticsearchIndex searchIndex, int tries, long sleep) throws SearchIndexException {
        if (event.getSeriesId() != null) {
            for (int i = 1; i <= tries; ++i) {
                SearchResult<Series> result = searchIndex.getByQuery(new SeriesSearchQuery(organization, user).withoutActions().withIdentifier(event.getSeriesId()));
                if (result.getHitCount() > 0L) {
                    event.setSeriesName(((Series)result.getItems()[0].getSource()).getTitle());
                    break;
                }
                Integer triesLeft = tries - i;
                logger.debug("Not able to find the series {} in the search index for the event {}. Will try {} more times.", new Object[]{event.getSeriesId(), event.getIdentifier(), triesLeft});
                try {
                    Thread.sleep(sleep);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted while sleeping before checking for the series being added to the index", (Throwable)e);
                }
            }
        }
    }

    private static String[] getPublicationFlavors(List<Publication> publications) {
        TreeSet<String> allPublicationFlavors = new TreeSet<String>();
        for (Publication p : publications) {
            for (Attachment attachment : p.getAttachments()) {
                if (attachment.getFlavor() == null) continue;
                allPublicationFlavors.add(attachment.getFlavor().toString());
            }
            for (Attachment attachment : p.getCatalogs()) {
                if (attachment.getFlavor() == null) continue;
                allPublicationFlavors.add(attachment.getFlavor().toString());
            }
            for (Attachment attachment : p.getTracks()) {
                if (attachment.getFlavor() == null) continue;
                allPublicationFlavors.add(attachment.getFlavor().toString());
            }
        }
        return allPublicationFlavors.toArray(new String[allPublicationFlavors.size()]);
    }

    public static Boolean subflavorMatches(List<Publication> publications, String previewSubtype) {
        String[] publicationFlavors = EventIndexUtils.getPublicationFlavors(publications);
        if (publicationFlavors != null && previewSubtype != null) {
            String subtype = "/" + previewSubtype;
            for (String flavor : publicationFlavors) {
                if (!flavor.endsWith(subtype)) continue;
                return true;
            }
        }
        return false;
    }
}

