/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.objects.event;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.opencastproject.elasticsearch.index.objects.IndexObject;
import org.opencastproject.elasticsearch.index.objects.event.Comment;
import org.opencastproject.elasticsearch.index.objects.event.EventIndexUtils;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.jaxb.ExtendedMetadataAdapter;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlType(name="event", namespace="http://index.matterhorn.opencastproject.org", propOrder={"identifier", "organization", "title", "description", "subject", "location", "presenters", "contributors", "seriesId", "seriesName", "language", "source", "created", "creator", "publisher", "license", "rights", "extendedMetadata", "accessPolicy", "managedAcl", "workflowState", "workflowId", "workflowDefinitionId", "recordingStartTime", "recordingEndTime", "duration", "hasComments", "hasOpenComments", "comments", "hasPreview", "needsCutting", "publications", "archiveVersion", "recordingStatus", "eventStatus", "agentId", "agentConfigurations", "technicalStartTime", "technicalEndTime", "technicalPresenters"})
@XmlRootElement(name="event", namespace="http://index.matterhorn.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Event
implements IndexObject {
    private static final Logger logger = LoggerFactory.getLogger(Event.class);
    public static final String DOCUMENT_TYPE = "event";
    public static final String XML_SURROUNDING_TAG = "events";
    private static final Map<String, String> workflowStatusMapping = new HashMap<String, String>();
    private static final Map<String, String> recordingStatusMapping = new HashMap<String, String>();
    @XmlElement(name="identifier")
    private String identifier = null;
    @XmlElement(name="organization")
    private String organization = null;
    @XmlElement(name="title")
    private String title = null;
    @XmlElement(name="description")
    private String description = null;
    @XmlElement(name="subject")
    private String subject = null;
    @XmlElement(name="location")
    private String location = null;
    @XmlElementWrapper(name="presenters")
    @XmlElement(name="presenter")
    private List<String> presenters = null;
    @XmlElementWrapper(name="contributors")
    @XmlElement(name="contributor")
    private List<String> contributors = null;
    @XmlElement(name="series_id")
    private String seriesId = null;
    @XmlElement(name="series_name")
    private String seriesName = null;
    @XmlElement(name="language")
    private String language = null;
    @XmlElement(name="source")
    private String source = null;
    @XmlElement(name="created")
    private String created = null;
    @XmlElement(name="creator")
    private String creator = null;
    @XmlElement(name="publisher")
    private String publisher = null;
    @XmlElement(name="license")
    private String license = null;
    @XmlElement(name="rights")
    private String rights = null;
    @XmlElement(name="extendedMetadata")
    @XmlJavaTypeAdapter(value=ExtendedMetadataAdapter.class)
    private Map<String, Map<String, List<String>>> extendedMetadata = new HashMap<String, Map<String, List<String>>>();
    @XmlElement(name="access_policy")
    private String accessPolicy = null;
    @XmlElement(name="managed_acl")
    private String managedAcl = null;
    @XmlElement(name="workflow_state")
    private String workflowState = null;
    @XmlElement(name="workflow_id")
    private Long workflowId = null;
    @XmlElement(name="workflow_definition_id")
    private String workflowDefinitionId = null;
    @XmlElement(name="recording_start_time")
    private String recordingStartTime = null;
    @XmlElement(name="recording_end_time")
    private String recordingEndTime = null;
    @XmlElement(name="duration")
    private Long duration = null;
    @XmlElement(name="event_status")
    private String eventStatus = null;
    @XmlElement(name="has_comments")
    private Boolean hasComments = false;
    @XmlElement(name="has_open_comments")
    private Boolean hasOpenComments = false;
    @XmlElement(name="comments")
    private List<Comment> comments = new ArrayList<Comment>();
    @XmlElement(name="has_preview")
    private Boolean hasPreview = false;
    @XmlElement(name="needs_cutting")
    private Boolean needsCutting = false;
    @XmlElementWrapper(name="publications")
    @XmlElement(name="publication")
    private List<Publication> publications = new ArrayList<Publication>();
    @XmlElement(name="recording_status")
    private String recordingStatus = null;
    @XmlElement(name="archive_version")
    private Long archiveVersion = null;
    @XmlElement(name="agent_id")
    private String agentId = null;
    @XmlElementWrapper(name="agent_configuration")
    private Map<String, String> agentConfigurations = new HashMap<String, String>();
    @XmlElement(name="technical_end_time")
    private String technicalEndTime = null;
    @XmlElement(name="technical_start_time")
    private String technicalStartTime = null;
    @XmlElementWrapper(name="technical_presenters")
    @XmlElement(name="technical_presenter")
    private List<String> technicalPresenters = null;
    private static JAXBContext context;

    public Event() {
    }

    public Event(String identifier, String organization) {
        this.identifier = identifier;
        this.organization = organization;
        this.updateEventStatus();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setSeriesId(String seriesId) {
        this.seriesId = seriesId;
    }

    public String getSeriesId() {
        return this.seriesId;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicense() {
        return this.license;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getRights() {
        return this.rights;
    }

    public void setAccessPolicy(String accessPolicy) {
        this.accessPolicy = accessPolicy;
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public void setManagedAcl(String managedAcl) {
        this.managedAcl = managedAcl;
    }

    public String getManagedAcl() {
        return this.managedAcl;
    }

    public void setWorkflowState(WorkflowInstance.WorkflowState workflowState) {
        this.workflowState = workflowState == null ? null : workflowState.toString();
        this.updateEventStatus();
    }

    public String getWorkflowState() {
        return this.workflowState;
    }

    public void setWorkflowId(Long workflowId) {
        this.workflowId = workflowId;
    }

    public Long getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowDefinitionId(String workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
    }

    public String getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    public void setRecordingStartDate(String recordingStartTime) {
        this.recordingStartTime = recordingStartTime;
    }

    public String getRecordingStartDate() {
        return this.recordingStartTime;
    }

    public void setRecordingEndDate(String recordingEndTime) {
        this.recordingEndTime = recordingEndTime;
    }

    public String getRecordingEndDate() {
        return this.recordingEndTime;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setPresenters(List<String> presenters) {
        this.presenters = presenters;
    }

    public List<String> getPresenters() {
        return this.presenters;
    }

    public void setContributors(List<String> contributors) {
        this.contributors = contributors;
    }

    public List<String> getContributors() {
        return this.contributors;
    }

    public void setHasComments(boolean hasComments) {
        this.hasComments = hasComments;
    }

    public boolean hasComments() {
        return this.hasComments;
    }

    public void setHasOpenComments(boolean hasOpenComments) {
        this.hasOpenComments = hasOpenComments;
    }

    public boolean hasOpenComments() {
        return this.hasOpenComments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public void setHasPreview(boolean hasPreview) {
        this.hasPreview = hasPreview;
    }

    public boolean hasPreview() {
        return this.hasPreview;
    }

    public void updatePreview(String previewSubtype) {
        this.hasPreview = EventIndexUtils.subflavorMatches(this.publications, previewSubtype);
    }

    public void setNeedsCutting(boolean needsCutting) {
        this.needsCutting = needsCutting;
    }

    public boolean needsCutting() {
        return this.needsCutting;
    }

    public void setPublications(List<Publication> publications) {
        this.publications = publications;
    }

    public List<Publication> getPublications() {
        return this.publications;
    }

    public void setArchiveVersion(Long archiveVersion) {
        this.archiveVersion = archiveVersion;
    }

    public Long getArchiveVersion() {
        return this.archiveVersion;
    }

    private void updateEventStatus() {
        if (this.getWorkflowId() != null && StringUtils.isBlank((CharSequence)this.getWorkflowState()) || this.getWorkflowId() == null && StringUtils.isNotBlank((CharSequence)this.getWorkflowState())) {
            logger.warn("The workflow id {} and workflow state {} are not in sync on event {} organization {}", new Object[]{this.getWorkflowId(), this.getWorkflowState(), this.getIdentifier(), this.getOrganization()});
        }
        this.eventStatus = this.getWorkflowId() != null && StringUtils.isNotBlank((CharSequence)this.getWorkflowState()) ? workflowStatusMapping.get(this.getWorkflowState()) : ("EVENTS.EVENTS.STATUS.PROCESSED".equals(this.eventStatus) && ("capture_finished".equals(this.getRecordingStatus()) || "upload_finished".equals(this.getRecordingStatus())) ? "EVENTS.EVENTS.STATUS.PROCESSED" : ("EVENTS.EVENTS.STATUS.PROCESSING_FAILURE".equals(this.eventStatus) && "capture_error".equals(this.getRecordingStatus()) || "upload_error".equals(this.getRecordingStatus()) ? recordingStatusMapping.get(this.getRecordingStatus()) : (StringUtils.isNotBlank((CharSequence)this.getRecordingStatus()) ? recordingStatusMapping.get(this.getRecordingStatus()) : (this.isScheduledEvent() ? "EVENTS.EVENTS.STATUS.SCHEDULED" : "EVENTS.EVENTS.STATUS.PROCESSED"))));
    }

    public String getDisplayableStatus(Map<String, Map<String, String>> customWorkflowStatusMapping) {
        if (this.getWorkflowId() != null && StringUtils.isNotBlank((CharSequence)this.getWorkflowState()) && customWorkflowStatusMapping.containsKey(this.getWorkflowDefinitionId()) && customWorkflowStatusMapping.get(this.getWorkflowDefinitionId()).containsKey(this.getWorkflowState())) {
            return customWorkflowStatusMapping.get(this.getWorkflowDefinitionId()).get(this.getWorkflowState());
        }
        return this.getEventStatus();
    }

    public boolean isScheduledEvent() {
        return StringUtils.isNotBlank((CharSequence)this.getAgentId());
    }

    public boolean hasRecordingStarted() {
        return this.isScheduledEvent() && StringUtils.isNotBlank((CharSequence)this.getRecordingStatus());
    }

    public void setRecordingStatus(String recordingStatus) {
        this.recordingStatus = recordingStatus;
        this.updateEventStatus();
    }

    public String getRecordingStatus() {
        return this.recordingStatus;
    }

    public String getEventStatus() {
        this.updateEventStatus();
        return this.eventStatus;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public Map<String, String> getAgentConfiguration() {
        return this.agentConfigurations;
    }

    public void setAgentConfiguration(Map<String, String> agentConfigurations) {
        this.agentConfigurations = agentConfigurations;
    }

    public String getTechnicalEndTime() {
        return this.technicalEndTime;
    }

    public void setTechnicalEndTime(String technicalEndTime) {
        this.technicalEndTime = technicalEndTime;
    }

    public String getTechnicalStartTime() {
        return this.technicalStartTime;
    }

    public void setTechnicalStartTime(String technicalStartTime) {
        this.technicalStartTime = technicalStartTime;
    }

    public List<String> getTechnicalPresenters() {
        return this.technicalPresenters;
    }

    public void setTechnicalPresenters(List<String> technicalPresenters) {
        this.technicalPresenters = technicalPresenters;
    }

    public void setExtendedMetadata(String type, Map<String, List<String>> metadata) {
        this.extendedMetadata.put(type, metadata);
    }

    public void resetExtendedMetadata() {
        this.extendedMetadata.clear();
    }

    public Map<String, Map<String, List<String>>> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    public static Event valueOf(InputStream xml, Unmarshaller unmarshaller) throws IOException {
        try {
            if (context == null) {
                Event.createJAXBContext();
            }
            Event event = (Event)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)xml), Event.class).getValue();
            return event;
        }
        catch (JAXBException e) {
            throw new IOException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)xml);
        }
    }

    public static Event valueOfJson(InputStream json) throws IOException, JSONException, XMLStreamException, JAXBException {
        String inputStr;
        if (context == null) {
            Event.createJAXBContext();
        }
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(json, "UTF-8"));
        StringBuilder jsonStringBuilder = new StringBuilder();
        while ((inputStr = streamReader.readLine()) != null) {
            jsonStringBuilder.append(inputStr);
        }
        JSONObject obj = new JSONObject(jsonStringBuilder.toString());
        Configuration config = new Configuration();
        config.setSupressAtAttributes(true);
        HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>(1);
        xmlToJsonNamespaces.put("http://index.matterhorn.opencastproject.org", "");
        config.setXmlToJsonNamespaces(xmlToJsonNamespaces);
        MappedNamespaceConvention con = new MappedNamespaceConvention(config);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
        Event event = (Event)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
        return event;
    }

    private static void createJAXBContext() throws JAXBException {
        context = JAXBContext.newInstance((Class[])new Class[]{Event.class});
    }

    public String toJSON() {
        try {
            if (context == null) {
                Event.createJAXBContext();
            }
            Marshaller marshaller = context.createMarshaller();
            Configuration config = new Configuration();
            config.setSupressAtAttributes(true);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            StringWriter writer = new StringWriter();
            MappedXMLStreamWriter xmlStreamWriter = new MappedXMLStreamWriter(con, writer){

                public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
                    super.writeStartElement("", local, "");
                }

                public void writeStartElement(String uri, String local) throws XMLStreamException {
                    super.writeStartElement("", local, "");
                }

                public void setPrefix(String pfx, String uri) throws XMLStreamException {
                }

                public void setDefaultNamespace(String uri) throws XMLStreamException {
                }
            };
            marshaller.marshal((Object)this, (XMLStreamWriter)xmlStreamWriter);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }

    public String toXML() {
        try {
            if (context == null) {
                Event.createJAXBContext();
            }
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }

    public static Unmarshaller createUnmarshaller() throws IOException {
        try {
            if (context == null) {
                Event.createJAXBContext();
            }
            return context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IOException(e.getLinkedException() != null ? e.getLinkedException() : e);
        }
    }

    static {
        recordingStatusMapping.put("capturing", "EVENTS.EVENTS.STATUS.RECORDING");
        recordingStatusMapping.put("capture_finished", "EVENTS.EVENTS.STATUS.RECORDING");
        recordingStatusMapping.put("manifest", "EVENTS.EVENTS.STATUS.INGESTING");
        recordingStatusMapping.put("manifest_finished", "EVENTS.EVENTS.STATUS.INGESTING");
        recordingStatusMapping.put("compressing", "EVENTS.EVENTS.STATUS.INGESTING");
        recordingStatusMapping.put("uploading", "EVENTS.EVENTS.STATUS.INGESTING");
        recordingStatusMapping.put("upload_finished", "EVENTS.EVENTS.STATUS.INGESTING");
        recordingStatusMapping.put("capture_error", "EVENTS.EVENTS.STATUS.RECORDING_FAILURE");
        recordingStatusMapping.put("manifest_error", "EVENTS.EVENTS.STATUS.RECORDING_FAILURE");
        recordingStatusMapping.put("compressing_error", "EVENTS.EVENTS.STATUS.RECORDING_FAILURE");
        recordingStatusMapping.put("upload_error", "EVENTS.EVENTS.STATUS.RECORDING_FAILURE");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.INSTANTIATED.toString(), "EVENTS.EVENTS.STATUS.PENDING");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.RUNNING.toString(), "EVENTS.EVENTS.STATUS.PROCESSING");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.FAILING.toString(), "EVENTS.EVENTS.STATUS.PROCESSING");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.PAUSED.toString(), "EVENTS.EVENTS.STATUS.PAUSED");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.SUCCEEDED.toString(), "EVENTS.EVENTS.STATUS.PROCESSED");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.FAILED.toString(), "EVENTS.EVENTS.STATUS.PROCESSING_FAILURE");
        workflowStatusMapping.put(WorkflowInstance.WorkflowState.STOPPED.toString(), "EVENTS.EVENTS.STATUS.PROCESSING_CANCELLED");
        context = null;
    }
}

