/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index.endpoint;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.util.SecurityContext;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="IndexEndpoint", title="Index Endpoint", abstractText="Provides operations related to the index that serves both the Admin UI and the External API", notes={})
@Component(immediate=true, property={"service.description=Index Endpoint", "opencast.service.type=org.opencastproject.elasticsearch.index.endpoint", "opencast.service.path=/index"}, service={IndexEndpoint.class})
public class IndexEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IndexEndpoint.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ElasticsearchIndex elasticsearchIndex;
    protected SecurityService securityService = null;
    private IndexRebuildService indexRebuildService = null;

    @Reference
    public void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    public void setIndexRebuildService(IndexRebuildService indexRebuildService) {
        this.indexRebuildService = indexRebuildService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate() {
        logger.info("Activate IndexEndpoint");
    }

    @POST
    @Path(value="clear")
    @RestQuery(name="clearIndex", description="Clear the index", returnDescription="OK if index is cleared", responses={@RestResponse(description="Index is cleared", responseCode=200), @RestResponse(description="Unable to clear index", responseCode=500)})
    public Response clearIndex() {
        SecurityContext securityContext = new SecurityContext(this.securityService, this.securityService.getOrganization(), this.securityService.getUser());
        return (Response)securityContext.runInContext(() -> {
            try {
                logger.info("Clear the index");
                this.elasticsearchIndex.clear();
                return RestUtil.R.ok();
            }
            catch (Throwable t) {
                logger.error("Clearing the index failed", t);
                return RestUtil.R.serverError();
            }
        });
    }

    @POST
    @Path(value="rebuild/{service}")
    @RestQuery(name="partiallyRebuildIndex", description="Repopulates the Index from an specific service", returnDescription="OK if repopulation has started", pathParameters={@RestParameter(name="service", isRequired=true, description="The service to recreate index from. The available services are: Themes, Series, Scheduler, AssetManager, Comments, Workflow and Search. The service order (see above) is very important except for Search! Make sure, you do not run index rebuildfor more than one service at a time!", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="OK if repopulation has started", responseCode=200)})
    public Response partiallyRebuildIndex(@PathParam(value="service") String service) {
        SecurityContext securityContext = new SecurityContext(this.securityService, this.securityService.getOrganization(), this.securityService.getUser());
        this.executor.execute(() -> securityContext.runInContext(() -> {
            try {
                logger.info("Starting to repopulate the index from service {}", (Object)service);
                this.indexRebuildService.rebuildIndex(this.elasticsearchIndex, service);
            }
            catch (Throwable t) {
                logger.error("Repopulating the index failed", t);
            }
        }));
        return RestUtil.R.ok();
    }

    @POST
    @Path(value="rebuild")
    @RestQuery(name="rebuild", description="Clear and repopulates the Index directly from the Services", returnDescription="OK if repopulation has started", responses={@RestResponse(description="OK if repopulation has started", responseCode=200)})
    public Response rebuildIndex() {
        SecurityContext securityContext = new SecurityContext(this.securityService, this.securityService.getOrganization(), this.securityService.getUser());
        this.executor.execute(() -> securityContext.runInContext(() -> {
            try {
                logger.info("Starting to repopulate the index");
                this.indexRebuildService.rebuildIndex(this.elasticsearchIndex);
            }
            catch (Throwable t) {
                logger.error("Repopulating the index failed", t);
            }
        }));
        return RestUtil.R.ok();
    }

    @POST
    @Path(value="resume/{service}")
    @RestQuery(name="resumeIndexRebuild", description="Starts repopulating the Index from an specific service and will then continue with the rest of the services that come afterwards", returnDescription="OK if repopulation has started", pathParameters={@RestParameter(name="service", isRequired=true, description="The service to start recreating the index from. The available services are: Themes, Series, Scheduler, AssetManager, Comments and Workflow. All services that come after the specified service in the order above will also run.", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="OK if repopulation has started", responseCode=200)})
    public Response resumeIndexRebuild(@PathParam(value="service") String service) {
        SecurityContext securityContext = new SecurityContext(this.securityService, this.securityService.getOrganization(), this.securityService.getUser());
        this.executor.execute(() -> securityContext.runInContext(() -> {
            try {
                logger.info("Resume repopulating the index from service {}", (Object)service);
                this.indexRebuildService.resumeIndexRebuild(this.elasticsearchIndex, service);
            }
            catch (Throwable t) {
                logger.error("Repopulating the index failed", t);
            }
        }));
        return RestUtil.R.ok();
    }

    @GET
    @Path(value="rebuild/states.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getrebuildstates", description="Returns the index rebuild servicerepopulation states", returnDescription="The repopulation states of the index rebuild services", responses={@RestResponse(description="Returns the repopulation states of the index rebuild services", responseCode=200)})
    public Response getRebuildStates() {
        Map<String, String> states = this.indexRebuildService.getRebuildStates();
        JSONArray statesAsJson = new JSONArray();
        for (Map.Entry<String, String> entry : states.entrySet()) {
            JSONObject data = new JSONObject();
            data.put((Object)"type", (Object)entry.getKey());
            data.put((Object)"state", (Object)entry.getValue());
            data.put((Object)"executionOrder", (Object)IndexRebuildService.Service.valueOf(entry.getKey()).ordinal());
            statesAsJson.add((Object)data);
        }
        JSONObject service = new JSONObject();
        service.put((Object)"service", (Object)statesAsJson);
        JSONObject services = new JSONObject();
        services.put((Object)"services", (Object)service);
        return Response.ok((Object)services.toJSONString()).build();
    }
}

