/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryPreprocessor {
    private static final Logger logger = LoggerFactory.getLogger(QueryPreprocessor.class);
    private static final char DOUBLE_QUOTE = '\"';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char ASTERISK = '*';
    private static final char EXCLAMATION_MARK = '!';
    private static final char BACKSLASH = '\\';
    private static final char AMPERSAND = '&';
    private static final char PIPE = '|';
    private static final Set<Character> ESCAPED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('!'), Character.valueOf('\\'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(':'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('\"'), Character.valueOf('/')));
    private static final Set<Character> UNARY_OPERATORS = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('!')));
    private static final Set<String> BINARY_OPERATORS = new HashSet<String>(Arrays.asList("&&", "||"));

    private QueryPreprocessor() {
    }

    public static String sanitize(String query) {
        Object sanitizedQuery = "";
        ArrayList<String> tokens = QueryPreprocessor.tokenize(query);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            Object sanitizedToken = QueryPreprocessor.isUnaryOperator(token) ? QueryPreprocessor.sanitizeUnaryOperator(token) : (QueryPreprocessor.isBinaryOperator(token) ? (i == 0 || QueryPreprocessor.isBinaryOperator(tokens.get(i - 1)) || i >= tokens.size() - 1 || QueryPreprocessor.isBinaryOperator(tokens.get(i + 1)) ? "\\" + token : token) : QueryPreprocessor.enablePartialMatches(token, 0));
            if (i != 0) {
                sanitizedQuery = (String)sanitizedQuery + " ";
            }
            sanitizedQuery = (String)sanitizedQuery + (String)sanitizedToken;
        }
        logger.debug("Sanitized input '{}' to '{}'", (Object)query, sanitizedQuery);
        return sanitizedQuery;
    }

    private static boolean isUnaryOperator(String token) {
        return token.length() > 0 && UNARY_OPERATORS.contains(Character.valueOf(token.charAt(0)));
    }

    private static boolean isBinaryOperator(String token) {
        return BINARY_OPERATORS.contains(token);
    }

    private static String enablePartialMatches(String string, int begin) {
        Object result = string;
        char ch = string.charAt(begin);
        if (ch != '\"' && ch != '*') {
            result = "";
            if (begin > 0) {
                result = (String)result + string.substring(0, begin);
            }
            result = (String)result + "*";
            result = (String)result + string.substring(begin, string.length());
        }
        if ((ch = ((String)result).charAt(((String)result).length() - 1)) != '\"' && ch != '*') {
            result = (String)result + "*";
        }
        return result;
    }

    private static String sanitizeUnaryOperator(String token) {
        Object sanitizedToken = token.length() == 1 ? "\\" + token.charAt(0) : QueryPreprocessor.enablePartialMatches(token, 1);
        return sanitizedToken;
    }

    private static ArrayList<String> tokenize(String query) {
        ArrayList<String> tokens = new ArrayList<String>();
        Object currentToken = "";
        boolean openDoubleQuote = false;
        for (int i = 0; i < query.length(); ++i) {
            char ch = query.charAt(i);
            if (ch == '\"') {
                if (openDoubleQuote) {
                    currentToken = (String)currentToken + "\"";
                    tokens.add((String)currentToken);
                    currentToken = "";
                    openDoubleQuote = false;
                    continue;
                }
                if (((String)currentToken).isEmpty() || QueryPreprocessor.isUnaryOperator("" + QueryPreprocessor.charAt(i - 1, query)) && Character.isWhitespace(QueryPreprocessor.charAt(i - 2, query))) {
                    currentToken = (String)currentToken + "\"";
                    openDoubleQuote = true;
                    continue;
                }
                currentToken = (String)currentToken + "\\\"";
                continue;
            }
            if (openDoubleQuote) {
                currentToken = (String)currentToken + ch;
                continue;
            }
            if (QueryPreprocessor.isUnaryOperator("" + ch) && Character.isWhitespace(QueryPreprocessor.charAt(i - 1, query))) {
                currentToken = (String)currentToken + ch;
                continue;
            }
            if (QueryPreprocessor.isBinaryOperator("" + ch + QueryPreprocessor.charAt(i + 1, query)) && Character.isWhitespace(QueryPreprocessor.charAt(i - 1, query)) && Character.isWhitespace(QueryPreprocessor.charAt(i + 2, query))) {
                tokens.add("" + ch + ch);
                ++i;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (((String)currentToken).isEmpty()) continue;
                tokens.add((String)currentToken);
                currentToken = "";
                continue;
            }
            currentToken = ESCAPED_CHARACTERS.contains(Character.valueOf(ch)) ? (String)currentToken + "\\" + ch : (String)currentToken + ch;
        }
        if (!((String)currentToken).isEmpty()) {
            if (openDoubleQuote) {
                currentToken = (String)currentToken + "\"";
            }
            tokens.add((String)currentToken);
        }
        return tokens;
    }

    private static char charAt(int position, String string) {
        if (0 <= position && position < string.length()) {
            return string.charAt(position);
        }
        return ' ';
    }
}

