/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.index;

import com.google.common.util.concurrent.Striped;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.impl.AbstractElasticsearchIndex;
import org.opencastproject.elasticsearch.impl.ElasticsearchDocument;
import org.opencastproject.elasticsearch.impl.SearchMetadataCollection;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventIndexUtils;
import org.opencastproject.elasticsearch.index.objects.event.EventQueryBuilder;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesIndexUtils;
import org.opencastproject.elasticsearch.index.objects.series.SeriesQueryBuilder;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.elasticsearch.index.objects.theme.IndexTheme;
import org.opencastproject.elasticsearch.index.objects.theme.ThemeQueryBuilder;
import org.opencastproject.elasticsearch.index.objects.theme.ThemeSearchQuery;
import org.opencastproject.security.api.User;
import org.opencastproject.util.data.functions.Misc;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Elasticsearch Index"}, immediate=true, service={ElasticsearchIndex.class})
public class ElasticsearchIndex
extends AbstractElasticsearchIndex {
    private int maxRetryAttemptsGet;
    private static final String MAX_RETRY_ATTEMPTS_GET_PROPERTY = "max.retry.attempts.get";
    private static final int DEFAULT_MAX_RETRY_ATTEMPTS_GET = 0;
    private int maxRetryAttemptsUpdate;
    private static final String MAX_RETRY_ATTEMPTS_UPDATE_PROPERTY = "max.retry.attempts.update";
    private static final int DEFAULT_MAX_RETRY_ATTEMPTS_UPDATE = 0;
    private int retryWaitingPeriodGet;
    private static final String RETRY_WAITING_PERIOD_GET_PROPERTY = "retry.waiting.period.get";
    private static final int DEFAULT_RETRY_WAITING_PERIOD_GET = 1000;
    private int retryWaitingPeriodUpdate;
    private static final String RETRY_WAITING_PERIOD_UPDATE_PROPERTY = "retry.waiting.period.update";
    private static final int DEFAULT_RETRY_WAITING_PERIOD_UPDATE = 1000;
    private static final int INDEX_VERSION = 101;
    private static final String VERSION_DOCUMENT_TYPE = "version";
    private static final String[] DOCUMENT_TYPES = new String[]{"event", "series", "theme", "version"};
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchIndex.class);
    private final Striped<Lock> locks = Striped.lazyWeakLock((int)1024);

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> properties) throws ComponentException {
        super.activate(properties, bundleContext);
        this.modified(properties);
        try {
            this.init(101);
        }
        catch (Throwable t) {
            throw new ComponentException("Error initializing elastic search index", t);
        }
    }

    @Deactivate
    public void deactivate() throws IOException {
        this.close();
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        super.modified(properties);
        this.maxRetryAttemptsGet = NumberUtils.toInt((String)((String)properties.get(MAX_RETRY_ATTEMPTS_GET_PROPERTY)), (int)0);
        this.retryWaitingPeriodGet = NumberUtils.toInt((String)((String)properties.get(RETRY_WAITING_PERIOD_GET_PROPERTY)), (int)1000);
        logger.info("Max retry attempts for get requests set to {}, timeout set to {} ms.", (Object)this.maxRetryAttemptsGet, (Object)this.retryWaitingPeriodGet);
        this.maxRetryAttemptsUpdate = NumberUtils.toInt((String)((String)properties.get(MAX_RETRY_ATTEMPTS_UPDATE_PROPERTY)), (int)0);
        this.retryWaitingPeriodUpdate = NumberUtils.toInt((String)((String)properties.get(RETRY_WAITING_PERIOD_UPDATE_PROPERTY)), (int)1000);
        logger.info("Max retry attempts for update requests set to {}, timeout set to {} ms.", (Object)this.maxRetryAttemptsUpdate, (Object)this.retryWaitingPeriodUpdate);
        if (this.maxRetryAttemptsGet < 0 || this.maxRetryAttemptsUpdate < 0 || this.retryWaitingPeriodGet < 0 || this.retryWaitingPeriodUpdate < 0) {
            logger.warn("You have configured negative values for max attempts or retry periods. Is this intended? This is equivalent to setting those values to 0.");
        }
    }

    public String[] getDocumentTypes() {
        return DOCUMENT_TYPES;
    }

    public Optional<Event> getEvent(String mediaPackageId, String organization, User user) throws SearchIndexException {
        return this.getEvent(mediaPackageId, organization, user, this.maxRetryAttemptsGet, this.retryWaitingPeriodGet);
    }

    private Optional<Event> getEvent(String mediaPackageId, String organization, User user, int maxRetryAttempts, int retryWaitingPeriod) throws SearchIndexException {
        EventSearchQuery query = new EventSearchQuery(organization, user).withoutActions().withIdentifier(mediaPackageId);
        SearchResult<Event> searchResult = this.getByQuery(query, maxRetryAttempts, retryWaitingPeriod);
        if (searchResult.getDocumentCount() == 0L) {
            return Optional.empty();
        }
        if (searchResult.getDocumentCount() == 1L) {
            return Optional.of((Event)searchResult.getItems()[0].getSource());
        }
        throw new IllegalStateException("Multiple events with identifier " + mediaPackageId + " found in search index");
    }

    public Optional<Series> getSeries(String seriesId, String organization, User user) throws SearchIndexException {
        return this.getSeries(seriesId, organization, user, this.maxRetryAttemptsGet, this.retryWaitingPeriodGet);
    }

    private Optional<Series> getSeries(String seriesId, String organization, User user, int maxRetryAttempts, int retryWaitingPeriod) throws SearchIndexException {
        SeriesSearchQuery query = new SeriesSearchQuery(organization, user).withoutActions().withIdentifier(seriesId);
        SearchResult<Series> searchResult = this.getByQuery(query, maxRetryAttempts, retryWaitingPeriod);
        if (searchResult.getDocumentCount() == 0L) {
            return Optional.empty();
        }
        if (searchResult.getDocumentCount() == 1L) {
            return Optional.of((Series)searchResult.getItems()[0].getSource());
        }
        throw new IllegalStateException("Multiple series with identifier " + seriesId + " found in search index");
    }

    public Optional<IndexTheme> getTheme(long themeId, String organization, User user) throws SearchIndexException {
        return this.getTheme(themeId, organization, user, this.maxRetryAttemptsGet, this.retryWaitingPeriodGet);
    }

    private Optional<IndexTheme> getTheme(long themeId, String organization, User user, int maxRetryAttempts, int retryWaitingPeriod) throws SearchIndexException {
        ThemeSearchQuery query = new ThemeSearchQuery(organization, user).withIdentifier(themeId);
        SearchResult<IndexTheme> searchResult = this.getByQuery(query, maxRetryAttempts, retryWaitingPeriod);
        if (searchResult.getDocumentCount() == 0L) {
            return Optional.empty();
        }
        if (searchResult.getDocumentCount() == 1L) {
            return Optional.of((IndexTheme)searchResult.getItems()[0].getSource());
        }
        throw new IllegalStateException("Multiple themes with identifier " + themeId + " found in search index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Event> addOrUpdateEvent(String id, Function<Optional<Event>, Optional<Event>> updateFunction, String orgId, User user) throws SearchIndexException {
        Lock lock = (Lock)this.locks.get((Object)id);
        lock.lock();
        logger.debug("Locked event '{}'", (Object)id);
        try {
            Optional<Event> eventOpt = this.getEvent(id, orgId, user, this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate);
            Optional<Event> updatedEventOpt = updateFunction.apply(eventOpt);
            if (updatedEventOpt.isPresent()) {
                this.update(updatedEventOpt.get());
            }
            Optional<Event> optional = updatedEventOpt;
            return optional;
        }
        finally {
            lock.unlock();
            logger.debug("Released locked event '{}'", (Object)id);
        }
    }

    private void update(Event event) throws SearchIndexException {
        logger.debug("Adding event {} to search index", (Object)event.getIdentifier());
        SearchMetadataCollection inputDocument = EventIndexUtils.toSearchMetadata(event);
        List resourceMetadata = inputDocument.getMetadata();
        ElasticsearchDocument doc = new ElasticsearchDocument(inputDocument.getIdentifier(), inputDocument.getDocumentType(), resourceMetadata);
        try {
            this.update(this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate, doc);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Cannot write event " + event + " to index", t);
        }
    }

    public void bulkEventUpdate(List<Event> eventList) throws SearchIndexException {
        ArrayList<ElasticsearchDocument> docs = new ArrayList<ElasticsearchDocument>();
        for (Event event : eventList) {
            logger.debug("Adding event {} to search index", (Object)event.getIdentifier());
            SearchMetadataCollection inputDocument = EventIndexUtils.toSearchMetadata(event);
            List resourceMetadata = inputDocument.getMetadata();
            docs.add(new ElasticsearchDocument(inputDocument.getIdentifier(), inputDocument.getDocumentType(), resourceMetadata));
        }
        try {
            this.bulkUpdate(this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate, docs);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Cannot write events " + eventList + " to index", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Series> addOrUpdateSeries(String id, Function<Optional<Series>, Optional<Series>> updateFunction, String orgId, User user) throws SearchIndexException {
        Lock lock = (Lock)this.locks.get((Object)id);
        lock.lock();
        logger.debug("Locked series '{}'", (Object)id);
        try {
            Optional<Series> seriesOpt = this.getSeries(id, orgId, user, this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate);
            Optional<Series> updatedSeriesOpt = updateFunction.apply(seriesOpt);
            if (updatedSeriesOpt.isPresent()) {
                this.update(updatedSeriesOpt.get());
            }
            Optional<Series> optional = updatedSeriesOpt;
            return optional;
        }
        finally {
            lock.unlock();
            logger.debug("Released locked series '{}'", (Object)id);
        }
    }

    private void update(Series series) throws SearchIndexException {
        logger.debug("Adding series {} to search index", (Object)series.getIdentifier());
        SearchMetadataCollection inputDocument = SeriesIndexUtils.toSearchMetadata(series);
        List resourceMetadata = inputDocument.getMetadata();
        ElasticsearchDocument doc = new ElasticsearchDocument(inputDocument.getIdentifier(), inputDocument.getDocumentType(), resourceMetadata);
        try {
            this.update(this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate, doc);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Cannot write series " + series + " to index", t);
        }
    }

    public void bulkSeriesUpdate(List<Series> seriesList) throws SearchIndexException {
        ArrayList<ElasticsearchDocument> docs = new ArrayList<ElasticsearchDocument>();
        for (Series series : seriesList) {
            logger.debug("Adding series {} to search index", (Object)series.getIdentifier());
            SearchMetadataCollection inputDocument = SeriesIndexUtils.toSearchMetadata(series);
            List resourceMetadata = inputDocument.getMetadata();
            docs.add(new ElasticsearchDocument(inputDocument.getIdentifier(), inputDocument.getDocumentType(), resourceMetadata));
        }
        try {
            this.bulkUpdate(this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate, docs);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Cannot write series " + seriesList + " to index", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<IndexTheme> addOrUpdateTheme(long id, Function<Optional<IndexTheme>, Optional<IndexTheme>> updateFunction, String orgId, User user) throws SearchIndexException {
        Lock lock = (Lock)this.locks.get((Object)id);
        lock.lock();
        logger.debug("Locked theme '{}'", (Object)id);
        try {
            Optional<IndexTheme> themeOpt = this.getTheme(id, orgId, user, this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate);
            Optional<IndexTheme> updatedThemeOpt = updateFunction.apply(themeOpt);
            if (updatedThemeOpt.isPresent()) {
                this.update(updatedThemeOpt.get());
            }
            Optional<IndexTheme> optional = updatedThemeOpt;
            return optional;
        }
        finally {
            lock.unlock();
            logger.debug("Released locked theme '{}'", (Object)id);
        }
    }

    private void update(IndexTheme theme) throws SearchIndexException {
        logger.debug("Adding theme {} to search index", (Object)theme.getIdentifier());
        SearchMetadataCollection inputDocument = theme.toSearchMetadata();
        List resourceMetadata = inputDocument.getMetadata();
        ElasticsearchDocument doc = new ElasticsearchDocument(inputDocument.getIdentifier(), inputDocument.getDocumentType(), resourceMetadata);
        try {
            this.update(this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate, doc);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Cannot write theme " + theme + " to index", t);
        }
    }

    public void bulkThemeUpdate(List<IndexTheme> themeList) throws SearchIndexException {
        ArrayList<ElasticsearchDocument> docs = new ArrayList<ElasticsearchDocument>();
        for (IndexTheme theme : themeList) {
            logger.debug("Adding theme {} to search index", (Object)theme.getIdentifier());
            SearchMetadataCollection inputDocument = theme.toSearchMetadata();
            List resourceMetadata = inputDocument.getMetadata();
            docs.add(new ElasticsearchDocument(inputDocument.getIdentifier(), inputDocument.getDocumentType(), resourceMetadata));
        }
        try {
            this.bulkUpdate(this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate, docs);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Cannot write themes " + themeList + " to index", t);
        }
    }

    public boolean deleteEvent(String eventId, String orgId) throws SearchIndexException {
        return this.delete("event", eventId, orgId);
    }

    public boolean deleteSeries(String seriesId, String orgId) throws SearchIndexException {
        return this.delete("series", seriesId, orgId);
    }

    public boolean deleteTheme(String themeId, String orgId) throws SearchIndexException {
        return this.delete("theme", themeId, orgId);
    }

    private boolean delete(String type, String id, String orgId) throws SearchIndexException {
        Lock lock = (Lock)this.locks.get((Object)id);
        lock.lock();
        logger.debug("Locked {} '{}'.", (Object)type, (Object)id);
        try {
            String idWithOrgId = id.concat(orgId);
            logger.debug("Removing element with id '{}' from search index '{}'", (Object)idWithOrgId, (Object)this.getSubIndexIdentifier(type));
            DeleteResponse deleteResponse = this.delete(type, idWithOrgId, this.maxRetryAttemptsUpdate, this.retryWaitingPeriodUpdate);
            if (deleteResponse.getResult().equals((Object)DocWriteResponse.Result.NOT_FOUND)) {
                logger.trace("Document {} to delete was not found on index '{}'", (Object)idWithOrgId, (Object)this.getSubIndexIdentifier(type));
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            throw new SearchIndexException("Cannot remove " + type + " " + id + " from index", e);
        }
        finally {
            lock.unlock();
            logger.debug("Released locked {} '{}'.", (Object)type, (Object)id);
        }
        return true;
    }

    public SearchResult<Event> getByQuery(EventSearchQuery query) throws SearchIndexException {
        return this.getByQuery(query, this.maxRetryAttemptsGet, this.retryWaitingPeriodGet);
    }

    private SearchResult<Event> getByQuery(EventSearchQuery query, int maxRetryAttempts, int retryWaitingPeriod) throws SearchIndexException {
        logger.debug("Searching index using event query '{}'", (Object)query);
        SearchRequest searchRequest = this.getSearchRequest((SearchQuery)query, (QueryBuilder)new EventQueryBuilder(query));
        try {
            Unmarshaller unmarshaller = Event.createUnmarshaller();
            return this.executeQuery((SearchQuery)query, searchRequest, metadata -> {
                try {
                    return EventIndexUtils.toRecordingEvent(metadata, unmarshaller);
                }
                catch (IOException e) {
                    return (Event)Misc.chuck((Throwable)e);
                }
            }, maxRetryAttempts, retryWaitingPeriod);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Error querying event index", t);
        }
    }

    public SearchResult<Series> getByQuery(SeriesSearchQuery query) throws SearchIndexException {
        return this.getByQuery(query, this.maxRetryAttemptsGet, this.retryWaitingPeriodGet);
    }

    private SearchResult<Series> getByQuery(SeriesSearchQuery query, int maxRetryAttempts, int retryWaitingPeriod) throws SearchIndexException {
        logger.debug("Searching index using series query '{}'", (Object)query);
        SearchRequest searchRequest = this.getSearchRequest((SearchQuery)query, (QueryBuilder)new SeriesQueryBuilder(query));
        try {
            Unmarshaller unmarshaller = Series.createUnmarshaller();
            return this.executeQuery((SearchQuery)query, searchRequest, metadata -> {
                try {
                    return SeriesIndexUtils.toSeries(metadata, unmarshaller);
                }
                catch (IOException e) {
                    return (Series)Misc.chuck((Throwable)e);
                }
            }, maxRetryAttempts, retryWaitingPeriod);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Error querying series index", t);
        }
    }

    public SearchResult<IndexTheme> getByQuery(ThemeSearchQuery query) throws SearchIndexException {
        return this.getByQuery(query, this.maxRetryAttemptsGet, this.retryWaitingPeriodGet);
    }

    private SearchResult<IndexTheme> getByQuery(ThemeSearchQuery query, int maxRetryAttempts, int retryWaitingPeriod) throws SearchIndexException {
        logger.debug("Searching index using theme query '{}'", (Object)query);
        SearchRequest searchRequest = this.getSearchRequest((SearchQuery)query, (QueryBuilder)new ThemeQueryBuilder(query));
        try {
            return this.executeQuery((SearchQuery)query, searchRequest, metadata -> {
                try {
                    return IndexTheme.fromSearchMetadata(metadata);
                }
                catch (IOException e) {
                    return (IndexTheme)Misc.chuck((Throwable)e);
                }
            }, maxRetryAttempts, retryWaitingPeriod);
        }
        catch (Throwable t) {
            throw new SearchIndexException("Error querying theme index", t);
        }
    }
}

