/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.distribution.streaming.wowza.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="streamingdistributionservice", title="Streaming Distribution Service", abstractText="This service distributes media packages to the streaming server, especially Wowza Streaming Server.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred:<a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={WowzaStreamingDistributionRestService.class}, property={"service.description=Streaming Distribution REST Endpoint", "opencast.service.type=org.opencastproject.distribution.streaming", "opencast.service.path=/distribution/streaming", "opencast.service.jobproducer=true"})
public class WowzaStreamingDistributionRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(WowzaStreamingDistributionRestService.class);
    private StreamingDistributionService service;
    private ServiceRegistry serviceRegistry = null;
    private static final Gson gson = new Gson();

    @Activate
    public void activate(ComponentContext cc) {
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setService(StreamingDistributionService service) {
        this.service = service;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/publishToStreaming")
    @RestQuery(name="publishToStreaming", description="Checks whether publish to streaming is configured for the current organization", returnDescription="Returns whether publish to streaming is configured for the current organization as a boolean.", responses={@RestResponse(responseCode=200, description="Whether publish to streaming is configured for the current organization.")})
    public Response publishToStreaming() {
        return Response.ok((Object)Boolean.toString(this.service.publishToStreaming())).build();
    }

    @POST
    @Path(value="/")
    @Produces(value={"text/xml"})
    @RestQuery(name="distribute", description="Distribute a media package element to this distribution channel", returnDescription="The job that can be used to track the distribution", restParameters={@RestParameter(name="mediapackage", isRequired=true, description="The mediapackage", type=RestParameter.Type.TEXT), @RestParameter(name="channelId", isRequired=true, description="The publication channel ID", type=RestParameter.Type.TEXT), @RestParameter(name="elementIds", isRequired=true, description="The elements to distribute as Json Array['IdOne','IdTwo']", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the distribution job"), @RestResponse(responseCode=204, description="There is no streaming distribution service available")})
    public Response distribute(@FormParam(value="mediapackage") String mediaPackageXml, @FormParam(value="channelId") String channelId, @FormParam(value="elementIds") String elementIds) {
        try {
            Set setElementIds = (Set)gson.fromJson(elementIds, new TypeToken<Set<String>>(){}.getType());
            MediaPackage mediapackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            Job job = this.service.distribute(channelId, mediapackage, setElementIds);
            if (job == null) {
                return Response.noContent().build();
            }
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to distribute element", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.warn("Error distributing element", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/distributesync")
    @Produces(value={"text/xml"})
    @RestQuery(name="distributesync", description="Syncrhonously distribute a media package element to this distribution channel", returnDescription="The distribution", restParameters={@RestParameter(name="mediapackage", isRequired=true, description="The mediapackage", type=RestParameter.Type.TEXT), @RestParameter(name="channelId", isRequired=true, description="The publication channel ID", type=RestParameter.Type.TEXT), @RestParameter(name="elementIds", isRequired=true, description="The elements to distribute as Json Array['IdOne','IdTwo']", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the distribution"), @RestResponse(responseCode=204, description="There is no streaming distribution service available")})
    public Response distributeSync(@FormParam(value="mediapackage") String mediaPackageXml, @FormParam(value="channelId") String channelId, @FormParam(value="elementIds") String elementIds) {
        try {
            Set setElementIds = (Set)gson.fromJson(elementIds, new TypeToken<Set<String>>(){}.getType());
            MediaPackage mediapackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            List result = this.service.distributeSync(channelId, mediapackage, setElementIds);
            if (result == null || result.isEmpty()) {
                return Response.noContent().build();
            }
            return Response.ok((Object)MediaPackageElementParser.getArrayAsXml((Collection)result)).build();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to distribute element", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.warn("Error distributing element", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/retract")
    @Produces(value={"text/xml"})
    @RestQuery(name="retract", description="Retract a media package element from this distribution channel", returnDescription="The job that can be used to track the retraction", restParameters={@RestParameter(name="mediapackage", isRequired=true, description="The mediapackage", type=RestParameter.Type.TEXT), @RestParameter(name="channelId", isRequired=true, description="The publication channel ID", type=RestParameter.Type.TEXT), @RestParameter(name="elementIds", isRequired=true, description="The elements to retract as Json Array['IdOne','IdTwo']", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the retraction job"), @RestResponse(responseCode=204, description="There is no streaming distribution service available")})
    public Response retract(@FormParam(value="mediapackage") String mediaPackageXml, @FormParam(value="channelId") String channelId, @FormParam(value="elementIds") String elementIds) {
        try {
            Set setElementIds = (Set)gson.fromJson(elementIds, new TypeToken<Set<String>>(){}.getType());
            MediaPackage mediapackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            Job job = this.service.retract(channelId, mediapackage, setElementIds);
            if (job == null) {
                return Response.noContent().build();
            }
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to retract element: {}", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.warn("Unable to retract media package '{}' from streaming channel: {}", new Object[]{mediaPackageXml, e});
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/retractsync")
    @Produces(value={"text/xml"})
    @RestQuery(name="retractsync", description="Synchronously retract a media package element from this distribution channel", returnDescription="The retraction", restParameters={@RestParameter(name="mediapackage", isRequired=true, description="The mediapackage", type=RestParameter.Type.TEXT), @RestParameter(name="channelId", isRequired=true, description="The publication channel ID", type=RestParameter.Type.TEXT), @RestParameter(name="elementIds", isRequired=true, description="The elements to retract as Json Array['IdOne','IdTwo']", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the retraction"), @RestResponse(responseCode=204, description="There is no streaming distribution service available")})
    public Response retractSync(@FormParam(value="mediapackage") String mediaPackageXml, @FormParam(value="channelId") String channelId, @FormParam(value="elementIds") String elementIds) {
        try {
            Set setElementIds = (Set)gson.fromJson(elementIds, new TypeToken<Set<String>>(){}.getType());
            MediaPackage mediapackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            List result = this.service.retractSync(channelId, mediapackage, setElementIds);
            if (result == null || result.isEmpty()) {
                return Response.noContent().build();
            }
            return Response.ok((Object)MediaPackageElementParser.getArrayAsXml((Collection)result)).build();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to retract element", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.warn("Unable to retract mediapackage '{}' from streaming channel: {}", new Object[]{mediaPackageXml, e});
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

