/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.distribution.streaming.wowza;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.distribution.api.AbstractDistributionService;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.AudioStream;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.FileSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(immediate=true, service={DistributionService.class, StreamingDistributionService.class}, property={"service.description=Distribution Service (Streaming)", "distribution.channel=streaming"})
public class WowzaStreamingDistributionService
extends AbstractDistributionService
implements StreamingDistributionService {
    protected static final String STREAMING_DIRECTORY_KEY = "org.opencastproject.streaming.directory";
    protected static final String WOWZA_FORMATS_KEY = "org.opencastproject.wowza.formats";
    protected static final String WOWZA_URL_KEY = "org.opencastproject.%s.wowza.url";
    protected static final String WOWZA_PORT_KEY = "org.opencastproject.%s.wowza.port";
    protected Map<String, URI> streamingUrls;
    protected static final String SMIL_ORDER_KEY = "org.opencastproject.wowza.smil.order";
    private static final String SMIL_ASCENDING_VALUE = "ascending";
    private static final String SMIL_DESCENDING_VALUE = "descending";
    private static final String SMIL_ATTR_VIDEO_BITRATE = "video-bitrate";
    private static final String SMIL_ATTR_VIDEO_WIDTH = "width";
    private static final String SMIL_ATTR_VIDEO_HEIGHT = "height";
    private static final String DISTRIBUTION_TYPE = "streaming";
    private static final Set<String> validSchemes;
    private static final Map<String, Integer> defaultProtocolPorts;
    protected static final String DEFAULT_SCHEME = "http";
    private static final Logger logger;
    public static final String JOB_TYPE = "org.opencastproject.distribution.streaming";
    public static final float DEFAULT_DISTRIBUTE_JOB_LOAD = 0.1f;
    public static final float DEFAULT_RETRACT_JOB_LOAD = 0.1f;
    public static final String DISTRIBUTE_JOB_LOAD_KEY = "job.load.streaming.distribute";
    public static final String RETRACT_JOB_LOAD_KEY = "job.load.streaming.retract";
    private float distributeJobLoad = 0.1f;
    private float retractJobLoad = 0.1f;
    private File distributionDirectory = null;
    private Set<TrackImpl.StreamingProtocol> supportedFormats;
    private boolean isSmilOrderDescending = false;
    private static final Gson gson;

    public WowzaStreamingDistributionService() {
        super(JOB_TYPE);
    }

    public String getDistributionType() {
        return DISTRIBUTION_TYPE;
    }

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> properties) throws ComponentException, ConfigurationException {
        this.modified(bundleContext, properties);
    }

    @Modified
    public void modified(BundleContext bundleContext, Map<String, Object> properties) throws ComponentException, ConfigurationException {
        if (properties != null && bundleContext != null) {
            ConcurrentHashMap<String, URI> streamingUrlConfiguration = new ConcurrentHashMap<String, URI>();
            Object distributionDirectoryPath = StringUtils.trimToNull((String)((String)properties.get(STREAMING_DIRECTORY_KEY)));
            if (distributionDirectoryPath == null && (distributionDirectoryPath = StringUtils.trimToNull((String)bundleContext.getProperty("org.opencastproject.storage.dir"))) != null) {
                distributionDirectoryPath = (String)distributionDirectoryPath + "/streams";
            }
            if (distributionDirectoryPath == null) {
                throw new ComponentException("Streaming distribution directory must be set");
            }
            this.distributionDirectory = new File((String)distributionDirectoryPath);
            if (!this.distributionDirectory.isDirectory()) {
                try {
                    Files.createDirectories(this.distributionDirectory.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ComponentException("Distribution directory " + this.distributionDirectory + " does not exist and can't be created", (Throwable)e);
                }
            }
            logger.info("Streaming distribution directory is {}", (Object)this.distributionDirectory);
            List organizations = this.organizationDirectoryService.getOrganizations();
            for (Organization org : organizations) {
                String orgId = org.getId();
                String streamingUrl = StringUtils.trimToNull((String)((String)properties.get(String.format(WOWZA_URL_KEY, orgId))));
                String streamingPort = StringUtils.trimToNull((String)((String)properties.get(String.format(WOWZA_PORT_KEY, orgId))));
                if (streamingUrl != null) {
                    try {
                        URI tenantStreamingUrl = WowzaStreamingDistributionService.getStreamingUrl(streamingUrl, streamingPort, validSchemes, DEFAULT_SCHEME, null);
                        if (tenantStreamingUrl == null) {
                            throw new ComponentException(String.format("Streaming URL is undefined for tenant %s.", orgId));
                        }
                        streamingUrlConfiguration.put(orgId, tenantStreamingUrl);
                        logger.info("Wowza Streaming URL for tenant {} set to \"{}\"", (Object)orgId, (Object)tenantStreamingUrl);
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new ComponentException(String.format("Wowza Streaming URL %s of tenant %s could not be parsed", streamingUrl, orgId), (Throwable)e);
                    }
                }
                logger.debug("Wowza Streaming URL is undefined for tenant {}", (Object)orgId);
            }
            this.streamingUrls = streamingUrlConfiguration;
            String formats = StringUtils.trimToNull((String)((String)properties.get(WOWZA_FORMATS_KEY)));
            if (formats == null) {
                this.setDefaultSupportedFormats();
            } else {
                this.setSupportedFormats(formats);
            }
            logger.info("The supported streaming formats are: {}", (Object)StringUtils.join(this.supportedFormats, (String)","));
            String smilOrder = StringUtils.trimToNull((String)((String)properties.get(SMIL_ORDER_KEY)));
            if (smilOrder == null || SMIL_ASCENDING_VALUE.equals(smilOrder)) {
                logger.info("The videos in the SMIL files will be sorted in ascending bitrate order");
                this.isSmilOrderDescending = false;
            } else if (SMIL_DESCENDING_VALUE.equals(smilOrder)) {
                this.isSmilOrderDescending = true;
                logger.info("The videos in the SMIL files will be sorted in descending bitrate order");
            } else {
                throw new ConfigurationException(SMIL_ORDER_KEY, String.format("Illegal value '%s'. Valid options are '%s' and '%s'", smilOrder, SMIL_ASCENDING_VALUE, SMIL_DESCENDING_VALUE));
            }
            this.distributeJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)DISTRIBUTE_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
            this.retractJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)RETRACT_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
        }
    }

    public boolean publishToStreaming() {
        String currentOrgId = this.securityService.getOrganization().getId();
        return this.streamingUrls.containsKey(currentOrgId);
    }

    private URI getStreamingURLforCurrentOrg() {
        String currentOrgId = this.securityService.getOrganization().getId();
        if (this.streamingUrls.containsKey(currentOrgId)) {
            return this.streamingUrls.get(currentOrgId);
        }
        return null;
    }

    private void setSupportedFormats(String formatString) {
        this.supportedFormats = new TreeSet<TrackImpl.StreamingProtocol>();
        for (String format : formatString.toUpperCase().split("[\\s,]")) {
            if (format.isEmpty()) continue;
            try {
                TrackImpl.StreamingProtocol protocol = TrackImpl.StreamingProtocol.valueOf((String)format);
                this.supportedFormats.add(protocol);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Found incorrect format \"{}\". Ignoring...", (Object)format);
            }
        }
    }

    private void setDefaultSupportedFormats() {
        this.supportedFormats = new TreeSet<TrackImpl.StreamingProtocol>(Arrays.asList(TrackImpl.StreamingProtocol.HLS, TrackImpl.StreamingProtocol.HDS, TrackImpl.StreamingProtocol.SMOOTH, TrackImpl.StreamingProtocol.DASH));
    }

    private static URI getStreamingUrl(String inputUri, String inputPort, Set<String> validSchemes, String defaultScheme, String defaultUri) throws URISyntaxException {
        URI uri;
        Integer port;
        try {
            port = Integer.parseInt(StringUtils.trimToEmpty((String)inputPort));
        }
        catch (NumberFormatException e) {
            port = null;
        }
        if (StringUtils.isNotBlank((CharSequence)inputUri)) {
            uri = new URI(inputUri);
        } else if (StringUtils.isNotBlank((CharSequence)defaultUri)) {
            uri = new URI(defaultUri);
        } else {
            throw new IllegalArgumentException("Provided streaming URL is empty.");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        String scheme = uri.getScheme();
        String uriPath = uri.getPath();
        if (uri.getHost() == null) {
            uriBuilder.host(uriPath.substring(0, uriPath.indexOf("/"))).replacePath(uriPath.substring(uriPath.indexOf("/")));
        }
        if (!validSchemes.contains(scheme)) {
            if (scheme == null) {
                uriBuilder.scheme(defaultScheme);
            } else {
                throw new URISyntaxException(inputUri, "Provided URI has an illegal scheme");
            }
        }
        if (port != null && !port.equals(defaultProtocolPorts.get(uriBuilder.build(new Object[0]).getScheme()))) {
            uriBuilder.port(port.intValue());
        }
        return uriBuilder.build(new Object[0]);
    }

    public Job distribute(String channelId, MediaPackage mediapackage, Set<String> elementIds) throws DistributionException {
        RequireUtil.notNull((Object)mediapackage, (String)"mediaPackage");
        RequireUtil.notNull(elementIds, (String)"elementIds");
        RequireUtil.notNull((Object)channelId, (String)"channelId");
        if (this.getStreamingURLforCurrentOrg() == null) {
            throw new IllegalStateException(String.format("No streaming url or port set for tenant %s", this.securityService.getOrganization().getId()));
        }
        if (this.distributionDirectory == null) {
            throw new IllegalStateException("Streaming distribution directory must be set (org.opencastproject.streaming.directory)");
        }
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.Distribute.toString(), Arrays.asList(channelId, MediaPackageParser.getAsXml((MediaPackage)mediapackage), gson.toJson(elementIds)), Float.valueOf(this.distributeJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new DistributionException("Unable to create a job", (Throwable)e);
        }
    }

    public Job distribute(String channelId, MediaPackage mediapackage, String elementId) throws DistributionException {
        return this.distribute(channelId, mediapackage, new HashSet<String>(Collections.singletonList(elementId)));
    }

    private List<MediaPackageElement> distributeElements(String channelId, MediaPackage mediaPackage, Set<String> elementIds, URI streamingURL) throws DistributionException {
        RequireUtil.notNull((Object)mediaPackage, (String)"mediaPackage");
        RequireUtil.notNull(elementIds, (String)"elementIds");
        RequireUtil.notNull((Object)channelId, (String)"channelId");
        ArrayList<MediaPackageElement> distributedElements = new ArrayList<MediaPackageElement>();
        for (MediaPackageElement element : this.getElements(mediaPackage, elementIds)) {
            distributedElements.addAll(this.distributeElement(channelId, mediaPackage, element, streamingURL));
        }
        return distributedElements;
    }

    private synchronized List<MediaPackageElement> distributeElement(String channelId, MediaPackage mediaPackage, MediaPackageElement element, URI streamingURL) throws DistributionException {
        if (this.supportedFormats.isEmpty()) {
            logger.warn("Skipping distribution of element \"{}\" because no streaming format was specified", (Object)element);
            return Collections.emptyList();
        }
        if (!MediaPackageElement.Type.Track.equals((Object)element.getElementType())) {
            logger.debug("Skipping {} {} for distribution to the streaming server", (Object)element.getElementType(), (Object)element.getIdentifier());
            return Collections.emptyList();
        }
        try {
            File source;
            try {
                source = this.workspace.get(element.getURI());
            }
            catch (IOException | NotFoundException e) {
                throw new DistributionException("Error getting element " + element.getURI() + " from the workspace", e);
            }
            ArrayList<MediaPackageElement> distribution = new ArrayList<MediaPackageElement>();
            File destination = this.getDistributionFile(channelId, mediaPackage, element, streamingURL);
            try {
                Files.createDirectories(destination.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DistributionException("Unable to create " + destination.getParentFile(), (Throwable)e);
            }
            logger.info("Distributing {} to {}", (Object)element.getIdentifier(), (Object)destination);
            try {
                FileSupport.link((File)source, (File)destination, (boolean)true);
            }
            catch (IOException e) {
                throw new DistributionException("Unable to copy " + source + " to " + destination, (Throwable)e);
            }
            if (!this.supportedFormats.isEmpty() && this.isStreamingFormat(element)) {
                File smilFile = this.getSmilFile(element, mediaPackage, channelId);
                Document smilXml = this.getSmilDocument(smilFile);
                this.addElementToSmil(smilXml, channelId, mediaPackage, element);
                URI smilUri = this.getSmilUri(smilFile, streamingURL);
                if (smilFile.isFile()) {
                    logger.debug("Skipped adding streaming manifest {} to search index, as it already exists.", (Object)element);
                } else {
                    for (TrackImpl.StreamingProtocol protocol : this.supportedFormats) {
                        distribution.add((MediaPackageElement)this.createTrackforStreamingProtocol(element, smilUri, protocol));
                        logger.info("Distributed element {} in {} format to the Wowza Server", (Object)element, (Object)protocol);
                    }
                }
                this.saveSmilFile(smilFile, smilXml);
            }
            logger.info("Distributed file {} to Wowza Server", (Object)element);
            return distribution;
        }
        catch (URISyntaxException e) {
            throw new DistributionException("Error distributing " + element, (Throwable)e);
        }
    }

    private void setTransport(MediaPackageElement element, TrackImpl.StreamingProtocol protocol) {
        if (element instanceof TrackImpl) {
            ((TrackImpl)element).setTransport(protocol);
        }
    }

    private File getSmilFile(MediaPackageElement element, MediaPackage mediapackage, String channelId) {
        String orgId = this.securityService.getOrganization().getId();
        String smilFileName = channelId + "_" + mediapackage.getIdentifier() + "_" + element.getFlavor().getType() + ".smil";
        return this.distributionDirectory.toPath().resolve(Paths.get(orgId, smilFileName)).toFile();
    }

    private URI getSmilUri(File smilFile, URI streamingURL) {
        return UriBuilder.fromUri((URI)streamingURL).path("smil:" + smilFile.getName()).build(new Object[0]);
    }

    private URI getStreamingUri(URI smilUri, TrackImpl.StreamingProtocol protocol) throws URISyntaxException {
        String fileName;
        switch (protocol) {
            case HLS: {
                fileName = "playlist.m3u8";
                break;
            }
            case HDS: {
                fileName = "manifest.f4m";
                break;
            }
            case SMOOTH: {
                fileName = "Manifest";
                break;
            }
            case DASH: {
                fileName = "manifest_mpm4sav_mvlist.mpd";
                break;
            }
            default: {
                fileName = "";
            }
        }
        return new URI(UrlSupport.concat((String)smilUri.toString(), (String)fileName));
    }

    private boolean isStreamingFormat(MediaPackageElement element) {
        String uriPath = element.getURI().getPath();
        return uriPath.endsWith(".mp4") || uriPath.contains("mp4:");
    }

    private Document getSmilDocument(File smilFile) throws DistributionException {
        if (!smilFile.isFile()) {
            try {
                DocumentBuilder docBuilder = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element smil = doc.createElement("smil");
                doc.appendChild(smil);
                Element head = doc.createElement("head");
                smil.appendChild(head);
                Element body = doc.createElement("body");
                smil.appendChild(body);
                Element switchElement = doc.createElement("switch");
                body.appendChild(switchElement);
                return doc;
            }
            catch (ParserConfigurationException ex) {
                logger.error("Could not create XML file for {}.", (Object)smilFile);
                throw new DistributionException("Could not create XML file for " + smilFile);
            }
        }
        try {
            DocumentBuilder docBuilder = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder();
            Document doc = docBuilder.parse(smilFile);
            if (!"smil".equalsIgnoreCase(doc.getDocumentElement().getNodeName())) {
                logger.error("XML-File {} is not a SMIL file.", (Object)smilFile);
                throw new DistributionException(String.format("XML-File %s is not an SMIL file.", smilFile.getName()));
            }
            return doc;
        }
        catch (IOException e) {
            logger.error("Could not open SMIL file {}", (Object)smilFile);
            throw new DistributionException(String.format("Could not open SMIL file %s", smilFile));
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not parse SMIL file {}", (Object)smilFile);
            throw new DistributionException(String.format("Could not parse SMIL file %s", smilFile));
        }
        catch (SAXException e) {
            logger.error("Could not parse XML file {}", (Object)smilFile);
            throw new DistributionException(String.format("Could not parse XML file %s", smilFile));
        }
    }

    private void saveSmilFile(File smilFile, Document doc) throws DistributionException {
        try {
            Transformer transformer = XmlSafeParser.newTransformerFactory().newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult stream = new StreamResult(smilFile);
            transformer.transform(source, stream);
            logger.info("SMIL file for Wowza server saved at {}", (Object)smilFile);
        }
        catch (TransformerException ex) {
            logger.error("Could not write SMIL file {} for distribution", (Object)smilFile);
            throw new DistributionException(String.format("Could not write SMIL file %s for distribution", smilFile));
        }
    }

    private void addElementToSmil(Document doc, String channelId, MediaPackage mediapackage, MediaPackageElement element) throws DOMException, URISyntaxException {
        if (!(element instanceof TrackImpl)) {
            return;
        }
        TrackImpl track = (TrackImpl)element;
        NodeList switchElementsList = doc.getElementsByTagName("switch");
        Node switchElement = null;
        if (switchElementsList.getLength() > 0) {
            switchElement = switchElementsList.item(0);
        } else {
            if (doc.getElementsByTagName("head").getLength() < 1) {
                doc.appendChild(doc.createElement("head"));
            }
            if (doc.getElementsByTagName("body").getLength() < 1) {
                doc.appendChild(doc.createElement("body"));
            }
            switchElement = doc.createElement("switch");
            doc.getElementsByTagName("body").item(0).appendChild(switchElement);
        }
        Element video = doc.createElement("video");
        video.setAttribute("src", this.getDistributionName(channelId, mediapackage, element));
        float bitrate = 0.0f;
        for (AudioStream stream : track.getAudio()) {
            bitrate += stream.getBitRate().floatValue();
        }
        Integer width = null;
        Integer height = null;
        for (VideoStream stream : track.getVideo()) {
            bitrate += stream.getBitRate().floatValue();
            if ((stream.getFrameWidth() == null || stream.getFrameHeight() == null) && (width != null || height != null)) continue;
            width = stream.getFrameWidth();
            height = stream.getFrameHeight();
        }
        video.setAttribute(SMIL_ATTR_VIDEO_BITRATE, Integer.toString((int)bitrate));
        if (width != null) {
            video.setAttribute(SMIL_ATTR_VIDEO_WIDTH, Integer.toString(width));
        } else {
            logger.debug("Could not set video width in the SMIL file for element {} of mediapackage {}. The value was null", (Object)element.getIdentifier(), (Object)mediapackage.getIdentifier());
        }
        if (height != null) {
            video.setAttribute(SMIL_ATTR_VIDEO_HEIGHT, Integer.toString(height));
        } else {
            logger.debug("Could not set video height in the SMIL file for element {} of mediapackage {}. The value was null", (Object)element.getIdentifier(), (Object)mediapackage.getIdentifier());
        }
        NodeList currentVideos = switchElement.getChildNodes();
        for (int i = 0; i < currentVideos.getLength(); ++i) {
            Node current = currentVideos.item(i);
            if (!"video".equals(current.getNodeName())) continue;
            float currentBitrate = Float.parseFloat(current.getAttributes().getNamedItem(SMIL_ATTR_VIDEO_BITRATE).getTextContent());
            if (!(this.isSmilOrderDescending && currentBitrate < bitrate) && (this.isSmilOrderDescending || !(currentBitrate > bitrate))) continue;
            switchElement.insertBefore(video, current);
            return;
        }
        switchElement.appendChild(video);
    }

    private TrackImpl createTrackforStreamingProtocol(MediaPackageElement element, URI smilUri, TrackImpl.StreamingProtocol protocol) throws URISyntaxException {
        TrackImpl track = (TrackImpl)element.clone();
        switch (protocol) {
            case HLS: {
                track.setMimeType(MimeType.mimeType((String)"application", (String)"x-mpegURL"));
                break;
            }
            case HDS: {
                track.setMimeType(MimeType.mimeType((String)"application", (String)"f4m+xml"));
                break;
            }
            case SMOOTH: {
                track.setMimeType(MimeType.mimeType((String)"application", (String)"vnd.ms-sstr+xml"));
                break;
            }
            case DASH: {
                track.setMimeType(MimeType.mimeType((String)"application", (String)"dash+xml"));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Received invalid streaming protocol: '%s'", protocol));
            }
        }
        this.setTransport((MediaPackageElement)track, protocol);
        track.setURI(this.getStreamingUri(smilUri, protocol));
        track.referTo(element);
        track.setIdentifier(null);
        track.setAudio(null);
        track.setVideo(null);
        track.setChecksum(null);
        return track;
    }

    public Job retract(String channelId, MediaPackage mediapackage, String elementId) throws DistributionException {
        return this.retract(channelId, mediapackage, new HashSet<String>(Collections.singletonList(elementId)));
    }

    public Job retract(String channelId, MediaPackage mediaPackage, Set<String> elementIds) throws DistributionException {
        RequireUtil.notNull((Object)mediaPackage, (String)"mediaPackage");
        RequireUtil.notNull(elementIds, (String)"elementIds");
        RequireUtil.notNull((Object)channelId, (String)"channelId");
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.Retract.toString(), Arrays.asList(channelId, MediaPackageParser.getAsXml((MediaPackage)mediaPackage), gson.toJson(elementIds)), Float.valueOf(this.retractJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new DistributionException("Unable to create a job", (Throwable)e);
        }
    }

    public List<MediaPackageElement> distributeSync(String channelId, MediaPackage mediaPackage, String elementId) throws DistributionException {
        HashSet<String> elementIds = new HashSet<String>();
        elementIds.add(elementId);
        return this.distributeSync(channelId, mediaPackage, elementIds);
    }

    public List<MediaPackageElement> distributeSync(String channelId, MediaPackage mediaPackage, Set<String> elementIds) throws DistributionException {
        if (this.getStreamingURLforCurrentOrg() == null) {
            logger.warn(String.format("Trying to distribute to streaming from tenant where streaming url or port aren't set.", this.securityService.getOrganization().getId()));
            return Collections.emptyList();
        }
        if (this.distributionDirectory == null) {
            logger.warn("Streaming distribution directory isn't set (org.opencastproject.streaming.directory)");
            return Collections.emptyList();
        }
        URI streamingURL = this.getStreamingURLforCurrentOrg();
        return this.distributeElements(channelId, mediaPackage, elementIds, streamingURL);
    }

    public List<MediaPackageElement> retractSync(String channelId, MediaPackage mediaPackage, String elementId) throws DistributionException {
        HashSet<String> elementIds = new HashSet<String>();
        elementIds.add(elementId);
        return this.retractSync(channelId, mediaPackage, elementIds);
    }

    public List<MediaPackageElement> retractSync(String channelId, MediaPackage mediaPackage, Set<String> elementIds) throws DistributionException {
        if (this.getStreamingURLforCurrentOrg() == null) {
            logger.warn(String.format("Trying to retract from streaming from tenant where streaming url or port aren't set.", this.securityService.getOrganization().getId()));
            return Collections.emptyList();
        }
        if (this.distributionDirectory == null) {
            logger.warn("Streaming distribution directory isn't set (org.opencastproject.streaming.directory)");
            return Collections.emptyList();
        }
        URI streamingURL = this.getStreamingURLforCurrentOrg();
        return this.retractElements(channelId, mediaPackage, elementIds, streamingURL);
    }

    private List<MediaPackageElement> retractElements(String channelId, MediaPackage mediaPackage, Set<String> elementIds, URI streamingURL) throws DistributionException {
        RequireUtil.notNull((Object)mediaPackage, (String)"mediaPackage");
        RequireUtil.notNull(elementIds, (String)"elementIds");
        RequireUtil.notNull((Object)channelId, (String)"channelId");
        ArrayList<MediaPackageElement> retractedElements = new ArrayList<MediaPackageElement>();
        for (MediaPackageElement element : this.getElements(mediaPackage, elementIds)) {
            retractedElements.addAll(this.retractElement(channelId, mediaPackage, element, streamingURL));
        }
        return retractedElements;
    }

    private List<MediaPackageElement> retractElement(String channelId, MediaPackage mediaPackage, MediaPackageElement element, URI streamingUrl) throws DistributionException {
        logger.debug("Retracting element {} with URI {}", (Object)element.getIdentifier(), (Object)element.getURI());
        if (!(element instanceof TrackImpl)) {
            return Collections.emptyList();
        }
        File elementFile = this.getDistributionFile(channelId, mediaPackage, element, streamingUrl);
        File smilFile = this.getSmilFile(element, mediaPackage, channelId);
        logger.debug("Deleting file {}", (Object)elementFile);
        if (elementFile == null || !elementFile.exists()) {
            logger.warn("{} does not exist but was to be deleted", (Object)elementFile);
            return Collections.singletonList(element);
        }
        if (elementFile.equals(smilFile)) {
            Document smilXml = this.getSmilDocument(smilFile);
            NodeList videoList = smilXml.getElementsByTagName("video");
            for (int i = 0; i < videoList.getLength(); ++i) {
                if (!(videoList.item(i) instanceof Element)) continue;
                Object smilPathStr = ((Element)videoList.item(i)).getAttribute("src");
                if (((String)smilPathStr).contains("mp4:")) {
                    smilPathStr = ((String)smilPathStr).replace("mp4:", "");
                }
                if (!((String)smilPathStr).endsWith(".mp4")) {
                    smilPathStr = (String)smilPathStr + ".mp4";
                }
                this.deleteElementFile(smilFile.toPath().resolveSibling((String)smilPathStr).toFile());
            }
            if (smilFile.isFile() && !smilFile.delete()) {
                logger.warn("The SMIL file {} could not be successfully deleted.", (Object)smilFile);
            }
        } else {
            this.deleteElementFile(elementFile);
        }
        logger.info("Finished retracting element {} of media package {}", (Object)element, (Object)mediaPackage);
        return Collections.singletonList(element);
    }

    private void deleteElementFile(File elementFile) {
        File mediapackageDir;
        File elementDir;
        if (elementFile.exists()) {
            if (!elementFile.delete()) {
                logger.warn("Could not properly delete element file: {}", (Object)elementFile);
            }
        } else {
            logger.warn("Tried to delete non-existent element file. Perhaps was already deleted?: {}", (Object)elementFile);
        }
        if ((elementDir = elementFile.getParentFile()) != null && elementDir.exists() && elementDir.list() != null) {
            if (elementDir.list().length == 0) {
                if (!elementDir.delete()) {
                    logger.warn("Could not properly delete element directory: {}", (Object)elementDir);
                }
            } else {
                logger.warn("Element directory was not empty after deleting element. Skipping deletion: {}", (Object)elementDir);
            }
        } else {
            logger.warn("Element directory did not exist when trying to delete it: {}", (Object)elementDir);
        }
        if ((mediapackageDir = elementDir.getParentFile()) != null && mediapackageDir.exists()) {
            if (mediapackageDir.list().length == 0) {
                if (!mediapackageDir.delete()) {
                    logger.warn("Could not properly delete mediapackage directory: {}", (Object)mediapackageDir);
                }
            } else {
                logger.debug("Mediapackage directory was not empty after deleting element. Skipping deletion: {}", (Object)mediapackageDir);
            }
        } else {
            logger.warn("Mediapackage directory did not exist when trying to delete it: {}", (Object)mediapackageDir);
        }
    }

    private File getDistributionFile(String channelId, MediaPackage mediapackage, MediaPackageElement element, URI streamingURL) {
        String orgId = this.securityService.getOrganization().getId();
        Path distributionPath = this.distributionDirectory.toPath().resolve(orgId);
        URI elementUri = element.getURI();
        URI relativeUri = streamingURL.relativize(elementUri);
        if (relativeUri != elementUri) {
            String[] uriPathParts;
            Object uriPath = relativeUri.getPath();
            uriPath = ((String)uriPath).substring(0, ((String)uriPath).lastIndexOf(47));
            if (!((String)(uriPath = ((String)uriPath).replace("smil:", ""))).endsWith(".smil")) {
                uriPath = (String)uriPath + ".smil";
            }
            if ((uriPathParts = ((String)uriPath).split("/")).length > 1) {
                logger.warn("Malformed URI path \"{}\". The SMIL files must be at the streaming application's root. Trying anyway...", uriPath);
            }
            return distributionPath.resolve((String)uriPath).toFile();
        }
        return new File(this.getElementDirectory(channelId, mediapackage, element.getIdentifier()), FilenameUtils.getName((String)elementUri.getPath()));
    }

    private File getMediaPackageDirectory(String channelId, MediaPackage mediaPackage) {
        String orgId = this.securityService.getOrganization().getId();
        return this.distributionDirectory.toPath().resolve(Paths.get(orgId, channelId, mediaPackage.getIdentifier().toString())).toFile();
    }

    private File getElementDirectory(String channelId, MediaPackage mediaPackage, String elementId) {
        return new File(this.getMediaPackageDirectory(channelId, mediaPackage), elementId);
    }

    private String getDistributionName(String channelId, MediaPackage mp, MediaPackageElement element) {
        String elementId = element.getIdentifier();
        String fileName = FilenameUtils.getBaseName((String)element.getURI().toString());
        Object tag = FilenameUtils.getExtension((String)element.getURI().toString()) + ":";
        if ("flv:".equals(tag)) {
            tag = "";
        }
        return (String)tag + channelId + "/" + mp.getIdentifier().toString() + "/" + elementId + "/" + fileName;
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            List<MediaPackageElement> elements;
            op = Operation.valueOf(operation);
            String channelId = (String)arguments.get(0);
            MediaPackage mediapackage = MediaPackageParser.getFromXml((String)((String)arguments.get(1)));
            Set elementIds = (Set)gson.fromJson((String)arguments.get(2), new TypeToken<Set<String>>(){}.getType());
            URI streamingUrl = this.getStreamingURLforCurrentOrg();
            if (streamingUrl == null) {
                logger.warn(String.format("Trying to distribute to or retract from streaming from tenant where streaming url or port aren't set.", this.securityService.getOrganization().getId()));
                return null;
            }
            if (this.distributionDirectory == null) {
                logger.warn("Streaming distribution directory isn't set (org.opencastproject.streaming.directory)");
                return null;
            }
            switch (op) {
                case Distribute: {
                    elements = this.distributeElements(channelId, mediapackage, elementIds, streamingUrl);
                    break;
                }
                case Retract: {
                    elements = this.retractElements(channelId, mediapackage, elementIds, streamingUrl);
                    break;
                }
                default: {
                    throw new ServiceRegistryException("This service can't handle operations of type '" + op + "'");
                }
            }
            if (!elements.isEmpty()) {
                return MediaPackageElementParser.getArrayAsXml(elements);
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + op + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + op + "'", (Throwable)e);
        }
    }

    private Set<MediaPackageElement> getElements(MediaPackage mediapackage, Set<String> elementIds) throws IllegalStateException {
        HashSet<MediaPackageElement> elements = new HashSet<MediaPackageElement>();
        for (String elementId : elementIds) {
            MediaPackageElement element = mediapackage.getElementById(elementId);
            if (element != null) {
                elements.add(element);
                continue;
            }
            logger.debug("No element " + elementId + " found in media package " + mediapackage.getIdentifier());
        }
        return elements;
    }

    public File getDistributionDirectory() {
        return this.distributionDirectory;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        super.setWorkspace(workspace);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        super.setSecurityService(securityService);
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        super.setUserDirectoryService(userDirectoryService);
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        super.setOrganizationDirectoryService(organizationDirectoryService);
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add(DEFAULT_SCHEME);
        temp.add("https");
        validSchemes = Collections.unmodifiableSet(temp);
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put(DEFAULT_SCHEME, 80);
        tempMap.put("https", 443);
        defaultProtocolPorts = Collections.unmodifiableMap(tempMap);
        logger = LoggerFactory.getLogger(WowzaStreamingDistributionService.class);
        gson = new Gson();
    }

    private static enum Operation {
        Distribute,
        Retract;

    }
}

