/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.distribution.download.remote;

import com.google.gson.Gson;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DistributionService;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.HttpUtil;
import org.opencastproject.util.JobUtil;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Options;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DistributionService.class, DownloadDistributionService.class}, property={"service.description=Distribution (Download) Remote Service Proxy", "distribution.channel=download"})
public class DownloadDistributionServiceRemoteImpl
extends RemoteBase
implements DistributionService,
DownloadDistributionService {
    private static final Logger logger = LoggerFactory.getLogger(DownloadDistributionServiceRemoteImpl.class);
    private static final String PARAM_CHANNEL_ID = "channelId";
    private static final String PARAM_MEDIAPACKAGE = "mediapackage";
    private static final String PARAM_ELEMENT_ID = "elementId";
    private static final String PARAM_CHECK_AVAILABILITY = "checkAvailability";
    private static final String PARAM_PRESERVE_REFERENCE = "preserveReference";
    private final Gson gson = new Gson();
    private String distributionChannel;

    public DownloadDistributionServiceRemoteImpl() {
        super("waiting for activation");
    }

    public String getDistributionType() {
        return this.distributionChannel;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.distributionChannel = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)"distribution.channel");
        this.serviceType = "org.opencastproject.distribution." + this.distributionChannel;
    }

    public Job distribute(String channelId, MediaPackage mediaPackage, String elementId) throws DistributionException {
        return this.distribute(channelId, mediaPackage, elementId, true);
    }

    public Job distribute(String channelId, MediaPackage mediaPackage, String elementId, boolean checkAvailability) throws DistributionException {
        HashSet<String> elementIds = new HashSet<String>();
        elementIds.add(elementId);
        return this.distribute(channelId, mediaPackage, elementIds, checkAvailability);
    }

    public Job distribute(String channelId, MediaPackage mediaPackage, Set<String> elementIds, boolean checkAvailability) throws DistributionException {
        return this.distribute(channelId, mediaPackage, elementIds, checkAvailability, false);
    }

    public Job distribute(String channelId, MediaPackage mediaPackage, Set<String> elementIds, boolean checkAvailability, boolean preserveReference) throws DistributionException {
        logger.info("Distributing {} elements to {}@{}", new Object[]{elementIds.size(), channelId, this.distributionChannel});
        HttpPost req = HttpUtil.post((NameValuePair[])new NameValuePair[]{HttpUtil.param((String)PARAM_CHANNEL_ID, (String)channelId), HttpUtil.param((String)PARAM_MEDIAPACKAGE, (String)MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), HttpUtil.param((String)PARAM_ELEMENT_ID, (String)this.gson.toJson(elementIds)), HttpUtil.param((String)PARAM_CHECK_AVAILABILITY, (String)Boolean.toString(checkAvailability)), HttpUtil.param((String)PARAM_PRESERVE_REFERENCE, (String)Boolean.toString(preserveReference))});
        Iterator iterator = Options.join((Option)this.runRequest((HttpRequestBase)req, JobUtil.jobFromHttpResponse)).iterator();
        if (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            return job;
        }
        throw new DistributionException(String.format("Unable to distribute '%s' elements of mediapackage '%s' using a remote destribution service proxy", elementIds.size(), mediaPackage.getIdentifier().toString()));
    }

    public Job retract(String channelId, MediaPackage mediaPackage, String elementId) throws DistributionException {
        HashSet<String> elementIds = new HashSet<String>();
        elementIds.add(elementId);
        return this.retract(channelId, mediaPackage, elementIds);
    }

    public Job retract(String channelId, MediaPackage mediaPackage, Set<String> elementIds) throws DistributionException {
        logger.info("Retracting {} elements from {}@{}", new Object[]{elementIds.size(), channelId, this.distributionChannel});
        HttpPost req = HttpUtil.post((String)"/retract", (NameValuePair[])new NameValuePair[]{HttpUtil.param((String)PARAM_MEDIAPACKAGE, (String)MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), HttpUtil.param((String)PARAM_ELEMENT_ID, (String)this.gson.toJson(elementIds)), HttpUtil.param((String)PARAM_CHANNEL_ID, (String)channelId)});
        Iterator iterator = Options.join((Option)this.runRequest((HttpRequestBase)req, JobUtil.jobFromHttpResponse)).iterator();
        if (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            return job;
        }
        throw new DistributionException(String.format("Unable to retract '%s' elements of mediapackage '%s' using a remote destribution service proxy", elementIds.size(), mediaPackage.getIdentifier().toString()));
    }

    public List<MediaPackageElement> distributeSync(String channelId, MediaPackage mediapackage, String elementId) throws DistributionException, MediaPackageException {
        HashSet<String> elementIds = new HashSet<String>();
        elementIds.add(elementId);
        return this.distributeSync(channelId, mediapackage, elementIds, true);
    }

    public List<MediaPackageElement> distributeSync(String channelId, MediaPackage mediapackage, Set<String> elementIds, boolean checkAvailability) throws DistributionException {
        logger.info("Distributing {} elements to {}@{}", new Object[]{elementIds.size(), channelId, this.distributionChannel});
        HttpPost req = HttpUtil.post((String)"/distributesync", (NameValuePair[])new NameValuePair[]{HttpUtil.param((String)PARAM_CHANNEL_ID, (String)channelId), HttpUtil.param((String)PARAM_MEDIAPACKAGE, (String)MediaPackageParser.getAsXml((MediaPackage)mediapackage)), HttpUtil.param((String)PARAM_ELEMENT_ID, (String)this.gson.toJson(elementIds)), HttpUtil.param((String)PARAM_CHECK_AVAILABILITY, (String)Boolean.toString(checkAvailability))});
        Iterator iterator = Options.join((Option)this.runRequest((HttpRequestBase)req, elementsFromHttpResponse)).iterator();
        if (iterator.hasNext()) {
            List elements = (List)iterator.next();
            return elements;
        }
        throw new DistributionException(String.format("Unable to distribute '%s' elements of mediapackage '%s' using a remote destribution service proxy", elementIds.size(), mediapackage.getIdentifier().toString()));
    }

    public List<MediaPackageElement> retractSync(String channelId, MediaPackage mediaPackage, String elementId) throws DistributionException {
        HashSet<String> elementIds = new HashSet<String>();
        elementIds.add(elementId);
        return this.retractSync(channelId, mediaPackage, elementIds);
    }

    public List<MediaPackageElement> retractSync(String channelId, MediaPackage mediaPackage, Set<String> elementIds) throws DistributionException {
        logger.info("Retracting {} elements from {}@{}", new Object[]{elementIds.size(), channelId, this.distributionChannel});
        HttpPost req = HttpUtil.post((String)"/retractsync", (NameValuePair[])new NameValuePair[]{HttpUtil.param((String)PARAM_MEDIAPACKAGE, (String)MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), HttpUtil.param((String)PARAM_ELEMENT_ID, (String)this.gson.toJson(elementIds)), HttpUtil.param((String)PARAM_CHANNEL_ID, (String)channelId)});
        Iterator iterator = Options.join((Option)this.runRequest((HttpRequestBase)req, elementsFromHttpResponse)).iterator();
        if (iterator.hasNext()) {
            List elements = (List)iterator.next();
            return elements;
        }
        throw new DistributionException(String.format("Unable to retract '%s' elements of mediapackage '%s' using a remote destribution service proxy", elementIds.size(), mediaPackage.getIdentifier().toString()));
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

