/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static final int DEFAULT_MAX_IDLE_TIME = 3600;
    private String rootDir;
    private ServiceRegistration<?> datasourceRegistration;
    private ComboPooledDataSource pooledDataSource;

    public void start(BundleContext bundleContext) throws Exception {
        this.rootDir = bundleContext.getProperty("org.opencastproject.storage.dir") + File.separator + "db";
        String jdbcDriver = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.driver"), "org.h2.Driver");
        String jdbcUrl = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.url"), "jdbc:h2:" + this.rootDir);
        if ("org.h2.Driver".equals(jdbcDriver)) {
            logger.warn("\n######################################################\n#                                                    #\n# WARNING: Opencast is using an H2 database.         #\n#          Never do this in production.              #\n#                                                    #\n#          For more information about database       #\n#          configuration, see:                       #\n#                                                    #\n#          https://docs.opencast.org                 #\n#                                                    #\n######################################################");
        }
        String jdbcUser = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.user"), "sa");
        String jdbcPass = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pass"), "sa");
        Integer maxPoolSize = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.max.size"));
        Integer minPoolSize = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.min.size"));
        Integer acquireIncrement = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.acquire.increment"));
        Integer maxStatements = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.max.statements"));
        Integer loginTimeout = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.login.timeout"));
        Integer maxIdleTime = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.max.idle.time"));
        Integer maxConnectionAge = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.max.connection.age"));
        Boolean testConnectionOnCheckin = this.getConfigBooleanProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.test.connection.on.checkin"));
        Boolean testConnectionOnCheckout = this.getConfigBooleanProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.test.connection.on.checkout"));
        Integer idleConnectionTestPeriod = this.getConfigProperty(bundleContext.getProperty("org.opencastproject.db.jdbc.pool.idle.connection.test.period"));
        this.pooledDataSource = new ComboPooledDataSource();
        this.pooledDataSource.setDriverClass(jdbcDriver);
        this.pooledDataSource.setJdbcUrl(jdbcUrl);
        this.pooledDataSource.setUser(jdbcUser);
        this.pooledDataSource.setPassword(jdbcPass);
        if (minPoolSize != null) {
            this.pooledDataSource.setMinPoolSize(minPoolSize);
            if (this.pooledDataSource.getInitialPoolSize() < minPoolSize) {
                this.pooledDataSource.setInitialPoolSize(minPoolSize);
            }
        }
        if (maxPoolSize != null) {
            this.pooledDataSource.setMaxPoolSize(maxPoolSize);
            if (this.pooledDataSource.getInitialPoolSize() > maxPoolSize) {
                this.pooledDataSource.setInitialPoolSize(maxPoolSize);
            }
        }
        if (acquireIncrement != null) {
            this.pooledDataSource.setAcquireIncrement(acquireIncrement);
        }
        if (maxStatements != null) {
            this.pooledDataSource.setMaxStatements(maxStatements);
        }
        if (loginTimeout != null) {
            this.pooledDataSource.setLoginTimeout(loginTimeout);
        }
        if (maxIdleTime != null) {
            this.pooledDataSource.setMaxIdleTime(maxIdleTime);
        } else if (this.pooledDataSource.getMaxIdleTime() == 0) {
            logger.debug("Setting database connection pool max.idle.time to default of {}", (Object)3600);
            this.pooledDataSource.setMaxIdleTime(3600);
        }
        if (maxConnectionAge != null) {
            this.pooledDataSource.setMaxConnectionAge(maxConnectionAge);
        }
        if (testConnectionOnCheckin != null) {
            this.pooledDataSource.setTestConnectionOnCheckin(testConnectionOnCheckin);
        }
        if (testConnectionOnCheckout != null) {
            this.pooledDataSource.setTestConnectionOnCheckout(testConnectionOnCheckout);
        }
        if (idleConnectionTestPeriod != null) {
            this.pooledDataSource.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
        }
        try (Connection connection = null;){
            logger.info("Testing connectivity to database at {}", (Object)jdbcUrl);
            connection = this.pooledDataSource.getConnection();
            Hashtable<String, String> dsProps = new Hashtable<String, String>();
            dsProps.put("osgi.jndi.service.name", "jdbc/opencast");
            this.datasourceRegistration = bundleContext.registerService(DataSource.class.getName(), (Object)this.pooledDataSource, dsProps);
        }
        logger.info("Database connection pool established at {}", (Object)jdbcUrl);
        logger.info("Database connection pool parameters: max.size={}, min.size={}, max.idle.time={}", new Object[]{this.pooledDataSource.getMaxPoolSize(), this.pooledDataSource.getMinPoolSize(), this.pooledDataSource.getMaxIdleTime()});
        Statement statement = this.pooledDataSource.getConnection().createStatement();
        long random = Math.round(Math.random() * 1000000.0);
        String tableName = "oc_temp_" + random;
        try {
            statement.executeUpdate("CREATE TABLE " + tableName + " ( id BIGINT NOT NULL, test BIGINT, PRIMARY KEY (id) );");
            this.runUpdate(statement, "INSERT INTO " + tableName + " VALUES (" + random + ", 0);");
            this.runUpdate(statement, "UPDATE " + tableName + " SET test = " + random + ";");
            ResultSet rs = statement.executeQuery("SELECT * FROM " + tableName + ";");
            while (rs.next()) {
                long id = rs.getLong("id");
                long test = rs.getLong("test");
                if (id == random && test == random) continue;
                throw new RuntimeException("Unable to verify updating a table functions correctly");
            }
            this.runUpdate(statement, "DELETE FROM " + tableName + " WHERE id = " + random + ";");
            logger.info("Database credentials passed basic tests!");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to verify SQL credentials have required permissions!", e);
        }
        finally {
            try {
                statement.executeUpdate("DROP TABLE " + tableName + ";");
            }
            catch (Exception e) {
                logger.warn("Unable to delete temp table {}, please remove this yourself!", (Object)tableName, (Object)e);
            }
        }
    }

    private void runUpdate(Statement statement, String sql) throws RuntimeException, SQLException {
        int affected = statement.executeUpdate(sql);
        if (affected != 1) {
            throw new RuntimeException("Unable to update on a testing table, check that your database user has the right permissions!");
        }
    }

    public void stop(BundleContext context) throws Exception {
        logger.info("Shutting down database");
        if (this.datasourceRegistration != null) {
            this.datasourceRegistration.unregister();
        }
        logger.info("Shutting down connection pool");
        DataSources.destroy(this.pooledDataSource);
    }

    private String getConfigProperty(String config, String defaultValue) {
        return config == null ? defaultValue : config;
    }

    private Integer getConfigProperty(String config) {
        return config == null ? null : Integer.valueOf(Integer.parseInt(config));
    }

    private Boolean getConfigBooleanProperty(String config) {
        return config == null ? null : Boolean.valueOf(Boolean.parseBoolean(config));
    }
}

