/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.coverimage.remote;

import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.coverimage.CoverImageException;
import org.opencastproject.coverimage.CoverImageService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CoverImageService.class}, property={"service.description=Cover Image Remote Service Proxy"})
public class CoverImageServiceRemoteImpl
extends RemoteBase
implements CoverImageService {
    private static final Logger logger = LoggerFactory.getLogger(CoverImageServiceRemoteImpl.class);

    public CoverImageServiceRemoteImpl() {
        super("org.opencastproject.coverimage");
    }

    public Job generateCoverImage(String xml, String xsl, String width, String height, String posterImageUri, String targetFlavor) throws CoverImageException {
        HttpPost post = new HttpPost("/generate");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("xml", xml));
            params.add(new BasicNameValuePair("xsl", xsl));
            params.add(new BasicNameValuePair("width", width));
            params.add(new BasicNameValuePair("height", height));
            params.add(new BasicNameValuePair("posterimage", posterImageUri));
            params.add(new BasicNameValuePair("targetflavor", targetFlavor));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new CoverImageException("Unable to assemble a remote cover image request", (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                Job r = JobParser.parseJob((String)content);
                logger.info("Cover image generation job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new CoverImageException("Unable to generate cover image using a remote generation service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new CoverImageException("Unable to generate cover image using a remote generation service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

