/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationTagUtil;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Prepare Media Workflow Operation Handler", "workflow.operation=prepare-av"})
public class PrepareAVWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PrepareAVWorkflowOperationHandler.class);
    private static final String QUESTION_MARK = "?";
    public static final String PREPARE_AV_PROFILE = "av.copy";
    public static final String MUX_AV_PROFILE = "mux-av.copy";
    public static final String PREPARE_AONLY_PROFILE = "audio-only.copy";
    public static final String PREPARE_VONLY_PROFILE = "video-only.copy";
    public static final String OPT_REWRITE = "rewrite";
    public static final String OPT_AUDIO_MUXING_SOURCE_FLAVORS = "audio-muxing-source-flavors";
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        try {
            logger.debug("Running a/v muxing workflow operation on workflow {}", (Object)workflowInstance.getId());
            return this.mux(workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult mux(WorkflowInstance wi) throws EncoderException, WorkflowOperationException, NotFoundException, MediaPackageException, IOException {
        EncodingProfile profile;
        MediaPackage src = wi.getMediaPackage();
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = wi.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        List targetTrackTags = tagsAndFlavors.getTargetTags();
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        String muxEncodingProfileName = StringUtils.trimToNull((String)operation.getConfiguration("mux-encoding-profile"));
        String audioVideoEncodingProfileName = StringUtils.trimToNull((String)operation.getConfiguration("audio-video-encoding-profile"));
        String videoOnlyEncodingProfileName = StringUtils.trimToNull((String)operation.getConfiguration("video-encoding-profile"));
        String audioOnlyEncodingProfileName = StringUtils.trimToNull((String)operation.getConfiguration("audio-encoding-profile"));
        WorkflowOperationTagUtil.TagDiff tagDiff = WorkflowOperationTagUtil.createTagDiff((List)targetTrackTags);
        boolean rewrite = true;
        if (StringUtils.trimToNull((String)operation.getConfiguration(OPT_REWRITE)) != null) {
            rewrite = Boolean.parseBoolean(operation.getConfiguration(OPT_REWRITE));
        }
        String audioMuxingSourceFlavors = StringUtils.trimToNull((String)operation.getConfiguration(OPT_AUDIO_MUXING_SOURCE_FLAVORS));
        TrackSelector trackSelector = new TrackSelector();
        trackSelector.addFlavor(sourceFlavor);
        Collection tracks = trackSelector.select(mediaPackage, false);
        Track audioTrack = null;
        Track videoTrack = null;
        switch (tracks.size()) {
            case 0: {
                logger.info("No audio/video tracks with flavor '{}' found to prepare", (Object)sourceFlavor);
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            case 1: {
                videoTrack = (Track)tracks.iterator().next();
                if (!videoTrack.hasAudio() && videoTrack.hasVideo() && audioMuxingSourceFlavors != null) {
                    audioTrack = this.findAudioTrack(videoTrack, mediaPackage, audioMuxingSourceFlavors);
                    break;
                }
                audioTrack = videoTrack;
                break;
            }
            case 2: {
                for (Track track : tracks) {
                    if (track.hasAudio() && !track.hasVideo()) {
                        audioTrack = track;
                        continue;
                    }
                    if (!track.hasAudio() && track.hasVideo()) {
                        videoTrack = track;
                        continue;
                    }
                    throw new WorkflowOperationException("Multiple tracks with competing audio/video streams and flavor '" + sourceFlavor + "' found");
                }
                break;
            }
            default: {
                logger.error("More than two tracks with flavor {} found. No idea what we should be doing", (Object)sourceFlavor);
                throw new WorkflowOperationException("More than two tracks with flavor '" + sourceFlavor + "' found");
            }
        }
        Job job = null;
        Track composedTrack = null;
        if (audioTrack == null && videoTrack != null) {
            if (rewrite) {
                logger.info("Encoding video only track {} to prepared version", (Object)videoTrack);
                if (videoOnlyEncodingProfileName == null) {
                    videoOnlyEncodingProfileName = PREPARE_VONLY_PROFILE;
                }
                if ((profile = this.composerService.getProfile(videoOnlyEncodingProfileName)) == null) {
                    throw new IllegalStateException("Encoding profile '" + videoOnlyEncodingProfileName + "' was not found");
                }
                composedTrack = this.prepare(videoTrack, mediaPackage, videoOnlyEncodingProfileName);
            } else {
                composedTrack = (Track)videoTrack.clone();
                composedTrack.setIdentifier(null);
                mediaPackage.add(composedTrack);
            }
        } else if (videoTrack == null && audioTrack != null) {
            if (rewrite) {
                logger.info("Encoding audio only track {} to prepared version", (Object)audioTrack);
                if (audioOnlyEncodingProfileName == null) {
                    audioOnlyEncodingProfileName = PREPARE_AONLY_PROFILE;
                }
                if ((profile = this.composerService.getProfile(audioOnlyEncodingProfileName)) == null) {
                    throw new IllegalStateException("Encoding profile '" + audioOnlyEncodingProfileName + "' was not found");
                }
                composedTrack = this.prepare(audioTrack, mediaPackage, audioOnlyEncodingProfileName);
            } else {
                composedTrack = (Track)audioTrack.clone();
                composedTrack.setIdentifier(null);
                mediaPackage.add(composedTrack);
            }
        } else if (audioTrack == videoTrack) {
            if (rewrite) {
                logger.info("Encoding audiovisual track {} to prepared version", (Object)videoTrack);
                if (audioVideoEncodingProfileName == null) {
                    audioVideoEncodingProfileName = PREPARE_AV_PROFILE;
                }
                if ((profile = this.composerService.getProfile(audioVideoEncodingProfileName)) == null) {
                    throw new IllegalStateException("Encoding profile '" + audioVideoEncodingProfileName + "' was not found");
                }
                composedTrack = this.prepare(videoTrack, mediaPackage, audioVideoEncodingProfileName);
            } else {
                composedTrack = (Track)videoTrack.clone();
                composedTrack.setIdentifier(null);
                mediaPackage.add(composedTrack);
            }
        } else {
            logger.info("Muxing audio and video only track {} to prepared version", (Object)videoTrack);
            if (audioTrack.hasVideo()) {
                logger.info("Stripping video from track {}", (Object)audioTrack);
                audioTrack = this.prepare(audioTrack, null, PREPARE_AONLY_PROFILE);
            }
            if (muxEncodingProfileName == null) {
                muxEncodingProfileName = MUX_AV_PROFILE;
            }
            if ((profile = this.composerService.getProfile(muxEncodingProfileName)) == null) {
                throw new IllegalStateException("Encoding profile '" + muxEncodingProfileName + "' was not found");
            }
            job = this.composerService.mux(videoTrack, audioTrack, profile.getIdentifier());
            if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
                throw new WorkflowOperationException("Muxing video track " + videoTrack + " and audio track " + audioTrack + " failed");
            }
            composedTrack = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
            mediaPackage.add(composedTrack);
            String fileName = this.getFileNameFromElements((MediaPackageElement)videoTrack, (MediaPackageElement)composedTrack);
            composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
        }
        long timeInQueue = 0L;
        if (job != null) {
            timeInQueue = job.getQueueTime();
        }
        composedTrack.setFlavor(targetFlavor);
        logger.debug("Composed track has flavor '{}'", (Object)composedTrack.getFlavor());
        WorkflowOperationTagUtil.applyTagDiff((WorkflowOperationTagUtil.TagDiff)tagDiff, (Track)composedTrack);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, timeInQueue);
    }

    private Track prepare(Track videoTrack, MediaPackage mediaPackage, String encodingProfile) throws WorkflowOperationException, NotFoundException, IOException, EncoderException, MediaPackageException {
        Track composedTrack = null;
        logger.info("Encoding video only track {} to prepared version", (Object)videoTrack);
        Job job = this.composerService.encode(videoTrack, encodingProfile);
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException("Rewriting container for video track " + videoTrack + " failed");
        }
        composedTrack = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
        if (mediaPackage != null) {
            mediaPackage.add(composedTrack);
            String fileName = this.getFileNameFromElements((MediaPackageElement)videoTrack, (MediaPackageElement)composedTrack);
            composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
        }
        return composedTrack;
    }

    private Track findAudioTrack(Track videoTrack, MediaPackage mediaPackage, String audioMuxingSourceFlavors) {
        if (audioMuxingSourceFlavors != null) {
            for (String flavorStr : audioMuxingSourceFlavors.split("[\\s,]")) {
                if (flavorStr.isEmpty()) continue;
                MediaPackageElementFlavor flavor = null;
                try {
                    flavor = MediaPackageElementFlavor.parseFlavor((String)flavorStr);
                }
                catch (IllegalArgumentException e) {
                    logger.error("The parameter {} contains an invalid flavor: {}", (Object)OPT_AUDIO_MUXING_SOURCE_FLAVORS, (Object)flavorStr);
                    throw e;
                }
                String type = QUESTION_MARK.equals(flavor.getType()) ? videoTrack.getFlavor().getType() : flavor.getType();
                String subtype = QUESTION_MARK.equals(flavor.getSubtype()) ? videoTrack.getFlavor().getSubtype() : flavor.getSubtype();
                flavor = new MediaPackageElementFlavor(type, subtype);
                for (Track track : mediaPackage.getTracks(flavor)) {
                    if (!track.hasAudio()) continue;
                    logger.info("Audio muxing found audio source {} with flavor {}", (Object)track, (Object)track.getFlavor());
                    return track;
                }
            }
        }
        return null;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

