/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessInformationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AccessInformationUtil.class);

    private AccessInformationUtil() {
    }

    public static JSONObject serializeManagedAcl(ManagedAcl managedAcl) {
        if (managedAcl == null) {
            throw new IllegalArgumentException("The parameter managedAcl must not be null");
        }
        JSONObject systemAclJson = new JSONObject();
        try {
            systemAclJson.put("id", (Object)managedAcl.getId());
            systemAclJson.put("name", (Object)managedAcl.getName());
        }
        catch (JSONException e) {
            logger.error("An unexpected error occured:", (Throwable)e);
        }
        return systemAclJson;
    }

    public static JSONObject serializePrivilegesByRole(AccessControlList acl) {
        if (acl == null) {
            throw new IllegalArgumentException("The parameter trans must not be null");
        }
        HashMap<String, JSONObject> privilegesByRole = new HashMap<String, JSONObject>();
        for (AccessControlEntry entry : acl.getEntries()) {
            JSONObject rolePrivileges;
            if (privilegesByRole.containsKey(entry.getRole())) {
                rolePrivileges = (JSONObject)privilegesByRole.get(entry.getRole());
            } else {
                rolePrivileges = new JSONObject();
                privilegesByRole.put(entry.getRole(), rolePrivileges);
            }
            try {
                rolePrivileges.put(entry.getAction(), entry.isAllow());
            }
            catch (JSONException e) {
                logger.error("An unexpected error occured:", (Throwable)e);
            }
        }
        JSONObject privilegesJson = new JSONObject();
        for (Map.Entry privilege : privilegesByRole.entrySet()) {
            try {
                privilegesJson.put((String)privilege.getKey(), privilege.getValue());
            }
            catch (JSONException e) {
                logger.error("An unexpected error occured:", (Throwable)e);
            }
        }
        return privilegesJson;
    }

    public static Option<ManagedAcl> matchAcls(List<ManagedAcl> acls, final AccessControlList acl) {
        return Monadics.mlist(acls).find((Function)new Predicate<ManagedAcl>(){

            public Boolean apply(ManagedAcl macl) {
                return AccessControlUtil.equals((AccessControlList)acl, (AccessControlList)macl.getAcl());
            }
        });
    }

    public static Option<ManagedAcl> matchAclsLenient(List<ManagedAcl> acls, AccessControlList acl, List<String> ignorePrefixes) {
        if (ignorePrefixes == null || ignorePrefixes.size() <= 0) {
            return AccessInformationUtil.matchAcls(acls, acl);
        }
        for (ManagedAcl managedAcl : acls) {
            AccessControlList aclCopy = acl;
            for (String prefix : ignorePrefixes) {
                List managedEntries = managedAcl.getAcl().getEntries();
                Optional<AccessControlEntry> managedEntry = managedEntries.stream().filter(s -> s.getRole().startsWith(prefix)).findFirst();
                if (!managedEntry.isEmpty()) continue;
                List entries = aclCopy.getEntries().stream().filter(s -> !s.getRole().startsWith(prefix)).collect(Collectors.toList());
                aclCopy = new AccessControlList(entries);
            }
            if (!AccessControlUtil.equals((AccessControlList)aclCopy, (AccessControlList)managedAcl.getAcl())) continue;
            return Option.some((Object)managedAcl);
        }
        return Option.none();
    }
}

