/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.aws.s3.endpoint;

import com.amazonaws.services.s3.model.StorageClass;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.ASelectQuery;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.api.storage.AssetStoreException;
import org.opencastproject.assetmanager.api.storage.StoragePath;
import org.opencastproject.assetmanager.aws.s3.AwsS3AssetStore;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Function0;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="archive-aws-s3", title="AWS S3 Archive", notes={"All paths are relative to the REST endpoint base (something like http://your.server/files)", "If you notice that this service is not working as expected, there might be a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"http://opencast.jira.com\">Opencast Issue Tracker</a>"}, abstractText="This service handles AWS S3 archived assets")
@Component(immediate=true, service={AwsS3RestEndpoint.class}, property={"service.description=AssetManager S3 REST Endpoint", "opencast.service.type=org.opencastproject.assetmanager.aws-s3", "opencast.service.path=/assets/aws/s3"})
public class AwsS3RestEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(AwsS3RestEndpoint.class);
    private AwsS3AssetStore awsS3AssetStore = null;
    private AssetManager assetManager = null;
    private SecurityService securityService = null;

    @GET
    @Path(value="{mediaPackageId}/assets/storageClass")
    @Produces(value={"text/plain"})
    @RestQuery(name="getStorageClass", description="Get the S3 Storage Class for each asset in the Media Package", pathParameters={@RestParameter(name="mediaPackageId", isRequired=true, type=RestParameter.Type.STRING, description="The media package indentifier.")}, responses={@RestResponse(description="mediapackage found in S3", responseCode=200), @RestResponse(description="mediapackage not found or has no assets in S3", responseCode=404)}, returnDescription="List each assets's Object Key and S3 Storage Class")
    public Response getStorageClass(final @PathParam(value="mediaPackageId") String mediaPackageId) {
        return AwsS3RestEndpoint.handleException(new Function0<Response>(){

            private String getMediaPackageId() {
                return StringUtils.trimToNull((String)mediaPackageId);
            }

            public Response apply() {
                AQueryBuilder q = AwsS3RestEndpoint.this.assetManager.createQuery();
                ASelectQuery idQuery = q.select(new Target[]{q.snapshot()}).where(q.organizationId(AwsS3RestEndpoint.this.securityService.getOrganization().getId()).and(q.mediaPackageId(this.getMediaPackageId())).and(q.version().isLatest()));
                AResult result = idQuery.run();
                if (result.getSize() > 1L) {
                    return RestUtil.R.serverError();
                }
                if (result.getSize() == 0L) {
                    return RestUtil.R.notFound();
                }
                ARecord item = (ARecord)result.getRecords().stream().findFirst().get();
                StringBuilder info = new StringBuilder();
                for (MediaPackageElement e : ((MediaPackage)AwsS3RestEndpoint.this.assetManager.getMediaPackage(item.getMediaPackageId()).get()).elements()) {
                    if (e.getElementType() == MediaPackageElement.Type.Publication) continue;
                    StoragePath storagePath = new StoragePath(AwsS3RestEndpoint.this.securityService.getOrganization().getId(), this.getMediaPackageId(), ((Snapshot)item.getSnapshot().get()).getVersion(), e.getIdentifier());
                    if (AwsS3RestEndpoint.this.awsS3AssetStore.contains(storagePath)) {
                        try {
                            info.append(String.format("%s,%s\n", AwsS3RestEndpoint.this.awsS3AssetStore.getAssetObjectKey(storagePath), AwsS3RestEndpoint.this.awsS3AssetStore.getAssetStorageClass(storagePath)));
                            continue;
                        }
                        catch (AssetStoreException ex) {
                            throw new AssetManagerException((Throwable)ex);
                        }
                    }
                    info.append(String.format("%s,NONE\n", e.getURI()));
                }
                return RestUtil.R.ok((Object)info.toString());
            }
        });
    }

    @PUT
    @Path(value="{mediaPackageId}/assets")
    @Produces(value={"text/plain"})
    @RestQuery(name="modifyStorageClass", description="Move the Media Package assets to the specified S3 Storage Class if possible", pathParameters={@RestParameter(name="mediaPackageId", isRequired=true, type=RestParameter.Type.STRING, description="The media package indentifier.")}, restParameters={@RestParameter(name="storageClass", isRequired=true, type=RestParameter.Type.STRING, description="The S3 storage class, valid terms STANDARD, STANDARD_IA, INTELLIGENT_TIERING, ONEZONE_IA,GLACIER_IR, GLACIER, and DEEP_ARCHIVE. See https://aws.amazon.com/s3/storage-classes/")}, responses={@RestResponse(description="mediapackage found in S3", responseCode=200), @RestResponse(description="mediapackage not found or has no assets in S3", responseCode=404)}, returnDescription="List each asset's Object Key and new S3 Storage Class")
    public Response modifyStorageClass(final @PathParam(value="mediaPackageId") String mediaPackageId, final @FormParam(value="storageClass") String storageClass) {
        return AwsS3RestEndpoint.handleException(new Function0<Response>(){

            private String getMediaPackageId() {
                return StringUtils.trimToNull((String)mediaPackageId);
            }

            private String getStorageClass() {
                return StringUtils.trimToNull((String)storageClass);
            }

            public Response apply() {
                AQueryBuilder q = AwsS3RestEndpoint.this.assetManager.createQuery();
                ASelectQuery idQuery = q.select(new Target[]{q.snapshot()}).where(q.organizationId(AwsS3RestEndpoint.this.securityService.getOrganization().getId()).and(q.mediaPackageId(this.getMediaPackageId())).and(q.version().isLatest()));
                AResult result = idQuery.run();
                if (result.getSize() > 1L) {
                    return RestUtil.R.serverError();
                }
                if (result.getSize() == 0L) {
                    return RestUtil.R.notFound();
                }
                ARecord item = (ARecord)result.getRecords().stream().findFirst().get();
                StringBuilder info = new StringBuilder();
                for (MediaPackageElement e : ((MediaPackage)AwsS3RestEndpoint.this.assetManager.getMediaPackage(item.getMediaPackageId()).get()).elements()) {
                    if (e.getElementType() == MediaPackageElement.Type.Publication) continue;
                    StoragePath storagePath = new StoragePath(AwsS3RestEndpoint.this.securityService.getOrganization().getId(), this.getMediaPackageId(), ((Snapshot)item.getSnapshot().get()).getVersion(), e.getIdentifier());
                    if (AwsS3RestEndpoint.this.awsS3AssetStore.contains(storagePath)) {
                        try {
                            info.append(String.format("%s,%s\n", AwsS3RestEndpoint.this.awsS3AssetStore.getAssetObjectKey(storagePath), AwsS3RestEndpoint.this.awsS3AssetStore.modifyAssetStorageClass(storagePath, this.getStorageClass())));
                            continue;
                        }
                        catch (AssetStoreException ex) {
                            throw new AssetManagerException((Throwable)ex);
                        }
                    }
                    info.append(String.format("%s,NONE\n", e.getURI()));
                }
                return RestUtil.R.ok((Object)info.toString());
            }
        });
    }

    @GET
    @Path(value="glacier/{mediaPackageId}/assets")
    @Produces(value={"text/plain"})
    @RestQuery(name="restoreAssetsStatus", description="Get the mediapackage asset's restored status", pathParameters={@RestParameter(name="mediaPackageId", isRequired=true, type=RestParameter.Type.STRING, description="The media package indentifier.")}, responses={@RestResponse(description="mediapackage found in S3 and assets in Glacier", responseCode=200), @RestResponse(description="mediapackage found in S3 but no assets in Glacier", responseCode=204), @RestResponse(description="mediapackage not found or has no assets in S3", responseCode=404)}, returnDescription="List each glacier asset's restoration status and expiration date")
    public Response getAssetRestoreState(final @PathParam(value="mediaPackageId") String mediaPackageId) {
        return AwsS3RestEndpoint.handleException(new Function0<Response>(){

            private String getMediaPackageId() {
                return StringUtils.trimToNull((String)mediaPackageId);
            }

            public Response apply() {
                AQueryBuilder q = AwsS3RestEndpoint.this.assetManager.createQuery();
                ASelectQuery idQuery = q.select(new Target[]{q.snapshot()}).where(q.organizationId(AwsS3RestEndpoint.this.securityService.getOrganization().getId()).and(q.mediaPackageId(this.getMediaPackageId())).and(q.version().isLatest()));
                AResult result = idQuery.run();
                if (result.getSize() > 1L) {
                    return RestUtil.R.serverError();
                }
                if (result.getSize() == 0L) {
                    return RestUtil.R.notFound();
                }
                ARecord item = (ARecord)result.getRecords().stream().findFirst().get();
                StringBuilder info = new StringBuilder();
                for (MediaPackageElement e : ((MediaPackage)AwsS3RestEndpoint.this.assetManager.getMediaPackage(item.getMediaPackageId()).get()).elements()) {
                    if (e.getElementType() == MediaPackageElement.Type.Publication) continue;
                    StoragePath storagePath = new StoragePath(AwsS3RestEndpoint.this.securityService.getOrganization().getId(), this.getMediaPackageId(), ((Snapshot)item.getSnapshot().get()).getVersion(), e.getIdentifier());
                    if (AwsS3RestEndpoint.this.isFrozen(storagePath)) {
                        try {
                            info.append(String.format("%s,%s\n", AwsS3RestEndpoint.this.awsS3AssetStore.getAssetObjectKey(storagePath), AwsS3RestEndpoint.this.awsS3AssetStore.getAssetRestoreStatusString(storagePath)));
                            continue;
                        }
                        catch (AssetStoreException ex) {
                            throw new AssetManagerException((Throwable)ex);
                        }
                    }
                    info.append(String.format("%s,NONE\n", storagePath));
                }
                if (info.length() == 0) {
                    return RestUtil.R.noContent();
                }
                return RestUtil.R.ok((Object)info.toString());
            }
        });
    }

    @PUT
    @Path(value="glacier/{mediaPackageId}/assets")
    @Produces(value={"text/plain"})
    @RestQuery(name="restoreAssets", description="Initiate the restore of any assets in Glacier storage class", pathParameters={@RestParameter(name="mediaPackageId", isRequired=true, type=RestParameter.Type.STRING, description="The media package indentifier.")}, restParameters={@RestParameter(name="restorePeriod", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="2", description="Number of days to restore the assets for, default see service configuration")}, responses={@RestResponse(description="restore of assets started", responseCode=204), @RestResponse(description="invalid restore period, must be greater than zero", responseCode=400), @RestResponse(description="mediapackage not found or has no assets in S3", responseCode=404)}, returnDescription="Restore of assets initiated")
    public Response restoreAssets(final @PathParam(value="mediaPackageId") String mediaPackageId, final @FormParam(value="restorePeriod") Integer restorePeriod) {
        return AwsS3RestEndpoint.handleException(new Function0<Response>(){

            private String getMediaPackageId() {
                return StringUtils.trimToNull((String)mediaPackageId);
            }

            private Integer getRestorePeriod() {
                return restorePeriod != null ? restorePeriod : AwsS3RestEndpoint.this.awsS3AssetStore.getRestorePeriod();
            }

            public Response apply() {
                Integer restorePeriod2 = this.getRestorePeriod();
                if (restorePeriod2 < 1) {
                    throw new BadRequestException("Restore period must be greater than zero!");
                }
                AQueryBuilder q = AwsS3RestEndpoint.this.assetManager.createQuery();
                ASelectQuery idQuery = q.select(new Target[]{q.snapshot()}).where(q.organizationId(AwsS3RestEndpoint.this.securityService.getOrganization().getId()).and(q.mediaPackageId(this.getMediaPackageId())).and(q.version().isLatest()));
                AResult result = idQuery.run();
                if (result.getSize() > 1L) {
                    return RestUtil.R.serverError();
                }
                if (result.getSize() == 0L) {
                    return RestUtil.R.notFound();
                }
                ARecord item = (ARecord)result.getRecords().stream().findFirst().get();
                for (MediaPackageElement e : ((MediaPackage)AwsS3RestEndpoint.this.assetManager.getMediaPackage(item.getMediaPackageId()).get()).elements()) {
                    StoragePath storagePath;
                    if (e.getElementType() == MediaPackageElement.Type.Publication || !AwsS3RestEndpoint.this.isFrozen(storagePath = new StoragePath(AwsS3RestEndpoint.this.securityService.getOrganization().getId(), this.getMediaPackageId(), ((Snapshot)item.getSnapshot().get()).getVersion(), e.getIdentifier()))) continue;
                    try {
                        AwsS3RestEndpoint.this.awsS3AssetStore.initiateRestoreAsset(storagePath, this.getRestorePeriod());
                    }
                    catch (AssetStoreException ex) {
                        throw new AssetManagerException((Throwable)ex);
                    }
                }
                return RestUtil.R.noContent();
            }
        });
    }

    private boolean isFrozen(StoragePath storagePath) {
        String assetStorageClass = this.awsS3AssetStore.getAssetStorageClass(storagePath);
        return this.awsS3AssetStore.contains(storagePath) && (StorageClass.Glacier == StorageClass.fromValue((String)assetStorageClass) || StorageClass.DeepArchive == StorageClass.fromValue((String)assetStorageClass));
    }

    public static <A> A handleException(Function0<A> f) {
        try {
            return (A)f.apply();
        }
        catch (AssetManagerException e) {
            if (e.isCauseNotAuthorized()) {
                throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
            }
            if (e.isCauseNotFound()) {
                throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            logger.error("Error calling archive REST method", (Throwable)e);
            if (e instanceof NotFoundException) {
                throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Reference
    void setAwsS3AssetStore(AwsS3AssetStore store) {
        this.awsS3AssetStore = store;
    }

    @Reference
    void setAssetManager(AssetManager service) {
        this.assetManager = service;
    }

    @Reference
    void setSecurityService(SecurityService service) {
        this.securityService = service;
    }
}

