/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.aws.persistence;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.assetmanager.api.storage.StoragePath;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetMapping;
import org.opencastproject.db.Queries;

@Entity(name="AwsAssetMapping")
@Table(name="oc_aws_asset_mapping", indexes={@Index(name="IX_oc_aws_asset_mapping_object_key", columnList="object_key")}, uniqueConstraints={@UniqueConstraint(name="UNQ_aws_archive_mapping_0", columnNames={"organization", "mediapackage", "mediapackage_element", "version"})})
@NamedQueries(value={@NamedQuery(name="AwsAssetMapping.findActiveMapping", query="SELECT m FROM AwsAssetMapping m WHERE m.organizationId = :organizationId AND m.mediaPackageId = :mediaPackageId AND m.mediaPackageElementId = :mediaPackageElementId AND m.version = :version AND m.deletionDate IS NULL"), @NamedQuery(name="AwsAssetMapping.findAllActiveByObjectKey", query="SELECT m FROM AwsAssetMapping m WHERE m.objectKey = :objectKey AND m.deletionDate IS NULL"), @NamedQuery(name="AwsAssetMapping.findAllActiveByMediaPackage", query="SELECT m FROM AwsAssetMapping m WHERE m.organizationId = :organizationId AND m.mediaPackageId = :mediaPackageId  AND m.deletionDate IS NULL"), @NamedQuery(name="AwsAssetMapping.findAllActiveByMediaPackageAndVersion", query="SELECT m FROM AwsAssetMapping m WHERE m.organizationId = :organizationId AND m.mediaPackageId = :mediaPackageId AND m.version = :version AND m.deletionDate IS NULL"), @NamedQuery(name="AwsAssetMapping.findAllByMediaPackage", query="SELECT m FROM AwsAssetMapping m WHERE m.mediaPackageId = :mediaPackageId ORDER BY m.version DESC")})
public class AwsAssetMappingDto {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id", length=128)
    @XmlAttribute
    private long id;
    @Column(name="organization", nullable=false, length=128)
    private String organizationId;
    @Column(name="mediapackage", nullable=false, length=128)
    private String mediaPackageId;
    @Column(name="mediapackage_element", nullable=false, length=128)
    private String mediaPackageElementId;
    @Column(name="version", nullable=false)
    private Long version;
    @Column(name="object_key", nullable=false, length=1024)
    private String objectKey;
    @Column(name="object_version", nullable=false, length=1024)
    private String objectVersion;
    @Column(name="deletion_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletionDate;

    public AwsAssetMappingDto() {
    }

    public AwsAssetMappingDto(String organizationId, String mediaPackageId, String elementId, Long version, String objectKey, String objectVersion) {
        this.organizationId = organizationId;
        this.mediaPackageId = mediaPackageId;
        this.mediaPackageElementId = elementId;
        this.version = version;
        this.objectKey = objectKey;
        this.objectVersion = objectVersion;
    }

    public AwsAssetMapping toAWSArchiveMapping() {
        return new AwsAssetMapping(this.organizationId, this.mediaPackageId, this.mediaPackageElementId, this.version, this.objectKey, this.objectVersion, this.deletionDate);
    }

    public static Function<EntityManager, AwsAssetMappingDto> storeMappingQuery(StoragePath path, String objectKey, String objectVersion) {
        return em -> {
            AwsAssetMappingDto mapDto = new AwsAssetMappingDto(path.getOrganizationId(), path.getMediaPackageId(), path.getMediaPackageElementId(), Long.valueOf(path.getVersion().toString()), objectKey, objectVersion);
            Optional<AwsAssetMappingDto> existing = AwsAssetMappingDto.findMappingQuery(path).apply((EntityManager)em);
            if (existing.isPresent() && objectKey.equals(existing.get().objectKey) && objectVersion.equals(existing.get().objectVersion)) {
                existing.get().setDeletionDate(null);
                return existing.get();
            }
            em.persist((Object)mapDto);
            return mapDto;
        };
    }

    public static Function<EntityManager, Optional<AwsAssetMappingDto>> findMappingQuery(StoragePath path) {
        return Queries.namedQuery.findOpt("AwsAssetMapping.findActiveMapping", AwsAssetMappingDto.class, new Object[]{Pair.of((Object)"organizationId", (Object)path.getOrganizationId()), Pair.of((Object)"mediaPackageId", (Object)path.getMediaPackageId()), Pair.of((Object)"mediaPackageElementId", (Object)path.getMediaPackageElementId()), Pair.of((Object)"version", (Object)Long.valueOf(path.getVersion().toString()))});
    }

    public static Function<EntityManager, List<AwsAssetMappingDto>> findMappingsByKeyQuery(String objectKey) {
        return Queries.namedQuery.findAll("AwsAssetMapping.findAllActiveByObjectKey", AwsAssetMappingDto.class, new Object[]{Pair.of((Object)"objectKey", (Object)objectKey)});
    }

    public static Function<EntityManager, List<AwsAssetMappingDto>> findMappingsByMediaPackageAndVersionQuery(StoragePath path) {
        return em -> {
            TypedQuery query;
            if (path.getVersion() != null) {
                query = em.createNamedQuery("AwsAssetMapping.findAllActiveByMediaPackageAndVersion", AwsAssetMappingDto.class);
                query.setParameter("version", (Object)Long.valueOf(path.getVersion().toString()));
            } else {
                query = em.createNamedQuery("AwsAssetMapping.findAllActiveByMediaPackage", AwsAssetMappingDto.class);
            }
            query.setParameter("organizationId", (Object)path.getOrganizationId());
            query.setParameter("mediaPackageId", (Object)path.getMediaPackageId());
            return query.getResultList();
        };
    }

    public static Consumer<EntityManager> deleteMapppingQuery(StoragePath path) {
        return em -> {
            Optional<AwsAssetMappingDto> mapDto = AwsAssetMappingDto.findMappingQuery(path).apply((EntityManager)em);
            if (mapDto.isEmpty()) {
                return;
            }
            mapDto.get().setDeletionDate(new Date());
            em.merge((Object)mapDto.get());
        };
    }

    public static Function<EntityManager, List<AwsAssetMappingDto>> findMappingsByMediaPackageQuery(String mpId) {
        return Queries.namedQuery.findAll("AwsAssetMapping.findAllByMediaPackage", AwsAssetMappingDto.class, new Object[]{Pair.of((Object)"mediaPackageId", (Object)mpId)});
    }

    public void setDeletionDate(Date deletionDate) {
        this.deletionDate = deletionDate;
    }
}

