/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.aws.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.opencastproject.assetmanager.api.storage.StoragePath;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetDatabase;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetDatabaseException;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetMapping;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetMappingDto;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Aws S3 File Archive Persistence"}, immediate=false, service={AwsAssetDatabase.class})
public class AwsAssetDatabaseImpl
implements AwsAssetDatabase {
    private static final Logger logger = LoggerFactory.getLogger(AwsAssetDatabaseImpl.class);
    public static final String PERSISTENCE_UNIT = "org.opencastproject.assetmanager.aws.persistence";
    protected EntityManagerFactory emf;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating AWS S3 archive");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        this.db.close();
    }

    @Reference(target="(osgi.unit.name=org.opencastproject.assetmanager.aws.persistence)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Override
    public AwsAssetMapping storeMapping(StoragePath path, String objectKey, String objectVersion) throws AwsAssetDatabaseException {
        try {
            AwsAssetMappingDto dto = (AwsAssetMappingDto)this.db.execTx(AwsAssetMappingDto.storeMappingQuery(path, objectKey, objectVersion));
            if (dto != null) {
                return dto.toAWSArchiveMapping();
            }
            return null;
        }
        catch (Exception e) {
            throw new AwsAssetDatabaseException(String.format("Could not store mapping for path %s", path), e);
        }
    }

    @Override
    public void deleteMapping(StoragePath path) throws AwsAssetDatabaseException {
        try {
            this.db.execTx(AwsAssetMappingDto.deleteMapppingQuery(path));
        }
        catch (Exception e) {
            throw new AwsAssetDatabaseException(String.format("Could not delete mapping for path %s", path), e);
        }
    }

    @Override
    public AwsAssetMapping findMapping(StoragePath path) throws AwsAssetDatabaseException {
        try {
            return ((Optional)this.db.execTx(AwsAssetMappingDto.findMappingQuery(path))).map(AwsAssetMappingDto::toAWSArchiveMapping).orElse(null);
        }
        catch (Exception e) {
            throw new AwsAssetDatabaseException(e);
        }
    }

    @Override
    public List<AwsAssetMapping> findMappingsByKey(String objectKey) throws AwsAssetDatabaseException {
        try {
            return ((List)this.db.execTx(AwsAssetMappingDto.findMappingsByKeyQuery(objectKey))).stream().map(AwsAssetMappingDto::toAWSArchiveMapping).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new AwsAssetDatabaseException(e);
        }
    }

    @Override
    public List<AwsAssetMapping> findMappingsByMediaPackageAndVersion(StoragePath path) throws AwsAssetDatabaseException {
        try {
            return ((List)this.db.execTx(AwsAssetMappingDto.findMappingsByMediaPackageAndVersionQuery(path))).stream().map(AwsAssetMappingDto::toAWSArchiveMapping).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new AwsAssetDatabaseException(e);
        }
    }

    @Override
    public List<AwsAssetMapping> findAllByMediaPackage(String mpId) throws AwsAssetDatabaseException {
        try {
            return ((List)this.db.execTx(AwsAssetMappingDto.findMappingsByMediaPackageQuery(mpId))).stream().map(AwsAssetMappingDto::toAWSArchiveMapping).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new AwsAssetDatabaseException(e);
        }
    }
}

