/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.aws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.storage.AssetStore;
import org.opencastproject.assetmanager.api.storage.AssetStoreException;
import org.opencastproject.assetmanager.api.storage.DeletionSelector;
import org.opencastproject.assetmanager.api.storage.Source;
import org.opencastproject.assetmanager.api.storage.StoragePath;
import org.opencastproject.assetmanager.aws.AwsUploadOperationResult;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetDatabase;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetDatabaseException;
import org.opencastproject.assetmanager.aws.persistence.AwsAssetMapping;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsAbstractArchive
implements AssetStore {
    private static final Logger logger = LoggerFactory.getLogger(AwsAbstractArchive.class);
    protected Workspace workspace;
    protected AwsAssetDatabase database;
    protected String storeType = null;
    protected String regionName = null;

    protected String getAWSConfigKey(ComponentContext cc, String key) {
        try {
            String value = StringUtils.trimToEmpty((String)OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)key));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            throw new ConfigurationException(key + " is invalid");
        }
        catch (RuntimeException e) {
            throw new ConfigurationException(key + " is missing or invalid", (Throwable)e);
        }
    }

    public Option<Long> getUsedSpace() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Option<Long> getUsableSpace() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Option<Long> getTotalSpace() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getStoreType() {
        return this.storeType;
    }

    public String getRegion() {
        return this.regionName;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setDatabase(AwsAssetDatabase db) {
        this.database = db;
    }

    public boolean copy(StoragePath from, StoragePath to) throws AssetStoreException {
        try {
            AwsAssetMapping map = this.database.findMapping(from);
            if (!this.contains(from)) {
                logger.warn("Origin file mapping not found in database: {}", (Object)from);
                return false;
            }
            logger.debug("Adding AWS {} link mapping to database: {} points to {}, version {}", new Object[]{this.getStoreType(), to, map.getObjectKey(), map.getObjectVersion()});
            this.database.storeMapping(to, map.getObjectKey(), map.getObjectVersion());
            return true;
        }
        catch (AwsAssetDatabaseException e) {
            throw new AssetStoreException((Throwable)e);
        }
    }

    public boolean contains(StoragePath path) throws AssetStoreException {
        try {
            AwsAssetMapping map = this.database.findMapping(path);
            return map != null;
        }
        catch (AwsAssetDatabaseException e) {
            throw new AssetStoreException((Throwable)e);
        }
    }

    protected File getFileFromWorkspace(Source source) {
        try {
            return this.workspace.get(source.getUri());
        }
        catch (NotFoundException e) {
            logger.error("Source file '{}' does not exist", (Object)source.getUri());
            throw new AssetStoreException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while getting file '{}' from workspace: {}", (Object)source.getUri(), (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new AssetStoreException((Throwable)e);
        }
    }

    public String buildObjectName(File origin, StoragePath storagePath) {
        String fileExt = FilenameUtils.getExtension((String)origin.getName());
        return this.buildFilename(storagePath, (String)(fileExt.isEmpty() ? "" : "." + fileExt));
    }

    protected String buildFilename(StoragePath path, String ext) {
        return StringUtils.join((Object[])new String[]{path.getOrganizationId(), path.getMediaPackageId(), path.getVersion().toString(), path.getMediaPackageElementId() + ext}, (String)"/");
    }

    public void put(StoragePath storagePath, Source source) throws AssetStoreException {
        File origin = this.getFileFromWorkspace(source);
        String objectName = this.buildObjectName(origin, storagePath);
        String objectVersion = null;
        try {
            AwsUploadOperationResult result = this.uploadObject(origin, objectName, source.getMimeType());
            objectName = result.getObjectName();
            objectVersion = result.getObjectVersion();
        }
        catch (Exception e) {
            throw new AssetStoreException((Throwable)e);
        }
        try {
            logger.debug("Adding AWS {} mapping to database: {} points to {}, object version {}", new Object[]{this.getStoreType(), storagePath, objectName, objectVersion});
            this.database.storeMapping(storagePath, objectName, objectVersion);
        }
        catch (AwsAssetDatabaseException e) {
            throw new AssetStoreException((Throwable)e);
        }
    }

    protected abstract AwsUploadOperationResult uploadObject(File var1, String var2, Optional<MimeType> var3) throws AssetStoreException;

    public Optional<InputStream> get(StoragePath path) throws AssetStoreException {
        try {
            AwsAssetMapping map = this.database.findMapping(path);
            if (map == null) {
                logger.warn("File mapping not found in database: {}", (Object)path);
                return Optional.empty();
            }
            logger.debug("Getting archive object from AWS {}: {}", (Object)this.getStoreType(), (Object)map.getObjectKey());
            return Optional.of(this.getObject(map));
        }
        catch (AssetStoreException e) {
            throw e;
        }
        catch (AwsAssetDatabaseException e) {
            throw new AssetStoreException((Throwable)e);
        }
    }

    protected abstract InputStream getObject(AwsAssetMapping var1) throws AssetStoreException;

    public boolean delete(DeletionSelector sel) throws AssetStoreException {
        StoragePath path = new StoragePath(sel.getOrganizationId(), sel.getMediaPackageId(), (Version)sel.getVersion().orElse(null), null);
        try {
            List<AwsAssetMapping> list = this.database.findMappingsByMediaPackageAndVersion(path);
            for (AwsAssetMapping map : list) {
                List<AwsAssetMapping> links = this.database.findMappingsByKey(map.getObjectKey());
                if (links.size() == 1) {
                    logger.debug("Deleting archive object from AWS {}: {}, version {}", new Object[]{this.getStoreType(), map.getObjectKey(), map.getObjectVersion()});
                    this.deleteObject(map);
                    logger.info("Archive object deleted from AWS {}: {}, version {}", new Object[]{this.getStoreType(), map.getObjectKey(), map.getObjectVersion()});
                }
                this.database.deleteMapping(new StoragePath(map.getOrganizationId(), map.getMediaPackageId(), (Version)new VersionImpl(map.getVersion().longValue()), map.getMediaPackageElementId()));
            }
            return true;
        }
        catch (AwsAssetDatabaseException e) {
            throw new AssetStoreException((Throwable)e);
        }
    }

    protected abstract void deleteObject(AwsAssetMapping var1) throws AssetStoreException;
}

