/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.util;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.mediapackage.MediaPackageElements;

public final class BulkUpdateUtil {
    private static final JSONParser parser = new JSONParser();

    private BulkUpdateUtil() {
    }

    public static Optional<Event> getEvent(IndexService indexSvc, ElasticsearchIndex index, String id) {
        try {
            Event event = (Event)indexSvc.getEvent(id, index).orNull();
            return Optional.ofNullable(event);
        }
        catch (SearchIndexException e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject addSchedulingDates(Event event, JSONObject scheduling) {
        String weekdayAbbrev;
        JSONObject result = BulkUpdateUtil.deepCopy(scheduling);
        ZonedDateTime startDate = ZonedDateTime.parse(event.getRecordingStartDate());
        ZonedDateTime endDate = ZonedDateTime.parse(event.getRecordingEndDate());
        InternalDuration oldDuration = InternalDuration.of(startDate.toInstant(), endDate.toInstant());
        ZoneId timezone = ZoneId.of((String)result.get((Object)"timezone"));
        if (result.containsKey((Object)"start")) {
            startDate = BulkUpdateUtil.adjustedSchedulingDate(result, "start", startDate, timezone);
        }
        if (result.containsKey((Object)"end")) {
            endDate = BulkUpdateUtil.adjustedSchedulingDate(result, "end", endDate, timezone);
        }
        if (endDate.isBefore(startDate)) {
            endDate = endDate.plusDays(1L);
        }
        if (result.containsKey((Object)"duration")) {
            JSONObject time = (JSONObject)result.get((Object)"duration");
            InternalDuration newDuration = new InternalDuration(oldDuration);
            if (time.containsKey((Object)"hour")) {
                newDuration.hours = (Long)time.get((Object)"hour");
            }
            if (time.containsKey((Object)"minute")) {
                newDuration.minutes = (Long)time.get((Object)"minute");
            }
            if (time.containsKey((Object)"second")) {
                newDuration.seconds = (Long)time.get((Object)"second");
            }
            if (result.containsKey((Object)"end")) {
                startDate = endDate.minusHours(newDuration.hours).minusMinutes(newDuration.minutes).minusSeconds(newDuration.seconds);
            } else {
                endDate = startDate.plusHours(newDuration.hours).plusMinutes(newDuration.minutes).plusSeconds(newDuration.seconds);
            }
        }
        if (result.containsKey((Object)"weekday") && (weekdayAbbrev = (String)result.get((Object)"weekday")) != null) {
            DayOfWeek newWeekDay = Arrays.stream(DayOfWeek.values()).filter(d -> d.name().startsWith(weekdayAbbrev.toUpperCase())).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot parse weekday: " + weekdayAbbrev));
            int daysDiff = newWeekDay.getValue() - startDate.getDayOfWeek().getValue();
            startDate = startDate.plusDays(daysDiff);
            endDate = endDate.plusDays(daysDiff);
        }
        result.put((Object)"start", (Object)startDate.format(DateTimeFormatter.ISO_INSTANT));
        result.put((Object)"end", (Object)endDate.format(DateTimeFormatter.ISO_INSTANT));
        return result;
    }

    public static JSONObject toNonTechnicalMetadataJson(JSONObject scheduling) {
        ArrayList<JSONObject> fields = new ArrayList<JSONObject>();
        if (scheduling.containsKey((Object)"agentId")) {
            JSONObject locationJson = new JSONObject();
            locationJson.put((Object)"id", (Object)"location");
            locationJson.put((Object)"value", scheduling.get((Object)"agentId"));
            fields.add(locationJson);
        }
        if (scheduling.containsKey((Object)"start") && scheduling.containsKey((Object)"end")) {
            JSONObject startDateJson = new JSONObject();
            startDateJson.put((Object)"id", (Object)"startDate");
            String startDate = Instant.parse((String)scheduling.get((Object)"start")).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + ".000Z";
            startDateJson.put((Object)"value", (Object)startDate);
            fields.add(startDateJson);
            JSONObject durationJson = new JSONObject();
            durationJson.put((Object)"id", (Object)"duration");
            Instant start = Instant.parse((String)scheduling.get((Object)"start"));
            Instant end = Instant.parse((String)scheduling.get((Object)"end"));
            InternalDuration duration = InternalDuration.of(start, end);
            durationJson.put((Object)"value", (Object)duration.toString());
            fields.add(durationJson);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"flavor", (Object)MediaPackageElements.EPISODE.toString());
        result.put((Object)"title", (Object)"EVENTS.EVENTS.DETAILS.CATALOG.EPISODE");
        result.put((Object)"fields", fields);
        return result;
    }

    public static JSONObject mergeMetadataFields(JSONObject first, JSONObject second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        JSONObject result = BulkUpdateUtil.deepCopy(first);
        Collection fields = (Collection)result.get((Object)"fields");
        fields.addAll((Collection)second.get((Object)"fields"));
        return result;
    }

    private static JSONObject deepCopy(JSONObject o) {
        try {
            return (JSONObject)parser.parse(o.toJSONString());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ZonedDateTime adjustedSchedulingDate(JSONObject scheduling, String dateKey, ZonedDateTime date, ZoneId timezone) {
        JSONObject time = (JSONObject)scheduling.get((Object)dateKey);
        ZonedDateTime result = date.withZoneSameInstant(timezone);
        if (time.containsKey((Object)"hour")) {
            int hour = Math.toIntExact((Long)time.get((Object)"hour"));
            result = result.withHour(hour);
        }
        if (time.containsKey((Object)"minute")) {
            int minute = Math.toIntExact((Long)time.get((Object)"minute"));
            result = result.withMinute(minute);
        }
        return result.withZoneSameInstant(ZoneOffset.UTC);
    }

    public static class BulkUpdateInstructions {
        private static final String KEY_EVENTS = "events";
        private static final String KEY_METADATA = "metadata";
        private static final String KEY_SCHEDULING = "scheduling";
        private final List<BulkUpdateInstructionGroup> groups;

        public BulkUpdateInstructions(String json) throws IllegalArgumentException {
            try {
                JSONArray root = (JSONArray)parser.parse(json);
                this.groups = new ArrayList<BulkUpdateInstructionGroup>(root.size());
                for (Object jsonGroup : root) {
                    JSONObject jsonObject = (JSONObject)jsonGroup;
                    JSONArray eventIds = (JSONArray)jsonObject.get((Object)KEY_EVENTS);
                    JSONObject metadata = (JSONObject)jsonObject.get((Object)KEY_METADATA);
                    JSONObject scheduling = (JSONObject)jsonObject.get((Object)KEY_SCHEDULING);
                    this.groups.add(new BulkUpdateInstructionGroup((List<String>)eventIds, metadata, scheduling));
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public List<BulkUpdateInstructionGroup> getGroups() {
            return this.groups;
        }
    }

    public static class BulkUpdateInstructionGroup {
        private final List<String> eventIds;
        private final JSONObject metadata;
        private final JSONObject scheduling;

        public BulkUpdateInstructionGroup(List<String> eventIds, JSONObject metadata, JSONObject scheduling) {
            this.eventIds = eventIds;
            this.metadata = metadata;
            this.scheduling = scheduling;
        }

        public List<String> getEventIds() {
            return this.eventIds;
        }

        public JSONObject getMetadata() {
            return this.metadata;
        }

        public JSONObject getScheduling() {
            return this.scheduling;
        }
    }

    private static class InternalDuration {
        private long hours;
        private long minutes;
        private long seconds;

        InternalDuration() {
        }

        InternalDuration(InternalDuration other) {
            this.hours = other.hours;
            this.minutes = other.minutes;
            this.seconds = other.seconds;
        }

        public static InternalDuration of(Instant start, Instant end) {
            InternalDuration result = new InternalDuration();
            Duration duration = Duration.between(start, end);
            result.hours = duration.toHours();
            result.minutes = duration.minusHours(result.hours).toMinutes();
            result.seconds = duration.minusHours(result.hours).minusMinutes(result.minutes).getSeconds();
            return result;
        }

        public String toString() {
            return String.format("%02d:%02d:%02d", this.hours, this.minutes, this.seconds);
        }
    }
}

