/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AdminUIConfiguration.class}, property={"service.description=Admin UI - Configuration", "service.pid=org.opencastproject.adminui"})
public class AdminUIConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AdminUIConfiguration.class);
    public static final String OPT_PREVIEW_SUBTYPE = "preview.subtype";
    public static final String OPT_WAVEFORM_SUBTYPE = "waveform.subtype";
    public static final String OPT_SMIL_CATALOG_FLAVOR = "smil.catalog.flavor";
    public static final String OPT_SMIL_CATALOG_TAGS = "smil.catalog.tags";
    public static final String OPT_SMIL_SILENCE_FLAVOR = "smil.silence.flavor";
    public static final String OPT_THUMBNAIL_UPLOADED_FLAVOR = "thumbnail.uploaded.flavor";
    public static final String OPT_THUMBNAIL_UPLOADED_TAGS = "thumbnail.uploaded.tags";
    public static final String OPT_THUMBNAIL_MASTER_PROFILE = "thumbnail.master.profile";
    public static final String OPT_THUMBNAIL_PREVIEW_FLAVOR = "thumbnail.preview.flavor";
    public static final String OPT_THUMBNAIL_PREVIEW_PROFILE = "thumbnail.preview.profile";
    public static final String OPT_THUMBNAIL_PREVIEW_PROFILE_DOWNSCALE = "thumbnail.preview.profile.downscale";
    public static final String OPT_THUMBNAIL_SOURCE_FLAVOR_TYPE_PRIMARY = "thumbnail.source.flavor.type.primary";
    public static final String OPT_THUMBNAIL_SOURCE_FLAVOR_TYPE_SECONDARY = "thumbnail.source.flavor.type.secondary";
    public static final String OPT_THUMBNAIL_SOURCE_FLAVOR_SUBTYPE = "thumbnail.source.flavor.subtype";
    public static final String OPT_THUMBNAIL_DEFAULT_POSITION = "thumbnail.default.position";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_AUTO = "thumbnail.distribution.auto";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_CHANNEL = "thumbnail.distribution.configurable.channel";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_FLAVOR = "thumbnail.distribution.configurable.flavor";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_TAGS = "thumbnail.distribution.configurable.tags";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_PROFILES = "thumbnail.distribution.configurable.profiles";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_CHANNEL = "thumbnail.distribution.oaipmh.channel";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_FLAVOR = "thumbnail.distribution.oaipmh.flavor";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_TAGS = "thumbnail.distribution.oaipmh.tags";
    public static final String OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_PROFILES = "thumbnail.distribution.oaipmh.profiles";
    public static final String OPT_SOURCE_TRACK_LEFT_FLAVOR = "sourcetrack.left.flavor";
    public static final String OPT_SOURCE_TRACK_RIGHT_FLAVOR = "sourcetrack.right.flavor";
    public static final String OPT_PREVIEW_AUDIO_SUBTYPE = "preview.audio.subtype";
    public static final String OPT_PREVIEW_VIDEO_SUBTYPE = "preview.video.subtype";
    private static final String OPT_RETRACT_WORKFLOW_ID = "retract.workflow.id";
    private static final String OPT_MATCH_MANAGED_ACL_ROLE_PREFIXES = "match.managed.acl.role.prefixes";
    private static final String DEFAULT_PREVIEW_SUBTYPE = "preview";
    private static final String DEFAULT_WAVEFORM_SUBTYPE = "waveform";
    private static final String DEFAULT_SMIL_CATALOG_FLAVOR = "smil/cutting";
    private static final String DEFAULT_SMIL_CATALOG_TAGS = "archive";
    private static final String DEFAULT_SMIL_SILENCE_FLAVOR = "*/silence";
    private static final String DEFAULT_THUMBNAIL_UPLOADED_FLAVOR = "thumbnail/source";
    private static final String DEFAULT_THUMBNAIL_UPLOADED_TAGS = "archive";
    private static final String DEFAULT_THUMBNAIL_MASTER_PROFILE = "editor.thumbnail.master";
    private static final String DEFAULT_THUMBNAIL_PREVIEW_FLAVOR = "thumbnail/preview";
    private static final String DEFAULT_THUMBNAIL_PREVIEW_PROFILE = "editor.thumbnail.preview";
    private static final String DEFAULT_THUMBNAIL_PREVIEW_PROFILE_DOWNSCALE = "editor.thumbnail.preview.downscale";
    private static final String DEFAULT_THUMBNAIL_SOURCE_FLAVOR_TYPE_PRIMARY = "presenter";
    private static final String DEFAULT_THUMBNAIL_SOURCE_FLAVOR_TYPE_SECONDARY = "presentation";
    private static final String DEFAULT_THUMBNAIL_SOURCE_FLAVOR_SUBTYPE = "source";
    private static final Double DEFAULT_THUMBNAIL_DEFAULT_POSITION = 1.0;
    private static final Boolean DEFAULT_THUMBNAIL_DISTRIBUTION_AUTO = false;
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_CHANNEL = "api";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_FLAVOR = "*/search+preview";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_TAGS = "engage-download";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_PROFILES = "search-cover.http.downscale";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_OAIPMH_CHANNEL = "oaipmh-default";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_OAIPMH_FLAVOR = "*/search+preview";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_OAIPMH_TAGS = "engage-download";
    private static final String DEFAULT_THUMBNAIL_DISTRIBUTION_OAIPMH_PROFILES = "search-cover.http.downscale";
    private static final String DEFAULT_PREVIEW_VIDEO_SUBTYPE = "video+preview";
    private static final String DEFAULT_PREVIEW_AUDIO_SUBTYPE = "audio+preview";
    private static final String DEFAULT_SOURCE_TRACK_LEFT_FLAVOR = "presenter/source";
    private static final String DEFAULT_SOURCE_TRACK_RIGHT_FLAVOR = "presentation/source";
    private static final String DEFAULT_RETRACT_WORKFLOW_ID = "delete";
    private static final String DEFAULT_MATCH_MANAGED_ACL_ROLE_PREFIXES = "";
    private String previewSubtype = "preview";
    private String waveformSubtype = "waveform";
    private Set<String> smilCatalogTagSet = new HashSet<String>();
    private MediaPackageElementFlavor smilCatalogFlavor = MediaPackageElementFlavor.parseFlavor((String)"smil/cutting");
    private MediaPackageElementFlavor smilSilenceFlavor = MediaPackageElementFlavor.parseFlavor((String)"*/silence");
    private String thumbnailUploadedFlavor = "thumbnail/source";
    private String thumbnailUploadedTags = "archive";
    private String thumbnailMasterProfile = "editor.thumbnail.master";
    private String thumbnailPreviewFlavor = "thumbnail/preview";
    private String thumbnailPreviewProfile = "editor.thumbnail.preview";
    private String thumbnailPreviewProfileDownscale = "editor.thumbnail.preview.downscale";
    private String thumbnailSourceFlavorTypePrimary = "presenter";
    private String thumbnailSourceFlavorTypeSecondary = "presentation";
    private String thumbnailSourceFlavorSubtype = "source";
    private Double thumbnailDefaultPosition = DEFAULT_THUMBNAIL_DEFAULT_POSITION;
    private ThumbnailDistributionSettings thumbnailDistributionOaiPmh;
    private ThumbnailDistributionSettings thumbnailDistributionConfigurable;
    private String previewVideoSubtype = "video+preview";
    private String previewAudioSubtype = "audio+preview";
    private MediaPackageElementFlavor sourceTrackLeftFlavor = MediaPackageElementFlavor.parseFlavor((String)"presenter/source");
    private MediaPackageElementFlavor sourceTrackRightFlavor = MediaPackageElementFlavor.parseFlavor((String)"presentation/source");
    private String retractWorkflowId = "delete";
    private List<String> matchManagedAclRolePrefixes = new ArrayList<String>(Arrays.asList("".split(",")));

    public String getPreviewSubtype() {
        return this.previewSubtype;
    }

    public String getWaveformSubtype() {
        return this.waveformSubtype;
    }

    public MediaPackageElementFlavor getSmilCatalogFlavor() {
        return this.smilCatalogFlavor;
    }

    public Set<String> getSmilCatalogTags() {
        return this.smilCatalogTagSet;
    }

    public MediaPackageElementFlavor getSmilSilenceFlavor() {
        return this.smilSilenceFlavor;
    }

    public String getThumbnailUploadedFlavor() {
        return this.thumbnailUploadedFlavor;
    }

    public String getThumbnailUploadedTags() {
        return this.thumbnailUploadedTags;
    }

    public String getThumbnailPreviewFlavor() {
        return this.thumbnailPreviewFlavor;
    }

    public String getThumbnailPreviewProfile() {
        return this.thumbnailPreviewProfile;
    }

    public String getThumbnailPreviewProfileDownscale() {
        return this.thumbnailPreviewProfileDownscale;
    }

    public String getThumbnailMasterProfile() {
        return this.thumbnailMasterProfile;
    }

    public String getThumbnailSourceFlavorSubtype() {
        return this.thumbnailSourceFlavorSubtype;
    }

    public String getThumbnailSourceFlavorTypePrimary() {
        return this.thumbnailSourceFlavorTypePrimary;
    }

    public String getThumbnailSourceFlavorTypeSecondary() {
        return this.thumbnailSourceFlavorTypeSecondary;
    }

    public Double getThumbnailDefaultPosition() {
        return this.thumbnailDefaultPosition;
    }

    public ThumbnailDistributionSettings getThumbnailDistributionOaiPmh() {
        return this.thumbnailDistributionOaiPmh;
    }

    public ThumbnailDistributionSettings getThumbnailDistributionConfigurable() {
        return this.thumbnailDistributionConfigurable;
    }

    public String getPreviewVideoSubtype() {
        return this.previewVideoSubtype;
    }

    public String getPreviewAudioSubtype() {
        return this.previewAudioSubtype;
    }

    public MediaPackageElementFlavor getSourceTrackLeftFlavor() {
        return this.sourceTrackLeftFlavor;
    }

    public MediaPackageElementFlavor getSourceTrackRightFlavor() {
        return this.sourceTrackRightFlavor;
    }

    public String getRetractWorkflowId() {
        return this.retractWorkflowId;
    }

    public List<String> getMatchManagedAclRolePrefixes() {
        return this.matchManagedAclRolePrefixes;
    }

    @Activate
    @Modified
    public void modified(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        this.previewSubtype = StringUtils.defaultString((String)((String)properties.get(OPT_PREVIEW_SUBTYPE)), (String)DEFAULT_PREVIEW_SUBTYPE);
        logger.debug("Preview subtype configuration set to '{}'", (Object)this.previewSubtype);
        this.waveformSubtype = StringUtils.defaultString((String)((String)properties.get(OPT_WAVEFORM_SUBTYPE)), (String)DEFAULT_WAVEFORM_SUBTYPE);
        logger.debug("Waveform subtype configuration set to '{}'", (Object)this.waveformSubtype);
        this.smilCatalogFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_SMIL_CATALOG_FLAVOR)), (String)DEFAULT_SMIL_CATALOG_FLAVOR));
        logger.debug("Smil catalog flavor configuration set to '{}'", (Object)this.smilCatalogFlavor);
        String tags = StringUtils.defaultString((String)((String)properties.get(OPT_SMIL_CATALOG_TAGS)), (String)"archive");
        String[] smilCatalogTags = StringUtils.split((String)tags, (String)",");
        this.smilCatalogTagSet.clear();
        if (smilCatalogTags != null) {
            this.smilCatalogTagSet.addAll(Arrays.asList(smilCatalogTags));
        }
        logger.debug("Smil catalog target tags configuration set to '{}'", this.smilCatalogTagSet);
        this.smilSilenceFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_SMIL_SILENCE_FLAVOR)), (String)DEFAULT_SMIL_SILENCE_FLAVOR));
        logger.debug("Smil silence flavor configuration set to '{}'", (Object)this.smilSilenceFlavor);
        this.thumbnailUploadedFlavor = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_UPLOADED_FLAVOR)), (String)DEFAULT_THUMBNAIL_UPLOADED_FLAVOR);
        logger.debug("Flavor for uploaded thumbnail set to '{}'", (Object)this.thumbnailUploadedFlavor);
        this.thumbnailUploadedTags = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_UPLOADED_TAGS)), (String)"archive");
        logger.debug("Tags for uploaded thumbnail set to '{}'", (Object)this.thumbnailUploadedTags);
        this.thumbnailPreviewFlavor = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_PREVIEW_FLAVOR)), (String)DEFAULT_THUMBNAIL_PREVIEW_FLAVOR);
        logger.debug("Thumbnail preview flavor set to '{}'", (Object)this.thumbnailPreviewFlavor);
        this.thumbnailPreviewProfile = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_PREVIEW_PROFILE)), (String)DEFAULT_THUMBNAIL_PREVIEW_PROFILE);
        logger.debug("Thumbnail preview encoding profile set to '{}'", (Object)this.thumbnailPreviewProfile);
        this.thumbnailPreviewProfileDownscale = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_PREVIEW_PROFILE_DOWNSCALE)), (String)DEFAULT_THUMBNAIL_PREVIEW_PROFILE_DOWNSCALE);
        logger.debug("Thumbnail preview downscale encoding profile set to '{}'", (Object)this.thumbnailPreviewProfileDownscale);
        this.thumbnailMasterProfile = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_MASTER_PROFILE)), (String)DEFAULT_THUMBNAIL_MASTER_PROFILE);
        logger.debug("Thumbnail master extraction encoding profile set to '{}'", (Object)this.thumbnailMasterProfile);
        this.thumbnailSourceFlavorTypePrimary = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_SOURCE_FLAVOR_TYPE_PRIMARY)), (String)DEFAULT_THUMBNAIL_SOURCE_FLAVOR_TYPE_PRIMARY);
        logger.debug("Thumbnail source flavor primary type set to '{}'", (Object)this.thumbnailSourceFlavorTypePrimary);
        this.thumbnailSourceFlavorTypeSecondary = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_SOURCE_FLAVOR_TYPE_SECONDARY)), (String)DEFAULT_THUMBNAIL_SOURCE_FLAVOR_TYPE_SECONDARY);
        logger.debug("Thumbnail source flavor secondary type set to '{}'", (Object)this.thumbnailSourceFlavorTypeSecondary);
        this.thumbnailSourceFlavorSubtype = StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_SOURCE_FLAVOR_SUBTYPE)), (String)DEFAULT_THUMBNAIL_SOURCE_FLAVOR_SUBTYPE);
        logger.debug("Thumbnail source flavor subtype set to '{}'", (Object)this.thumbnailSourceFlavorSubtype);
        this.thumbnailDefaultPosition = Double.parseDouble(StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DEFAULT_POSITION)), (String)DEFAULT_THUMBNAIL_DEFAULT_POSITION.toString()));
        logger.debug("Thumbnail default position set to '{}'", (Object)this.thumbnailDefaultPosition);
        boolean thumbnailAutoDistribution = BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_AUTO)), (String)DEFAULT_THUMBNAIL_DISTRIBUTION_AUTO.toString()));
        logger.debug("Thumbnail auto distribution: {}", (Object)thumbnailAutoDistribution);
        this.thumbnailDistributionOaiPmh = new ThumbnailDistributionSettings(thumbnailAutoDistribution, StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_CHANNEL)), (String)DEFAULT_THUMBNAIL_DISTRIBUTION_OAIPMH_CHANNEL), StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_FLAVOR)), (String)"*/search+preview"), StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_TAGS)), (String)"engage-download"), StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_OAIPMH_PROFILES)), (String)"search-cover.http.downscale"));
        this.thumbnailDistributionConfigurable = new ThumbnailDistributionSettings(thumbnailAutoDistribution, StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_CHANNEL)), (String)DEFAULT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_CHANNEL), StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_FLAVOR)), (String)"*/search+preview"), StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_TAGS)), (String)"engage-download"), StringUtils.defaultString((String)((String)properties.get(OPT_THUMBNAIL_DISTRIBUTION_CONFIGURABLE_PROFILES)), (String)"search-cover.http.downscale"));
        this.previewVideoSubtype = StringUtils.defaultString((String)((String)properties.get(OPT_PREVIEW_VIDEO_SUBTYPE)), (String)DEFAULT_PREVIEW_VIDEO_SUBTYPE);
        logger.debug("Preview video subtype set to '{}'", (Object)this.previewVideoSubtype);
        this.previewAudioSubtype = StringUtils.defaultString((String)((String)properties.get(OPT_PREVIEW_AUDIO_SUBTYPE)), (String)DEFAULT_PREVIEW_AUDIO_SUBTYPE);
        logger.debug("Preview audio subtype set to '{}'", (Object)this.previewAudioSubtype);
        this.sourceTrackLeftFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_SOURCE_TRACK_LEFT_FLAVOR)), (String)DEFAULT_SOURCE_TRACK_LEFT_FLAVOR));
        logger.debug("Source track left flavor set to '{}'", (Object)this.sourceTrackLeftFlavor);
        this.sourceTrackRightFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_SOURCE_TRACK_RIGHT_FLAVOR)), (String)DEFAULT_SOURCE_TRACK_RIGHT_FLAVOR));
        logger.debug("Source track right flavor set to '{}'", (Object)this.sourceTrackRightFlavor);
        this.retractWorkflowId = StringUtils.defaultString((String)((String)properties.get(OPT_RETRACT_WORKFLOW_ID)), (String)DEFAULT_RETRACT_WORKFLOW_ID);
        logger.debug("Retract workflow ID set to {}", (Object)this.retractWorkflowId);
        String tmp = StringUtils.defaultString((String)((String)properties.get(OPT_MATCH_MANAGED_ACL_ROLE_PREFIXES)), (String)DEFAULT_MATCH_MANAGED_ACL_ROLE_PREFIXES);
        this.matchManagedAclRolePrefixes = new ArrayList<String>(Arrays.asList(tmp.split(",")));
        logger.debug("Match managed acl role prefixes set to {}", this.matchManagedAclRolePrefixes);
        logger.info("Configuration updated");
    }

    public final class ThumbnailDistributionSettings {
        private boolean enabled;
        private String channelId;
        private MediaPackageElementFlavor flavor;
        private String[] tags;
        private String[] profiles;

        public boolean getEnabled() {
            return this.enabled && !StringUtils.isEmpty((CharSequence)this.channelId);
        }

        public String getChannelId() {
            return this.channelId;
        }

        public MediaPackageElementFlavor getFlavor() {
            return this.flavor;
        }

        public String[] getTags() {
            return this.tags;
        }

        public String[] getProfiles() {
            return this.profiles;
        }

        ThumbnailDistributionSettings(boolean enabled, String channelId, String flavor, String tags, String profiles) {
            this.enabled = enabled;
            this.channelId = StringUtils.trimToEmpty((String)channelId);
            this.flavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.trimToEmpty((String)flavor));
            this.tags = StringUtils.split((String)StringUtils.trimToEmpty((String)tags), (String)",");
            this.profiles = StringUtils.split((String)StringUtils.trimToEmpty((String)profiles), (String)",");
        }
    }
}

