/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg.client;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.CapabilitiesReader;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.CachingFile;
import ca.nrc.cadc.util.InvalidConfigException;
import ca.nrc.cadc.util.MultiValuedProperties;
import ca.nrc.cadc.util.PropertiesReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.log4j.Logger;

public class RegistryClient {
    private static Logger log = Logger.getLogger(RegistryClient.class);
    @Deprecated
    private static final String HOST_PROPERTY = RegistryClient.class.getName() + ".host";
    private static final String CONFIG_BASE_URL = RegistryClient.class.getName() + ".baseURL";
    static final String CONFIG_FILE = "cadc-registry.properties";
    static final String CONFIG_CACHE_DIR = "cadc-registry-1.4";
    @Deprecated
    private static final URL DEFAULT_REG_BASE_URL;
    private static final String FILE_SEP;
    private static final URI DEFAULT_ITYPE;
    private String hostname;
    private URL regBaseURL;
    private String capsDomain;
    private int connectionTimeout = 30000;
    private int readTimeout = 60000;

    public RegistryClient() {
        PropertiesReader propReader = new PropertiesReader(CONFIG_FILE);
        MultiValuedProperties mvp = propReader.getAllProperties();
        String str = mvp.getFirstPropertyValue(CONFIG_BASE_URL);
        if (str != null) {
            try {
                if (str.endsWith("/")) {
                    str = str.substring(0, str.length() - 1);
                }
                this.regBaseURL = new URL(str);
                log.debug((Object)("regbaseURL: " + this.regBaseURL));
                return;
            }
            catch (MalformedURLException ex) {
                throw new InvalidConfigException("cadc-registry.properties: " + CONFIG_BASE_URL + " = " + str + " is not a valid URL", (Throwable)ex);
            }
        }
        URL origURL = DEFAULT_REG_BASE_URL;
        try {
            String hostP = System.getProperty(HOST_PROPERTY);
            log.debug((Object)("     host: " + hostP));
            if (hostP != null && this.hostname == null && (hostP = hostP.trim()).length() > 0) {
                this.hostname = hostP;
            }
            log.debug((Object)("Original resourceCapURL: " + origURL));
            this.regBaseURL = this.mangleHostname(origURL);
            log.debug((Object)("Mangled resourceCapURL: " + this.regBaseURL));
            if (!origURL.equals(this.regBaseURL)) {
                this.capsDomain = "alt-domains/" + this.regBaseURL.getHost();
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error transforming resource-caps URL", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isRegistryLookupOverride() {
        return !DEFAULT_REG_BASE_URL.equals(this.regBaseURL);
    }

    public URL getAccessURL(URI resourceID) throws IOException, ResourceNotFoundException {
        return this.getAccessURL(Query.CAPABILITIES, resourceID);
    }

    public URL getAccessURL(Query queryName, URI uri) throws IOException, ResourceNotFoundException {
        File queryCacheFile = this.getQueryCacheFile(queryName);
        log.debug((Object)("Capabilities cache file: " + queryCacheFile));
        URL queryURL = new URL(this.regBaseURL + "/" + queryName.getValue());
        CachingFile cachedCapSource = new CachingFile(queryCacheFile, queryURL);
        cachedCapSource.setConnectionTimeout(this.connectionTimeout);
        cachedCapSource.setReadTimeout(this.readTimeout);
        String map = cachedCapSource.getContent();
        ByteArrayInputStream mapStream = new ByteArrayInputStream(map.getBytes(StandardCharsets.UTF_8));
        MultiValuedProperties mvp = new MultiValuedProperties();
        try {
            mvp.load((InputStream)mapStream);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load properties from cache, src=" + queryURL, e);
        }
        List values = mvp.getProperty(uri.toString());
        if (values == null || values.isEmpty()) {
            throw new ResourceNotFoundException("not found: " + uri + " src=" + queryURL);
        }
        if (values.size() > 1) {
            throw new RuntimeException("multiple values for " + uri + " src=" + queryURL);
        }
        try {
            return new URL((String)values.get(0));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed URL for " + uri + " src=" + queryURL, e);
        }
    }

    public Capabilities getCapabilities(URI resourceID) throws IOException, ResourceNotFoundException {
        if (resourceID == null) {
            String msg = "Input parameter (resourceID) should not be null";
            throw new IllegalArgumentException(msg);
        }
        URL serviceCapsURL = this.getAccessURL(Query.CAPABILITIES, resourceID);
        log.debug((Object)("Service capabilities URL: " + serviceCapsURL));
        File capabilitiesFile = this.getCapabilitiesCacheFile(resourceID);
        CachingFile cachedCapabilities = new CachingFile(capabilitiesFile, serviceCapsURL);
        cachedCapabilities.setConnectionTimeout(this.connectionTimeout);
        cachedCapabilities.setReadTimeout(this.readTimeout);
        String xml = cachedCapabilities.getContent();
        CapabilitiesReader capReader = new CapabilitiesReader();
        return capReader.read(xml);
    }

    public URL getServiceURL(URI resourceIdentifier, URI standardID, AuthMethod authMethod) {
        return this.getServiceURL(resourceIdentifier, standardID, authMethod, DEFAULT_ITYPE);
    }

    public URL getServiceURL(URI resourceID, URI standardID, AuthMethod authMethod, URI interfaceType) {
        Interface intf;
        if (resourceID == null || standardID == null || authMethod == null || interfaceType == null) {
            String msg = "No input parameters should be null";
            throw new IllegalArgumentException(msg);
        }
        URL url = null;
        log.debug((Object)("resourceIdentifier=" + resourceID + ", standardID=" + standardID + ", authMethod=" + authMethod + ", interfaceType=" + interfaceType));
        Capabilities caps = null;
        try {
            caps = this.getCapabilities(resourceID);
        }
        catch (ResourceNotFoundException ex) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not obtain service URL", e);
        }
        Capability cap = caps.findCapability(standardID);
        if (cap != null && (intf = cap.findInterface(authMethod, interfaceType)) != null) {
            url = intf.getAccessURL().getURL();
        }
        return url;
    }

    File getQueryCacheFile(Query queryName) {
        String baseCacheDir = this.getBaseCacheDirectory();
        if (this.capsDomain != null) {
            baseCacheDir = baseCacheDir + FILE_SEP + this.capsDomain;
        }
        String path = FILE_SEP + queryName.getValue();
        log.debug((Object)("Caching file [" + path + "] in dir [" + baseCacheDir + "]"));
        File file = new File(baseCacheDir + path);
        return file;
    }

    private File getCapabilitiesCacheFile(URI resourceID) {
        String baseCacheDir = this.getBaseCacheDirectory();
        String resourceCacheDir = baseCacheDir + resourceID.getAuthority();
        if (this.capsDomain != null) {
            resourceCacheDir = baseCacheDir + this.capsDomain + FILE_SEP + resourceID.getAuthority();
        }
        String path = resourceID.getPath() + FILE_SEP + "capabilities.xml";
        log.debug((Object)("Caching file [" + path + "] in dir [" + resourceCacheDir + "]"));
        File file = new File(resourceCacheDir, path);
        return file;
    }

    private String getBaseCacheDirectory() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String userName = System.getProperty("user.name");
        if (tmpDir == null) {
            throw new RuntimeException("No tmp system dir defined.");
        }
        String baseCacheDir = null;
        baseCacheDir = userName == null ? tmpDir + FILE_SEP + CONFIG_CACHE_DIR + FILE_SEP : tmpDir + FILE_SEP + userName + FILE_SEP + CONFIG_CACHE_DIR + FILE_SEP;
        log.debug((Object)("Base cache dir: " + baseCacheDir));
        return baseCacheDir;
    }

    public URL mangleHostname(URL url) throws MalformedURLException {
        URL retURL = url;
        log.debug((Object)("mangling URL: " + url));
        if (this.hostname != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(url.getProtocol());
            sb.append("://");
            sb.append(this.hostname);
            int p = url.getPort();
            if (p > 0 && p != url.getDefaultPort()) {
                sb.append(":");
                sb.append(p);
            }
            sb.append(url.getPath());
            retURL = new URL(sb.toString());
        }
        log.debug((Object)("mangled URL: " + retURL));
        return retURL;
    }

    public static String getDomain(String hostname) {
        if (hostname == null) {
            return null;
        }
        int dotIndex = hostname.indexOf(46);
        if (dotIndex <= 0) {
            return null;
        }
        if (dotIndex + 1 == hostname.length()) {
            return null;
        }
        return hostname.substring(dotIndex + 1);
    }

    URL getRegistryBaseURL() {
        return this.regBaseURL;
    }

    String getCapsDomain() {
        return this.capsDomain;
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        DEFAULT_ITYPE = Standards.INTERFACE_PARAM_HTTP;
        try {
            DEFAULT_REG_BASE_URL = new URL("https://ws.cadc-ccda.hia-iha.nrc-cnrc.gc.ca/reg");
        }
        catch (MalformedURLException e) {
            log.fatal((Object)"BUG: hard-coded default URL is malformed", (Throwable)e);
            throw new ExceptionInInitializerError("BUG: hard-coded default URL is malformed: " + e.getMessage());
        }
    }

    public static enum Query {
        APPLICATIONS("applications"),
        CAPABILITIES("resource-caps");

        private String value;

        private Query(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

