/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg.client;

import ca.nrc.cadc.util.MultiValuedProperties;
import ca.nrc.cadc.util.PropertiesReader;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class LocalAuthority {
    private static final Logger log = Logger.getLogger(LocalAuthority.class);
    private static final String LOCAL_AUTH_PROP_FILE = LocalAuthority.class.getSimpleName() + ".properties";
    private Map<String, String> authorityMap = new TreeMap<String, String>();

    public LocalAuthority() {
        PropertiesReader propReader = new PropertiesReader("cadc-registry.properties");
        MultiValuedProperties mvp = propReader.getAllProperties();
        if (mvp.isEmpty()) {
            propReader = new PropertiesReader(LOCAL_AUTH_PROP_FILE);
            mvp = propReader.getAllProperties();
        }
        for (String std : mvp.keySet()) {
            List values = mvp.getProperty(std);
            if (values.size() > 1) {
                throw new IllegalStateException("found " + values.size() + " values for " + std);
            }
            if (values.isEmpty()) {
                log.debug((Object)(std + " has no value, skipping"));
                continue;
            }
            String val = (String)values.get(0);
            log.debug((Object)("authorityMap: " + std + " -> " + val));
            this.authorityMap.put(std, val);
        }
    }

    public URI getServiceURI(String baseStandardID) {
        String resourceIdentifier = this.authorityMap.get(baseStandardID);
        if (resourceIdentifier == null) {
            throw new NoSuchElementException("not found: " + baseStandardID);
        }
        return URI.create(resourceIdentifier);
    }
}

