/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg;

import ca.nrc.cadc.reg.AccessURL;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.XMLConstants;
import ca.nrc.cadc.xml.W3CConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class CapabilitiesWriter {
    private static final Logger log = Logger.getLogger(CapabilitiesWriter.class);
    private static final List<Namespace> NAMESPACE_LIST = Collections.unmodifiableList(Arrays.asList(XMLConstants.CAPABILITIES_NS, XMLConstants.VODATASERVICE_NS, XMLConstants.VORESOURCE_NS));

    public void write(Capabilities caps, OutputStream out) throws IOException {
        this.write(caps, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }

    public void write(Capabilities caps, Writer out) throws IOException {
        Element root = this.getRootElement(caps);
        this.write(root, out);
    }

    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    private Element getRootElement(Capabilities caps) {
        Element root = new Element("capabilities", XMLConstants.CAPABILITIES_NS);
        for (Namespace namespace : NAMESPACE_LIST) {
            root.addNamespaceDeclaration(namespace);
        }
        root.addNamespaceDeclaration(W3CConstants.XSI_NS);
        List namespacesInScope = root.getNamespacesInScope();
        for (Capability c : caps.getCapabilities()) {
            Element ce = this.getCapabilityElement(c, namespacesInScope);
            root.addContent((Content)ce);
        }
        return root;
    }

    private Element getCapabilityElement(Capability c, List<Namespace> namespacesInScope) {
        Element ret = new Element("capability", Namespace.NO_NAMESPACE);
        ret.setAttribute("standardID", c.getStandardID().toASCIIString());
        boolean ext = false;
        if (c.getExtensionNamespace() != null && c.getExtensionType() != null) {
            ret.addNamespaceDeclaration(c.getExtensionNamespace());
            ret.setAttribute(this.deepCopy(c.getExtensionType(), W3CConstants.XSI_NS));
            ext = true;
        }
        ArrayList<Namespace> allNamespacesInScope = new ArrayList<Namespace>();
        allNamespacesInScope.addAll(ret.getNamespacesInScope());
        allNamespacesInScope.addAll(namespacesInScope);
        for (Interface i : c.getInterfaces()) {
            Element ie = this.getInterfaceElement(i, allNamespacesInScope);
            ret.addContent((Content)ie);
        }
        if (ext) {
            for (Element e : c.getExtensionMetadata()) {
                ret.addContent((Content)this.deepCopy(e));
            }
        }
        return ret;
    }

    private Attribute deepCopy(Attribute a, Namespace ns) {
        return new Attribute(a.getName(), a.getValue(), ns);
    }

    private Element deepCopy(Element e) {
        if (!Namespace.NO_NAMESPACE.equals((Object)e.getNamespace())) {
            throw new UnsupportedOperationException("expected extension metadata to be in " + Namespace.NO_NAMESPACE + ", found: " + e.getNamespace());
        }
        Element ret = new Element(e.getName(), Namespace.NO_NAMESPACE);
        for (Attribute a : e.getAttributes()) {
            ret.setAttribute(this.deepCopy(a, Namespace.NO_NAMESPACE));
        }
        if (e.getChildren().isEmpty()) {
            ret.setText(e.getText());
        } else {
            for (Element c : e.getChildren()) {
                ret.addContent((Content)this.deepCopy(c));
            }
        }
        return ret;
    }

    private Element getInterfaceElement(Interface i, List<Namespace> nsInScope) {
        String fragmentStart;
        Element ret = new Element("interface", Namespace.NO_NAMESPACE);
        URI type = i.getType();
        String fullURL = type.toString();
        String genericURL = fullURL.contains(fragmentStart = "#") ? fullURL.substring(0, fullURL.indexOf(fragmentStart)) : fullURL;
        String prefix = "vs:";
        for (Namespace namespace : nsInScope) {
            if (!namespace.getURI().equals(genericURL)) continue;
            prefix = namespace.getPrefix() + ":";
            break;
        }
        String stype = prefix + type.getFragment();
        ret.setAttribute("type", stype, W3CConstants.XSI_NS);
        if (i.role != null) {
            ret.setAttribute("role", i.role, Namespace.NO_NAMESPACE);
        }
        if (i.version != null) {
            ret.setAttribute("version", i.version, Namespace.NO_NAMESPACE);
        }
        Element aue = this.getAccessURLElement(i.getAccessURL());
        ret.addContent((Content)aue);
        for (URI uri : i.getSecurityMethods()) {
            Element sme = this.getSecurityMethodElement(uri);
            ret.addContent((Content)sme);
        }
        return ret;
    }

    private Element getAccessURLElement(AccessURL a) {
        Element ret = new Element("accessURL", Namespace.NO_NAMESPACE);
        if (a.use != null) {
            ret.setAttribute("use", a.use);
        }
        ret.setText(a.getURL().toExternalForm());
        return ret;
    }

    private Element getSecurityMethodElement(URI s) {
        Element ret = new Element("securityMethod", Namespace.NO_NAMESPACE);
        if (!Standards.SECURITY_METHOD_ANON.equals(s)) {
            ret.setAttribute("standardID", s.toASCIIString());
        }
        return ret;
    }
}

