/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg;

import ca.nrc.cadc.reg.AccessURL;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.XMLConstants;
import ca.nrc.cadc.xml.W3CConstants;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;

public class CapabilitiesReader {
    private static final Logger log = Logger.getLogger(CapabilitiesReader.class);
    protected Map<String, String> schemaMap;

    public CapabilitiesReader() {
        this(true);
    }

    public CapabilitiesReader(boolean enableSchemaValidation) {
        if (enableSchemaValidation) {
            this.schemaMap = XMLConstants.SCHEMA_MAP;
        }
    }

    public Capabilities read(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("XML must not be null");
        }
        return this.read(new StringReader(xml));
    }

    public Capabilities read(InputStream istream) {
        if (istream == null) {
            throw new RuntimeException("capabilities xml file stream closed");
        }
        try {
            return this.read(new InputStreamReader(istream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public Capabilities read(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        Document document = null;
        try {
            document = XmlUtil.buildDocument((Reader)reader, this.schemaMap);
        }
        catch (IOException ioe) {
            String msg = "Error reading XML: " + ioe.getMessage();
            throw new RuntimeException(msg, ioe);
        }
        catch (JDOMException jde) {
            String msg = "XML failed schema validation: " + jde.getMessage();
            throw new RuntimeException(msg, jde);
        }
        return this.buildCapabilities(document.getRootElement());
    }

    private Capabilities buildCapabilities(Element root) {
        Capabilities caps = new Capabilities();
        List capElementList = root.getChildren("capability", Namespace.NO_NAMESPACE);
        for (Element capElement : capElementList) {
            Capability cap = this.buildCapability(capElement);
            caps.getCapabilities().add(cap);
        }
        return caps;
    }

    private Capability buildCapability(Element capElement) {
        Capability cap = new Capability(this.parseStandardID(capElement, true));
        Attribute attr = capElement.getAttribute("type", W3CConstants.XSI_NS);
        if (attr != null) {
            String type = attr.getValue();
            for (Namespace ns : capElement.getNamespacesInScope()) {
                if (!type.startsWith(ns.getPrefix() + ":")) continue;
                cap.setExtensionNamespace(ns);
                attr.detach();
                cap.setExtensionType(attr);
                log.debug((Object)("found extension: " + ns + " " + attr.getValue()));
            }
        }
        List intfElementList = capElement.getChildren();
        for (Element e : intfElementList) {
            if (e.getName().equals("interface")) {
                Interface intf = this.buildInterface(e);
                cap.getInterfaces().add(intf);
                continue;
            }
            cap.getExtensionMetadata().add(e);
        }
        for (Element e : cap.getExtensionMetadata()) {
            e.detach();
        }
        return cap;
    }

    private Interface buildInterface(Element intfElement) {
        Attribute attr = intfElement.getAttribute("type", W3CConstants.XSI_NS);
        String type = attr.getValue();
        for (Namespace ns : intfElement.getNamespacesInScope()) {
            if (!type.startsWith(ns.getPrefix() + ":")) continue;
            type = type.replace(ns.getPrefix() + ":", ns.getURI() + "#");
        }
        URI itype = URI.create(type);
        log.debug((Object)("found type: " + attr + " -> " + itype));
        AccessURL accessURL = this.parseAccessURL(intfElement.getChild("accessURL"));
        Interface intf = new Interface(itype, accessURL);
        intf.role = intfElement.getAttributeValue("role");
        intf.version = intfElement.getAttributeValue("version");
        List sms = intfElement.getChildren("securityMethod");
        for (Element sme : sms) {
            URI sm = this.parseSecurityMethod(sme);
            intf.getSecurityMethods().add(sm);
        }
        return intf;
    }

    private URI parseSecurityMethod(Element securityMethodElement) {
        URI standardID = this.parseStandardID(securityMethodElement, false);
        if (standardID == null) {
            standardID = Standards.SECURITY_METHOD_ANON;
        }
        return standardID;
    }

    private AccessURL parseAccessURL(Element accessURLElement) {
        AccessURL accessURL = new AccessURL(this.parseURL(accessURLElement));
        accessURL.use = accessURLElement.getAttributeValue("use");
        return accessURL;
    }

    private URL parseURL(Element accessURLElement) {
        String accessURLString = accessURLElement.getText();
        try {
            return new URL(accessURLString);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid accessURL: " + accessURLString, ex);
        }
    }

    private URI parseStandardID(Element e, boolean required) {
        String standardIDString = e.getAttributeValue("standardID");
        if (standardIDString == null && !required) {
            return null;
        }
        try {
            return new URI(standardIDString);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("invalid standardID: " + standardIDString, ex);
        }
    }
}

