/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.SpringCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCamelServerCodegen
extends SpringCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures,
OptionalFeatures {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    public static final String PROJECT_NAME = "projectName";
    public static final String CAMEL_REST_COMPONENT = "camelRestComponent";
    public static final String CAMEL_REST_BINDING_MODE = "camelRestBindingMode";
    public static final String CAMEL_REST_CLIENT_REQUEST_VALIDATION = "camelRestClientRequestValidation";
    public static final String CAMEL_USE_DEFAULT_VALIDATION_ERROR_PROCESSOR = "camelUseDefaultValidationtErrorProcessor";
    public static final String CAMEL_VALIDATION_ERROR_PROCESSOR = "camelValidationErrorProcessor";
    public static final String CAMEL_SECURITY_DEFINITIONS = "camelSecurityDefinitions";
    public static final String CAMEL_DATAFORMAT_PROPERTIES = "camelDataformatProperties";
    private String camelRestComponent = "servlet";
    private String camelRestBindingMode = "auto";
    private boolean camelRestClientRequestValidation = false;
    private boolean camelUseDefaultValidationtErrorProcessor = true;
    private String camelValidationErrorProcessor = "validationErrorProcessor";
    private boolean camelSecurityDefinitions = true;
    private String camelDataformatProperties = "";
    private final Logger LOGGER = LoggerFactory.getLogger(JavaCamelServerCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-camel";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Camel server (beta).";
    }

    public JavaCamelServerCodegen() {
        this.templateDir = "java-camel-server";
        this.addCliOptions();
        this.artifactId = "openapi-camel";
        this.library = "";
    }

    @Override
    public void processOpts() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        if (!this.additionalProperties.containsKey("dateLibrary")) {
            this.additionalProperties.put("dateLibrary", "legacy");
        }
        super.processOpts();
        this.apiTemplateFiles.remove("apiController.mustache");
        this.LOGGER.info("***** Java Apache Camel Server Generator *****");
        this.supportingFiles.clear();
        this.manageAdditionalProperties();
        HashMap dataFormatProperties = new HashMap();
        if (!"off".equals(this.camelRestBindingMode)) {
            Arrays.stream(this.camelDataformatProperties.split(",")).forEach(property -> {
                String[] dataFormatProperty = property.split("=");
                if (dataFormatProperty.length == 2) {
                    dataFormatProperties.put(dataFormatProperty[0].trim(), dataFormatProperty[1].trim());
                }
            });
        }
        this.additionalProperties.put(CAMEL_DATAFORMAT_PROPERTIES, dataFormatProperties.entrySet());
        this.supportingFiles.add(new SupportingFile("restConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "RestConfiguration.java"));
        if (this.performBeanValidation) {
            this.apiTemplateFiles.put("validation.mustache", "Validator.java");
            if (this.camelUseDefaultValidationtErrorProcessor) {
                this.supportingFiles.add(new SupportingFile("errorProcessor.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "ValidationErrorProcessor.java"));
            }
        }
        if ("spring-boot".equals(this.library)) {
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("openapi2SpringBoot.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "OpenApiGeneratorApplication.java"));
            if (!this.interfaceOnly) {
                this.apiTemplateFiles.put("routesImpl.mustache", "RoutesImpl.java");
            }
            this.supportingFiles.add(new SupportingFile("application.mustache", "src.main.resources".replace(".", File.separator), "application.properties"));
            this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "RFC3339DateFormat.java"));
            this.apiTestTemplateFiles.put("test.mustache", ".java");
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        String mediaType;
        boolean bindingModeOff = false;
        if (co.hasProduces) {
            for (Map<String, String> produces : co.produces) {
                mediaType = produces.get("mediaType");
                if (!APPLICATION_JSON.equals(mediaType) && !APPLICATION_XML.equals(mediaType)) {
                    bindingModeOff = true;
                }
                if (APPLICATION_JSON.equals(mediaType)) {
                    produces.put("isJson", "true");
                }
                if (!APPLICATION_XML.equals(mediaType)) continue;
                produces.put("isXml", "true");
            }
        }
        if (co.hasConsumes) {
            for (Map<String, String> consumes : co.consumes) {
                mediaType = consumes.get("mediaType");
                if (!APPLICATION_JSON.equals(mediaType) && !APPLICATION_XML.equals(mediaType)) {
                    bindingModeOff = true;
                }
                if (APPLICATION_JSON.equals(mediaType)) {
                    consumes.put("isJson", "true");
                }
                if (!APPLICATION_XML.equals(mediaType)) continue;
                consumes.put("isXml", "true");
            }
        }
        co.vendorExtensions.put(CAMEL_REST_BINDING_MODE, bindingModeOff);
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
    }

    private void addCliOptions() {
        this.cliOptions.add(new CliOption(CAMEL_REST_COMPONENT, "name of the Camel component to use as the REST consumer").defaultValue(this.camelRestComponent));
        this.cliOptions.add(new CliOption(CAMEL_REST_BINDING_MODE, "binding mode to be used by the REST consumer").defaultValue(this.camelRestBindingMode));
        this.cliOptions.add(CliOption.newBoolean(CAMEL_REST_CLIENT_REQUEST_VALIDATION, "enable validation of the client request to check whether the Content-Type and Accept headers from the client is supported by the Rest-DSL configuration", this.camelRestClientRequestValidation));
        this.cliOptions.add(CliOption.newBoolean(CAMEL_USE_DEFAULT_VALIDATION_ERROR_PROCESSOR, "generate default validation error processor", this.camelUseDefaultValidationtErrorProcessor));
        this.cliOptions.add(new CliOption(CAMEL_VALIDATION_ERROR_PROCESSOR, "validation error processor bean name").defaultValue(this.camelValidationErrorProcessor));
        this.cliOptions.add(CliOption.newBoolean(CAMEL_SECURITY_DEFINITIONS, "generate camel security definitions", this.camelSecurityDefinitions));
        this.cliOptions.add(new CliOption(CAMEL_DATAFORMAT_PROPERTIES, "list of dataformat properties separated by comma (propertyName1=propertyValue2,...").defaultValue(this.camelDataformatProperties));
    }

    private void manageAdditionalProperties() {
        this.camelRestComponent = this.manageAdditionalProperty(CAMEL_REST_COMPONENT, this.camelRestComponent);
        this.camelRestBindingMode = this.manageAdditionalProperty(CAMEL_REST_BINDING_MODE, this.camelRestBindingMode);
        this.camelRestClientRequestValidation = this.manageAdditionalProperty(CAMEL_REST_CLIENT_REQUEST_VALIDATION, this.camelRestClientRequestValidation);
        this.camelUseDefaultValidationtErrorProcessor = this.manageAdditionalProperty(CAMEL_USE_DEFAULT_VALIDATION_ERROR_PROCESSOR, this.camelUseDefaultValidationtErrorProcessor);
        this.camelValidationErrorProcessor = this.manageAdditionalProperty(CAMEL_VALIDATION_ERROR_PROCESSOR, this.camelValidationErrorProcessor);
        this.camelSecurityDefinitions = this.manageAdditionalProperty(CAMEL_SECURITY_DEFINITIONS, this.camelSecurityDefinitions);
        this.camelDataformatProperties = this.manageAdditionalProperty(CAMEL_DATAFORMAT_PROPERTIES, this.camelDataformatProperties);
    }

    private <T> T manageAdditionalProperty(String propertyName, T defaultValue) {
        if (this.additionalProperties.containsKey(propertyName)) {
            Object propertyValue = this.additionalProperties.get(propertyName);
            if (defaultValue instanceof Boolean && !(propertyValue instanceof Boolean)) {
                return (T)this.manageBooleanAdditionalProperty((String)propertyValue);
            }
            return (T)this.additionalProperties.get(propertyName);
        }
        this.additionalProperties.put(propertyName, defaultValue);
        return defaultValue;
    }

    private Boolean manageBooleanAdditionalProperty(String propertyValue) {
        return Boolean.parseBoolean(propertyValue);
    }
}

