/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpMezzioPathHandlerServerCodegen
extends AbstractPhpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PhpMezzioPathHandlerServerCodegen.class);
    public static final String OPT_MODERN = "modern";
    public static final String VEN_FROM_QUERY = "internal.ze-ph.fromQuery";
    public static final String VEN_COLLECTION_FORMAT = "internal.ze-ph.collectionFormat";
    public static final String VEN_QUERY_DATA_TYPE = "internal.ze-ph.queryDataType";
    public static final String VEN_HAS_QUERY_DATA = "internal.ze-ph.hasQueryData";
    public static final String VEN_FROM_CONTAINER = "internal.ze-ph.fromContainer";
    public static final String VEN_CONTAINER_DATA_TYPE = "internal.ze-ph.containerDataType";
    private boolean useModernSyntax = false;

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-mezzio-ph";
    }

    @Override
    public String getHelp() {
        return "Generates PHP server stub using Mezzio ( https://docs.mezzio.dev/mezzio/ ) and Path Handler ( https://github.com/Articus/PathHandler ).";
    }

    public PhpMezzioPathHandlerServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.typeMapping.put("double", "float");
        this.languageSpecificPrimitives.remove("\\DateTime");
        this.languageSpecificPrimitives.remove("\\SplFileObject");
        this.templateDir = "php-mezzio-ph";
        this.embeddedTemplateDir = "php-mezzio-ph";
        this.invokerPackage = "App";
        this.srcBasePath = "src" + File.separator + "App";
        this.apiDirName = "Handler";
        this.modelDirName = "DTO";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.apiNameSuffix = "";
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.json.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.php", "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("container.php", "application", "container.php"));
        this.supportingFiles.add(new SupportingFile("config.yml", "application", "config.yml"));
        this.supportingFiles.add(new SupportingFile("app.yml.mustache", "application" + File.separator + "config", "app.yml"));
        this.supportingFiles.add(new SupportingFile("path_handler.yml.mustache", "application" + File.separator + "config", "path_handler.yml"));
        this.supportingFiles.add(new SupportingFile("data_transfer.yml.mustache", "application" + File.separator + "config", "data_transfer.yml"));
        this.supportingFiles.add(new SupportingFile("Factory.php.mustache", this.srcBasePath, "Factory.php"));
        this.supportingFiles.add(new SupportingFile("InternalServerError.php.mustache", this.srcBasePath + File.separator + "Middleware", "InternalServerError.php"));
        this.additionalProperties.put("artifactVersion", "1.0.0");
        this.addSwitch(OPT_MODERN, "use modern language features (generated code will require PHP 8.0)", this.useModernSyntax);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_MODERN)) {
            this.templateDir = "php-mezzio-ph-modern";
            this.embeddedTemplateDir = "php-mezzio-ph-modern";
            this.useModernSyntax = true;
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(resourcePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(resourcePath, opList);
        }
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!co.operationId.equals(op.operationId)) continue;
            ++counter;
        }
        if (counter == 0) {
            co.operationIdLowerCase = co.operationId.toLowerCase(Locale.ROOT);
            opList.add(co);
            co.baseName = tag;
        }
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(this.toModelName(name));
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Map extensions = p.getExtensions();
        String result = extensions != null && extensions.containsKey(VEN_CONTAINER_DATA_TYPE) ? (String)extensions.get(VEN_CONTAINER_DATA_TYPE) : (this.useModernSyntax && (ModelUtils.isArraySchema(p) || ModelUtils.isMapSchema(p)) ? "array" : super.getTypeDeclaration(p));
        return result;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        this.generateParameterSchemas(openAPI);
        this.generateContainerSchemas(openAPI);
    }

    protected void generateParameterSchemas(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            for (Map.Entry pathsEntry : paths.entrySet()) {
                String pathname = (String)pathsEntry.getKey();
                PathItem path = (PathItem)pathsEntry.getValue();
                Map operationMap = path.readOperationsMap();
                if (operationMap == null) continue;
                for (Map.Entry operationMapEntry : operationMap.entrySet()) {
                    PathItem.HttpMethod method = (PathItem.HttpMethod)operationMapEntry.getKey();
                    Operation operation = (Operation)operationMapEntry.getValue();
                    HashMap<String, Schema> propertySchemas = new HashMap<String, Schema>();
                    if (operation == null || operation.getParameters() == null) continue;
                    ArrayList<String> requiredProperties = new ArrayList<String>();
                    for (Parameter parameter : operation.getParameters()) {
                        Parameter referencedParameter = ModelUtils.getReferencedParameter(openAPI, parameter);
                        Schema propertySchema = this.convertParameterToSchema(openAPI, referencedParameter);
                        if (propertySchema == null) continue;
                        propertySchemas.put(propertySchema.getName(), propertySchema);
                        if (!Boolean.TRUE.equals(referencedParameter.getRequired())) continue;
                        requiredProperties.add(propertySchema.getName());
                    }
                    if (propertySchemas.isEmpty()) continue;
                    ObjectSchema schema = new ObjectSchema();
                    String operationId = this.getOrGenerateOperationId(operation, pathname, method.name());
                    schema.setDescription("Query parameters for " + operationId);
                    schema.setProperties(propertySchemas);
                    schema.setRequired(requiredProperties);
                    this.addInternalExtensionToSchema((Schema)schema, VEN_FROM_QUERY, Boolean.TRUE);
                    String schemaName = this.generateUniqueSchemaName(openAPI, operationId + "QueryData");
                    openAPI.getComponents().addSchemas(schemaName, (Schema)schema);
                    String schemaDataType = this.getTypeDeclaration(this.toModelName(schemaName));
                    this.addInternalExtensionToOperation(operation, VEN_QUERY_DATA_TYPE, schemaDataType);
                    this.addInternalExtensionToOperation(operation, VEN_HAS_QUERY_DATA, Boolean.TRUE);
                }
            }
        }
    }

    protected Schema convertParameterToSchema(OpenAPI openAPI, Parameter parameter) {
        BooleanSchema property = null;
        if (parameter instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)parameter;
            Schema parameterSchema = ModelUtils.getReferencedSchema(openAPI, queryParameter.getSchema());
            if (ModelUtils.isArraySchema(parameterSchema)) {
                Schema itemSchema = ((ArraySchema)parameterSchema).getItems();
                ArraySchema arraySchema = new ArraySchema();
                arraySchema.setMinItems(parameterSchema.getMinItems());
                arraySchema.setMaxItems(parameterSchema.getMaxItems());
                arraySchema.setItems(itemSchema);
                String collectionFormat = this.getCollectionFormat((Parameter)queryParameter);
                if (collectionFormat == null) {
                    collectionFormat = "csv";
                }
                this.addInternalExtensionToSchema((Schema)arraySchema, VEN_COLLECTION_FORMAT, collectionFormat);
                property = arraySchema;
            } else {
                switch (parameterSchema.getType()) {
                    case "string": {
                        StringSchema stringSchema = new StringSchema();
                        stringSchema.setMinLength(parameterSchema.getMinLength());
                        stringSchema.setMaxLength(parameterSchema.getMaxLength());
                        stringSchema.setPattern(parameterSchema.getPattern());
                        stringSchema.setEnum(parameterSchema.getEnum());
                        property = stringSchema;
                        break;
                    }
                    case "integer": {
                        IntegerSchema integerSchema = new IntegerSchema();
                        integerSchema.setMinimum(parameterSchema.getMinimum());
                        integerSchema.setMaximum(parameterSchema.getMaximum());
                        property = integerSchema;
                        break;
                    }
                    case "number": {
                        NumberSchema floatSchema = new NumberSchema();
                        floatSchema.setMinimum(parameterSchema.getMinimum());
                        floatSchema.setMaximum(parameterSchema.getMaximum());
                        property = floatSchema;
                        break;
                    }
                    case "boolean": {
                        property = new BooleanSchema();
                        break;
                    }
                    case "date": {
                        property = new DateSchema();
                        break;
                    }
                    case "date-time": {
                        property = new DateTimeSchema();
                    }
                }
            }
            if (property != null) {
                property.setName(queryParameter.getName());
                property.setDescription(queryParameter.getDescription());
                this.addInternalExtensionToSchema((Schema)property, VEN_FROM_QUERY, Boolean.TRUE);
            }
        }
        return property;
    }

    protected void addInternalExtensionToSchema(Schema schema, String name, Object value) {
        if (schema.getExtensions() == null) {
            schema.setExtensions(new HashMap());
        }
        schema.getExtensions().put(name, value);
    }

    protected void addInternalExtensionToOperation(Operation operation, String name, Object value) {
        if (operation.getExtensions() == null) {
            operation.setExtensions(new HashMap());
        }
        operation.getExtensions().put(name, value);
    }

    protected String generateUniqueSchemaName(OpenAPI openAPI, String name) {
        String result = name;
        if (openAPI.getComponents().getSchemas() != null) {
            int count = 1;
            while (openAPI.getComponents().getSchemas().containsKey(result)) {
                result = name + "_" + count;
                ++count;
            }
        }
        return result;
    }

    protected void generateContainerSchemas(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        for (String pathName : paths.keySet()) {
            for (Operation operation : ((PathItem)paths.get((Object)pathName)).readOperations()) {
                Content requestBodyContent;
                RequestBody requestBody;
                List parameters = operation.getParameters();
                if (parameters != null) {
                    for (Parameter parameter : parameters) {
                        this.generateContainerSchemas(openAPI, ModelUtils.getReferencedParameter(openAPI, parameter).getSchema());
                    }
                }
                if ((requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody())) != null && (requestBodyContent = requestBody.getContent()) != null) {
                    for (String mediaTypeName : requestBodyContent.keySet()) {
                        this.generateContainerSchemas(openAPI, ((MediaType)requestBodyContent.get((Object)mediaTypeName)).getSchema());
                    }
                }
                ApiResponses responses = operation.getResponses();
                for (String responseCode : responses.keySet()) {
                    ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, (ApiResponse)responses.get((Object)responseCode));
                    Content responseContent = response.getContent();
                    if (responseContent == null) continue;
                    for (String mediaTypeName : responseContent.keySet()) {
                        this.generateContainerSchemas(openAPI, ((MediaType)responseContent.get((Object)mediaTypeName)).getSchema());
                    }
                }
            }
        }
    }

    protected void generateContainerSchemas(OpenAPI openAPI, Schema schema) {
        if (schema != null) {
            schema = ModelUtils.getReferencedSchema(openAPI, schema);
            Boolean isContainer = Boolean.FALSE;
            if (ModelUtils.isObjectSchema(schema)) {
                Map properties = schema.getProperties();
                if (properties != null) {
                    for (String propertyName : properties.keySet()) {
                        this.generateContainerSchemas(openAPI, (Schema)properties.get(propertyName));
                    }
                }
            } else if (ModelUtils.isArraySchema(schema)) {
                this.generateContainerSchemas(openAPI, ((ArraySchema)schema).getItems());
                isContainer = Boolean.TRUE;
            } else if (ModelUtils.isMapSchema(schema)) {
                Object itemSchema = schema.getAdditionalProperties();
                if (itemSchema instanceof Schema) {
                    this.generateContainerSchemas(openAPI, (Schema)itemSchema);
                }
                isContainer = Boolean.TRUE;
            }
            if (isContainer.booleanValue()) {
                String containerSchemaName = this.generateUniqueSchemaName(openAPI, "Collection");
                ObjectSchema containerSchema = new ObjectSchema();
                containerSchema.addProperties("inner", schema);
                this.addInternalExtensionToSchema((Schema)containerSchema, VEN_FROM_CONTAINER, Boolean.TRUE);
                openAPI.getComponents().addSchemas(containerSchemaName, (Schema)containerSchema);
                String containerDataType = this.getTypeDeclaration(this.toModelName(containerSchemaName));
                this.addInternalExtensionToSchema(schema, VEN_CONTAINER_DATA_TYPE, containerDataType);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        String pathPattern = null;
        for (CodegenOperation op : operationList) {
            String httpMethodDeclaration;
            switch (op.httpMethod) {
                case "GET": {
                    httpMethodDeclaration = "Get()";
                    break;
                }
                case "POST": {
                    httpMethodDeclaration = "Post()";
                    break;
                }
                case "PATCH": {
                    httpMethodDeclaration = "Patch()";
                    break;
                }
                case "PUT": {
                    httpMethodDeclaration = "Put()";
                    break;
                }
                case "DELETE": {
                    httpMethodDeclaration = "Delete()";
                    break;
                }
                default: {
                    httpMethodDeclaration = "HttpMethod(\"" + op.httpMethod + "\")";
                }
            }
            op.httpMethod = httpMethodDeclaration;
            if (op.produces != null) {
                for (Map p : op.produces) {
                    if (!p.replace("mediaType", "*/*", "n/a")) continue;
                    this.LOGGER.warn("Media type range '*/*' is not supported, using 'n/a' for code generation instead");
                }
            }
            if (pathPattern != null) continue;
            pathPattern = this.generatePathPattern(op);
        }
        operations.put("pathPattern", pathPattern);
        return objs;
    }

    protected String generatePathPattern(CodegenOperation op) {
        String result = op.path;
        for (CodegenParameter pp : op.pathParams) {
            StringBuilder replacement = new StringBuilder("{" + pp.paramName);
            if (pp.isEnum) {
                StringBuilder enumRegExp = new StringBuilder();
                for (String enumValue : pp._enum) {
                    if (enumRegExp.length() > 0) {
                        enumRegExp.append("|");
                    }
                    enumRegExp.append(enumValue.replaceAll("[\\Q<>()[]{}|^$-=!?*+.\\\\E]", "\\\\$0"));
                }
                replacement.append(":");
                replacement.append((CharSequence)enumRegExp);
            } else if (pp.isInteger) {
                replacement.append(":0|(?:-?[1-9][0-9]*)");
            } else if (pp.isString && pp.pattern != null && !pp.pattern.isEmpty()) {
                replacement.append(":");
                replacement.append(pp.pattern);
            }
            replacement.append("}");
            result = result.replace("{" + pp.paramName + "}", replacement);
        }
        return result;
    }
}

