/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.GeneratorNotFoundException;

public class CodegenConfigLoader {
    public static CodegenConfig forName(String name) {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class, CodegenConfig.class.getClassLoader());
        StringBuilder availableConfigs = new StringBuilder();
        for (CodegenConfig config : loader) {
            if (config.getName().equals(name)) {
                return config;
            }
            availableConfigs.append(config.getName()).append("\n");
        }
        try {
            return (CodegenConfig)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GeneratorNotFoundException("Can't load config class with name '".concat(name) + "'\nAvailable:\n" + availableConfigs, e);
        }
    }

    public static List<CodegenConfig> getAll() {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class, CodegenConfig.class.getClassLoader());
        ArrayList<CodegenConfig> output = new ArrayList<CodegenConfig>();
        for (CodegenConfig aLoader : loader) {
            output.add(aLoader);
        }
        return output;
    }
}

