/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.google.common.collect.Sets;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.File;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PythonLegacyClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientCodegen
extends PythonLegacyClientCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PythonClientCodegen.class);
    private Map<String, Schema> modelNameToSchemaCache;
    private DateTimeFormatter iso8601Date = DateTimeFormatter.ISO_DATE;
    private DateTimeFormatter iso8601DateTime = DateTimeFormatter.ISO_DATE_TIME;

    public PythonClientCodegen() {
        this.templateDir = "python";
        this.embeddedTemplateDir = "python";
        this.supportsAdditionalPropertiesWithComposedSchema = true;
        this.setDisallowAdditionalPropertiesIfNotPresent(false);
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.instantiationTypes.put("map", "dict");
        this.languageSpecificPrimitives.add("file_type");
        this.languageSpecificPrimitives.add("none_type");
        this.cliOptions.remove(4);
        this.cliOptions.add(new CliOption("pythonAttrNoneIfUnset", "when accessing unset attribute, return `None` instead of raising `ApiAttributeError`").defaultValue(Boolean.FALSE.toString()));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
    }

    @Override
    public void processOpts() {
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        this.modelPackage = this.packageName + ".model";
        this.supportingFiles.add(new SupportingFile("model_utils.mustache", this.packagePath(), "model_utils.py"));
        this.supportingFiles.add(new SupportingFile("__init__models.mustache", this.packagePath() + File.separatorChar + "models", "__init__.py"));
        SupportingFile originalInitModel = this.supportingFiles.stream().filter(sf -> sf.getTemplateFile().equals("__init__model.mustache")).reduce((a, b) -> {
            throw new IllegalStateException("Multiple elements: " + (Object)a + ", " + (Object)b);
        }).get();
        this.supportingFiles.remove((Object)originalInitModel);
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.packagePath() + File.separatorChar + "model", "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__apis.mustache", this.packagePath() + File.separatorChar + "apis", "__init__.py"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing.mustache", this.packagePath(), "signing.py"));
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = Boolean.valueOf(this.additionalProperties.get("generateSourceCodeOnly").toString());
        }
        ModelUtils.setGenerateAliasAsModel(true);
        this.LOGGER.info("generateAliasAsModel is hard coded to true in this generator. Alias models will only be generated if they contain validations or enums");
        Boolean attrNoneIfUnset = false;
        if (this.additionalProperties.containsKey("pythonAttrNoneIfUnset")) {
            attrNoneIfUnset = Boolean.valueOf(this.additionalProperties.get("pythonAttrNoneIfUnset").toString());
        }
        this.additionalProperties.put("attrNoneIfUnset", attrNoneIfUnset);
        if (!"urllib3".equals(this.getLibrary())) {
            throw new RuntimeException("Only the `urllib3` library is supported in the refactored `python` client generator at the moment. Please fall back to `python-legacy` client generator for the time being. We welcome contributions to add back `asyncio`, `tornado` support to the `python` client generator.");
        }
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public Schema unaliasSchema(Schema schema, Map<String, String> usedImportMappings) {
        Map<String, Schema> allSchemas = ModelUtils.getSchemas(this.openAPI);
        if (allSchemas == null || allSchemas.isEmpty()) {
            return schema;
        }
        if (schema != null && StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            String simpleRef = ModelUtils.getSimpleRef(schema.get$ref());
            if (usedImportMappings.containsKey(simpleRef)) {
                this.LOGGER.debug("Schema unaliasing of {} omitted because aliased class is to be mapped to {}", (Object)simpleRef, (Object)usedImportMappings.get(simpleRef));
                return schema;
            }
            Schema ref = allSchemas.get(simpleRef);
            if (ref == null) {
                OnceLogger.once(this.LOGGER).warn("{} is not defined", (Object)schema.get$ref());
                return schema;
            }
            if (ref.getEnum() != null && !ref.getEnum().isEmpty()) {
                return schema;
            }
            if (ModelUtils.isArraySchema(ref)) {
                if (ModelUtils.isGenerateAliasAsModel(ref)) {
                    return schema;
                }
                return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
            }
            if (ModelUtils.isComposedSchema(ref)) {
                return schema;
            }
            if (ModelUtils.isMapSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                if (ModelUtils.isGenerateAliasAsModel(ref)) {
                    return schema;
                }
                return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
            }
            if (ModelUtils.isObjectSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                if (ModelUtils.hasValidation(ref)) {
                    return schema;
                }
                if (!this.getAllOfDescendants(simpleRef, this.openAPI).isEmpty()) {
                    return schema;
                }
                return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
            }
            if (ModelUtils.hasValidation(ref)) {
                return schema;
            }
            return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
        }
        return schema;
    }

    public String pythonDate(Object dateValue) {
        String strValue = null;
        if (dateValue instanceof OffsetDateTime) {
            OffsetDateTime date = null;
            try {
                date = (OffsetDateTime)dateValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date` format for value {}", dateValue);
                date = ((Date)dateValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = date.format(this.iso8601Date);
        } else {
            strValue = dateValue.toString();
        }
        return "dateutil_parser('" + strValue + "').date()";
    }

    public String pythonDateTime(Object dateTimeValue) {
        String strValue = null;
        if (dateTimeValue instanceof OffsetDateTime) {
            OffsetDateTime dateTime = null;
            try {
                dateTime = (OffsetDateTime)dateTimeValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date-time` format for value {}", dateTimeValue);
                dateTime = ((Date)dateTimeValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = dateTime.format(this.iso8601DateTime);
        } else {
            strValue = dateTimeValue.toString();
        }
        return "dateutil_parser('" + strValue + "')";
    }

    @Override
    public String toDefaultValue(Schema p) {
        Object defaultObject = null;
        if (p.getDefault() != null) {
            defaultObject = p.getDefault();
        } else if (p.getEnum() != null && p.getEnum().size() == 1) {
            defaultObject = p.getEnum().get(0);
        }
        if (defaultObject == null) {
            return null;
        }
        String defaultValue = defaultObject.toString();
        if (ModelUtils.isDateSchema(p)) {
            defaultValue = this.pythonDate(defaultObject);
        } else if (ModelUtils.isDateTimeSchema(p)) {
            defaultValue = this.pythonDateTime(defaultObject);
        } else if (!(!ModelUtils.isStringSchema(p) || ModelUtils.isByteArraySchema(p) || ModelUtils.isBinarySchema(p) || ModelUtils.isFileSchema(p) || ModelUtils.isUUIDSchema(p) || ModelUtils.isEmailSchema(p))) {
            defaultValue = this.ensureQuotes(defaultValue);
        } else if (ModelUtils.isBooleanSchema(p)) {
            defaultValue = Boolean.valueOf(defaultValue) == false ? "False" : "True";
        }
        return defaultValue;
    }

    @Override
    public String toModelImport(String name) {
        return "from " + this.modelPackage() + "." + this.toModelFilename(name) + " import " + this.toModelName(name);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        HashMap val = (HashMap)objs.get("operations");
        ArrayList operations = (ArrayList)val.get("operation");
        for (CodegenOperation operation : operations) {
            if (operation.imports.isEmpty()) continue;
            String[] modelNames = operation.imports.toArray(new String[0]);
            operation.imports.clear();
            for (String modelName : modelNames) {
                operation.imports.add(this.toModelImport(modelName));
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        super.postProcessAllModels(objs);
        ArrayList<String> modelsToRemove = new ArrayList<String>();
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        for (String schemaName : allDefinitions.keySet()) {
            Schema refSchema = new Schema().$ref("#/components/schemas/" + schemaName);
            Schema unaliasedSchema = this.unaliasSchema(refSchema, this.importMapping);
            String modelName = this.toModelName(schemaName);
            if (unaliasedSchema.get$ref() == null) {
                modelsToRemove.add(modelName);
                continue;
            }
            HashMap objModel = (HashMap)objs.get(modelName);
            if (objModel == null) continue;
            List models = (List)objModel.get("models");
            for (Map model : models) {
                CodegenModel cm = (CodegenModel)model.get("model");
                String[] importModelNames = cm.imports.toArray(new String[0]);
                cm.imports.clear();
                for (String importModelName : importModelNames) {
                    cm.imports.add(this.toModelImport(importModelName));
                    String globalImportFixer = "globals()['" + importModelName + "'] = " + importModelName;
                    cm.imports.add(globalImportFixer);
                }
            }
        }
        for (String modelName : modelsToRemove) {
            objs.remove(modelName);
        }
        return objs;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty cp = super.fromProperty(name, p);
        if (cp.isEnum) {
            this.updateCodegenPropertyEnum(cp);
        }
        if (cp.isPrimitiveType && p.get$ref() != null) {
            cp.complexType = cp.dataType;
        }
        if (cp.isArray && cp.complexType == null && cp.mostInnerItems.complexType != null) {
            cp.complexType = cp.mostInnerItems.complexType;
        }
        return cp;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> extensions;
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.mostInnerItems != null) {
            allowableValues = var.mostInnerItems.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        String varDataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
        Schema referencedSchema = this.getModelNameToSchemaCache().get(varDataType);
        String dataType = referencedSchema != null ? this.getTypeDeclaration(referencedSchema) : varDataType;
        List<Map<String, Object>> enumVars = this.buildEnumVars(values, dataType);
        Map<String, Object> map = extensions = var.mostInnerItems != null ? var.mostInnerItems.getVendorExtensions() : var.getVendorExtensions();
        if (referencedSchema != null) {
            extensions = referencedSchema.getExtensions();
        }
        this.updateEnumVarsWithExtensions(enumVars, extensions, dataType);
        allowableValues.put("enumVars", enumVars);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter cp = super.fromRequestBody(body, imports, bodyParameterName);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        if (schema.get$ref() == null) {
            return cp;
        }
        Schema unaliasedSchema = this.unaliasSchema(schema, this.importMapping);
        CodegenProperty unaliasedProp = this.fromProperty("body", unaliasedSchema);
        Boolean dataTypeMismatch = !cp.dataType.equals(unaliasedProp.dataType);
        Boolean baseTypeMismatch = !cp.baseType.equals(unaliasedProp.complexType) && unaliasedProp.complexType != null;
        if (dataTypeMismatch.booleanValue() || baseTypeMismatch.booleanValue()) {
            cp.dataType = unaliasedProp.dataType;
            cp.baseType = unaliasedProp.complexType;
        }
        return cp;
    }

    @Override
    protected void addBodyModelSchema(CodegenParameter codegenParameter, String name, Schema schema, Set<String> imports, String bodyParameterName, boolean forceSimpleRef) {
        Schema bodySchema;
        Schema unaliased;
        if (name != null && (unaliased = this.unaliasSchema(bodySchema = new Schema().$ref("#/components/schemas/" + name), this.importMapping)).get$ref() != null) {
            forceSimpleRef = true;
        }
        super.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, forceSimpleRef);
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\s+", "_").toUpperCase(Locale.ROOT);
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.ensureQuotes(value);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty p) {
        this.postProcessPattern(p.pattern, p.vendorExtensions);
        if (p.complexType == null && p.isArray && p.mostInnerItems.complexType != null && !this.languageSpecificPrimitives.contains(p.mostInnerItems.complexType)) {
            p.complexType = p.mostInnerItems.complexType;
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter p) {
        this.postProcessPattern(p.pattern, p.vendorExtensions);
        if (p.baseType != null && this.languageSpecificPrimitives.contains(p.baseType)) {
            p.baseType = null;
        }
    }

    private void fixComposedSchemaRequiredVars(Schema schema, CodegenModel result) {
        List anyOf;
        ComposedSchema cs = (ComposedSchema)schema;
        LinkedHashMap<String, Schema> selfProperties = new LinkedHashMap<String, Schema>();
        ArrayList<String> selfRequired = new ArrayList<String>();
        LinkedHashMap<String, Schema> otherProperties = new LinkedHashMap<String, Schema>();
        ArrayList<String> otherRequired = new ArrayList<String>();
        ArrayList oneOfanyOfSchemas = new ArrayList();
        List oneOf = cs.getOneOf();
        if (oneOf != null) {
            oneOfanyOfSchemas.addAll(oneOf);
        }
        if ((anyOf = cs.getAnyOf()) != null) {
            oneOfanyOfSchemas.addAll(anyOf);
        }
        for (Schema sc : oneOfanyOfSchemas) {
            Schema refSchema = ModelUtils.getReferencedSchema(this.openAPI, sc);
            this.addProperties(otherProperties, otherRequired, refSchema);
        }
        HashSet otherRequiredSet = new HashSet(otherRequired);
        List allOf = cs.getAllOf();
        if (schema.getProperties() != null && !schema.getProperties().isEmpty() || allOf != null) {
            this.addProperties(selfProperties, selfRequired, schema);
        }
        if (result.discriminator != null) {
            selfRequired.add(result.discriminator.getPropertyBaseName());
        }
        HashSet<String> selfRequiredSet = new HashSet<String>(selfRequired);
        List<CodegenProperty> reqVars = result.getRequiredVars();
        ArrayList<CodegenProperty> reqVarsThatMustBeOptional = new ArrayList<CodegenProperty>();
        if (reqVars != null) {
            for (CodegenProperty cp : reqVars) {
                String propName = cp.baseName;
                if (!otherRequiredSet.contains(propName) || selfRequiredSet.contains(propName)) continue;
                cp.required = false;
                reqVarsThatMustBeOptional.add(cp);
            }
        }
        for (CodegenProperty cp : reqVarsThatMustBeOptional) {
            result.getRequiredVars().remove(cp);
            result.getOptionalVars().add(cp);
        }
    }

    @Override
    protected void addParentContainer(CodegenModel model, String name, Schema schema) {
        super.addParentContainer(model, name, schema);
        ArrayList<String> referencedModelNames = new ArrayList<String>();
        model.dataType = this.getTypeString(schema, "", "", referencedModelNames);
    }

    @Override
    public CodegenModel fromModel(String name, Schema sc) {
        CodegenModel cm = super.fromModel(name, sc);
        if (cm.requiredVars.size() > 0 && (cm.oneOf.size() > 0 || cm.anyOf.size() > 0)) {
            this.fixComposedSchemaRequiredVars(sc, cm);
        }
        ArrayList<List<CodegenProperty>> listOfLists = new ArrayList<List<CodegenProperty>>();
        listOfLists.add(cm.requiredVars);
        listOfLists.add(cm.optionalVars);
        for (List list : listOfLists) {
            for (CodegenProperty cp : list) {
                this.postProcessModelProperty(cm, cp);
            }
        }
        Boolean isNotPythonModelSimpleModel = ModelUtils.isComposedSchema(sc) || ModelUtils.isObjectSchema(sc) || ModelUtils.isMapSchema(sc);
        if (isNotPythonModelSimpleModel.booleanValue()) {
            return cm;
        }
        String string = this.toDefaultValue(sc);
        if (sc.getDefault() == null && string == null) {
            cm.hasRequired = true;
        } else if (sc.getDefault() != null) {
            cm.defaultValue = string;
            cm.hasRequired = false;
        } else if (string != null && cm.defaultValue == null) {
            cm.defaultValue = string;
            cm.hasRequired = false;
        }
        return cm;
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = this.getSingleSchemaType(schema);
        if (this.typeMapping.containsKey(openAPIType)) {
            String type = (String)this.typeMapping.get(openAPIType);
            return type;
        }
        return this.toModelName(openAPIType);
    }

    public String getModelName(Schema sc) {
        Schema unaliasedSchema;
        if (sc.get$ref() != null && (unaliasedSchema = this.unaliasSchema(sc, this.importMapping)).get$ref() != null) {
            return this.toModelName(ModelUtils.getSimpleRef(sc.get$ref()));
        }
        return null;
    }

    private String getTypeString(Schema p, String prefix, String suffix, List<String> referencedModelNames) {
        Schema unaliasedSchema;
        String fullSuffix = suffix;
        if (")".equals(suffix)) {
            fullSuffix = "," + suffix;
        }
        if (StringUtils.isNotEmpty((CharSequence)p.get$ref()) && (unaliasedSchema = this.unaliasSchema(p, this.importMapping)).get$ref() != null) {
            String modelName = this.toModelName(ModelUtils.getSimpleRef(p.get$ref()));
            if (referencedModelNames != null) {
                referencedModelNames.add(modelName);
            }
            return prefix + modelName + fullSuffix;
        }
        if (this.isAnyTypeSchema(p)) {
            return prefix + "bool, date, datetime, dict, float, int, list, str, none_type" + suffix;
        }
        if (ModelUtils.isNullable(ModelUtils.getReferencedSchema(this.openAPI, p))) {
            fullSuffix = ", none_type" + suffix;
        }
        if (this.isFreeFormObject(p) && this.getAdditionalProperties(p) == null) {
            return prefix + "bool, date, datetime, dict, float, int, list, str" + fullSuffix;
        }
        if ((ModelUtils.isMapSchema(p) || "object".equals(p.getType())) && this.getAdditionalProperties(p) != null) {
            Schema inner = this.getAdditionalProperties(p);
            return prefix + "{str: " + this.getTypeString(inner, "(", ")", referencedModelNames) + "}" + fullSuffix;
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                Schema anyType = new Schema();
                return this.getTypeString(anyType, "[", "]", referencedModelNames);
            }
            return prefix + this.getTypeString(inner, "[", "]", referencedModelNames) + fullSuffix;
        }
        if (ModelUtils.isFileSchema(p)) {
            return prefix + "file_type" + fullSuffix;
        }
        String baseType = this.getSchemaType(p);
        return prefix + baseType + fullSuffix;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        return this.getTypeString(p, "", "", null);
    }

    @Override
    public String toInstantiationType(Schema property) {
        if (ModelUtils.isArraySchema(property) || ModelUtils.isMapSchema(property) || property.getAdditionalProperties() != null) {
            return this.getSchemaType(property);
        }
        return super.toInstantiationType(property);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema addProps = this.getAdditionalProperties(schema);
        if (addProps != null) {
            ArrayList<String> referencedModelNames = new ArrayList<String>();
            codegenModel.additionalPropertiesType = this.getTypeString(addProps, "", "", referencedModelNames);
            if (referencedModelNames.size() != 0) {
                codegenModel.imports.addAll(referencedModelNames);
            }
        }
    }

    protected Object getObjectExample(Schema sc) {
        Boolean objectModel;
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((objectModel = Boolean.valueOf(ModelUtils.isObjectSchema(schema) || ModelUtils.isMapSchema(schema) || ModelUtils.isComposedSchema(schema))).booleanValue()) {
            return null;
        }
        if (schema.getExample() != null) {
            return schema.getExample();
        }
        if (schema.getDefault() != null) {
            return schema.getDefault();
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return schema.getEnum().get(0);
        }
        return null;
    }

    private String ensureQuotes(String in) {
        Pattern pattern = Pattern.compile("\r\n|\r|\n");
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            return "'''" + in + "'''";
        }
        String strPattern = "^['\"].*?['\"]$";
        if (in.matches(strPattern)) {
            return in;
        }
        return "\"" + in + "\"";
    }

    @Override
    public String toExampleValue(Schema schema) {
        Object objExample = this.getObjectExample(schema);
        String modelName = this.getModelName(schema);
        return this.toExampleValueRecursive(modelName, schema, objExample, 1, "", 0, Sets.newHashSet());
    }

    public String toExampleValue(Schema schema, Object objExample) {
        String modelName = this.getModelName(schema);
        return this.toExampleValueRecursive(modelName, schema, objExample, 1, "", 0, Sets.newHashSet());
    }

    private Boolean simpleStringSchema(Schema schema) {
        Schema sc = schema;
        String ref = schema.get$ref();
        if (ref != null) {
            sc = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if (!(!ModelUtils.isStringSchema(sc) || ModelUtils.isDateSchema(sc) || ModelUtils.isDateTimeSchema(sc) || "Number".equalsIgnoreCase(sc.getFormat()) || ModelUtils.isByteArraySchema(sc) || ModelUtils.isBinarySchema(sc) || schema.getPattern() != null)) {
            return true;
        }
        return false;
    }

    private CodegenDiscriminator.MappedModel getDiscriminatorMappedModel(CodegenDiscriminator disc) {
        for (CodegenDiscriminator.MappedModel mm : disc.getMappedModels()) {
            String modelName = mm.getModelName();
            Schema modelSchema = this.getModelNameToSchemaCache().get(modelName);
            if (!ModelUtils.isObjectSchema(modelSchema)) continue;
            return mm;
        }
        return null;
    }

    private String toExampleValueRecursive(String modelName, Schema schema, Object objExample, int indentationLevel, String prefix, Integer exampleLine, Set<Schema> seenSchemas) {
        String indentionConst = "    ";
        String currentIndentation = "";
        String closingIndentation = "";
        for (int i = 0; i < indentationLevel; ++i) {
            currentIndentation = currentIndentation + "    ";
        }
        if (exampleLine.equals(0)) {
            closingIndentation = currentIndentation;
            currentIndentation = "";
        } else {
            closingIndentation = currentIndentation;
        }
        String openChars = "";
        String closeChars = "";
        if (modelName != null) {
            openChars = modelName + "(";
            closeChars = ")";
        }
        String fullPrefix = currentIndentation + prefix + openChars;
        String example = null;
        if (objExample != null) {
            example = objExample.toString();
        }
        if (seenSchemas.contains(schema)) {
            if (modelName != null) {
                return fullPrefix + closeChars;
            }
            if (ModelUtils.isNullable(schema)) {
                return fullPrefix + "None" + closeChars;
            }
            if (ModelUtils.isArraySchema(schema)) {
                return fullPrefix + "[]" + closeChars;
            }
            return fullPrefix + "{}" + closeChars;
        }
        if (null != schema.get$ref()) {
            String ref;
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            Schema refSchema = allDefinitions.get(ref = ModelUtils.getSimpleRef(schema.get$ref()));
            if (null == refSchema) {
                this.LOGGER.warn("Unable to find referenced schema " + schema.get$ref() + "\n");
                return fullPrefix + "None" + closeChars;
            }
            String refModelName = this.getModelName(schema);
            return this.toExampleValueRecursive(refModelName, refSchema, objExample, indentationLevel, prefix, exampleLine, seenSchemas);
        }
        if (ModelUtils.isNullType(schema) || this.isAnyTypeSchema(schema)) {
            return fullPrefix + "None" + closeChars;
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            example = objExample == null ? "True" : ("false".equalsIgnoreCase(objExample.toString()) ? "False" : "True");
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = objExample == null ? this.pythonDate("1970-01-01") : this.pythonDate(objExample);
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = objExample == null ? this.pythonDateTime("1970-01-01T00:00:00.00Z") : this.pythonDateTime(objExample);
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            if (objExample == null) {
                example = "/path/to/file";
            }
            example = "open('" + example + "', 'rb')";
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            if (objExample == null) {
                example = "'YQ=='";
            }
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (objExample == null) {
                if ("Number".equalsIgnoreCase(schema.getFormat())) {
                    example = "2";
                    return fullPrefix + example + closeChars;
                }
                if (StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                    String pattern = schema.getPattern();
                    Pattern valueExtractor = Pattern.compile("^/?(.+?)/?(.?)$");
                    Matcher m = valueExtractor.matcher(pattern);
                    RgxGen rgxGen = null;
                    if (m.find()) {
                        int groupCount = m.groupCount();
                        if (groupCount == 1) {
                            String isolatedPattern = m.group(1);
                            rgxGen = new RgxGen((CharSequence)isolatedPattern);
                        } else if (groupCount == 2) {
                            String isolatedPattern = m.group(1);
                            String flags = m.group(2);
                            if (flags.contains("i")) {
                                rgxGen = new RgxGen((CharSequence)isolatedPattern);
                                RgxGenProperties properties = new RgxGenProperties();
                                RgxGenOption.CASE_INSENSITIVE.setInProperties(properties, (Object)true);
                                rgxGen.setProperties(properties);
                            } else {
                                rgxGen = new RgxGen((CharSequence)isolatedPattern);
                            }
                        }
                    } else {
                        rgxGen = new RgxGen((CharSequence)pattern);
                    }
                    Random random = new Random(18L);
                    example = rgxGen.generate(random);
                } else if (schema.getMinLength() != null) {
                    example = "";
                    int len = schema.getMinLength();
                    for (int i = 0; i < len; ++i) {
                        example = example + "a";
                    }
                } else {
                    example = ModelUtils.isUUIDSchema(schema) ? "046b6c7f-0b8a-43b9-b35d-6489e6daee91" : "string_example";
                }
            }
            return fullPrefix + this.ensureQuotes(example) + closeChars;
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (objExample == null) {
                example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1";
            }
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (objExample == null) {
                example = schema.getMinimum() != null ? schema.getMinimum().toString() : "3.14";
            }
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arrayschema = (ArraySchema)schema;
            Schema itemSchema = arrayschema.getItems();
            String itemModelName = this.getModelName(itemSchema);
            if (objExample instanceof Iterable && itemModelName == null) {
                return fullPrefix + objExample.toString() + closeChars;
            }
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            example = fullPrefix + "[\n" + this.toExampleValueRecursive(itemModelName, itemSchema, objExample, indentationLevel + 1, "", exampleLine + 1, newSeenSchemas) + ",\n" + closingIndentation + "]" + closeChars;
            return example;
        }
        if (ModelUtils.isMapSchema(schema)) {
            Object addPropsObj;
            if (modelName == null) {
                fullPrefix = fullPrefix + "{";
                closeChars = "}";
            }
            if ((addPropsObj = schema.getAdditionalProperties()) instanceof Schema) {
                Schema addPropsSchema = (Schema)addPropsObj;
                String key = "key";
                Object addPropsExample = this.getObjectExample(addPropsSchema);
                if (addPropsSchema.getEnum() != null && !addPropsSchema.getEnum().isEmpty()) {
                    key = addPropsSchema.getEnum().get(0).toString();
                }
                addPropsExample = this.exampleFromStringOrArraySchema(addPropsSchema, addPropsExample, key);
                String addPropPrefix = key + "=";
                if (modelName == null) {
                    addPropPrefix = this.ensureQuotes(key) + ": ";
                }
                String addPropsModelName = this.getModelName(addPropsSchema);
                HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
                newSeenSchemas.add(schema);
                example = fullPrefix + "\n" + this.toExampleValueRecursive(addPropsModelName, addPropsSchema, addPropsExample, indentationLevel + 1, addPropPrefix, exampleLine + 1, newSeenSchemas) + ",\n" + closingIndentation + closeChars;
            } else {
                example = fullPrefix + closeChars;
            }
            return example;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            CodegenDiscriminator disc;
            if (modelName == null) {
                fullPrefix = fullPrefix + "{";
                closeChars = "}";
            }
            if ((disc = this.createDiscriminator(modelName, schema, this.openAPI)) != null) {
                CodegenDiscriminator.MappedModel mm = this.getDiscriminatorMappedModel(disc);
                if (mm != null) {
                    String discPropNameValue = mm.getMappingName();
                    String addPropsExample = mm.getModelName();
                } else {
                    return fullPrefix + closeChars;
                }
            }
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            String exampleForObjectModel = this.exampleForObjectModel(schema, fullPrefix, closeChars, null, indentationLevel, exampleLine, closingIndentation, newSeenSchemas);
            return exampleForObjectModel;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            CodegenDiscriminator disc = this.createDiscriminator(modelName, schema, this.openAPI);
            if (disc != null) {
                CodegenDiscriminator.MappedModel mm = this.getDiscriminatorMappedModel(disc);
                if (mm != null) {
                    String discPropNameValue = mm.getMappingName();
                    String chosenModelName = mm.getModelName();
                    Schema modelSchema = this.getModelNameToSchemaCache().get(chosenModelName);
                    CodegenProperty cp = new CodegenProperty();
                    cp.setName(disc.getPropertyName());
                    cp.setExample(discPropNameValue);
                    HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
                    newSeenSchemas.add(schema);
                    String exampleForObjectModel = this.exampleForObjectModel(modelSchema, fullPrefix, closeChars, cp, indentationLevel, exampleLine, closingIndentation, newSeenSchemas);
                    return exampleForObjectModel;
                }
                return fullPrefix + closeChars;
            }
            return fullPrefix + closeChars;
        }
        this.LOGGER.warn("Type " + schema.getType() + " not handled properly in toExampleValue");
        return example;
    }

    private String exampleForObjectModel(Schema schema, String fullPrefix, String closeChars, CodegenProperty discProp, int indentationLevel, int exampleLine, String closingIndentation, Set<Schema> seenSchemas) {
        Map requiredAndOptionalProps = schema.getProperties();
        if (requiredAndOptionalProps == null || requiredAndOptionalProps.isEmpty()) {
            return fullPrefix + closeChars;
        }
        String example = fullPrefix + "\n";
        for (Map.Entry entry : requiredAndOptionalProps.entrySet()) {
            String propName = (String)entry.getKey();
            Schema propSchema = (Schema)entry.getValue();
            boolean readOnly = false;
            if (propSchema.getReadOnly() != null) {
                readOnly = propSchema.getReadOnly();
            }
            if (readOnly) continue;
            String ref = propSchema.get$ref();
            if (ref != null) {
                Schema refSchema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
                if (refSchema.getReadOnly() != null) {
                    readOnly = refSchema.getReadOnly();
                }
                if (readOnly) continue;
            }
            propName = this.toVarName(propName);
            String propModelName = null;
            Object propExample = null;
            if (discProp != null && propName.equals(discProp.name)) {
                propModelName = null;
                propExample = discProp.example;
            } else {
                propModelName = this.getModelName(propSchema);
                propExample = this.exampleFromStringOrArraySchema(propSchema, null, propName);
            }
            example = example + this.toExampleValueRecursive(propModelName, propSchema, propExample, indentationLevel + 1, propName + "=", exampleLine + 1, seenSchemas) + ",\n";
        }
        example = example + closingIndentation + closeChars;
        return example;
    }

    private Object exampleFromStringOrArraySchema(Schema sc, Object currentExample, String propName) {
        Object example;
        if (currentExample != null) {
            return currentExample;
        }
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((example = this.getObjectExample(schema)) != null) {
            return example;
        }
        if (this.simpleStringSchema(schema).booleanValue()) {
            return propName + "_example";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema itemSchema = arraySchema.getItems();
            example = this.getObjectExample(itemSchema);
            if (example != null) {
                return example;
            }
            if (this.simpleStringSchema(itemSchema).booleanValue()) {
                return propName + "_example";
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        String finalExample;
        Schema schema = parameter.getSchema();
        if (schema == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because parameter lacks a schema");
            return;
        }
        Object example = null;
        example = codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example") ? codegenParameter.vendorExtensions.get("x-example") : (parameter.getExample() != null ? parameter.getExample() : (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && ((Example)parameter.getExamples().values().iterator().next()).getValue() != null ? ((Example)parameter.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema)));
        example = this.exampleFromStringOrArraySchema(schema, example, parameter.getName());
        codegenParameter.example = finalExample = this.toExampleValue(schema, example);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        MediaType mediaType;
        Schema schema;
        Content content;
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        }
        if ((content = requestBody.getContent()).size() > 1) {
            OnceLogger.once(this.LOGGER).warn("Multiple MediaTypes found, using only the first one");
        }
        if ((schema = (mediaType = (MediaType)content.values().iterator().next()).getSchema()) == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because requestBody content lacks a schema");
            return;
        }
        Object example = null;
        example = mediaType.getExample() != null ? mediaType.getExample() : (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && ((Example)mediaType.getExamples().values().iterator().next()).getValue() != null ? ((Example)mediaType.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema));
        example = this.exampleFromStringOrArraySchema(schema, example, codegenParameter.paramName);
        codegenParameter.example = this.toExampleValue(schema, example);
    }

    @Override
    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter cp = super.fromFormProperty(name, propertySchema, imports);
        Parameter p = new Parameter();
        p.setSchema(propertySchema);
        p.setName(cp.paramName);
        this.setParameterExampleValue(cp, p);
        return cp;
    }

    @Override
    protected Map<String, Schema> getModelNameToSchemaCache() {
        if (this.modelNameToSchemaCache == null) {
            HashMap m = new HashMap();
            ModelUtils.getSchemas(this.openAPI).forEach((key, schema) -> m.put(this.toModelName((String)key), schema));
            this.modelNameToSchemaCache = Collections.unmodifiableMap(m);
        }
        return this.modelNameToSchemaCache;
    }
}

