/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartClientCodegen
extends DefaultCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(DartClientCodegen.class);
    public static final String PUB_LIBRARY = "pubLibrary";
    public static final String PUB_NAME = "pubName";
    public static final String PUB_VERSION = "pubVersion";
    public static final String PUB_DESCRIPTION = "pubDescription";
    public static final String PUB_AUTHOR = "pubAuthor";
    public static final String PUB_AUTHOR_EMAIL = "pubAuthorEmail";
    public static final String PUB_HOMEPAGE = "pubHomepage";
    public static final String USE_ENUM_EXTENSION = "useEnumExtension";
    protected String pubLibrary = "openapi.api";
    protected String pubName = "openapi";
    protected String pubVersion = "1.0.0";
    protected String pubDescription = "OpenAPI API client";
    protected String pubAuthor = "Author";
    protected String pubAuthorEmail = "author@homepage";
    protected String pubHomepage = "homepage";
    protected boolean useEnumExtension = false;
    protected String sourceFolder = "";
    protected String apiDocPath = "doc" + File.separator;
    protected String modelDocPath = "doc" + File.separator;
    protected String apiTestPath = "test" + File.separator;
    protected String modelTestPath = "test" + File.separator;
    protected Set<String> additionalReservedWords;

    public DartClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.outputFolder = "generated-code/dart";
        this.modelTemplateFiles.put("model.mustache", ".dart");
        this.apiTemplateFiles.put("api.mustache", ".dart");
        this.templateDir = "dart2";
        this.embeddedTemplateDir = "dart2";
        this.apiPackage = "lib.api";
        this.modelPackage = "lib.model";
        this.modelDocTemplateFiles.put("object_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.modelTestTemplateFiles.put("model_test.mustache", ".dart");
        this.apiTestTemplateFiles.put("api_test.mustache", ".dart");
        ArrayList<String> reservedWordsList = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(DartClientCodegen.class.getResourceAsStream("/dart/dart-keywords.txt"), StandardCharsets.UTF_8));
            while (reader.ready()) {
                reservedWordsList.add(reader.readLine());
            }
            reader.close();
        }
        catch (Exception e) {
            LOGGER.error("Error reading dart keywords. Exception: {}", (Object)e.getMessage());
        }
        this.setReservedWordsLowerCase(reservedWordsList);
        this.languageSpecificPrimitives = Sets.newHashSet((Object[])new String[]{"String", "bool", "int", "num", "double", "dynamic"});
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "List");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("number", "num");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("decimal", "double");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("file", "MultipartFile");
        this.typeMapping.put("binary", "MultipartFile");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("AnyType", "Object");
        this.defaultIncludes = Sets.newHashSet((Object[])new String[]{"String", "bool", "int", "num", "double", "dynamic", "List", "Set", "Map", "DateTime", "Object", "MultipartFile"});
        this.additionalReservedWords = Sets.newHashSet((Object[])new String[]{"File", "Client", "Future", "Response"});
        this.cliOptions.add(new CliOption(PUB_LIBRARY, "Library name in generated code"));
        this.cliOptions.add(new CliOption(PUB_NAME, "Name in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_VERSION, "Version in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_DESCRIPTION, "Description in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_AUTHOR, "Author name in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_AUTHOR_EMAIL, "Email address of the author in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_HOMEPAGE, "Homepage in generated pubspec"));
        this.cliOptions.add(new CliOption(USE_ENUM_EXTENSION, "Allow the 'x-enum-values' extension for enums"));
        this.cliOptions.add(new CliOption("sourceFolder", "Source folder for generated code"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "dart";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart 2.x client library.";
    }

    protected void defaultProcessOpts() {
        super.processOpts();
    }

    @Override
    public void processOpts() {
        this.defaultProcessOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(PUB_NAME)) {
            this.setPubName((String)this.additionalProperties.get(PUB_NAME));
        } else {
            this.additionalProperties.put(PUB_NAME, this.pubName);
        }
        if (this.additionalProperties.containsKey(PUB_LIBRARY)) {
            this.setPubLibrary((String)this.additionalProperties.get(PUB_LIBRARY));
        } else {
            this.additionalProperties.put(PUB_LIBRARY, this.pubLibrary);
        }
        if (this.additionalProperties.containsKey(PUB_VERSION)) {
            this.setPubVersion((String)this.additionalProperties.get(PUB_VERSION));
        } else {
            this.additionalProperties.put(PUB_VERSION, this.pubVersion);
        }
        if (this.additionalProperties.containsKey(PUB_DESCRIPTION)) {
            this.setPubDescription((String)this.additionalProperties.get(PUB_DESCRIPTION));
        } else {
            this.additionalProperties.put(PUB_DESCRIPTION, this.pubDescription);
        }
        if (this.additionalProperties.containsKey(PUB_AUTHOR)) {
            this.setPubAuthor((String)this.additionalProperties.get(PUB_AUTHOR));
        } else {
            this.additionalProperties.put(PUB_AUTHOR, this.pubAuthor);
        }
        if (this.additionalProperties.containsKey(PUB_AUTHOR_EMAIL)) {
            this.setPubAuthorEmail((String)this.additionalProperties.get(PUB_AUTHOR_EMAIL));
        } else {
            this.additionalProperties.put(PUB_AUTHOR_EMAIL, this.pubAuthorEmail);
        }
        if (this.additionalProperties.containsKey(PUB_HOMEPAGE)) {
            this.setPubHomepage((String)this.additionalProperties.get(PUB_HOMEPAGE));
        } else {
            this.additionalProperties.put(PUB_HOMEPAGE, this.pubHomepage);
        }
        if (this.additionalProperties.containsKey(USE_ENUM_EXTENSION)) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack(USE_ENUM_EXTENSION));
        } else {
            this.additionalProperties.put(USE_ENUM_EXTENSION, this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.templateDir == null) {
            this.templateDir = "dart2";
            this.embeddedTemplateDir = "dart2";
        }
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", libFolder, "api_client.dart"));
        this.supportingFiles.add(new SupportingFile("api_exception.mustache", libFolder, "api_exception.dart"));
        this.supportingFiles.add(new SupportingFile("api_helper.mustache", libFolder, "api_helper.dart"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", authFolder, "authentication.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_basic_auth.mustache", authFolder, "http_basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_bearer_auth.mustache", authFolder, "http_bearer_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
    }

    @Override
    protected boolean isReservedWord(String word) {
        return super.isReservedWord(word) || this.defaultIncludes().contains(word) || this.additionalReservedWords.contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.apiTestPath.replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.modelTestPath.replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        name = name.replace("-", "_");
        if ((name = name.replaceAll("^_", "")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey("" + (char)character))) {
            name = StringUtils.escape(name, this.specialCharReplacements, Lists.newArrayList((Object[])new String[]{"_"}), "_");
        }
        name = this.sanitizeName(name);
        if ((name = StringUtils.camelize(name, true)).matches("^\\d.*")) {
            name = "n" + name;
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        String nameWithPrefixSuffix = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize(nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_test";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_test";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            return "const {}";
        }
        if (ModelUtils.isArraySchema(schema)) {
            return "const []";
        }
        if (schema.getDefault() != null) {
            if (ModelUtils.isStringSchema(schema)) {
                return "'" + schema.getDefault().toString().replace("'", "\\'") + "'";
            }
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = ModelUtils.unaliasSchema(this.openAPI, p, this.importMapping);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = this.getSchemaItems((ArraySchema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = this.getAdditionalProperties(target);
            if (inner == null) {
                LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            LOGGER.error("No Type defined for Schema " + p);
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!model.isEnum && property.isEnum) {
            if (property.items != null) {
                property.setDatatypeWithEnum(property.datatypeWithEnum.replace(property.items.datatypeWithEnum, model.classname + property.items.datatypeWithEnum));
            } else {
                property.setDatatypeWithEnum(property.datatypeWithEnum.replace(property.enumName, model.classname + property.enumName));
            }
        }
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        for (CodegenResponse r : op.responses) {
            String value;
            if (r.containerType == null || !this.typeMapping().containsKey(r.containerType) || !this.needToImport(value = this.typeMapping().get(r.containerType))) continue;
            op.imports.add(value);
        }
        return op;
    }

    @Override
    protected void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String dataType) {
        if (vendorExtensions != null && this.useEnumExtension && vendorExtensions.containsKey("x-enum-values")) {
            enumVars.clear();
            Object extension = vendorExtensions.get("x-enum-values");
            List values = (List)extension;
            for (Map value : values) {
                HashMap<String, Object> enumVar = new HashMap<String, Object>();
                enumVar.put("name", this.toEnumVarName((String)value.get("identifier"), dataType));
                enumVar.put("value", this.toEnumValue(value.get("numericValue").toString(), dataType));
                enumVar.put("isString", this.isDataTypeString(dataType));
                if (value.containsKey("description")) {
                    enumVar.put("description", value.get("description").toString());
                }
                enumVars.add(enumVar);
            }
        } else {
            super.updateEnumVarsWithExtensions(enumVars, vendorExtensions, dataType);
        }
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "empty";
        }
        if (("number".equalsIgnoreCase(datatype) || "double".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) && value.matches("^-?\\d.*")) {
            boolean isNegative = value.startsWith("-");
            return this.toVarName("number" + (isNegative ? "_negative" : "") + value);
        }
        return this.toVarName(value);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toOperationId(String operationId) {
        operationId = super.toOperationId(operationId);
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            operationId = StringUtils.camelize("call_" + operationId, true);
        }
        return operationId;
    }

    public void setPubLibrary(String pubLibrary) {
        this.pubLibrary = pubLibrary;
    }

    public void setPubName(String pubName) {
        this.pubName = pubName;
    }

    public void setPubVersion(String pubVersion) {
        this.pubVersion = pubVersion;
    }

    public void setPubDescription(String pubDescription) {
        this.pubDescription = pubDescription;
    }

    public void setPubAuthor(String pubAuthor) {
        this.pubAuthor = pubAuthor;
    }

    public void setPubAuthorEmail(String pubAuthorEmail) {
        this.pubAuthorEmail = pubAuthorEmail;
    }

    public void setPubHomepage(String pubHomepage) {
        this.pubHomepage = pubHomepage;
    }

    public void setUseEnumExtension(boolean useEnumExtension) {
        this.useEnumExtension = useEnumExtension;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String dartPostProcessFile = System.getenv("DART_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dartPostProcessFile)) {
            return;
        }
        if ("dart".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = dartPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

