/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;

public class TypeScriptAxiosClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String SNAPSHOT = "snapshot";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String SEPARATE_MODELS_AND_API = "withSeparateModelsAndApi";
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String npmRepository = null;
    private String tsModelPackage = "";

    public TypeScriptAxiosClientCodegen() {
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-axios";
        this.templateDir = "typescript-axios";
        this.embeddedTemplateDir = "typescript-axios";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package"));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(SNAPSHOT, "When setting this property to true the version will be suffixed with -SNAPSHOT.yyyyMMddHHmm", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(SEPARATE_MODELS_AND_API, "Put the model and api in separate folders and in separate classes", "boolean").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public String getName() {
        return "typescript-axios";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using axios.";
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private static String getRelativeToRoot(String path) {
        StringBuilder sb = new StringBuilder();
        int slashCount = path.split("/").length;
        if (slashCount == 0) {
            sb.append("./");
        } else {
            for (int i = 0; i < slashCount; ++i) {
                sb.append("../");
            }
        }
        return sb.toString();
    }

    @Override
    public void processOpts() {
        boolean emptyModelOrApi;
        super.processOpts();
        this.tsModelPackage = this.modelPackage.replaceAll("\\.", "/");
        String tsApiPackage = this.apiPackage.replaceAll("\\.", "/");
        String modelRelativeToRoot = TypeScriptAxiosClientCodegen.getRelativeToRoot(this.tsModelPackage);
        String apiRelativeToRoot = TypeScriptAxiosClientCodegen.getRelativeToRoot(tsApiPackage);
        this.additionalProperties.put("tsModelPackage", this.tsModelPackage);
        this.additionalProperties.put("tsApiPackage", tsApiPackage);
        this.additionalProperties.put("apiRelativeToRoot", apiRelativeToRoot);
        this.additionalProperties.put("modelRelativeToRoot", modelRelativeToRoot);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("baseApi.mustache", "", "base.ts"));
        this.supportingFiles.add(new SupportingFile("api.mustache", "", "api.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("custom.d.mustache", "", "custom.d.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        boolean separateModelsAndApi = this.additionalProperties.getOrDefault(SEPARATE_MODELS_AND_API, false);
        if (separateModelsAndApi) {
            this.modelTemplateFiles.put("model.mustache", ".ts");
            this.apiTemplateFiles.put("apiInner.mustache", ".ts");
            this.supportingFiles.add(new SupportingFile("modelIndex.mustache", this.tsModelPackage, "index.ts"));
        }
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.addNpmPackageGeneration();
        }
        boolean bl = emptyModelOrApi = separateModelsAndApi && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.modelPackage, this.apiPackage});
        if (emptyModelOrApi) {
            throw new RuntimeException("apiPackage and modelPackage must be defined");
        }
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema inner = ((ArraySchema)p).getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "{ [key: string]: " + this.getTypeDeclaration(inner) + "; }";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "any";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "any";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map vals = objs.getOrDefault("operations", new HashMap());
        List operations = vals.getOrDefault("operation", new ArrayList());
        operations.stream().filter(op -> op.hasConsumes).filter(op -> op.consumes.stream().anyMatch(opc -> opc.values().stream().anyMatch("multipart/form-data"::equals))).forEach(op -> op.vendorExtensions.putIfAbsent("multipartFormData", true));
        return objs;
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> ret = super.postProcessModels(objs);
        List models = (List)ret.get("models");
        for (Map m : models) {
            CodegenModel model = (CodegenModel)m.get("model");
            model.classFilename = model.classname.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
        }
        for (Map m : (List)ret.get("imports")) {
            String javaImport = ((String)m.get("import")).substring(this.modelPackage.length() + 1);
            String tsImport = this.tsModelPackage + "/" + javaImport;
            m.put("tsImport", tsImport);
            m.put("class", javaImport);
            m.put("filename", javaImport.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT));
        }
        return ret;
    }

    @Override
    public String toModelFilename(String name) {
        return super.toModelFilename(name).replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
    }

    @Override
    public String toApiFilename(String name) {
        return super.toApiFilename(name).replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.valueOf(this.additionalProperties.get(SNAPSHOT).toString()).booleanValue()) {
            if (this.npmVersion.toUpperCase(Locale.ROOT).matches("^.*-SNAPSHOT$")) {
                this.setNpmVersion(this.npmVersion + "." + this.SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
            } else {
                this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + this.SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
            }
        }
        this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
    }
}

