/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinSpringServerCodegen
extends AbstractKotlinCodegen
implements BeanValidationFeatures {
    private static Logger LOGGER = LoggerFactory.getLogger(KotlinSpringServerCodegen.class);
    private static final HashSet<String> VARIABLE_RESERVED_WORDS = new HashSet<String>(Arrays.asList("ApiClient", "ApiException", "ApiResponse"));
    public static final String TITLE = "title";
    public static final String LAMBDA = "lambda";
    public static final String SERVER_PORT = "serverPort";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String SPRING_BOOT = "spring-boot";
    public static final String EXCEPTION_HANDLER = "exceptionHandler";
    public static final String GRADLE_BUILD_FILE = "gradleBuildFile";
    public static final String SWAGGER_ANNOTATIONS = "swaggerAnnotations";
    public static final String SERVICE_INTERFACE = "serviceInterface";
    public static final String SERVICE_IMPLEMENTATION = "serviceImplementation";
    private String basePackage;
    private String invokerPackage;
    private String serverPort = "8080";
    private String title = "OpenAPI Kotlin Spring";
    private String resourceFolder = "src/main/resources";
    private boolean useBeanValidation = true;
    private boolean exceptionHandler = true;
    private boolean gradleBuildFile = true;
    private boolean swaggerAnnotations = false;
    private boolean serviceInterface = false;
    private boolean serviceImplementation = false;

    public KotlinSpringServerCodegen() {
        this.reservedWords.addAll(VARIABLE_RESERVED_WORDS);
        this.outputFolder = "generated-code/kotlin-spring";
        this.apiTestTemplateFiles.clear();
        this.templateDir = "kotlin-spring";
        this.embeddedTemplateDir = "kotlin-spring";
        this.artifactId = "openapi-spring";
        this.invokerPackage = "org.openapitools";
        this.basePackage = "org.openapitools";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.typeMapping.put("array", "List");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("ByteArray", "ByteArray");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("binary", "Array<kotlin.Byte>");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("date-time", "java.time.OffsetDateTime");
        this.typeMapping.put("Date", "java.time.LocalDate");
        this.typeMapping.put("DateTime", "java.time.OffsetDateTime");
        this.importMapping.put("Date", "java.time.LocalDate");
        this.importMapping.put("DateTime", "java.time.OffsetDateTime");
        this.languageSpecificPrimitives.addAll(Arrays.asList("Any", "Byte", "ByteArray", "Short", "Int", "Long", "Float", "Double", "Boolean", "Char", "String", "Array", "List", "Map", "Set"));
        this.addOption(TITLE, "server title name or client service name", this.title);
        this.addOption(BASE_PACKAGE, "base package (invokerPackage) for generated code", this.basePackage);
        this.addOption(SERVER_PORT, "configuration the port in which the sever is to run on", this.serverPort);
        this.addOption("modelPackage", "model package for generated code", this.modelPackage);
        this.addOption("apiPackage", "api package for generated code", this.apiPackage);
        this.addSwitch(EXCEPTION_HANDLER, "generate default global exception handlers", this.exceptionHandler);
        this.addSwitch(GRADLE_BUILD_FILE, "generate a gradle build file using the Kotlin DSL", this.gradleBuildFile);
        this.addSwitch(SWAGGER_ANNOTATIONS, "generate swagger annotations to go alongside controllers and models", this.swaggerAnnotations);
        this.addSwitch(SERVICE_INTERFACE, "generate service interfaces to go alongside controllers. In most cases this option would be used to update an existing project, so not to override implementations. Useful to help facilitate the generation gap pattern", this.serviceInterface);
        this.addSwitch(SERVICE_IMPLEMENTATION, "generate stub service implementations that extends service interfaces. If this is set to true service interfaces will also be generated", this.serviceImplementation);
        this.addSwitch("useBeanValidation", "Use BeanValidation API annotations to validate data types", this.useBeanValidation);
        this.supportedLibraries.put(SPRING_BOOT, "Spring-boot Server application.");
        this.setLibrary(SPRING_BOOT);
        CliOption cliOpt = new CliOption("library", "library template (sub-template) to use");
        cliOpt.setDefault(SPRING_BOOT);
        cliOpt.setEnum(this.supportedLibraries);
        this.cliOptions.add(cliOpt);
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(boolean exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean getGradleBuildFile() {
        return this.gradleBuildFile;
    }

    public void setGradleBuildFile(boolean gradleBuildFile) {
        this.gradleBuildFile = gradleBuildFile;
    }

    public boolean getSwaggerAnnotations() {
        return this.swaggerAnnotations;
    }

    public void setSwaggerAnnotations(boolean swaggerAnnotations) {
        this.swaggerAnnotations = swaggerAnnotations;
    }

    public boolean getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(boolean serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public boolean getServiceImplementation() {
        return this.serviceImplementation;
    }

    public void setServiceImplementation(boolean serviceImplementation) {
        this.serviceImplementation = serviceImplementation;
    }

    public boolean getUseBeanValidation() {
        return this.useBeanValidation;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "kotlin-spring";
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin Spring application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        if (!this.additionalProperties.containsKey("library")) {
            this.additionalProperties.put("library", this.library);
        }
        if (!this.additionalProperties.containsKey(BASE_PACKAGE) && this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            LOGGER.info("Set base package to invoker package (" + this.basePackage + ")");
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        if (this.additionalProperties.containsKey(SERVER_PORT)) {
            this.setServerPort((String)this.additionalProperties.get(SERVER_PORT));
        } else {
            this.additionalProperties.put(SERVER_PORT, this.serverPort);
        }
        if (this.additionalProperties.containsKey(EXCEPTION_HANDLER)) {
            this.setExceptionHandler(Boolean.valueOf(this.additionalProperties.get(EXCEPTION_HANDLER).toString()));
        }
        this.writePropertyBack(EXCEPTION_HANDLER, this.exceptionHandler);
        if (this.additionalProperties.containsKey(GRADLE_BUILD_FILE)) {
            this.setGradleBuildFile(Boolean.valueOf(this.additionalProperties.get(GRADLE_BUILD_FILE).toString()));
        }
        this.writePropertyBack(GRADLE_BUILD_FILE, this.gradleBuildFile);
        if (this.additionalProperties.containsKey(SWAGGER_ANNOTATIONS)) {
            this.setSwaggerAnnotations(Boolean.valueOf(this.additionalProperties.get(SWAGGER_ANNOTATIONS).toString()));
        }
        this.writePropertyBack(SWAGGER_ANNOTATIONS, this.swaggerAnnotations);
        if (this.additionalProperties.containsKey(SERVICE_INTERFACE)) {
            this.setServiceInterface(Boolean.valueOf(this.additionalProperties.get(SERVICE_INTERFACE).toString()));
        }
        this.writePropertyBack(SERVICE_INTERFACE, this.serviceInterface);
        if (this.additionalProperties.containsKey(SERVICE_IMPLEMENTATION)) {
            this.setServiceImplementation(Boolean.valueOf(this.additionalProperties.get(SERVICE_IMPLEMENTATION).toString()));
        }
        this.writePropertyBack(SERVICE_IMPLEMENTATION, this.serviceImplementation);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (this.serviceInterface) {
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
        } else if (this.serviceImplementation) {
            LOGGER.warn("If you set `serviceImplementation` to true, `serviceInterface` will also be set to true");
            this.additionalProperties.put(SERVICE_INTERFACE, true);
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
            this.apiTemplateFiles.put("serviceImpl.mustache", "ServiceImpl.kt");
        }
        if (this.exceptionHandler) {
            this.supportingFiles.add(new SupportingFile("exceptions.mustache", KotlinSpringServerCodegen.sanitizeDirectory(this.sourceFolder + File.separator + this.apiPackage), "Exceptions.kt"));
        }
        if (this.library.equals(SPRING_BOOT)) {
            LOGGER.info("Setup code generator for Kotlin Spring Boot");
            this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            if (this.gradleBuildFile) {
                this.supportingFiles.add(new SupportingFile("buildGradleKts.mustache", "", "build.gradle.kts"));
                this.supportingFiles.add(new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
            }
            this.supportingFiles.add(new SupportingFile("application.mustache", this.resourceFolder, "application.yaml"));
            this.supportingFiles.add(new SupportingFile("springBootApplication.mustache", KotlinSpringServerCodegen.sanitizeDirectory(this.sourceFolder + File.separator + this.basePackage), "Application.kt"));
        }
        this.addMustacheLambdas(this.additionalProperties);
        this.additionalProperties.put("jackson", "true");
    }

    private void addMustacheLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"escapeDoubleQuote", (Object)new EscapeLambda("\"", "\\\"")).build();
        if (objs.containsKey(LAMBDA)) {
            LOGGER.warn("The lambda property is a reserved word, and will be overwritten!");
        }
        objs.put(LAMBDA, lambdas);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase(Locale.ROOT).endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = StringUtils.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI);
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, 8080));
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
        if (model.discriminator != null && this.additionalProperties.containsKey("jackson")) {
            model.imports.addAll(Arrays.asList("JsonSubTypes", "JsonTypeInfo"));
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        models.stream().map(mo -> (Map)mo).map(mo -> (CodegenModel)mo.get("model")).filter(cm -> Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null).forEach(cm -> {
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        });
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            ops.forEach(operation -> {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    responses.forEach(resp -> {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner((CodegenResponse)resp){
                            final /* synthetic */ CodegenResponse val$resp;
                            {
                                this.val$resp = codegenResponse;
                            }

                            @Override
                            public void setReturnType(String returnType) {
                                this.val$resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                this.val$resp.containerType = returnContainer;
                            }
                        });
                    });
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner((CodegenOperation)operation){
                    final /* synthetic */ CodegenOperation val$operation;
                    {
                        this.val$operation = codegenOperation;
                    }

                    @Override
                    public void setReturnType(String returnType) {
                        this.val$operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        this.val$operation.returnContainer = returnContainer;
                    }
                });
            });
        }
        return objs;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        if (returnType == null) {
            dataTypeAssigner.setReturnType("Unit");
        } else if (returnType.startsWith("List")) {
            int end2 = returnType.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (returnType.startsWith("Map") && (end = returnType.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(returnType.substring("Map<".length(), end).split(",")[1].trim());
            dataTypeAssigner.setReturnContainer("Map");
        }
    }

    private static String sanitizeDirectory(String in) {
        return in.replace(".", File.separator);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        CodegenModel m = super.fromModel(name, schema, allDefinitions);
        m.optionalVars = m.optionalVars.stream().distinct().collect(Collectors.toList());
        m.allVars.stream().filter(p -> !m.vars.contains(p)).forEach(p -> {
            p.isInherited = true;
        });
        return m;
    }

    private static class EscapeLambda
    implements Mustache.Lambda {
        private String from;
        private String to;

        EscapeLambda(String from, String to) {
            this.from = from;
            this.to = Matcher.quoteReplacement(to);
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replaceAll(this.from, this.to));
        }
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

