/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.online.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConfigLoader;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.online.api.GenApiDelegate;
import org.openapitools.codegen.online.model.Generated;
import org.openapitools.codegen.online.model.GeneratorInput;
import org.openapitools.codegen.online.model.ResponseCode;
import org.openapitools.codegen.online.service.Generator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class GenApiService
implements GenApiDelegate {
    private static List<String> clients = new ArrayList();
    private static List<String> servers = new ArrayList();
    private static Map<String, Generated> fileMap = new HashMap();
    @Autowired
    private NativeWebRequest request;

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<Resource> downloadFile(String fileId) {
        ByteArrayResource resource;
        Generated g = (Generated)fileMap.get(fileId);
        System.out.println("looking for fileId " + fileId);
        System.out.println("got filename " + g.getFilename());
        File file = new File(g.getFilename());
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        try {
            resource = new ByteArrayResource(Files.readAllBytes(path));
        }
        catch (FileNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "File not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "I/O error while reading file", (Throwable)e);
        }
        try {
            FileUtils.deleteDirectory((File)file.getParentFile());
        }
        catch (IOException e) {
            System.out.println("failed to delete file " + file.getAbsolutePath());
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.valueOf((String)"application/zip")).header("Content-Disposition", new String[]{"attachment; filename=\"" + g.getFriendlyName() + "-generated.zip\""})).header("Accept-Range", new String[]{"bytes"})).body((Object)resource);
    }

    public ResponseEntity<ResponseCode> generateClient(String language, GeneratorInput generatorInput) {
        String filename = Generator.generateClient((String)language, (GeneratorInput)generatorInput);
        return this.getResponse(filename, language + "-client");
    }

    public ResponseEntity<Map<String, CliOption>> getClientOptions(String language) {
        Map opts = Generator.getOptions((String)language);
        if (opts != null) {
            return ResponseEntity.ok().body((Object)opts);
        }
        return ResponseEntity.notFound().build();
    }

    public ResponseEntity<Map<String, CliOption>> getServerOptions(String framework) {
        Map opts = Generator.getOptions((String)framework);
        if (opts != null) {
            return ResponseEntity.ok().body((Object)opts);
        }
        return ResponseEntity.notFound().build();
    }

    public ResponseEntity<List<String>> clientOptions() {
        return ResponseEntity.ok().body((Object)clients);
    }

    public ResponseEntity<List<String>> serverOptions() {
        return ResponseEntity.ok().body((Object)servers);
    }

    public ResponseEntity<ResponseCode> generateServerForLanguage(String framework, GeneratorInput generatorInput) {
        if (framework == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Framework is required");
        }
        String filename = Generator.generateServer((String)framework, (GeneratorInput)generatorInput);
        System.out.println("generated name: " + filename);
        return this.getResponse(filename, framework + "-server");
    }

    private ResponseEntity<ResponseCode> getResponse(String filename, String friendlyName) {
        String host = System.getenv("GENERATOR_HOST");
        Object uriBuilder = !StringUtils.isBlank((CharSequence)host) ? UriComponentsBuilder.fromUriString((String)host) : ServletUriComponentsBuilder.fromCurrentContextPath();
        if (filename != null) {
            String code = UUID.randomUUID().toString();
            Generated g = new Generated();
            g.setFilename(filename);
            g.setFriendlyName(friendlyName);
            fileMap.put(code, g);
            System.out.println(code + ", " + filename);
            String link = uriBuilder.path("/api/gen/download/").path(code).toUriString();
            return ResponseEntity.ok().body((Object)new ResponseCode(code, link));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    static {
        List extensions = CodegenConfigLoader.getAll();
        for (CodegenConfig config : extensions) {
            if (config.getTag().equals((Object)CodegenType.CLIENT) || config.getTag().equals((Object)CodegenType.DOCUMENTATION)) {
                clients.add(config.getName());
                continue;
            }
            if (!config.getTag().equals((Object)CodegenType.SERVER)) continue;
            servers.add(config.getName());
        }
        clients.sort(String.CASE_INSENSITIVE_ORDER);
        servers.sort(String.CASE_INSENSITIVE_ORDER);
    }
}

