/**
 * Copyright (C) 2014 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Portions of this code are modifications based on work created and shared by Google:
 * 
 *  http://code.google.com/policies.html
 *
 * and used according to terms described in the Creative Commons 3.0 Attribution License:
 *
 *   http://creativecommons.org/licenses/by/3.0/
 *  
 * Specifically, the gtfs-realtime.proto:
 *
 *   http://code.google.com/transit/realtime/docs/gtfs-realtime_proto.html
 *
 * was used to generate this source file.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: com/google/transit/realtime/gtfs-realtime-NYCT.proto

package com.google.transit.realtime;

public final class GtfsRealtimeNYCT {
  private GtfsRealtimeNYCT() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(com.google.transit.realtime.GtfsRealtimeNYCT.nyctFeedHeader);
    registry.add(com.google.transit.realtime.GtfsRealtimeNYCT.nyctTripDescriptor);
    registry.add(com.google.transit.realtime.GtfsRealtimeNYCT.nyctStopTimeUpdate);
  }
  public interface TripReplacementPeriodOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string route_id = 1;
    /**
     * <code>optional string route_id = 1;</code>
     *
     * <pre>
     * The replacement period is for this route
     * </pre>
     */
    boolean hasRouteId();
    /**
     * <code>optional string route_id = 1;</code>
     *
     * <pre>
     * The replacement period is for this route
     * </pre>
     */
    java.lang.String getRouteId();
    /**
     * <code>optional string route_id = 1;</code>
     *
     * <pre>
     * The replacement period is for this route
     * </pre>
     */
    com.google.protobuf.ByteString
        getRouteIdBytes();

    // optional .transit_realtime.TimeRange replacement_period = 2;
    /**
     * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
     *
     * <pre>
     * The start time is omitted, the end time is currently now + 30 minutes for
     * all routes of the A division
     * </pre>
     */
    boolean hasReplacementPeriod();
    /**
     * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
     *
     * <pre>
     * The start time is omitted, the end time is currently now + 30 minutes for
     * all routes of the A division
     * </pre>
     */
    com.google.transit.realtime.GtfsRealtime.TimeRange getReplacementPeriod();
    /**
     * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
     *
     * <pre>
     * The start time is omitted, the end time is currently now + 30 minutes for
     * all routes of the A division
     * </pre>
     */
    com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder getReplacementPeriodOrBuilder();
  }
  /**
   * Protobuf type {@code transit_realtime.TripReplacementPeriod}
   */
  public static final class TripReplacementPeriod extends
      com.google.protobuf.GeneratedMessage
      implements TripReplacementPeriodOrBuilder {
    // Use TripReplacementPeriod.newBuilder() to construct.
    private TripReplacementPeriod(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private TripReplacementPeriod(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final TripReplacementPeriod defaultInstance;
    public static TripReplacementPeriod getDefaultInstance() {
      return defaultInstance;
    }

    public TripReplacementPeriod getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private TripReplacementPeriod(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              routeId_ = input.readBytes();
              break;
            }
            case 18: {
              com.google.transit.realtime.GtfsRealtime.TimeRange.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = replacementPeriod_.toBuilder();
              }
              replacementPeriod_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TimeRange.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(replacementPeriod_);
                replacementPeriod_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_TripReplacementPeriod_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_TripReplacementPeriod_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.class, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder.class);
    }

    public static com.google.protobuf.Parser<TripReplacementPeriod> PARSER =
        new com.google.protobuf.AbstractParser<TripReplacementPeriod>() {
      public TripReplacementPeriod parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TripReplacementPeriod(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<TripReplacementPeriod> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string route_id = 1;
    public static final int ROUTE_ID_FIELD_NUMBER = 1;
    private java.lang.Object routeId_;
    /**
     * <code>optional string route_id = 1;</code>
     *
     * <pre>
     * The replacement period is for this route
     * </pre>
     */
    public boolean hasRouteId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string route_id = 1;</code>
     *
     * <pre>
     * The replacement period is for this route
     * </pre>
     */
    public java.lang.String getRouteId() {
      java.lang.Object ref = routeId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          routeId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string route_id = 1;</code>
     *
     * <pre>
     * The replacement period is for this route
     * </pre>
     */
    public com.google.protobuf.ByteString
        getRouteIdBytes() {
      java.lang.Object ref = routeId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        routeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional .transit_realtime.TimeRange replacement_period = 2;
    public static final int REPLACEMENT_PERIOD_FIELD_NUMBER = 2;
    private com.google.transit.realtime.GtfsRealtime.TimeRange replacementPeriod_;
    /**
     * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
     *
     * <pre>
     * The start time is omitted, the end time is currently now + 30 minutes for
     * all routes of the A division
     * </pre>
     */
    public boolean hasReplacementPeriod() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
     *
     * <pre>
     * The start time is omitted, the end time is currently now + 30 minutes for
     * all routes of the A division
     * </pre>
     */
    public com.google.transit.realtime.GtfsRealtime.TimeRange getReplacementPeriod() {
      return replacementPeriod_;
    }
    /**
     * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
     *
     * <pre>
     * The start time is omitted, the end time is currently now + 30 minutes for
     * all routes of the A division
     * </pre>
     */
    public com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder getReplacementPeriodOrBuilder() {
      return replacementPeriod_;
    }

    private void initFields() {
      routeId_ = "";
      replacementPeriod_ = com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (hasReplacementPeriod()) {
        if (!getReplacementPeriod().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getRouteIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, replacementPeriod_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getRouteIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, replacementPeriod_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code transit_realtime.TripReplacementPeriod}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_TripReplacementPeriod_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_TripReplacementPeriod_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.class, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getReplacementPeriodFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        routeId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (replacementPeriodBuilder_ == null) {
          replacementPeriod_ = com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance();
        } else {
          replacementPeriodBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_TripReplacementPeriod_descriptor;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.getDefaultInstance();
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod build() {
        com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod buildPartial() {
        com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod result = new com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.routeId_ = routeId_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (replacementPeriodBuilder_ == null) {
          result.replacementPeriod_ = replacementPeriod_;
        } else {
          result.replacementPeriod_ = replacementPeriodBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod other) {
        if (other == com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.getDefaultInstance()) return this;
        if (other.hasRouteId()) {
          bitField0_ |= 0x00000001;
          routeId_ = other.routeId_;
          onChanged();
        }
        if (other.hasReplacementPeriod()) {
          mergeReplacementPeriod(other.getReplacementPeriod());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (hasReplacementPeriod()) {
          if (!getReplacementPeriod().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string route_id = 1;
      private java.lang.Object routeId_ = "";
      /**
       * <code>optional string route_id = 1;</code>
       *
       * <pre>
       * The replacement period is for this route
       * </pre>
       */
      public boolean hasRouteId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string route_id = 1;</code>
       *
       * <pre>
       * The replacement period is for this route
       * </pre>
       */
      public java.lang.String getRouteId() {
        java.lang.Object ref = routeId_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          routeId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string route_id = 1;</code>
       *
       * <pre>
       * The replacement period is for this route
       * </pre>
       */
      public com.google.protobuf.ByteString
          getRouteIdBytes() {
        java.lang.Object ref = routeId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          routeId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string route_id = 1;</code>
       *
       * <pre>
       * The replacement period is for this route
       * </pre>
       */
      public Builder setRouteId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        routeId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string route_id = 1;</code>
       *
       * <pre>
       * The replacement period is for this route
       * </pre>
       */
      public Builder clearRouteId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        routeId_ = getDefaultInstance().getRouteId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string route_id = 1;</code>
       *
       * <pre>
       * The replacement period is for this route
       * </pre>
       */
      public Builder setRouteIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        routeId_ = value;
        onChanged();
        return this;
      }

      // optional .transit_realtime.TimeRange replacement_period = 2;
      private com.google.transit.realtime.GtfsRealtime.TimeRange replacementPeriod_ = com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.google.transit.realtime.GtfsRealtime.TimeRange, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder, com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> replacementPeriodBuilder_;
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public boolean hasReplacementPeriod() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRange getReplacementPeriod() {
        if (replacementPeriodBuilder_ == null) {
          return replacementPeriod_;
        } else {
          return replacementPeriodBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public Builder setReplacementPeriod(com.google.transit.realtime.GtfsRealtime.TimeRange value) {
        if (replacementPeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          replacementPeriod_ = value;
          onChanged();
        } else {
          replacementPeriodBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public Builder setReplacementPeriod(
          com.google.transit.realtime.GtfsRealtime.TimeRange.Builder builderForValue) {
        if (replacementPeriodBuilder_ == null) {
          replacementPeriod_ = builderForValue.build();
          onChanged();
        } else {
          replacementPeriodBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public Builder mergeReplacementPeriod(com.google.transit.realtime.GtfsRealtime.TimeRange value) {
        if (replacementPeriodBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              replacementPeriod_ != com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance()) {
            replacementPeriod_ =
              com.google.transit.realtime.GtfsRealtime.TimeRange.newBuilder(replacementPeriod_).mergeFrom(value).buildPartial();
          } else {
            replacementPeriod_ = value;
          }
          onChanged();
        } else {
          replacementPeriodBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public Builder clearReplacementPeriod() {
        if (replacementPeriodBuilder_ == null) {
          replacementPeriod_ = com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance();
          onChanged();
        } else {
          replacementPeriodBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRange.Builder getReplacementPeriodBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getReplacementPeriodFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder getReplacementPeriodOrBuilder() {
        if (replacementPeriodBuilder_ != null) {
          return replacementPeriodBuilder_.getMessageOrBuilder();
        } else {
          return replacementPeriod_;
        }
      }
      /**
       * <code>optional .transit_realtime.TimeRange replacement_period = 2;</code>
       *
       * <pre>
       * The start time is omitted, the end time is currently now + 30 minutes for
       * all routes of the A division
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.google.transit.realtime.GtfsRealtime.TimeRange, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder, com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> 
          getReplacementPeriodFieldBuilder() {
        if (replacementPeriodBuilder_ == null) {
          replacementPeriodBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.google.transit.realtime.GtfsRealtime.TimeRange, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder, com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder>(
                  replacementPeriod_,
                  getParentForChildren(),
                  isClean());
          replacementPeriod_ = null;
        }
        return replacementPeriodBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:transit_realtime.TripReplacementPeriod)
    }

    static {
      defaultInstance = new TripReplacementPeriod(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.TripReplacementPeriod)
  }

  public interface NyctFeedHeaderOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string nyct_subway_version = 1;
    /**
     * <code>required string nyct_subway_version = 1;</code>
     *
     * <pre>
     * Version of the NYCT Subway extensions
     * The current version is 1.0
     * </pre>
     */
    boolean hasNyctSubwayVersion();
    /**
     * <code>required string nyct_subway_version = 1;</code>
     *
     * <pre>
     * Version of the NYCT Subway extensions
     * The current version is 1.0
     * </pre>
     */
    java.lang.String getNyctSubwayVersion();
    /**
     * <code>required string nyct_subway_version = 1;</code>
     *
     * <pre>
     * Version of the NYCT Subway extensions
     * The current version is 1.0
     * </pre>
     */
    com.google.protobuf.ByteString
        getNyctSubwayVersionBytes();

    // repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    java.util.List<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod> 
        getTripReplacementPeriodList();
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod getTripReplacementPeriod(int index);
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    int getTripReplacementPeriodCount();
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    java.util.List<? extends com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder> 
        getTripReplacementPeriodOrBuilderList();
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder getTripReplacementPeriodOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code transit_realtime.NyctFeedHeader}
   *
   * <pre>
   * NYCT Subway extensions for the feed header
   * </pre>
   */
  public static final class NyctFeedHeader extends
      com.google.protobuf.GeneratedMessage
      implements NyctFeedHeaderOrBuilder {
    // Use NyctFeedHeader.newBuilder() to construct.
    private NyctFeedHeader(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private NyctFeedHeader(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final NyctFeedHeader defaultInstance;
    public static NyctFeedHeader getDefaultInstance() {
      return defaultInstance;
    }

    public NyctFeedHeader getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private NyctFeedHeader(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              nyctSubwayVersion_ = input.readBytes();
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                tripReplacementPeriod_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod>();
                mutable_bitField0_ |= 0x00000002;
              }
              tripReplacementPeriod_.add(input.readMessage(com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          tripReplacementPeriod_ = java.util.Collections.unmodifiableList(tripReplacementPeriod_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctFeedHeader_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctFeedHeader_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.class, com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.Builder.class);
    }

    public static com.google.protobuf.Parser<NyctFeedHeader> PARSER =
        new com.google.protobuf.AbstractParser<NyctFeedHeader>() {
      public NyctFeedHeader parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new NyctFeedHeader(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<NyctFeedHeader> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string nyct_subway_version = 1;
    public static final int NYCT_SUBWAY_VERSION_FIELD_NUMBER = 1;
    private java.lang.Object nyctSubwayVersion_;
    /**
     * <code>required string nyct_subway_version = 1;</code>
     *
     * <pre>
     * Version of the NYCT Subway extensions
     * The current version is 1.0
     * </pre>
     */
    public boolean hasNyctSubwayVersion() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string nyct_subway_version = 1;</code>
     *
     * <pre>
     * Version of the NYCT Subway extensions
     * The current version is 1.0
     * </pre>
     */
    public java.lang.String getNyctSubwayVersion() {
      java.lang.Object ref = nyctSubwayVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          nyctSubwayVersion_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string nyct_subway_version = 1;</code>
     *
     * <pre>
     * Version of the NYCT Subway extensions
     * The current version is 1.0
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNyctSubwayVersionBytes() {
      java.lang.Object ref = nyctSubwayVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        nyctSubwayVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;
    public static final int TRIP_REPLACEMENT_PERIOD_FIELD_NUMBER = 2;
    private java.util.List<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod> tripReplacementPeriod_;
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    public java.util.List<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod> getTripReplacementPeriodList() {
      return tripReplacementPeriod_;
    }
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    public java.util.List<? extends com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder> 
        getTripReplacementPeriodOrBuilderList() {
      return tripReplacementPeriod_;
    }
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    public int getTripReplacementPeriodCount() {
      return tripReplacementPeriod_.size();
    }
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod getTripReplacementPeriod(int index) {
      return tripReplacementPeriod_.get(index);
    }
    /**
     * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
     *
     * <pre>
     * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
     * trip within the trip_replacement_period. 
     * This feed is a full dataset, it contains all trips starting 
     * in the trip_replacement_period. If a trip from the static GTFS is not
     * found in the GTFS-realtime feed, it should be considered as cancelled.
     * The replacement period can be different for each route, so here is 
     * a list of the routes where the trips in the feed replace all 
     * scheduled trips within the replacement period.
     * </pre>
     */
    public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder getTripReplacementPeriodOrBuilder(
        int index) {
      return tripReplacementPeriod_.get(index);
    }

    private void initFields() {
      nyctSubwayVersion_ = "";
      tripReplacementPeriod_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasNyctSubwayVersion()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getTripReplacementPeriodCount(); i++) {
        if (!getTripReplacementPeriod(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNyctSubwayVersionBytes());
      }
      for (int i = 0; i < tripReplacementPeriod_.size(); i++) {
        output.writeMessage(2, tripReplacementPeriod_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNyctSubwayVersionBytes());
      }
      for (int i = 0; i < tripReplacementPeriod_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, tripReplacementPeriod_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code transit_realtime.NyctFeedHeader}
     *
     * <pre>
     * NYCT Subway extensions for the feed header
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeaderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctFeedHeader_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctFeedHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.class, com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getTripReplacementPeriodFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        nyctSubwayVersion_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (tripReplacementPeriodBuilder_ == null) {
          tripReplacementPeriod_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          tripReplacementPeriodBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctFeedHeader_descriptor;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.getDefaultInstance();
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader build() {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader buildPartial() {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader result = new com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.nyctSubwayVersion_ = nyctSubwayVersion_;
        if (tripReplacementPeriodBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            tripReplacementPeriod_ = java.util.Collections.unmodifiableList(tripReplacementPeriod_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.tripReplacementPeriod_ = tripReplacementPeriod_;
        } else {
          result.tripReplacementPeriod_ = tripReplacementPeriodBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader other) {
        if (other == com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.getDefaultInstance()) return this;
        if (other.hasNyctSubwayVersion()) {
          bitField0_ |= 0x00000001;
          nyctSubwayVersion_ = other.nyctSubwayVersion_;
          onChanged();
        }
        if (tripReplacementPeriodBuilder_ == null) {
          if (!other.tripReplacementPeriod_.isEmpty()) {
            if (tripReplacementPeriod_.isEmpty()) {
              tripReplacementPeriod_ = other.tripReplacementPeriod_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTripReplacementPeriodIsMutable();
              tripReplacementPeriod_.addAll(other.tripReplacementPeriod_);
            }
            onChanged();
          }
        } else {
          if (!other.tripReplacementPeriod_.isEmpty()) {
            if (tripReplacementPeriodBuilder_.isEmpty()) {
              tripReplacementPeriodBuilder_.dispose();
              tripReplacementPeriodBuilder_ = null;
              tripReplacementPeriod_ = other.tripReplacementPeriod_;
              bitField0_ = (bitField0_ & ~0x00000002);
              tripReplacementPeriodBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getTripReplacementPeriodFieldBuilder() : null;
            } else {
              tripReplacementPeriodBuilder_.addAllMessages(other.tripReplacementPeriod_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasNyctSubwayVersion()) {
          
          return false;
        }
        for (int i = 0; i < getTripReplacementPeriodCount(); i++) {
          if (!getTripReplacementPeriod(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string nyct_subway_version = 1;
      private java.lang.Object nyctSubwayVersion_ = "";
      /**
       * <code>required string nyct_subway_version = 1;</code>
       *
       * <pre>
       * Version of the NYCT Subway extensions
       * The current version is 1.0
       * </pre>
       */
      public boolean hasNyctSubwayVersion() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string nyct_subway_version = 1;</code>
       *
       * <pre>
       * Version of the NYCT Subway extensions
       * The current version is 1.0
       * </pre>
       */
      public java.lang.String getNyctSubwayVersion() {
        java.lang.Object ref = nyctSubwayVersion_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          nyctSubwayVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string nyct_subway_version = 1;</code>
       *
       * <pre>
       * Version of the NYCT Subway extensions
       * The current version is 1.0
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNyctSubwayVersionBytes() {
        java.lang.Object ref = nyctSubwayVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          nyctSubwayVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string nyct_subway_version = 1;</code>
       *
       * <pre>
       * Version of the NYCT Subway extensions
       * The current version is 1.0
       * </pre>
       */
      public Builder setNyctSubwayVersion(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        nyctSubwayVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string nyct_subway_version = 1;</code>
       *
       * <pre>
       * Version of the NYCT Subway extensions
       * The current version is 1.0
       * </pre>
       */
      public Builder clearNyctSubwayVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        nyctSubwayVersion_ = getDefaultInstance().getNyctSubwayVersion();
        onChanged();
        return this;
      }
      /**
       * <code>required string nyct_subway_version = 1;</code>
       *
       * <pre>
       * Version of the NYCT Subway extensions
       * The current version is 1.0
       * </pre>
       */
      public Builder setNyctSubwayVersionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        nyctSubwayVersion_ = value;
        onChanged();
        return this;
      }

      // repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;
      private java.util.List<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod> tripReplacementPeriod_ =
        java.util.Collections.emptyList();
      private void ensureTripReplacementPeriodIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          tripReplacementPeriod_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod>(tripReplacementPeriod_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder> tripReplacementPeriodBuilder_;

      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod> getTripReplacementPeriodList() {
        if (tripReplacementPeriodBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tripReplacementPeriod_);
        } else {
          return tripReplacementPeriodBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public int getTripReplacementPeriodCount() {
        if (tripReplacementPeriodBuilder_ == null) {
          return tripReplacementPeriod_.size();
        } else {
          return tripReplacementPeriodBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod getTripReplacementPeriod(int index) {
        if (tripReplacementPeriodBuilder_ == null) {
          return tripReplacementPeriod_.get(index);
        } else {
          return tripReplacementPeriodBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder setTripReplacementPeriod(
          int index, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod value) {
        if (tripReplacementPeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.set(index, value);
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder setTripReplacementPeriod(
          int index, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder builderForValue) {
        if (tripReplacementPeriodBuilder_ == null) {
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.set(index, builderForValue.build());
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder addTripReplacementPeriod(com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod value) {
        if (tripReplacementPeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.add(value);
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder addTripReplacementPeriod(
          int index, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod value) {
        if (tripReplacementPeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.add(index, value);
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder addTripReplacementPeriod(
          com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder builderForValue) {
        if (tripReplacementPeriodBuilder_ == null) {
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.add(builderForValue.build());
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder addTripReplacementPeriod(
          int index, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder builderForValue) {
        if (tripReplacementPeriodBuilder_ == null) {
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.add(index, builderForValue.build());
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder addAllTripReplacementPeriod(
          java.lang.Iterable<? extends com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod> values) {
        if (tripReplacementPeriodBuilder_ == null) {
          ensureTripReplacementPeriodIsMutable();
          super.addAll(values, tripReplacementPeriod_);
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder clearTripReplacementPeriod() {
        if (tripReplacementPeriodBuilder_ == null) {
          tripReplacementPeriod_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public Builder removeTripReplacementPeriod(int index) {
        if (tripReplacementPeriodBuilder_ == null) {
          ensureTripReplacementPeriodIsMutable();
          tripReplacementPeriod_.remove(index);
          onChanged();
        } else {
          tripReplacementPeriodBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder getTripReplacementPeriodBuilder(
          int index) {
        return getTripReplacementPeriodFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder getTripReplacementPeriodOrBuilder(
          int index) {
        if (tripReplacementPeriodBuilder_ == null) {
          return tripReplacementPeriod_.get(index);  } else {
          return tripReplacementPeriodBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public java.util.List<? extends com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder> 
           getTripReplacementPeriodOrBuilderList() {
        if (tripReplacementPeriodBuilder_ != null) {
          return tripReplacementPeriodBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tripReplacementPeriod_);
        }
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder addTripReplacementPeriodBuilder() {
        return getTripReplacementPeriodFieldBuilder().addBuilder(
            com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.getDefaultInstance());
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder addTripReplacementPeriodBuilder(
          int index) {
        return getTripReplacementPeriodFieldBuilder().addBuilder(
            index, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.getDefaultInstance());
      }
      /**
       * <code>repeated .transit_realtime.TripReplacementPeriod trip_replacement_period = 2;</code>
       *
       * <pre>
       * For the NYCT Subway, the GTFS-realtime feed replaces any scheduled
       * trip within the trip_replacement_period. 
       * This feed is a full dataset, it contains all trips starting 
       * in the trip_replacement_period. If a trip from the static GTFS is not
       * found in the GTFS-realtime feed, it should be considered as cancelled.
       * The replacement period can be different for each route, so here is 
       * a list of the routes where the trips in the feed replace all 
       * scheduled trips within the replacement period.
       * </pre>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder> 
           getTripReplacementPeriodBuilderList() {
        return getTripReplacementPeriodFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder> 
          getTripReplacementPeriodFieldBuilder() {
        if (tripReplacementPeriodBuilder_ == null) {
          tripReplacementPeriodBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriod.Builder, com.google.transit.realtime.GtfsRealtimeNYCT.TripReplacementPeriodOrBuilder>(
                  tripReplacementPeriod_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          tripReplacementPeriod_ = null;
        }
        return tripReplacementPeriodBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:transit_realtime.NyctFeedHeader)
    }

    static {
      defaultInstance = new NyctFeedHeader(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.NyctFeedHeader)
  }

  public interface NyctTripDescriptorOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string train_id = 1;
    /**
     * <code>optional string train_id = 1;</code>
     *
     * <pre>
     * The nyct_train_id is meant for internal use only. It provides an
     * easy way to associated GTFS-realtime trip identifiers with NYCT rail
     * operations identifier 
     * 
     * The ATS office system assigns unique train identification (Train ID) to
     * each train operating within or ready to enter the mainline of the
     * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
     * as follows: 
     * 
     * The first character represents the trip type designator. 0 identifies a
     * scheduled revenue trip. Other revenue trip values that are a result of a
     * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
     * train] also known as shortly lined service.  
     * 
     * The second character 6 represents the trip line i.e. number 6 train The
     * third set of characters identify the decoded origin time. The last
     * character may be blank "on the whole minute" or + "30 seconds" 
     * 
     * Note: Origin times will not change when there is a trip type change.  This
     * is followed by a three character "Origin Location" / "Destination
     * Location"
     * </pre>
     */
    boolean hasTrainId();
    /**
     * <code>optional string train_id = 1;</code>
     *
     * <pre>
     * The nyct_train_id is meant for internal use only. It provides an
     * easy way to associated GTFS-realtime trip identifiers with NYCT rail
     * operations identifier 
     * 
     * The ATS office system assigns unique train identification (Train ID) to
     * each train operating within or ready to enter the mainline of the
     * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
     * as follows: 
     * 
     * The first character represents the trip type designator. 0 identifies a
     * scheduled revenue trip. Other revenue trip values that are a result of a
     * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
     * train] also known as shortly lined service.  
     * 
     * The second character 6 represents the trip line i.e. number 6 train The
     * third set of characters identify the decoded origin time. The last
     * character may be blank "on the whole minute" or + "30 seconds" 
     * 
     * Note: Origin times will not change when there is a trip type change.  This
     * is followed by a three character "Origin Location" / "Destination
     * Location"
     * </pre>
     */
    java.lang.String getTrainId();
    /**
     * <code>optional string train_id = 1;</code>
     *
     * <pre>
     * The nyct_train_id is meant for internal use only. It provides an
     * easy way to associated GTFS-realtime trip identifiers with NYCT rail
     * operations identifier 
     * 
     * The ATS office system assigns unique train identification (Train ID) to
     * each train operating within or ready to enter the mainline of the
     * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
     * as follows: 
     * 
     * The first character represents the trip type designator. 0 identifies a
     * scheduled revenue trip. Other revenue trip values that are a result of a
     * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
     * train] also known as shortly lined service.  
     * 
     * The second character 6 represents the trip line i.e. number 6 train The
     * third set of characters identify the decoded origin time. The last
     * character may be blank "on the whole minute" or + "30 seconds" 
     * 
     * Note: Origin times will not change when there is a trip type change.  This
     * is followed by a three character "Origin Location" / "Destination
     * Location"
     * </pre>
     */
    com.google.protobuf.ByteString
        getTrainIdBytes();

    // optional bool is_assigned = 2;
    /**
     * <code>optional bool is_assigned = 2;</code>
     *
     * <pre>
     * This trip has been assigned to a physical train. If true, this trip is
     * already underway or most likely will depart shortly. 
     *
     * Train Assignment is a function of the Automatic Train Supervision (ATS)
     * office system used by NYCT Rail Operations to monitor and track train
     * movements. ATS provides the ability to "assign" the nyct_train_id
     * attribute when a physical train is at its origin terminal. These assigned
     * trips have the is_assigned field set in the TripDescriptor.
     *
     * When a train is at a terminal but has not been given a work program it is
     * declared unassigned and is tagged as such. Unassigned trains can be moved
     * to a storage location or assigned a nyct_train_id when a determination for
     * service is made.
     * </pre>
     */
    boolean hasIsAssigned();
    /**
     * <code>optional bool is_assigned = 2;</code>
     *
     * <pre>
     * This trip has been assigned to a physical train. If true, this trip is
     * already underway or most likely will depart shortly. 
     *
     * Train Assignment is a function of the Automatic Train Supervision (ATS)
     * office system used by NYCT Rail Operations to monitor and track train
     * movements. ATS provides the ability to "assign" the nyct_train_id
     * attribute when a physical train is at its origin terminal. These assigned
     * trips have the is_assigned field set in the TripDescriptor.
     *
     * When a train is at a terminal but has not been given a work program it is
     * declared unassigned and is tagged as such. Unassigned trains can be moved
     * to a storage location or assigned a nyct_train_id when a determination for
     * service is made.
     * </pre>
     */
    boolean getIsAssigned();

    // optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;
    /**
     * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
     *
     * <pre>
     * Uptown and Bronx-bound trains are moving NORTH.
     * Times Square Shuttle to Grand Central is also northbound.
     *
     * Downtown and Brooklyn-bound trains are moving SOUTH.
     * Times Square Shuttle to Times Square is also southbound.
     * 
     * EAST and WEST are not used currently.
     * </pre>
     */
    boolean hasDirection();
    /**
     * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
     *
     * <pre>
     * Uptown and Bronx-bound trains are moving NORTH.
     * Times Square Shuttle to Grand Central is also northbound.
     *
     * Downtown and Brooklyn-bound trains are moving SOUTH.
     * Times Square Shuttle to Times Square is also southbound.
     * 
     * EAST and WEST are not used currently.
     * </pre>
     */
    com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction getDirection();
  }
  /**
   * Protobuf type {@code transit_realtime.NyctTripDescriptor}
   *
   * <pre>
   * NYCT Subway extensions for the trip descriptor
   * </pre>
   */
  public static final class NyctTripDescriptor extends
      com.google.protobuf.GeneratedMessage
      implements NyctTripDescriptorOrBuilder {
    // Use NyctTripDescriptor.newBuilder() to construct.
    private NyctTripDescriptor(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private NyctTripDescriptor(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final NyctTripDescriptor defaultInstance;
    public static NyctTripDescriptor getDefaultInstance() {
      return defaultInstance;
    }

    public NyctTripDescriptor getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private NyctTripDescriptor(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              trainId_ = input.readBytes();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              isAssigned_ = input.readBool();
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction value = com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000004;
                direction_ = value;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctTripDescriptor_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctTripDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.class, com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Builder.class);
    }

    public static com.google.protobuf.Parser<NyctTripDescriptor> PARSER =
        new com.google.protobuf.AbstractParser<NyctTripDescriptor>() {
      public NyctTripDescriptor parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new NyctTripDescriptor(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<NyctTripDescriptor> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code transit_realtime.NyctTripDescriptor.Direction}
     *
     * <pre>
     * The direction the train is moving. 
     * </pre>
     */
    public enum Direction
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>NORTH = 1;</code>
       */
      NORTH(0, 1),
      /**
       * <code>EAST = 2;</code>
       */
      EAST(1, 2),
      /**
       * <code>SOUTH = 3;</code>
       */
      SOUTH(2, 3),
      /**
       * <code>WEST = 4;</code>
       */
      WEST(3, 4),
      ;

      /**
       * <code>NORTH = 1;</code>
       */
      public static final int NORTH_VALUE = 1;
      /**
       * <code>EAST = 2;</code>
       */
      public static final int EAST_VALUE = 2;
      /**
       * <code>SOUTH = 3;</code>
       */
      public static final int SOUTH_VALUE = 3;
      /**
       * <code>WEST = 4;</code>
       */
      public static final int WEST_VALUE = 4;


      public final int getNumber() { return value; }

      public static Direction valueOf(int value) {
        switch (value) {
          case 1: return NORTH;
          case 2: return EAST;
          case 3: return SOUTH;
          case 4: return WEST;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Direction>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Direction>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
              public Direction findValueByNumber(int number) {
                return Direction.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.getDescriptor().getEnumTypes().get(0);
      }

      private static final Direction[] VALUES = values();

      public static Direction valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Direction(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.NyctTripDescriptor.Direction)
    }

    private int bitField0_;
    // optional string train_id = 1;
    public static final int TRAIN_ID_FIELD_NUMBER = 1;
    private java.lang.Object trainId_;
    /**
     * <code>optional string train_id = 1;</code>
     *
     * <pre>
     * The nyct_train_id is meant for internal use only. It provides an
     * easy way to associated GTFS-realtime trip identifiers with NYCT rail
     * operations identifier 
     * 
     * The ATS office system assigns unique train identification (Train ID) to
     * each train operating within or ready to enter the mainline of the
     * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
     * as follows: 
     * 
     * The first character represents the trip type designator. 0 identifies a
     * scheduled revenue trip. Other revenue trip values that are a result of a
     * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
     * train] also known as shortly lined service.  
     * 
     * The second character 6 represents the trip line i.e. number 6 train The
     * third set of characters identify the decoded origin time. The last
     * character may be blank "on the whole minute" or + "30 seconds" 
     * 
     * Note: Origin times will not change when there is a trip type change.  This
     * is followed by a three character "Origin Location" / "Destination
     * Location"
     * </pre>
     */
    public boolean hasTrainId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string train_id = 1;</code>
     *
     * <pre>
     * The nyct_train_id is meant for internal use only. It provides an
     * easy way to associated GTFS-realtime trip identifiers with NYCT rail
     * operations identifier 
     * 
     * The ATS office system assigns unique train identification (Train ID) to
     * each train operating within or ready to enter the mainline of the
     * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
     * as follows: 
     * 
     * The first character represents the trip type designator. 0 identifies a
     * scheduled revenue trip. Other revenue trip values that are a result of a
     * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
     * train] also known as shortly lined service.  
     * 
     * The second character 6 represents the trip line i.e. number 6 train The
     * third set of characters identify the decoded origin time. The last
     * character may be blank "on the whole minute" or + "30 seconds" 
     * 
     * Note: Origin times will not change when there is a trip type change.  This
     * is followed by a three character "Origin Location" / "Destination
     * Location"
     * </pre>
     */
    public java.lang.String getTrainId() {
      java.lang.Object ref = trainId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          trainId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string train_id = 1;</code>
     *
     * <pre>
     * The nyct_train_id is meant for internal use only. It provides an
     * easy way to associated GTFS-realtime trip identifiers with NYCT rail
     * operations identifier 
     * 
     * The ATS office system assigns unique train identification (Train ID) to
     * each train operating within or ready to enter the mainline of the
     * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
     * as follows: 
     * 
     * The first character represents the trip type designator. 0 identifies a
     * scheduled revenue trip. Other revenue trip values that are a result of a
     * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
     * train] also known as shortly lined service.  
     * 
     * The second character 6 represents the trip line i.e. number 6 train The
     * third set of characters identify the decoded origin time. The last
     * character may be blank "on the whole minute" or + "30 seconds" 
     * 
     * Note: Origin times will not change when there is a trip type change.  This
     * is followed by a three character "Origin Location" / "Destination
     * Location"
     * </pre>
     */
    public com.google.protobuf.ByteString
        getTrainIdBytes() {
      java.lang.Object ref = trainId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        trainId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional bool is_assigned = 2;
    public static final int IS_ASSIGNED_FIELD_NUMBER = 2;
    private boolean isAssigned_;
    /**
     * <code>optional bool is_assigned = 2;</code>
     *
     * <pre>
     * This trip has been assigned to a physical train. If true, this trip is
     * already underway or most likely will depart shortly. 
     *
     * Train Assignment is a function of the Automatic Train Supervision (ATS)
     * office system used by NYCT Rail Operations to monitor and track train
     * movements. ATS provides the ability to "assign" the nyct_train_id
     * attribute when a physical train is at its origin terminal. These assigned
     * trips have the is_assigned field set in the TripDescriptor.
     *
     * When a train is at a terminal but has not been given a work program it is
     * declared unassigned and is tagged as such. Unassigned trains can be moved
     * to a storage location or assigned a nyct_train_id when a determination for
     * service is made.
     * </pre>
     */
    public boolean hasIsAssigned() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool is_assigned = 2;</code>
     *
     * <pre>
     * This trip has been assigned to a physical train. If true, this trip is
     * already underway or most likely will depart shortly. 
     *
     * Train Assignment is a function of the Automatic Train Supervision (ATS)
     * office system used by NYCT Rail Operations to monitor and track train
     * movements. ATS provides the ability to "assign" the nyct_train_id
     * attribute when a physical train is at its origin terminal. These assigned
     * trips have the is_assigned field set in the TripDescriptor.
     *
     * When a train is at a terminal but has not been given a work program it is
     * declared unassigned and is tagged as such. Unassigned trains can be moved
     * to a storage location or assigned a nyct_train_id when a determination for
     * service is made.
     * </pre>
     */
    public boolean getIsAssigned() {
      return isAssigned_;
    }

    // optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;
    public static final int DIRECTION_FIELD_NUMBER = 3;
    private com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction direction_;
    /**
     * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
     *
     * <pre>
     * Uptown and Bronx-bound trains are moving NORTH.
     * Times Square Shuttle to Grand Central is also northbound.
     *
     * Downtown and Brooklyn-bound trains are moving SOUTH.
     * Times Square Shuttle to Times Square is also southbound.
     * 
     * EAST and WEST are not used currently.
     * </pre>
     */
    public boolean hasDirection() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
     *
     * <pre>
     * Uptown and Bronx-bound trains are moving NORTH.
     * Times Square Shuttle to Grand Central is also northbound.
     *
     * Downtown and Brooklyn-bound trains are moving SOUTH.
     * Times Square Shuttle to Times Square is also southbound.
     * 
     * EAST and WEST are not used currently.
     * </pre>
     */
    public com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction getDirection() {
      return direction_;
    }

    private void initFields() {
      trainId_ = "";
      isAssigned_ = false;
      direction_ = com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction.NORTH;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getTrainIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBool(2, isAssigned_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeEnum(3, direction_.getNumber());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getTrainIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, isAssigned_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, direction_.getNumber());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code transit_realtime.NyctTripDescriptor}
     *
     * <pre>
     * NYCT Subway extensions for the trip descriptor
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctTripDescriptor_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctTripDescriptor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.class, com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        trainId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        isAssigned_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        direction_ = com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction.NORTH;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctTripDescriptor_descriptor;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.getDefaultInstance();
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor build() {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor buildPartial() {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor result = new com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.trainId_ = trainId_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.isAssigned_ = isAssigned_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.direction_ = direction_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor other) {
        if (other == com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.getDefaultInstance()) return this;
        if (other.hasTrainId()) {
          bitField0_ |= 0x00000001;
          trainId_ = other.trainId_;
          onChanged();
        }
        if (other.hasIsAssigned()) {
          setIsAssigned(other.getIsAssigned());
        }
        if (other.hasDirection()) {
          setDirection(other.getDirection());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string train_id = 1;
      private java.lang.Object trainId_ = "";
      /**
       * <code>optional string train_id = 1;</code>
       *
       * <pre>
       * The nyct_train_id is meant for internal use only. It provides an
       * easy way to associated GTFS-realtime trip identifiers with NYCT rail
       * operations identifier 
       * 
       * The ATS office system assigns unique train identification (Train ID) to
       * each train operating within or ready to enter the mainline of the
       * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
       * as follows: 
       * 
       * The first character represents the trip type designator. 0 identifies a
       * scheduled revenue trip. Other revenue trip values that are a result of a
       * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
       * train] also known as shortly lined service.  
       * 
       * The second character 6 represents the trip line i.e. number 6 train The
       * third set of characters identify the decoded origin time. The last
       * character may be blank "on the whole minute" or + "30 seconds" 
       * 
       * Note: Origin times will not change when there is a trip type change.  This
       * is followed by a three character "Origin Location" / "Destination
       * Location"
       * </pre>
       */
      public boolean hasTrainId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string train_id = 1;</code>
       *
       * <pre>
       * The nyct_train_id is meant for internal use only. It provides an
       * easy way to associated GTFS-realtime trip identifiers with NYCT rail
       * operations identifier 
       * 
       * The ATS office system assigns unique train identification (Train ID) to
       * each train operating within or ready to enter the mainline of the
       * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
       * as follows: 
       * 
       * The first character represents the trip type designator. 0 identifies a
       * scheduled revenue trip. Other revenue trip values that are a result of a
       * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
       * train] also known as shortly lined service.  
       * 
       * The second character 6 represents the trip line i.e. number 6 train The
       * third set of characters identify the decoded origin time. The last
       * character may be blank "on the whole minute" or + "30 seconds" 
       * 
       * Note: Origin times will not change when there is a trip type change.  This
       * is followed by a three character "Origin Location" / "Destination
       * Location"
       * </pre>
       */
      public java.lang.String getTrainId() {
        java.lang.Object ref = trainId_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          trainId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string train_id = 1;</code>
       *
       * <pre>
       * The nyct_train_id is meant for internal use only. It provides an
       * easy way to associated GTFS-realtime trip identifiers with NYCT rail
       * operations identifier 
       * 
       * The ATS office system assigns unique train identification (Train ID) to
       * each train operating within or ready to enter the mainline of the
       * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
       * as follows: 
       * 
       * The first character represents the trip type designator. 0 identifies a
       * scheduled revenue trip. Other revenue trip values that are a result of a
       * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
       * train] also known as shortly lined service.  
       * 
       * The second character 6 represents the trip line i.e. number 6 train The
       * third set of characters identify the decoded origin time. The last
       * character may be blank "on the whole minute" or + "30 seconds" 
       * 
       * Note: Origin times will not change when there is a trip type change.  This
       * is followed by a three character "Origin Location" / "Destination
       * Location"
       * </pre>
       */
      public com.google.protobuf.ByteString
          getTrainIdBytes() {
        java.lang.Object ref = trainId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          trainId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string train_id = 1;</code>
       *
       * <pre>
       * The nyct_train_id is meant for internal use only. It provides an
       * easy way to associated GTFS-realtime trip identifiers with NYCT rail
       * operations identifier 
       * 
       * The ATS office system assigns unique train identification (Train ID) to
       * each train operating within or ready to enter the mainline of the
       * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
       * as follows: 
       * 
       * The first character represents the trip type designator. 0 identifies a
       * scheduled revenue trip. Other revenue trip values that are a result of a
       * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
       * train] also known as shortly lined service.  
       * 
       * The second character 6 represents the trip line i.e. number 6 train The
       * third set of characters identify the decoded origin time. The last
       * character may be blank "on the whole minute" or + "30 seconds" 
       * 
       * Note: Origin times will not change when there is a trip type change.  This
       * is followed by a three character "Origin Location" / "Destination
       * Location"
       * </pre>
       */
      public Builder setTrainId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        trainId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string train_id = 1;</code>
       *
       * <pre>
       * The nyct_train_id is meant for internal use only. It provides an
       * easy way to associated GTFS-realtime trip identifiers with NYCT rail
       * operations identifier 
       * 
       * The ATS office system assigns unique train identification (Train ID) to
       * each train operating within or ready to enter the mainline of the
       * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
       * as follows: 
       * 
       * The first character represents the trip type designator. 0 identifies a
       * scheduled revenue trip. Other revenue trip values that are a result of a
       * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
       * train] also known as shortly lined service.  
       * 
       * The second character 6 represents the trip line i.e. number 6 train The
       * third set of characters identify the decoded origin time. The last
       * character may be blank "on the whole minute" or + "30 seconds" 
       * 
       * Note: Origin times will not change when there is a trip type change.  This
       * is followed by a three character "Origin Location" / "Destination
       * Location"
       * </pre>
       */
      public Builder clearTrainId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        trainId_ = getDefaultInstance().getTrainId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string train_id = 1;</code>
       *
       * <pre>
       * The nyct_train_id is meant for internal use only. It provides an
       * easy way to associated GTFS-realtime trip identifiers with NYCT rail
       * operations identifier 
       * 
       * The ATS office system assigns unique train identification (Train ID) to
       * each train operating within or ready to enter the mainline of the
       * monitored territory. An example of this is 06 0123+ PEL/BBR and is decoded
       * as follows: 
       * 
       * The first character represents the trip type designator. 0 identifies a
       * scheduled revenue trip. Other revenue trip values that are a result of a
       * change to the base schedule include; [= reroute], [/ skip stop], [$ turn
       * train] also known as shortly lined service.  
       * 
       * The second character 6 represents the trip line i.e. number 6 train The
       * third set of characters identify the decoded origin time. The last
       * character may be blank "on the whole minute" or + "30 seconds" 
       * 
       * Note: Origin times will not change when there is a trip type change.  This
       * is followed by a three character "Origin Location" / "Destination
       * Location"
       * </pre>
       */
      public Builder setTrainIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        trainId_ = value;
        onChanged();
        return this;
      }

      // optional bool is_assigned = 2;
      private boolean isAssigned_ ;
      /**
       * <code>optional bool is_assigned = 2;</code>
       *
       * <pre>
       * This trip has been assigned to a physical train. If true, this trip is
       * already underway or most likely will depart shortly. 
       *
       * Train Assignment is a function of the Automatic Train Supervision (ATS)
       * office system used by NYCT Rail Operations to monitor and track train
       * movements. ATS provides the ability to "assign" the nyct_train_id
       * attribute when a physical train is at its origin terminal. These assigned
       * trips have the is_assigned field set in the TripDescriptor.
       *
       * When a train is at a terminal but has not been given a work program it is
       * declared unassigned and is tagged as such. Unassigned trains can be moved
       * to a storage location or assigned a nyct_train_id when a determination for
       * service is made.
       * </pre>
       */
      public boolean hasIsAssigned() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bool is_assigned = 2;</code>
       *
       * <pre>
       * This trip has been assigned to a physical train. If true, this trip is
       * already underway or most likely will depart shortly. 
       *
       * Train Assignment is a function of the Automatic Train Supervision (ATS)
       * office system used by NYCT Rail Operations to monitor and track train
       * movements. ATS provides the ability to "assign" the nyct_train_id
       * attribute when a physical train is at its origin terminal. These assigned
       * trips have the is_assigned field set in the TripDescriptor.
       *
       * When a train is at a terminal but has not been given a work program it is
       * declared unassigned and is tagged as such. Unassigned trains can be moved
       * to a storage location or assigned a nyct_train_id when a determination for
       * service is made.
       * </pre>
       */
      public boolean getIsAssigned() {
        return isAssigned_;
      }
      /**
       * <code>optional bool is_assigned = 2;</code>
       *
       * <pre>
       * This trip has been assigned to a physical train. If true, this trip is
       * already underway or most likely will depart shortly. 
       *
       * Train Assignment is a function of the Automatic Train Supervision (ATS)
       * office system used by NYCT Rail Operations to monitor and track train
       * movements. ATS provides the ability to "assign" the nyct_train_id
       * attribute when a physical train is at its origin terminal. These assigned
       * trips have the is_assigned field set in the TripDescriptor.
       *
       * When a train is at a terminal but has not been given a work program it is
       * declared unassigned and is tagged as such. Unassigned trains can be moved
       * to a storage location or assigned a nyct_train_id when a determination for
       * service is made.
       * </pre>
       */
      public Builder setIsAssigned(boolean value) {
        bitField0_ |= 0x00000002;
        isAssigned_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_assigned = 2;</code>
       *
       * <pre>
       * This trip has been assigned to a physical train. If true, this trip is
       * already underway or most likely will depart shortly. 
       *
       * Train Assignment is a function of the Automatic Train Supervision (ATS)
       * office system used by NYCT Rail Operations to monitor and track train
       * movements. ATS provides the ability to "assign" the nyct_train_id
       * attribute when a physical train is at its origin terminal. These assigned
       * trips have the is_assigned field set in the TripDescriptor.
       *
       * When a train is at a terminal but has not been given a work program it is
       * declared unassigned and is tagged as such. Unassigned trains can be moved
       * to a storage location or assigned a nyct_train_id when a determination for
       * service is made.
       * </pre>
       */
      public Builder clearIsAssigned() {
        bitField0_ = (bitField0_ & ~0x00000002);
        isAssigned_ = false;
        onChanged();
        return this;
      }

      // optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;
      private com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction direction_ = com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction.NORTH;
      /**
       * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
       *
       * <pre>
       * Uptown and Bronx-bound trains are moving NORTH.
       * Times Square Shuttle to Grand Central is also northbound.
       *
       * Downtown and Brooklyn-bound trains are moving SOUTH.
       * Times Square Shuttle to Times Square is also southbound.
       * 
       * EAST and WEST are not used currently.
       * </pre>
       */
      public boolean hasDirection() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
       *
       * <pre>
       * Uptown and Bronx-bound trains are moving NORTH.
       * Times Square Shuttle to Grand Central is also northbound.
       *
       * Downtown and Brooklyn-bound trains are moving SOUTH.
       * Times Square Shuttle to Times Square is also southbound.
       * 
       * EAST and WEST are not used currently.
       * </pre>
       */
      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction getDirection() {
        return direction_;
      }
      /**
       * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
       *
       * <pre>
       * Uptown and Bronx-bound trains are moving NORTH.
       * Times Square Shuttle to Grand Central is also northbound.
       *
       * Downtown and Brooklyn-bound trains are moving SOUTH.
       * Times Square Shuttle to Times Square is also southbound.
       * 
       * EAST and WEST are not used currently.
       * </pre>
       */
      public Builder setDirection(com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        direction_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.NyctTripDescriptor.Direction direction = 3;</code>
       *
       * <pre>
       * Uptown and Bronx-bound trains are moving NORTH.
       * Times Square Shuttle to Grand Central is also northbound.
       *
       * Downtown and Brooklyn-bound trains are moving SOUTH.
       * Times Square Shuttle to Times Square is also southbound.
       * 
       * EAST and WEST are not used currently.
       * </pre>
       */
      public Builder clearDirection() {
        bitField0_ = (bitField0_ & ~0x00000004);
        direction_ = com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.Direction.NORTH;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:transit_realtime.NyctTripDescriptor)
    }

    static {
      defaultInstance = new NyctTripDescriptor(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.NyctTripDescriptor)
  }

  public interface NyctStopTimeUpdateOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string scheduled_track = 1;
    /**
     * <code>optional string scheduled_track = 1;</code>
     *
     * <pre>
     * Provides the planned station arrival track. The following is the Manhattan
     * track configurations:
     * 1: southbound local
     * 2: southbound express
     * 3: northbound express
     * 4: northbound local
     *
     * In the Bronx (except Dyre Ave line)
     * M: bi-directional express (in the AM express to Manhattan, in the PM
     * express away).
     *
     * The Dyre Ave line is configured:
     * 1: southbound
     * 2: northbound
     * 3: bi-directional
     * </pre>
     */
    boolean hasScheduledTrack();
    /**
     * <code>optional string scheduled_track = 1;</code>
     *
     * <pre>
     * Provides the planned station arrival track. The following is the Manhattan
     * track configurations:
     * 1: southbound local
     * 2: southbound express
     * 3: northbound express
     * 4: northbound local
     *
     * In the Bronx (except Dyre Ave line)
     * M: bi-directional express (in the AM express to Manhattan, in the PM
     * express away).
     *
     * The Dyre Ave line is configured:
     * 1: southbound
     * 2: northbound
     * 3: bi-directional
     * </pre>
     */
    java.lang.String getScheduledTrack();
    /**
     * <code>optional string scheduled_track = 1;</code>
     *
     * <pre>
     * Provides the planned station arrival track. The following is the Manhattan
     * track configurations:
     * 1: southbound local
     * 2: southbound express
     * 3: northbound express
     * 4: northbound local
     *
     * In the Bronx (except Dyre Ave line)
     * M: bi-directional express (in the AM express to Manhattan, in the PM
     * express away).
     *
     * The Dyre Ave line is configured:
     * 1: southbound
     * 2: northbound
     * 3: bi-directional
     * </pre>
     */
    com.google.protobuf.ByteString
        getScheduledTrackBytes();

    // optional string actual_track = 2;
    /**
     * <code>optional string actual_track = 2;</code>
     *
     * <pre>
     * This is the actual track that the train is operating on and can be used to
     * determine if a train is operating according to its current schedule
     * (plan).
     * 
     * The actual track is known only shortly before the train reaches a station,
     * typically not before it leaves the previous station. Therefore, the NYCT
     * feed sets this field only for the first station of the remaining trip.
     * 
     * Different actual and scheduled track is the result of manually rerouting a
     * train off it scheduled path.  When this occurs, prediction data may become
     * unreliable since the train is no longer operating in accordance to its
     * schedule.  The rules engine for the 'countdown' clocks will remove this
     * train from all schedule stations.
     * </pre>
     */
    boolean hasActualTrack();
    /**
     * <code>optional string actual_track = 2;</code>
     *
     * <pre>
     * This is the actual track that the train is operating on and can be used to
     * determine if a train is operating according to its current schedule
     * (plan).
     * 
     * The actual track is known only shortly before the train reaches a station,
     * typically not before it leaves the previous station. Therefore, the NYCT
     * feed sets this field only for the first station of the remaining trip.
     * 
     * Different actual and scheduled track is the result of manually rerouting a
     * train off it scheduled path.  When this occurs, prediction data may become
     * unreliable since the train is no longer operating in accordance to its
     * schedule.  The rules engine for the 'countdown' clocks will remove this
     * train from all schedule stations.
     * </pre>
     */
    java.lang.String getActualTrack();
    /**
     * <code>optional string actual_track = 2;</code>
     *
     * <pre>
     * This is the actual track that the train is operating on and can be used to
     * determine if a train is operating according to its current schedule
     * (plan).
     * 
     * The actual track is known only shortly before the train reaches a station,
     * typically not before it leaves the previous station. Therefore, the NYCT
     * feed sets this field only for the first station of the remaining trip.
     * 
     * Different actual and scheduled track is the result of manually rerouting a
     * train off it scheduled path.  When this occurs, prediction data may become
     * unreliable since the train is no longer operating in accordance to its
     * schedule.  The rules engine for the 'countdown' clocks will remove this
     * train from all schedule stations.
     * </pre>
     */
    com.google.protobuf.ByteString
        getActualTrackBytes();
  }
  /**
   * Protobuf type {@code transit_realtime.NyctStopTimeUpdate}
   *
   * <pre>
   * NYCT Subway extensions for the stop time update
   * </pre>
   */
  public static final class NyctStopTimeUpdate extends
      com.google.protobuf.GeneratedMessage
      implements NyctStopTimeUpdateOrBuilder {
    // Use NyctStopTimeUpdate.newBuilder() to construct.
    private NyctStopTimeUpdate(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private NyctStopTimeUpdate(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final NyctStopTimeUpdate defaultInstance;
    public static NyctStopTimeUpdate getDefaultInstance() {
      return defaultInstance;
    }

    public NyctStopTimeUpdate getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private NyctStopTimeUpdate(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              scheduledTrack_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              actualTrack_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctStopTimeUpdate_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctStopTimeUpdate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.class, com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.Builder.class);
    }

    public static com.google.protobuf.Parser<NyctStopTimeUpdate> PARSER =
        new com.google.protobuf.AbstractParser<NyctStopTimeUpdate>() {
      public NyctStopTimeUpdate parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new NyctStopTimeUpdate(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<NyctStopTimeUpdate> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string scheduled_track = 1;
    public static final int SCHEDULED_TRACK_FIELD_NUMBER = 1;
    private java.lang.Object scheduledTrack_;
    /**
     * <code>optional string scheduled_track = 1;</code>
     *
     * <pre>
     * Provides the planned station arrival track. The following is the Manhattan
     * track configurations:
     * 1: southbound local
     * 2: southbound express
     * 3: northbound express
     * 4: northbound local
     *
     * In the Bronx (except Dyre Ave line)
     * M: bi-directional express (in the AM express to Manhattan, in the PM
     * express away).
     *
     * The Dyre Ave line is configured:
     * 1: southbound
     * 2: northbound
     * 3: bi-directional
     * </pre>
     */
    public boolean hasScheduledTrack() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string scheduled_track = 1;</code>
     *
     * <pre>
     * Provides the planned station arrival track. The following is the Manhattan
     * track configurations:
     * 1: southbound local
     * 2: southbound express
     * 3: northbound express
     * 4: northbound local
     *
     * In the Bronx (except Dyre Ave line)
     * M: bi-directional express (in the AM express to Manhattan, in the PM
     * express away).
     *
     * The Dyre Ave line is configured:
     * 1: southbound
     * 2: northbound
     * 3: bi-directional
     * </pre>
     */
    public java.lang.String getScheduledTrack() {
      java.lang.Object ref = scheduledTrack_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          scheduledTrack_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string scheduled_track = 1;</code>
     *
     * <pre>
     * Provides the planned station arrival track. The following is the Manhattan
     * track configurations:
     * 1: southbound local
     * 2: southbound express
     * 3: northbound express
     * 4: northbound local
     *
     * In the Bronx (except Dyre Ave line)
     * M: bi-directional express (in the AM express to Manhattan, in the PM
     * express away).
     *
     * The Dyre Ave line is configured:
     * 1: southbound
     * 2: northbound
     * 3: bi-directional
     * </pre>
     */
    public com.google.protobuf.ByteString
        getScheduledTrackBytes() {
      java.lang.Object ref = scheduledTrack_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scheduledTrack_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string actual_track = 2;
    public static final int ACTUAL_TRACK_FIELD_NUMBER = 2;
    private java.lang.Object actualTrack_;
    /**
     * <code>optional string actual_track = 2;</code>
     *
     * <pre>
     * This is the actual track that the train is operating on and can be used to
     * determine if a train is operating according to its current schedule
     * (plan).
     * 
     * The actual track is known only shortly before the train reaches a station,
     * typically not before it leaves the previous station. Therefore, the NYCT
     * feed sets this field only for the first station of the remaining trip.
     * 
     * Different actual and scheduled track is the result of manually rerouting a
     * train off it scheduled path.  When this occurs, prediction data may become
     * unreliable since the train is no longer operating in accordance to its
     * schedule.  The rules engine for the 'countdown' clocks will remove this
     * train from all schedule stations.
     * </pre>
     */
    public boolean hasActualTrack() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string actual_track = 2;</code>
     *
     * <pre>
     * This is the actual track that the train is operating on and can be used to
     * determine if a train is operating according to its current schedule
     * (plan).
     * 
     * The actual track is known only shortly before the train reaches a station,
     * typically not before it leaves the previous station. Therefore, the NYCT
     * feed sets this field only for the first station of the remaining trip.
     * 
     * Different actual and scheduled track is the result of manually rerouting a
     * train off it scheduled path.  When this occurs, prediction data may become
     * unreliable since the train is no longer operating in accordance to its
     * schedule.  The rules engine for the 'countdown' clocks will remove this
     * train from all schedule stations.
     * </pre>
     */
    public java.lang.String getActualTrack() {
      java.lang.Object ref = actualTrack_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          actualTrack_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string actual_track = 2;</code>
     *
     * <pre>
     * This is the actual track that the train is operating on and can be used to
     * determine if a train is operating according to its current schedule
     * (plan).
     * 
     * The actual track is known only shortly before the train reaches a station,
     * typically not before it leaves the previous station. Therefore, the NYCT
     * feed sets this field only for the first station of the remaining trip.
     * 
     * Different actual and scheduled track is the result of manually rerouting a
     * train off it scheduled path.  When this occurs, prediction data may become
     * unreliable since the train is no longer operating in accordance to its
     * schedule.  The rules engine for the 'countdown' clocks will remove this
     * train from all schedule stations.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getActualTrackBytes() {
      java.lang.Object ref = actualTrack_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        actualTrack_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      scheduledTrack_ = "";
      actualTrack_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getScheduledTrackBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getActualTrackBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getScheduledTrackBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getActualTrackBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code transit_realtime.NyctStopTimeUpdate}
     *
     * <pre>
     * NYCT Subway extensions for the stop time update
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctStopTimeUpdate_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctStopTimeUpdate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.class, com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        scheduledTrack_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        actualTrack_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.internal_static_transit_realtime_NyctStopTimeUpdate_descriptor;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.getDefaultInstance();
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate build() {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate buildPartial() {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate result = new com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.scheduledTrack_ = scheduledTrack_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.actualTrack_ = actualTrack_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate other) {
        if (other == com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.getDefaultInstance()) return this;
        if (other.hasScheduledTrack()) {
          bitField0_ |= 0x00000001;
          scheduledTrack_ = other.scheduledTrack_;
          onChanged();
        }
        if (other.hasActualTrack()) {
          bitField0_ |= 0x00000002;
          actualTrack_ = other.actualTrack_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string scheduled_track = 1;
      private java.lang.Object scheduledTrack_ = "";
      /**
       * <code>optional string scheduled_track = 1;</code>
       *
       * <pre>
       * Provides the planned station arrival track. The following is the Manhattan
       * track configurations:
       * 1: southbound local
       * 2: southbound express
       * 3: northbound express
       * 4: northbound local
       *
       * In the Bronx (except Dyre Ave line)
       * M: bi-directional express (in the AM express to Manhattan, in the PM
       * express away).
       *
       * The Dyre Ave line is configured:
       * 1: southbound
       * 2: northbound
       * 3: bi-directional
       * </pre>
       */
      public boolean hasScheduledTrack() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string scheduled_track = 1;</code>
       *
       * <pre>
       * Provides the planned station arrival track. The following is the Manhattan
       * track configurations:
       * 1: southbound local
       * 2: southbound express
       * 3: northbound express
       * 4: northbound local
       *
       * In the Bronx (except Dyre Ave line)
       * M: bi-directional express (in the AM express to Manhattan, in the PM
       * express away).
       *
       * The Dyre Ave line is configured:
       * 1: southbound
       * 2: northbound
       * 3: bi-directional
       * </pre>
       */
      public java.lang.String getScheduledTrack() {
        java.lang.Object ref = scheduledTrack_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          scheduledTrack_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string scheduled_track = 1;</code>
       *
       * <pre>
       * Provides the planned station arrival track. The following is the Manhattan
       * track configurations:
       * 1: southbound local
       * 2: southbound express
       * 3: northbound express
       * 4: northbound local
       *
       * In the Bronx (except Dyre Ave line)
       * M: bi-directional express (in the AM express to Manhattan, in the PM
       * express away).
       *
       * The Dyre Ave line is configured:
       * 1: southbound
       * 2: northbound
       * 3: bi-directional
       * </pre>
       */
      public com.google.protobuf.ByteString
          getScheduledTrackBytes() {
        java.lang.Object ref = scheduledTrack_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scheduledTrack_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string scheduled_track = 1;</code>
       *
       * <pre>
       * Provides the planned station arrival track. The following is the Manhattan
       * track configurations:
       * 1: southbound local
       * 2: southbound express
       * 3: northbound express
       * 4: northbound local
       *
       * In the Bronx (except Dyre Ave line)
       * M: bi-directional express (in the AM express to Manhattan, in the PM
       * express away).
       *
       * The Dyre Ave line is configured:
       * 1: southbound
       * 2: northbound
       * 3: bi-directional
       * </pre>
       */
      public Builder setScheduledTrack(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        scheduledTrack_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string scheduled_track = 1;</code>
       *
       * <pre>
       * Provides the planned station arrival track. The following is the Manhattan
       * track configurations:
       * 1: southbound local
       * 2: southbound express
       * 3: northbound express
       * 4: northbound local
       *
       * In the Bronx (except Dyre Ave line)
       * M: bi-directional express (in the AM express to Manhattan, in the PM
       * express away).
       *
       * The Dyre Ave line is configured:
       * 1: southbound
       * 2: northbound
       * 3: bi-directional
       * </pre>
       */
      public Builder clearScheduledTrack() {
        bitField0_ = (bitField0_ & ~0x00000001);
        scheduledTrack_ = getDefaultInstance().getScheduledTrack();
        onChanged();
        return this;
      }
      /**
       * <code>optional string scheduled_track = 1;</code>
       *
       * <pre>
       * Provides the planned station arrival track. The following is the Manhattan
       * track configurations:
       * 1: southbound local
       * 2: southbound express
       * 3: northbound express
       * 4: northbound local
       *
       * In the Bronx (except Dyre Ave line)
       * M: bi-directional express (in the AM express to Manhattan, in the PM
       * express away).
       *
       * The Dyre Ave line is configured:
       * 1: southbound
       * 2: northbound
       * 3: bi-directional
       * </pre>
       */
      public Builder setScheduledTrackBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        scheduledTrack_ = value;
        onChanged();
        return this;
      }

      // optional string actual_track = 2;
      private java.lang.Object actualTrack_ = "";
      /**
       * <code>optional string actual_track = 2;</code>
       *
       * <pre>
       * This is the actual track that the train is operating on and can be used to
       * determine if a train is operating according to its current schedule
       * (plan).
       * 
       * The actual track is known only shortly before the train reaches a station,
       * typically not before it leaves the previous station. Therefore, the NYCT
       * feed sets this field only for the first station of the remaining trip.
       * 
       * Different actual and scheduled track is the result of manually rerouting a
       * train off it scheduled path.  When this occurs, prediction data may become
       * unreliable since the train is no longer operating in accordance to its
       * schedule.  The rules engine for the 'countdown' clocks will remove this
       * train from all schedule stations.
       * </pre>
       */
      public boolean hasActualTrack() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string actual_track = 2;</code>
       *
       * <pre>
       * This is the actual track that the train is operating on and can be used to
       * determine if a train is operating according to its current schedule
       * (plan).
       * 
       * The actual track is known only shortly before the train reaches a station,
       * typically not before it leaves the previous station. Therefore, the NYCT
       * feed sets this field only for the first station of the remaining trip.
       * 
       * Different actual and scheduled track is the result of manually rerouting a
       * train off it scheduled path.  When this occurs, prediction data may become
       * unreliable since the train is no longer operating in accordance to its
       * schedule.  The rules engine for the 'countdown' clocks will remove this
       * train from all schedule stations.
       * </pre>
       */
      public java.lang.String getActualTrack() {
        java.lang.Object ref = actualTrack_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          actualTrack_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string actual_track = 2;</code>
       *
       * <pre>
       * This is the actual track that the train is operating on and can be used to
       * determine if a train is operating according to its current schedule
       * (plan).
       * 
       * The actual track is known only shortly before the train reaches a station,
       * typically not before it leaves the previous station. Therefore, the NYCT
       * feed sets this field only for the first station of the remaining trip.
       * 
       * Different actual and scheduled track is the result of manually rerouting a
       * train off it scheduled path.  When this occurs, prediction data may become
       * unreliable since the train is no longer operating in accordance to its
       * schedule.  The rules engine for the 'countdown' clocks will remove this
       * train from all schedule stations.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getActualTrackBytes() {
        java.lang.Object ref = actualTrack_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          actualTrack_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string actual_track = 2;</code>
       *
       * <pre>
       * This is the actual track that the train is operating on and can be used to
       * determine if a train is operating according to its current schedule
       * (plan).
       * 
       * The actual track is known only shortly before the train reaches a station,
       * typically not before it leaves the previous station. Therefore, the NYCT
       * feed sets this field only for the first station of the remaining trip.
       * 
       * Different actual and scheduled track is the result of manually rerouting a
       * train off it scheduled path.  When this occurs, prediction data may become
       * unreliable since the train is no longer operating in accordance to its
       * schedule.  The rules engine for the 'countdown' clocks will remove this
       * train from all schedule stations.
       * </pre>
       */
      public Builder setActualTrack(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        actualTrack_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string actual_track = 2;</code>
       *
       * <pre>
       * This is the actual track that the train is operating on and can be used to
       * determine if a train is operating according to its current schedule
       * (plan).
       * 
       * The actual track is known only shortly before the train reaches a station,
       * typically not before it leaves the previous station. Therefore, the NYCT
       * feed sets this field only for the first station of the remaining trip.
       * 
       * Different actual and scheduled track is the result of manually rerouting a
       * train off it scheduled path.  When this occurs, prediction data may become
       * unreliable since the train is no longer operating in accordance to its
       * schedule.  The rules engine for the 'countdown' clocks will remove this
       * train from all schedule stations.
       * </pre>
       */
      public Builder clearActualTrack() {
        bitField0_ = (bitField0_ & ~0x00000002);
        actualTrack_ = getDefaultInstance().getActualTrack();
        onChanged();
        return this;
      }
      /**
       * <code>optional string actual_track = 2;</code>
       *
       * <pre>
       * This is the actual track that the train is operating on and can be used to
       * determine if a train is operating according to its current schedule
       * (plan).
       * 
       * The actual track is known only shortly before the train reaches a station,
       * typically not before it leaves the previous station. Therefore, the NYCT
       * feed sets this field only for the first station of the remaining trip.
       * 
       * Different actual and scheduled track is the result of manually rerouting a
       * train off it scheduled path.  When this occurs, prediction data may become
       * unreliable since the train is no longer operating in accordance to its
       * schedule.  The rules engine for the 'countdown' clocks will remove this
       * train from all schedule stations.
       * </pre>
       */
      public Builder setActualTrackBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        actualTrack_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:transit_realtime.NyctStopTimeUpdate)
    }

    static {
      defaultInstance = new NyctStopTimeUpdate(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.NyctStopTimeUpdate)
  }

  public static final int NYCT_FEED_HEADER_FIELD_NUMBER = 1001;
  /**
   * <code>extend .transit_realtime.FeedHeader { ... }</code>
   *
   * <pre>
   * Version of the NYCT Subway extensions
   * The current version is 1.0
   * </pre>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      com.google.transit.realtime.GtfsRealtime.FeedHeader,
      com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader> nyctFeedHeader = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.class,
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctFeedHeader.getDefaultInstance());
  public static final int NYCT_TRIP_DESCRIPTOR_FIELD_NUMBER = 1001;
  /**
   * <code>extend .transit_realtime.TripDescriptor { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      com.google.transit.realtime.GtfsRealtime.TripDescriptor,
      com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor> nyctTripDescriptor = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.class,
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctTripDescriptor.getDefaultInstance());
  public static final int NYCT_STOP_TIME_UPDATE_FIELD_NUMBER = 1001;
  /**
   * <code>extend .transit_realtime.TripUpdate.StopTimeUpdate { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate,
      com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate> nyctStopTimeUpdate = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.class,
        com.google.transit.realtime.GtfsRealtimeNYCT.NyctStopTimeUpdate.getDefaultInstance());
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_transit_realtime_TripReplacementPeriod_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_transit_realtime_TripReplacementPeriod_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_transit_realtime_NyctFeedHeader_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_transit_realtime_NyctFeedHeader_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_transit_realtime_NyctTripDescriptor_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_transit_realtime_NyctTripDescriptor_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_transit_realtime_NyctStopTimeUpdate_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_transit_realtime_NyctStopTimeUpdate_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n4com/google/transit/realtime/gtfs-realt" +
      "ime-NYCT.proto\022\020transit_realtime\032/com/go" +
      "ogle/transit/realtime/gtfs-realtime.prot" +
      "o\"b\n\025TripReplacementPeriod\022\020\n\010route_id\030\001" +
      " \001(\t\0227\n\022replacement_period\030\002 \001(\0132\033.trans" +
      "it_realtime.TimeRange\"w\n\016NyctFeedHeader\022" +
      "\033\n\023nyct_subway_version\030\001 \002(\t\022H\n\027trip_rep" +
      "lacement_period\030\002 \003(\0132\'.transit_realtime" +
      ".TripReplacementPeriod\"\265\001\n\022NyctTripDescr" +
      "iptor\022\020\n\010train_id\030\001 \001(\t\022\023\n\013is_assigned\030\002",
      " \001(\010\022A\n\tdirection\030\003 \001(\0162..transit_realti" +
      "me.NyctTripDescriptor.Direction\"5\n\tDirec" +
      "tion\022\t\n\005NORTH\020\001\022\010\n\004EAST\020\002\022\t\n\005SOUTH\020\003\022\010\n\004" +
      "WEST\020\004\"C\n\022NyctStopTimeUpdate\022\027\n\017schedule" +
      "d_track\030\001 \001(\t\022\024\n\014actual_track\030\002 \001(\t:Y\n\020n" +
      "yct_feed_header\022\034.transit_realtime.FeedH" +
      "eader\030\351\007 \001(\0132 .transit_realtime.NyctFeed" +
      "Header:e\n\024nyct_trip_descriptor\022 .transit" +
      "_realtime.TripDescriptor\030\351\007 \001(\0132$.transi" +
      "t_realtime.NyctTripDescriptor:q\n\025nyct_st",
      "op_time_update\022+.transit_realtime.TripUp" +
      "date.StopTimeUpdate\030\351\007 \001(\0132$.transit_rea" +
      "ltime.NyctStopTimeUpdateB\035\n\033com.google.t" +
      "ransit.realtime"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_transit_realtime_TripReplacementPeriod_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_transit_realtime_TripReplacementPeriod_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_transit_realtime_TripReplacementPeriod_descriptor,
              new java.lang.String[] { "RouteId", "ReplacementPeriod", });
          internal_static_transit_realtime_NyctFeedHeader_descriptor =
            getDescriptor().getMessageTypes().get(1);
          internal_static_transit_realtime_NyctFeedHeader_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_transit_realtime_NyctFeedHeader_descriptor,
              new java.lang.String[] { "NyctSubwayVersion", "TripReplacementPeriod", });
          internal_static_transit_realtime_NyctTripDescriptor_descriptor =
            getDescriptor().getMessageTypes().get(2);
          internal_static_transit_realtime_NyctTripDescriptor_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_transit_realtime_NyctTripDescriptor_descriptor,
              new java.lang.String[] { "TrainId", "IsAssigned", "Direction", });
          internal_static_transit_realtime_NyctStopTimeUpdate_descriptor =
            getDescriptor().getMessageTypes().get(3);
          internal_static_transit_realtime_NyctStopTimeUpdate_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_transit_realtime_NyctStopTimeUpdate_descriptor,
              new java.lang.String[] { "ScheduledTrack", "ActualTrack", });
          nyctFeedHeader.internalInit(descriptor.getExtensions().get(0));
          nyctTripDescriptor.internalInit(descriptor.getExtensions().get(1));
          nyctStopTimeUpdate.internalInit(descriptor.getExtensions().get(2));
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.google.transit.realtime.GtfsRealtime.getDescriptor(),
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
